// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the status of a procurement portal preference, including the activation
// state of e-invoice delivery and purchase order retrieval features.
func (c *Client) UpdateProcurementPortalPreferenceStatus(ctx context.Context, params *UpdateProcurementPortalPreferenceStatusInput, optFns ...func(*Options)) (*UpdateProcurementPortalPreferenceStatusOutput, error) {
	if params == nil {
		params = &UpdateProcurementPortalPreferenceStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateProcurementPortalPreferenceStatus", params, optFns, c.addOperationUpdateProcurementPortalPreferenceStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateProcurementPortalPreferenceStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateProcurementPortalPreferenceStatusInput struct {

	// The Amazon Resource Name (ARN) of the procurement portal preference to update.
	//
	// This member is required.
	ProcurementPortalPreferenceArn *string

	// The updated status of the e-invoice delivery preference.
	EinvoiceDeliveryPreferenceStatus types.ProcurementPortalPreferenceStatus

	// The reason for the e-invoice delivery preference status update, providing
	// context for the change.
	EinvoiceDeliveryPreferenceStatusReason *string

	// The updated status of the purchase order retrieval preference.
	PurchaseOrderRetrievalPreferenceStatus types.ProcurementPortalPreferenceStatus

	// The reason for the purchase order retrieval preference status update, providing
	// context for the change.
	PurchaseOrderRetrievalPreferenceStatusReason *string

	noSmithyDocumentSerde
}

type UpdateProcurementPortalPreferenceStatusOutput struct {

	// The Amazon Resource Name (ARN) of the procurement portal preference with
	// updated status.
	//
	// This member is required.
	ProcurementPortalPreferenceArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateProcurementPortalPreferenceStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateProcurementPortalPreferenceStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateProcurementPortalPreferenceStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateProcurementPortalPreferenceStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateProcurementPortalPreferenceStatusValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateProcurementPortalPreferenceStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateProcurementPortalPreferenceStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateProcurementPortalPreferenceStatus",
	}
}
