// Code generated by smithy-go-codegen DO NOT EDIT.

package invoicing

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/invoicing/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing procurement portal preference configuration. This operation
// can modify settings for e-invoice delivery and purchase order retrieval.
func (c *Client) PutProcurementPortalPreference(ctx context.Context, params *PutProcurementPortalPreferenceInput, optFns ...func(*Options)) (*PutProcurementPortalPreferenceOutput, error) {
	if params == nil {
		params = &PutProcurementPortalPreferenceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutProcurementPortalPreference", params, optFns, c.addOperationPutProcurementPortalPreferenceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutProcurementPortalPreferenceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutProcurementPortalPreferenceInput struct {

	// Updated list of contact information for portal administrators and technical
	// contacts.
	//
	// This member is required.
	Contacts []types.Contact

	// Updated flag indicating whether e-invoice delivery is enabled for this
	// procurement portal preference.
	//
	// This member is required.
	EinvoiceDeliveryEnabled *bool

	// The Amazon Resource Name (ARN) of the procurement portal preference to update.
	//
	// This member is required.
	ProcurementPortalPreferenceArn *string

	// Updated flag indicating whether purchase order retrieval is enabled for this
	// procurement portal preference.
	//
	// This member is required.
	PurchaseOrderRetrievalEnabled *bool

	// Updated e-invoice delivery configuration including document types, attachment
	// types, and customization settings for the portal.
	EinvoiceDeliveryPreference *types.EinvoiceDeliveryPreference

	// The updated endpoint URL where e-invoices will be delivered to the procurement
	// portal. Must be a valid HTTPS URL.
	ProcurementPortalInstanceEndpoint *string

	// The updated shared secret or authentication credential for the procurement
	// portal. This value must be encrypted at rest.
	ProcurementPortalSharedSecret *string

	// Specifies criteria for selecting which invoices should be processed using a
	// particular procurement portal preference.
	Selector *types.ProcurementPortalPreferenceSelector

	// Updated configuration settings for the test environment of the procurement
	// portal.
	TestEnvPreference *types.TestEnvPreferenceInput

	noSmithyDocumentSerde
}

type PutProcurementPortalPreferenceOutput struct {

	// The Amazon Resource Name (ARN) of the updated procurement portal preference.
	//
	// This member is required.
	ProcurementPortalPreferenceArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutProcurementPortalPreferenceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpPutProcurementPortalPreference{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpPutProcurementPortalPreference{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutProcurementPortalPreference"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutProcurementPortalPreferenceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutProcurementPortalPreference(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutProcurementPortalPreference(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutProcurementPortalPreference",
	}
}
