// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Contains information on the current access control policies for the bucket.
type AccessControlList struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicReadAccess *bool

	// A value that indicates whether public write access for the bucket is enabled
	// through an Access Control List (ACL).
	AllowsPublicWriteAccess *bool

	noSmithyDocumentSerde
}

// Contains information about the access keys.
type AccessKey struct {

	// Principal ID of the user.
	PrincipalId *string

	// Name of the user.
	UserName *string

	// Type of the user.
	UserType *string

	noSmithyDocumentSerde
}

// Contains information about the access keys.
type AccessKeyDetails struct {

	// The access key ID of the user.
	AccessKeyId *string

	// The principal ID of the user.
	PrincipalId *string

	// The name of the user.
	UserName *string

	// The type of the user.
	UserType *string

	noSmithyDocumentSerde
}

// Contains information about the account.
type Account struct {

	// ID of the member's Amazon Web Services account
	//
	// This member is required.
	Uid *string

	// Name of the member's Amazon Web Services account.
	Name *string

	noSmithyDocumentSerde
}

// Contains information about the account.
type AccountDetail struct {

	// The member account ID.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account. The following list includes the rules
	// for a valid email address:
	//
	//   - The email address must be a minimum of 6 and a maximum of 64 characters
	//   long.
	//
	//   - All characters must be 7-bit ASCII characters.
	//
	//   - There must be one and only one @ symbol, which separates the local name
	//   from the domain name.
	//
	//   - The local name can't contain any of the following characters:
	//
	// whitespace, " ' ( ) < > [ ] : ' , \ | % &
	//
	//   - The local name can't begin with a dot (.).
	//
	//   - The domain name can consist of only the characters [a-z], [A-Z], [0-9],
	//   hyphen (-), or dot (.).
	//
	//   - The domain name can't begin or end with a dot (.) or hyphen (-).
	//
	//   - The domain name must contain at least one dot.
	//
	// This member is required.
	Email *string

	noSmithyDocumentSerde
}

// Provides details of the GuardDuty member account that uses a free trial service.
type AccountFreeTrialInfo struct {

	// The account identifier of the GuardDuty member account.
	AccountId *string

	// Describes the data source enabled for the GuardDuty member account.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources *DataSourcesFreeTrial

	// A list of features enabled for the GuardDuty account.
	Features []FreeTrialFeatureConfigurationResult

	noSmithyDocumentSerde
}

// Contains information about the account level permissions on the S3 bucket.
type AccountLevelPermissions struct {

	// Describes the S3 Block Public Access settings of the bucket's parent account.
	BlockPublicAccess *BlockPublicAccess

	noSmithyDocumentSerde
}

// Represents a list of map of accounts with the number of findings associated
// with each account.
type AccountStatistics struct {

	// The ID of the Amazon Web Services account.
	AccountId *string

	// The timestamp at which the finding for this account was last generated.
	LastGeneratedAt *time.Time

	// The total number of findings associated with an account.
	TotalFindings *int32

	noSmithyDocumentSerde
}

// Contains information about actions.
type Action struct {

	// The GuardDuty finding activity type.
	ActionType *string

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction

	// Information about the Kubernetes API call action described in this finding.
	KubernetesApiCallAction *KubernetesApiCallAction

	// Information whether the user has the permission to use a specific Kubernetes
	// API.
	KubernetesPermissionCheckedDetails *KubernetesPermissionCheckedDetails

	// Information about the role binding that grants the permission defined in a
	// Kubernetes role.
	KubernetesRoleBindingDetails *KubernetesRoleBindingDetails

	// Information about the Kubernetes role name and role type.
	KubernetesRoleDetails *KubernetesRoleDetails

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction

	// Information about RDS_LOGIN_ATTEMPT action described in this finding.
	RdsLoginAttemptAction *RdsLoginAttemptAction

	noSmithyDocumentSerde
}

// Information about the actors involved in an attack sequence.
type Actor struct {

	// ID of the threat actor.
	//
	// This member is required.
	Id *string

	// Contains information about the process associated with the threat actor. This
	// includes details such as process name, path, execution time, and unique
	// identifiers that help track the actor's activities within the system.
	Process *ActorProcess

	// Contains information about the user session where the activity initiated.
	Session *Session

	// Contains information about the user credentials used by the threat actor.
	User *User

	noSmithyDocumentSerde
}

// Contains information about a process involved in a GuardDuty finding, including
// process identification, execution details, and file information.
type ActorProcess struct {

	// The name of the process as it appears in the system.
	//
	// This member is required.
	Name *string

	// The full file path to the process executable on the system.
	//
	// This member is required.
	Path *string

	// The SHA256 hash of the process executable file, which can be used for
	// identification and verification purposes.
	Sha256 *string

	noSmithyDocumentSerde
}

// Contains additional information about the detected threat.
type AdditionalInfo struct {

	// The device name of the EBS volume, if applicable.
	DeviceName *string

	// The version ID of the S3 object, if applicable.
	VersionId *string

	noSmithyDocumentSerde
}

// Information about the installed EKS add-on (GuardDuty security agent).
type AddonDetails struct {

	// Status of the installed EKS add-on.
	AddonStatus *string

	// Version of the installed EKS add-on.
	AddonVersion *string

	noSmithyDocumentSerde
}

// The account within the organization specified as the GuardDuty delegated
// administrator.
type AdminAccount struct {

	// The Amazon Web Services account ID for the account.
	AdminAccountId *string

	// Indicates whether the account is enabled as the delegated administrator.
	AdminStatus AdminStatus

	noSmithyDocumentSerde
}

// Contains information about the administrator account and invitation.
type Administrator struct {

	// The ID of the account used as the administrator account.
	AccountId *string

	// The value that is used to validate the administrator account to the member
	// account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Information about the installed GuardDuty security agent.
type AgentDetails struct {

	// Version of the installed GuardDuty security agent.
	Version *string

	noSmithyDocumentSerde
}

// Contains information about the anomalies.
type Anomaly struct {

	// Information about the types of profiles.
	Profiles map[string]map[string][]AnomalyObject

	// Information about the behavior of the anomalies.
	Unusual *AnomalyUnusual

	noSmithyDocumentSerde
}

// Contains information about the unusual anomalies.
type AnomalyObject struct {

	// The recorded value.
	Observations *Observations

	// The frequency of the anomaly.
	ProfileSubtype ProfileSubtype

	// The type of behavior of the profile.
	ProfileType ProfileType

	noSmithyDocumentSerde
}

// Contains information about the behavior of the anomaly that is new to GuardDuty.
type AnomalyUnusual struct {

	// The behavior of the anomalous activity that caused GuardDuty to generate the
	// finding.
	Behavior map[string]map[string]AnomalyObject

	noSmithyDocumentSerde
}

// Contains information about the Autonomous System (AS) associated with the
// network endpoints involved in an attack sequence.
type AutonomousSystem struct {

	// Name associated with the Autonomous System (AS).
	//
	// This member is required.
	Name *string

	// The unique number that identifies the Autonomous System (AS).
	//
	// This member is required.
	Number *int32

	noSmithyDocumentSerde
}

// Contains information about the Auto Scaling Group involved in a GuardDuty
// finding, including unique identifiers of the Amazon EC2 instances.
type AutoscalingAutoScalingGroup struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that are
	// part of the same Auto Scaling Group.
	Ec2InstanceUids []string

	noSmithyDocumentSerde
}

// Contains information about the API action.
type AwsApiCallAction struct {

	// The details of the Amazon Web Services account that made the API call. This
	// field identifies the resources that were affected by this API call.
	AffectedResources map[string]string

	// The Amazon Web Services API name.
	Api *string

	// The Amazon Web Services API caller type.
	CallerType *string

	// The domain information for the Amazon Web Services API call.
	DomainDetails *DomainDetails

	// The error code of the failed Amazon Web Services API action.
	ErrorCode *string

	// The details of the Amazon Web Services account that made the API call. This
	// field appears if the call was made from outside your account.
	RemoteAccountDetails *RemoteAccountDetails

	// The remote IP information of the connection that initiated the Amazon Web
	// Services API call.
	RemoteIpDetails *RemoteIpDetails

	// The Amazon Web Services service name whose API was invoked.
	ServiceName *string

	// The agent through which the API request was made.
	UserAgent *string

	noSmithyDocumentSerde
}

// Contains information on how the bucker owner's S3 Block Public Access settings
// are being applied to the S3 bucket. See [S3 Block Public Access]for more information.
//
// [S3 Block Public Access]: https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html
type BlockPublicAccess struct {

	// Indicates if S3 Block Public Access is set to BlockPublicAcls .
	BlockPublicAcls *bool

	// Indicates if S3 Block Public Access is set to BlockPublicPolicy .
	BlockPublicPolicy *bool

	// Indicates if S3 Block Public Access is set to IgnorePublicAcls .
	IgnorePublicAcls *bool

	// Indicates if S3 Block Public Access is set to RestrictPublicBuckets .
	RestrictPublicBuckets *bool

	noSmithyDocumentSerde
}

// Contains information about the bucket level permissions for the S3 bucket.
type BucketLevelPermissions struct {

	// Contains information on how Access Control Policies are applied to the bucket.
	AccessControlList *AccessControlList

	// Contains information on which account level S3 Block Public Access settings are
	// applied to the S3 bucket.
	BlockPublicAccess *BlockPublicAccess

	// Contains information on the bucket policies for the S3 bucket.
	BucketPolicy *BucketPolicy

	noSmithyDocumentSerde
}

// Contains information on the current bucket policies for the S3 bucket.
type BucketPolicy struct {

	// A value that indicates whether public read access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicReadAccess *bool

	// A value that indicates whether public write access for the bucket is enabled
	// through a bucket policy.
	AllowsPublicWriteAccess *bool

	noSmithyDocumentSerde
}

// Contains information about the city associated with the IP address.
type City struct {

	// The city name of the remote IP address.
	CityName *string

	noSmithyDocumentSerde
}

// Contains information about the CloudFormation stack involved in a GuardDuty
// finding, including unique identifiers of the Amazon EC2 instances.
type CloudformationStack struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that were
	// created as part of the same CloudFormation stack.
	Ec2InstanceUids []string

	noSmithyDocumentSerde
}

// Contains information on the status of CloudTrail as a data source for the
// detector.
type CloudTrailConfigurationResult struct {

	// Describes whether CloudTrail is enabled as a data source for the detector.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the condition.
type Condition struct {

	// Represents the equal condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Eq []string

	// Represents an equal condition to be applied to a single field when querying for
	// findings.
	Equals []string

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	GreaterThan *int64

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	GreaterThanOrEqual *int64

	// Represents a greater than condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gt *int32

	// Represents a greater than or equal condition to be applied to a single field
	// when querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Gte *int32

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	LessThan *int64

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	LessThanOrEqual *int64

	// Represents a less than condition to be applied to a single field when querying
	// for findings.
	//
	// Deprecated: This member has been deprecated.
	Lt *int32

	// Represents a less than or equal condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Lte *int32

	// Represents the match condition to be applied to a single field when querying
	// for findings.
	//
	// The matches condition is available only for create-filter and update-filter
	// APIs.
	Matches []string

	// Represents the not equal condition to be applied to a single field when
	// querying for findings.
	//
	// Deprecated: This member has been deprecated.
	Neq []string

	// Represents a not equal condition to be applied to a single field when querying
	// for findings.
	NotEquals []string

	// Represents the not match condition to be applied to a single field when
	// querying for findings.
	//
	// The not-matches condition is available only for create-filter and update-filter
	// APIs.
	NotMatches []string

	noSmithyDocumentSerde
}

// Details of a container.
type Container struct {

	// The container runtime (such as, Docker or containerd) used to run the container.
	ContainerRuntime *string

	// Container ID.
	Id *string

	// Container image.
	Image *string

	// Part of the image name before the last slash. For example, imagePrefix for
	// public.ecr.aws/amazonlinux/amazonlinux:latest would be
	// public.ecr.aws/amazonlinux. If the image name is relative and does not have a
	// slash, this field is empty.
	ImagePrefix *string

	// Container name.
	Name *string

	// Container security context.
	SecurityContext *SecurityContext

	// Container volume mounts.
	VolumeMounts []VolumeMount

	noSmithyDocumentSerde
}

// Contains information about container resources involved in a GuardDuty finding.
// This structure provides details about containers that were identified as part of
// suspicious or malicious activity.
type ContainerFindingResource struct {

	// The container image information, including the image name and tag used to run
	// the container that was involved in the finding.
	//
	// This member is required.
	Image *string

	// The unique ID associated with the container image.
	ImageUid *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon EC2 instance that is running the Amazon
// ECS container.
type ContainerInstanceDetails struct {

	// Represents total number of nodes in the Amazon ECS cluster.
	CompatibleContainerInstances *int64

	// Represents the nodes in the Amazon ECS cluster that has a HEALTHY coverage
	// status.
	CoveredContainerInstances *int64

	noSmithyDocumentSerde
}

// Contains information about the country where the remote IP address is located.
type Country struct {

	// The country code of the remote IP address.
	CountryCode *string

	// The country name of the remote IP address.
	CountryName *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon EC2 instance runtime coverage details.
type CoverageEc2InstanceDetails struct {

	// Information about the installed security agent.
	AgentDetails *AgentDetails

	// The cluster ARN of the Amazon ECS cluster running on the Amazon EC2 instance.
	ClusterArn *string

	// The Amazon EC2 instance ID.
	InstanceId *string

	// The instance type of the Amazon EC2 instance.
	InstanceType *string

	// Indicates how the GuardDuty security agent is managed for this resource.
	//
	//   - AUTO_MANAGED indicates that GuardDuty deploys and manages updates for this
	//   resource.
	//
	//   - MANUAL indicates that you are responsible to deploy, update, and manage the
	//   GuardDuty security agent updates for this resource.
	//
	// The DISABLED status doesn't apply to Amazon EC2 instances and Amazon EKS
	// clusters.
	ManagementType ManagementType

	noSmithyDocumentSerde
}

// Contains information about Amazon ECS cluster runtime coverage details.
type CoverageEcsClusterDetails struct {

	// The name of the Amazon ECS cluster.
	ClusterName *string

	// Information about the Amazon ECS container running on Amazon EC2 instance.
	ContainerInstanceDetails *ContainerInstanceDetails

	// Information about the Fargate details associated with the Amazon ECS cluster.
	FargateDetails *FargateDetails

	noSmithyDocumentSerde
}

// Information about the EKS cluster that has a coverage status.
type CoverageEksClusterDetails struct {

	// Information about the installed EKS add-on.
	AddonDetails *AddonDetails

	// Name of the EKS cluster.
	ClusterName *string

	// Represents all the nodes within the EKS cluster in your account.
	CompatibleNodes *int64

	// Represents the nodes within the EKS cluster that have a HEALTHY coverage status.
	CoveredNodes *int64

	// Indicates how the Amazon EKS add-on GuardDuty agent is managed for this EKS
	// cluster.
	//
	// AUTO_MANAGED indicates GuardDuty deploys and manages updates for this resource.
	//
	// MANUAL indicates that you are responsible to deploy, update, and manage the
	// Amazon EKS add-on GuardDuty agent for this resource.
	ManagementType ManagementType

	noSmithyDocumentSerde
}

// Represents a condition that when matched will be added to the response of the
// operation.
type CoverageFilterCondition struct {

	// Represents an equal condition that is applied to a single field while
	// retrieving the coverage details.
	Equals []string

	// Represents a not equal condition that is applied to a single field while
	// retrieving the coverage details.
	NotEquals []string

	noSmithyDocumentSerde
}

// Represents the criteria used in the filter.
type CoverageFilterCriteria struct {

	// Represents a condition that when matched will be added to the response of the
	// operation.
	FilterCriterion []CoverageFilterCriterion

	noSmithyDocumentSerde
}

// Represents a condition that when matched will be added to the response of the
// operation.
type CoverageFilterCriterion struct {

	// An enum value representing possible filter fields.
	//
	// Replace the enum value CLUSTER_NAME with EKS_CLUSTER_NAME . CLUSTER_NAME has
	// been deprecated.
	CriterionKey CoverageFilterCriterionKey

	// Contains information about the condition.
	FilterCondition *CoverageFilterCondition

	noSmithyDocumentSerde
}

// Information about the resource of the GuardDuty account.
type CoverageResource struct {

	// The unique ID of the Amazon Web Services account.
	AccountId *string

	// Represents the status of the EKS cluster coverage.
	CoverageStatus CoverageStatus

	// The unique ID of the GuardDuty detector associated with the resource.
	DetectorId *string

	// Represents the reason why a coverage status was UNHEALTHY for the EKS cluster.
	Issue *string

	// Information about the resource for which the coverage statistics are retrieved.
	ResourceDetails *CoverageResourceDetails

	// The unique ID of the resource.
	ResourceId *string

	// The timestamp at which the coverage details for the resource were last updated.
	// This is in UTC format.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about the resource for each individual EKS cluster.
type CoverageResourceDetails struct {

	// Information about the Amazon EC2 instance assessed for runtime coverage.
	Ec2InstanceDetails *CoverageEc2InstanceDetails

	// Information about the Amazon ECS cluster that is assessed for runtime coverage.
	EcsClusterDetails *CoverageEcsClusterDetails

	// EKS cluster details involved in the coverage statistics.
	EksClusterDetails *CoverageEksClusterDetails

	// The type of Amazon Web Services resource.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Information about the sorting criteria used in the coverage statistics.
type CoverageSortCriteria struct {

	// Represents the field name used to sort the coverage details.
	//
	// Replace the enum value CLUSTER_NAME with EKS_CLUSTER_NAME . CLUSTER_NAME has
	// been deprecated.
	AttributeName CoverageSortKey

	// The order in which the sorted findings are to be displayed.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Information about the coverage statistics for a resource.
type CoverageStatistics struct {

	// Represents coverage statistics for EKS clusters aggregated by coverage status.
	CountByCoverageStatus map[string]int64

	// Represents coverage statistics for EKS clusters aggregated by resource type.
	CountByResourceType map[string]int64

	noSmithyDocumentSerde
}

// Information about the protected resource that is associated with the created
// Malware Protection plan. Presently, S3Bucket is the only supported protected
// resource.
type CreateProtectedResource struct {

	// Information about the protected S3 bucket resource.
	S3Bucket *CreateS3BucketResource

	noSmithyDocumentSerde
}

// Information about the protected S3 bucket resource.
type CreateS3BucketResource struct {

	// Name of the S3 bucket.
	BucketName *string

	// Information about the specified object prefixes. The S3 object will be scanned
	// only if it belongs to any of the specified object prefixes.
	ObjectPrefixes []string

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled.
type DataSourceConfigurations struct {

	// Describes whether any Kubernetes logs are enabled as data sources.
	Kubernetes *KubernetesConfiguration

	// Describes whether Malware Protection is enabled as a data source.
	MalwareProtection *MalwareProtectionConfiguration

	// Describes whether S3 data event logs are enabled as a data source.
	S3Logs *S3LogsConfiguration

	noSmithyDocumentSerde
}

// Contains information on the status of data sources for the detector.
type DataSourceConfigurationsResult struct {

	// An object that contains information on the status of CloudTrail as a data
	// source.
	//
	// This member is required.
	CloudTrail *CloudTrailConfigurationResult

	// An object that contains information on the status of DNS logs as a data source.
	//
	// This member is required.
	DNSLogs *DNSLogsConfigurationResult

	// An object that contains information on the status of VPC flow logs as a data
	// source.
	//
	// This member is required.
	FlowLogs *FlowLogsConfigurationResult

	// An object that contains information on the status of S3 Data event logs as a
	// data source.
	//
	// This member is required.
	S3Logs *S3LogsConfigurationResult

	// An object that contains information on the status of all Kubernetes data
	// sources.
	Kubernetes *KubernetesConfigurationResult

	// Describes the configuration of Malware Protection data sources.
	MalwareProtection *MalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled for the GuardDuty
// member account.
type DataSourceFreeTrial struct {

	// A value that specifies the number of days left to use each enabled data source.
	FreeTrialDaysRemaining *int32

	noSmithyDocumentSerde
}

// Contains information about which data sources are enabled for the GuardDuty
// member account.
type DataSourcesFreeTrial struct {

	// Describes whether any Amazon Web Services CloudTrail management event logs are
	// enabled as data sources.
	CloudTrail *DataSourceFreeTrial

	// Describes whether any DNS logs are enabled as data sources.
	DnsLogs *DataSourceFreeTrial

	// Describes whether any VPC Flow logs are enabled as data sources.
	FlowLogs *DataSourceFreeTrial

	// Describes whether any Kubernetes logs are enabled as data sources.
	Kubernetes *KubernetesDataSourceFreeTrial

	// Describes whether Malware Protection is enabled as a data source.
	MalwareProtection *MalwareProtectionDataSourceFreeTrial

	// Describes whether any S3 data event logs are enabled as data sources.
	S3Logs *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Represents list a map of dates with a count of total findings generated on each
// date.
type DateStatistics struct {

	// The timestamp when the total findings count is observed.
	//
	// For example, Date would look like "2024-09-05T17:00:00-07:00" whereas
	// LastGeneratedAt would look like 2024-09-05T17:12:29-07:00".
	Date *time.Time

	// The timestamp at which the last finding in the findings count, was generated.
	LastGeneratedAt *time.Time

	// The severity of the findings generated on each date.
	Severity *float64

	// The total number of findings that were generated per severity level on each
	// date.
	TotalFindings *int32

	noSmithyDocumentSerde
}

// Contains information on the server side encryption method used in the S3
// bucket. See [S3 Server-Side Encryption]for more information.
//
// [S3 Server-Side Encryption]: https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html
type DefaultServerSideEncryption struct {

	// The type of encryption used for objects within the S3 bucket.
	EncryptionType *string

	// The Amazon Resource Name (ARN) of the KMS encryption key. Only available if the
	// bucket EncryptionType is aws:kms .
	KmsMasterKeyArn *string

	noSmithyDocumentSerde
}

// Contains information about the publishing destination, including the ID, type,
// and status.
type Destination struct {

	// The unique ID of the publishing destination.
	//
	// This member is required.
	DestinationId *string

	// The type of resource used for the publishing destination. Currently, only
	// Amazon S3 buckets are supported.
	//
	// This member is required.
	DestinationType DestinationType

	// The status of the publishing destination.
	//
	// This member is required.
	Status PublishingStatus

	noSmithyDocumentSerde
}

// Contains the Amazon Resource Name (ARN) of the resource to publish to, such as
// an S3 bucket, and the ARN of the KMS key to use to encrypt published findings.
type DestinationProperties struct {

	// The ARN of the resource to publish to.
	//
	// To specify an S3 bucket folder use the following format:
	// arn:aws:s3:::DOC-EXAMPLE-BUCKET/myFolder/
	DestinationArn *string

	// The ARN of the KMS key to use for encryption.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains information about the detected behavior.
type Detection struct {

	// The details about the anomalous activity that caused GuardDuty to generate the
	// finding.
	Anomaly *Anomaly

	// The details about the attack sequence.
	Sequence *Sequence

	noSmithyDocumentSerde
}

// Information about the additional configuration for a feature in your GuardDuty
// account.
type DetectorAdditionalConfiguration struct {

	// Name of the additional configuration.
	Name FeatureAdditionalConfiguration

	// Status of the additional configuration.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Information about the additional configuration.
type DetectorAdditionalConfigurationResult struct {

	// Name of the additional configuration.
	Name FeatureAdditionalConfiguration

	// Status of the additional configuration.
	Status FeatureStatus

	// The timestamp at which the additional configuration was last updated. This is
	// in UTC format.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about a GuardDuty feature.
//
// Specifying both EKS Runtime Monitoring ( EKS_RUNTIME_MONITORING ) and Runtime
// Monitoring ( RUNTIME_MONITORING ) will cause an error. You can add only one of
// these two features because Runtime Monitoring already includes the threat
// detection for Amazon EKS resources. For more information, see [Runtime Monitoring].
//
// [Runtime Monitoring]: https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html
type DetectorFeatureConfiguration struct {

	// Additional configuration for a resource.
	AdditionalConfiguration []DetectorAdditionalConfiguration

	// The name of the feature.
	Name DetectorFeature

	// The status of the feature.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Contains information about a GuardDuty feature.
//
// Specifying both EKS Runtime Monitoring ( EKS_RUNTIME_MONITORING ) and Runtime
// Monitoring ( RUNTIME_MONITORING ) will cause an error. You can add only one of
// these two features because Runtime Monitoring already includes the threat
// detection for Amazon EKS resources. For more information, see [Runtime Monitoring].
//
// [Runtime Monitoring]: https://docs.aws.amazon.com/guardduty/latest/ug/runtime-monitoring.html
type DetectorFeatureConfigurationResult struct {

	// Additional configuration for a resource.
	AdditionalConfiguration []DetectorAdditionalConfigurationResult

	// Indicates the name of the feature that can be enabled for the detector.
	Name DetectorFeatureResult

	// Indicates the status of the feature that is enabled for the detector.
	Status FeatureStatus

	// The timestamp at which the feature object was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information on the status of DNS logs as a data source.
type DNSLogsConfigurationResult struct {

	// Denotes whether DNS logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the DNS_REQUEST action described in this finding.
type DnsRequestAction struct {

	// Indicates whether the targeted port is blocked.
	Blocked *bool

	// The domain information for the DNS query.
	Domain *string

	// The second and top level domain involved in the activity that potentially
	// prompted GuardDuty to generate this finding. For a list of top-level and
	// second-level domains, see [public suffix list].
	//
	// [public suffix list]: https://publicsuffix.org/
	DomainWithSuffix *string

	// The network connection protocol observed in the activity that prompted
	// GuardDuty to generate the finding.
	Protocol *string

	// The Amazon Web Services account ID that owns the VPC through which the DNS
	// request was made.
	VpcOwnerAccountId *string

	noSmithyDocumentSerde
}

// Contains information about the domain.
type DomainDetails struct {

	// The domain information for the Amazon Web Services API call.
	Domain *string

	noSmithyDocumentSerde
}

// Contains information about an EBS snapshot that was scanned for malware.
type EbsSnapshot struct {

	// The device name of the EBS snapshot that was scanned.
	DeviceName *string

	noSmithyDocumentSerde
}

// Contains details about the EBS snapshot that was scanned for malware.
type EbsSnapshotDetails struct {

	// The Amazon Resource Name (ARN) of the EBS snapshot.
	SnapshotArn *string

	noSmithyDocumentSerde
}

// Contains list of scanned and skipped EBS volumes with details.
type EbsVolumeDetails struct {

	// List of EBS volumes that were scanned.
	ScannedVolumeDetails []VolumeDetail

	// List of EBS volumes that were skipped from the malware scan.
	SkippedVolumeDetails []VolumeDetail

	noSmithyDocumentSerde
}

// Contains details from the malware scan that created a finding.
type EbsVolumeScanDetails struct {

	// Returns the completion date and time of the malware scan.
	ScanCompletedAt *time.Time

	// Contains a complete view providing malware scan result details.
	ScanDetections *ScanDetections

	// Unique Id of the malware scan that generated the finding.
	ScanId *string

	// Returns the start date and time of the malware scan.
	ScanStartedAt *time.Time

	// Specifies the scan type that invoked the malware scan.
	ScanType ScanType

	// Contains list of threat intelligence sources used to detect threats.
	Sources []string

	// GuardDuty finding ID that triggered a malware scan.
	TriggerFindingId *string

	noSmithyDocumentSerde
}

// Describes the configuration of scanning EBS volumes as a data source.
type EbsVolumesResult struct {

	// Specifies the reason why scanning EBS volumes (Malware Protection) was not
	// enabled as a data source.
	Reason *string

	// Describes whether scanning EBS volumes is enabled as a data source.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the Amazon EC2 Image involved in a GuardDuty
// finding, including unique identifiers of the Amazon EC2 instances.
type Ec2Image struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that were
	// launched with the same Amazon Machine Image (AMI).
	Ec2InstanceUids []string

	noSmithyDocumentSerde
}

// Contains details about the EC2 AMI that was scanned.
type Ec2ImageDetails struct {

	// The Amazon Resource Name (ARN) of the EC2 AMI.
	ImageArn *string

	noSmithyDocumentSerde
}

// Details about the potentially impacted Amazon EC2 instance resource.
type Ec2Instance struct {

	// The availability zone of the Amazon EC2 instance. For more information, see [Availability zones] in
	// the Amazon EC2 User Guide.
	//
	// [Availability zones]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-availability-zones
	AvailabilityZone *string

	// The ID of the network interface.
	Ec2NetworkInterfaceUids []string

	// Contains information about the EC2 instance profile.
	IamInstanceProfile *IamInstanceProfile

	// The image description of the Amazon EC2 instance.
	ImageDescription *string

	// The state of the Amazon EC2 instance. For more information, see [Amazon EC2 instance state changes] in the Amazon
	// EC2 User Guide.
	//
	// [Amazon EC2 instance state changes]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html
	InstanceState *string

	// Type of the Amazon EC2 instance.
	InstanceType *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. This shows
	// applicable Amazon Web Services Outposts instances.
	OutpostArn *string

	// The platform of the Amazon EC2 instance.
	Platform *string

	// The product code of the Amazon EC2 instance.
	ProductCodes []ProductCode

	noSmithyDocumentSerde
}

// Contains information about the Amazon EC2 launch template involved in a
// GuardDuty finding, including unique identifiers of the Amazon EC2 instances.
type Ec2LaunchTemplate struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that
	// share the same Amazon EC2 launch template.
	Ec2InstanceUids []string

	// Version of the EC2 launch template.
	Version *string

	noSmithyDocumentSerde
}

// Contains information about the elastic network interface of the Amazon EC2
// instance.
type Ec2NetworkInterface struct {

	// A list of IPv6 addresses for the Amazon EC2 instance.
	Ipv6Addresses []string

	// Other private IP address information of the Amazon EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails

	// The public IP address of the Amazon EC2 instance.
	PublicIp *string

	// The security groups associated with the Amazon EC2 instance.
	SecurityGroups []SecurityGroup

	// The subnet ID of the Amazon EC2 instance.
	SubNetId *string

	// The VPC ID of the Amazon EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon EC2 VPC involved in a GuardDuty finding,
// including unique identifiers of the Amazon EC2 instances.
type Ec2Vpc struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that were
	// launched within the same Virtual Private Cloud (VPC).
	Ec2InstanceUids []string

	noSmithyDocumentSerde
}

// Contains information about the Amazon ECS cluster involved in a GuardDuty
// finding, including cluster identification and status.
type EcsCluster struct {

	// A list of unique identifiers for the Amazon EC2 instances that serve as
	// container instances in the Amazon ECS cluster.
	Ec2InstanceUids []string

	// The current status of the Amazon ECS cluster.
	Status EcsClusterStatus

	noSmithyDocumentSerde
}

// Contains information about the details of the ECS Cluster.
type EcsClusterDetails struct {

	// The number of services that are running on the cluster in an ACTIVE state.
	ActiveServicesCount *int32

	// The Amazon Resource Name (ARN) that identifies the cluster.
	Arn *string

	// The name of the ECS Cluster.
	Name *string

	// The number of container instances registered into the cluster.
	RegisteredContainerInstancesCount *int32

	// The number of tasks in the cluster that are in the RUNNING state.
	RunningTasksCount *int32

	// The status of the ECS cluster.
	Status *string

	// The tags of the ECS Cluster.
	Tags []Tag

	// Contains information about the details of the ECS Task.
	TaskDetails *EcsTaskDetails

	noSmithyDocumentSerde
}

// Contains information about Amazon ECS task involved in a GuardDuty finding,
// including task definition and container identifiers.
type EcsTask struct {

	// A list of unique identifiers for the containers associated with the Amazon ECS
	// task.
	ContainerUids []string

	// The timestamp indicating when the Amazon ECS task was created, in UTC format.
	CreatedAt *time.Time

	// The infrastructure type on which the Amazon ECS task runs.
	LaunchType EcsLaunchType

	// The ARN of task definition which describes the container and volume definitions
	// of the Amazon ECS task.
	TaskDefinitionArn *string

	noSmithyDocumentSerde
}

// Contains information about the task in an ECS cluster.
type EcsTaskDetails struct {

	// The Amazon Resource Name (ARN) of the task.
	Arn *string

	// The containers that's associated with the task.
	Containers []Container

	// The ARN of the task definition that creates the task.
	DefinitionArn *string

	// The name of the task group that's associated with the task.
	Group *string

	// A capacity on which the task is running. For example, Fargate and EC2 .
	LaunchType *string

	// The Unix timestamp for the time when the task started.
	StartedAt *time.Time

	// Contains the tag specified when a task is started.
	StartedBy *string

	// The tags of the ECS Task.
	Tags []Tag

	// The Unix timestamp for the time when the task was created.
	TaskCreatedAt *time.Time

	// The version counter for the task.
	Version *string

	// The list of data volume definitions for the task.
	Volumes []Volume

	noSmithyDocumentSerde
}

// Contains information about the Amazon EKS cluster involved in a GuardDuty
// finding, including cluster identification, status, and network configuration.
type EksCluster struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the Amazon EKS cluster
	// involved in the finding.
	Arn *string

	// The timestamp indicating when the Amazon EKS cluster was created, in UTC format.
	CreatedAt *time.Time

	// A list of unique identifiers for the Amazon EC2 instances that serve as worker
	// nodes in the Amazon EKS cluster.
	Ec2InstanceUids []string

	// The current status of the Amazon EKS cluster.
	Status ClusterStatus

	// The ID of the Amazon Virtual Private Cloud (Amazon VPC) associated with the
	// Amazon EKS cluster.
	VpcId *string

	noSmithyDocumentSerde
}

// Details about the EKS cluster involved in a Kubernetes finding.
type EksClusterDetails struct {

	// EKS cluster ARN.
	Arn *string

	// The timestamp when the EKS cluster was created.
	CreatedAt *time.Time

	// EKS cluster name.
	Name *string

	// The EKS cluster status.
	Status *string

	// The EKS cluster tags.
	Tags []Tag

	// The VPC ID to which the EKS cluster is attached.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the reason that the finding was generated.
type Evidence struct {

	// A list of threat intelligence details related to the evidence.
	ThreatIntelligenceDetails []ThreatIntelligenceDetail

	noSmithyDocumentSerde
}

// Contains information about Amazon Web Services Fargate details associated with
// an Amazon ECS cluster.
type FargateDetails struct {

	// Runtime coverage issues identified for the resource running on Amazon Web
	// Services Fargate.
	Issues []string

	// Indicates how the GuardDuty security agent is managed for this resource.
	//
	//   - AUTO_MANAGED indicates that GuardDuty deploys and manages updates for this
	//   resource.
	//
	//   - DISABLED indicates that the deployment of the GuardDuty security agent is
	//   disabled for this resource.
	//
	// The MANUAL status doesn't apply to the Amazon Web Services Fargate (Amazon ECS
	// only) woprkloads.
	ManagementType ManagementType

	noSmithyDocumentSerde
}

// Contains information about the condition.
type FilterCondition struct {

	// Represents an equal condition to be applied to a single field when querying for
	// scan entries.
	EqualsValue *string

	// Represents a greater than condition to be applied to a single field when
	// querying for scan entries.
	GreaterThan *int64

	// Represents a less than condition to be applied to a single field when querying
	// for scan entries.
	LessThan *int64

	noSmithyDocumentSerde
}

// Represents the criteria to be used in the filter for describing scan entries.
type FilterCriteria struct {

	// Represents a condition that when matched will be added to the response of the
	// operation.
	FilterCriterion []FilterCriterion

	noSmithyDocumentSerde
}

// Represents a condition that when matched will be added to the response of the
// operation. Irrespective of using any filter criteria, an administrator account
// can view the scan entries for all of its member accounts. However, each member
// account can view the scan entries only for their own account.
type FilterCriterion struct {

	// An enum value representing possible scan properties to match with given scan
	// entries.
	CriterionKey CriterionKey

	// Contains information about the condition.
	FilterCondition *FilterCondition

	noSmithyDocumentSerde
}

// Contains information about the finding that is generated when abnormal or
// suspicious activity is detected.
type Finding struct {

	// The ID of the account in which the finding was generated.
	//
	// This member is required.
	AccountId *string

	// The ARN of the finding.
	//
	// This member is required.
	Arn *string

	// The time and date when the finding was created.
	//
	// This member is required.
	CreatedAt *string

	// The ID of the finding.
	//
	// This member is required.
	Id *string

	// The Region where the finding was generated. For findings generated from [Global Service Events], the
	// Region value in the finding might differ from the Region where GuardDuty
	// identifies the potential threat. For more information, see [How GuardDuty handles Amazon Web Services CloudTrail global events]in the Amazon
	// GuardDuty User Guide.
	//
	// [Global Service Events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-global-service-events
	// [How GuardDuty handles Amazon Web Services CloudTrail global events]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_data-sources.html#cloudtrail_global
	//
	// This member is required.
	Region *string

	// Contains information about the Amazon Web Services resource associated with the
	// activity that prompted GuardDuty to generate a finding.
	//
	// This member is required.
	Resource *Resource

	// The version of the schema used for the finding.
	//
	// This member is required.
	SchemaVersion *string

	// The severity of the finding.
	//
	// This member is required.
	Severity *float64

	// The type of finding.
	//
	// This member is required.
	Type *string

	// The time and date when the finding was last updated.
	//
	// This member is required.
	UpdatedAt *string

	// Amazon Resource Name (ARN) associated with the attack sequence finding.
	AssociatedAttackSequenceArn *string

	// The confidence score for the finding.
	Confidence *float64

	// The description of the finding.
	Description *string

	// The partition associated with the finding.
	Partition *string

	// Contains additional information about the generated finding.
	Service *Service

	// The title of the finding.
	Title *string

	noSmithyDocumentSerde
}

// Contains information about the criteria used for querying findings.
type FindingCriteria struct {

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]Condition

	noSmithyDocumentSerde
}

// Contains information about finding statistics.
type FindingStatistics struct {

	// Represents a list of map of severity to count statistics for a set of findings.
	//
	// Deprecated: This parameter is deprecated. Please set GroupBy to 'SEVERITY' to
	// return GroupedBySeverity instead.
	CountBySeverity map[string]int32

	// Represents a list of map of accounts with a findings count associated with each
	// account.
	GroupedByAccount []AccountStatistics

	// Represents a list of map of dates with a count of total findings generated on
	// each date per severity level.
	GroupedByDate []DateStatistics

	// Represents a list of map of finding types with a count of total findings
	// generated for each type.
	//
	// Based on the orderBy parameter, this request returns either the most occurring
	// finding types or the least occurring finding types. If the orderBy parameter is
	// ASC , this will represent the least occurring finding types in your account;
	// otherwise, this will represent the most occurring finding types. The default
	// value of orderBy is DESC .
	GroupedByFindingType []FindingTypeStatistics

	// Represents a list of map of top resources with a count of total findings.
	GroupedByResource []ResourceStatistics

	// Represents a list of map of total findings for each severity level.
	GroupedBySeverity []SeverityStatistics

	noSmithyDocumentSerde
}

// Information about each finding type associated with the groupedByFindingType
// statistics.
type FindingTypeStatistics struct {

	// Name of the finding type.
	FindingType *string

	// The timestamp at which this finding type was last generated in your environment.
	LastGeneratedAt *time.Time

	// The total number of findings associated with generated for each distinct
	// finding type.
	TotalFindings *int32

	noSmithyDocumentSerde
}

// Contains information on the status of VPC flow logs as a data source.
type FlowLogsConfigurationResult struct {

	// Denotes whether VPC flow logs is enabled as a data source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the free trial period for a feature.
type FreeTrialFeatureConfigurationResult struct {

	// The number of the remaining free trial days for the feature.
	FreeTrialDaysRemaining *int32

	// The name of the feature for which the free trial is configured.
	Name FreeTrialFeatureResult

	noSmithyDocumentSerde
}

// Contains information about the location of the remote IP address. By default,
// GuardDuty returns Geolocation with Lat and Lon as 0.0 .
type GeoLocation struct {

	// The latitude information of the remote IP address.
	Lat *float64

	// The longitude information of the remote IP address.
	Lon *float64

	noSmithyDocumentSerde
}

// Contains information about the results of the malware scan.
type GetMalwareScanResultDetails struct {

	// The total number of files that failed to be scanned.
	FailedFileCount *int64

	// Status indicating whether threats were found for a completed scan.
	ScanResultStatus ScanResultStatus

	// The total number of files that were skipped during the scan.
	SkippedFileCount *int64

	// The total number of files in which threats were detected.
	ThreatFoundFileCount *int64

	// The threats that were detected during the malware scan.
	Threats []ScanResultThreat

	// The total number of bytes that were scanned.
	TotalBytes *int64

	// The total number of files that were processed during the scan.
	TotalFileCount *int64

	// The total number of unique threats that were detected during the scan.
	UniqueThreatCount *int64

	noSmithyDocumentSerde
}

// Contains details of the highest severity threat detected during scan and number
// of infected files.
type HighestSeverityThreatDetails struct {

	// Total number of infected files with the highest severity threat detected.
	Count *int32

	// Severity level of the highest severity threat detected.
	Severity *string

	// Threat name of the highest severity threat detected as part of the malware scan.
	ThreatName *string

	noSmithyDocumentSerde
}

// Represents a pre-existing file or directory on the host machine that the volume
// maps to.
type HostPath struct {

	// Path of the file or directory on the host that the volume maps to.
	Path *string

	noSmithyDocumentSerde
}

// Contains information about the EC2 instance profile.
type IamInstanceProfile struct {

	// The profile ARN of the EC2 instance.
	Arn *string

	// The profile ID of the EC2 instance.
	Id *string

	noSmithyDocumentSerde
}

// Contains information about the IAM instance profile involved in a GuardDuty
// finding, including unique identifiers of the Amazon EC2 instances.
type IamInstanceProfileV2 struct {

	// A list of unique identifiers for the compromised Amazon EC2 instances that
	// share the same IAM instance profile.
	Ec2InstanceUids []string

	noSmithyDocumentSerde
}

// Contains information about the impersonated user.
type ImpersonatedUser struct {

	// The group to which the user name belongs.
	Groups []string

	// Information about the username that was being impersonated.
	Username *string

	noSmithyDocumentSerde
}

// Contains information about the incremental scan configuration.
type IncrementalScanDetails struct {

	// Amazon Resource Name (ARN) of the baseline resource used for incremental
	// scanning. The scan will only process changes since this baseline resource was
	// created.
	//
	// This member is required.
	BaselineResourceArn *string

	noSmithyDocumentSerde
}

// Contains information about the indicators that include a set of signals
// observed in an attack sequence.
type Indicator struct {

	// Specific indicator keys observed in the attack sequence. For description of the
	// valid values for key, see [Attack sequence finding details]in the Amazon GuardDuty User Guide.
	//
	// [Attack sequence finding details]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings-summary.html#guardduty-extended-threat-detection-attack-sequence-finding-details
	//
	// This member is required.
	Key IndicatorType

	// Title describing the indicator.
	Title *string

	// Values associated with each indicator key. For example, if the indicator key is
	// SUSPICIOUS_NETWORK , then the value will be the name of the network. If the
	// indicator key is ATTACK_TACTIC , then the value will be one of the MITRE
	// tactics.
	Values []string

	noSmithyDocumentSerde
}

// Contains information about the details of an instance.
type InstanceDetails struct {

	// The Availability Zone of the EC2 instance.
	AvailabilityZone *string

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile

	// The image description of the EC2 instance.
	ImageDescription *string

	// The image ID of the EC2 instance.
	ImageId *string

	// The ID of the EC2 instance.
	InstanceId *string

	// The state of the EC2 instance.
	InstanceState *string

	// The type of the EC2 instance.
	InstanceType *string

	// The launch time of the EC2 instance.
	LaunchTime *string

	// The elastic network interface information of the EC2 instance.
	NetworkInterfaces []NetworkInterface

	// The Amazon Resource Name (ARN) of the Amazon Web Services Outpost. Only
	// applicable to Amazon Web Services Outposts instances.
	OutpostArn *string

	// The platform of the EC2 instance.
	Platform *string

	// The product code of the EC2 instance.
	ProductCodes []ProductCode

	// The tags of the EC2 instance.
	Tags []Tag

	noSmithyDocumentSerde
}

// Contains information about the invitation to become a member account.
type Invitation struct {

	// The ID of the account that the invitation was sent from.
	AccountId *string

	// The ID of the invitation. This value is used to validate the inviter account to
	// the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains detailed information about where a threat was detected.
type ItemDetails struct {

	// Additional information about the detected threat item.
	AdditionalInfo *AdditionalInfo

	// The hash value of the infected item.
	Hash *string

	// The path where the threat was detected.
	ItemPath *string

	// Amazon Resource Name (ARN) of the resource where the threat was detected.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Information about the nested item path and hash of the protected resource.
type ItemPath struct {

	// The hash value of the infected resource.
	Hash *string

	// The nested item path where the infected file was found.
	NestedItemPath *string

	noSmithyDocumentSerde
}

// Information about the Kubernetes API call action described in this finding.
type KubernetesApiCallAction struct {

	// The name of the namespace where the Kubernetes API call action takes place.
	Namespace *string

	// Parameters related to the Kubernetes API call action.
	Parameters *string

	// Contains information about the remote IP address of the connection.
	RemoteIpDetails *RemoteIpDetails

	// The Kubernetes API request URI.
	RequestUri *string

	// The resource component in the Kubernetes API call action.
	Resource *string

	// The name of the resource in the Kubernetes API call action.
	ResourceName *string

	// The IP of the Kubernetes API caller and the IPs of any proxies or load
	// balancers between the caller and the API endpoint.
	SourceIps []string

	// The resulting HTTP response code of the Kubernetes API call action.
	StatusCode *int32

	// The name of the sub-resource in the Kubernetes API call action.
	Subresource *string

	// The user agent of the caller of the Kubernetes API.
	UserAgent *string

	// The Kubernetes API request HTTP verb.
	Verb *string

	noSmithyDocumentSerde
}

// Describes whether Kubernetes audit logs are enabled as a data source.
type KubernetesAuditLogsConfiguration struct {

	// The status of Kubernetes audit logs as a data source.
	//
	// This member is required.
	Enable *bool

	noSmithyDocumentSerde
}

// Describes whether Kubernetes audit logs are enabled as a data source.
type KubernetesAuditLogsConfigurationResult struct {

	// A value that describes whether Kubernetes audit logs are enabled as a data
	// source.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Describes whether any Kubernetes data sources are enabled.
type KubernetesConfiguration struct {

	// The status of Kubernetes audit logs as a data source.
	//
	// This member is required.
	AuditLogs *KubernetesAuditLogsConfiguration

	noSmithyDocumentSerde
}

// Describes whether any Kubernetes logs will be enabled as a data source.
type KubernetesConfigurationResult struct {

	// Describes whether Kubernetes audit logs are enabled as a data source.
	//
	// This member is required.
	AuditLogs *KubernetesAuditLogsConfigurationResult

	noSmithyDocumentSerde
}

// Provides details about the Kubernetes resources when it is enabled as a data
// source.
type KubernetesDataSourceFreeTrial struct {

	// Describes whether Kubernetes audit logs are enabled as a data source.
	AuditLogs *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Details about Kubernetes resources such as a Kubernetes user or workload
// resource involved in a Kubernetes finding.
type KubernetesDetails struct {

	// Details about the Kubernetes user involved in a Kubernetes finding.
	KubernetesUserDetails *KubernetesUserDetails

	// Details about the Kubernetes workload involved in a Kubernetes finding.
	KubernetesWorkloadDetails *KubernetesWorkloadDetails

	noSmithyDocumentSerde
}

// Information about the Kubernetes API for which you check if you have permission
// to call.
type KubernetesPermissionCheckedDetails struct {

	// Information whether the user has the permission to call the Kubernetes API.
	Allowed *bool

	// The namespace where the Kubernetes API action will take place.
	Namespace *string

	// The Kubernetes resource with which your Kubernetes API call will interact.
	Resource *string

	// The verb component of the Kubernetes API call. For example, when you check
	// whether or not you have the permission to call the CreatePod API, the verb
	// component will be Create .
	Verb *string

	noSmithyDocumentSerde
}

// Contains information about the role binding that grants the permission defined
// in a Kubernetes role.
type KubernetesRoleBindingDetails struct {

	// The kind of the role. For role binding, this value will be RoleBinding .
	Kind *string

	// The name of the RoleBinding .
	Name *string

	// The type of the role being referenced. This could be either Role or ClusterRole .
	RoleRefKind *string

	// The name of the role being referenced. This must match the name of the Role or
	// ClusterRole that you want to bind to.
	RoleRefName *string

	// The unique identifier of the role binding.
	Uid *string

	noSmithyDocumentSerde
}

// Information about the Kubernetes role name and role type.
type KubernetesRoleDetails struct {

	// The kind of role. For this API, the value of kind will be Role .
	Kind *string

	// The name of the Kubernetes role.
	Name *string

	// The unique identifier of the Kubernetes role name.
	Uid *string

	noSmithyDocumentSerde
}

// Details about the Kubernetes user involved in a Kubernetes finding.
type KubernetesUserDetails struct {

	// The groups that include the user who called the Kubernetes API.
	Groups []string

	// Information about the impersonated user.
	ImpersonatedUser *ImpersonatedUser

	// Entity that assumes the IAM role when Kubernetes RBAC permissions are assigned
	// to that role.
	SessionName []string

	// The user ID of the user who called the Kubernetes API.
	Uid *string

	// The username of the user who called the Kubernetes API.
	Username *string

	noSmithyDocumentSerde
}

// Contains information about Kubernetes workloads involved in a GuardDuty
// finding, including pods, deployments, and other Kubernetes resources.
type KubernetesWorkload struct {

	// A list of unique identifiers for the containers that are part of the Kubernetes
	// workload.
	ContainerUids []string

	// The types of Kubernetes resources involved in the workload.
	KubernetesResourcesTypes KubernetesResourcesTypes

	// The Kubernetes namespace in which the workload is running, providing logical
	// isolation within the cluster.
	Namespace *string

	noSmithyDocumentSerde
}

// Details about the Kubernetes workload involved in a Kubernetes finding.
type KubernetesWorkloadDetails struct {

	// Containers running as part of the Kubernetes workload.
	Containers []Container

	// Whether the host IPC flag is enabled for the pods in the workload.
	HostIPC *bool

	// Whether the hostNetwork flag is enabled for the pods included in the workload.
	HostNetwork *bool

	// Whether the host PID flag is enabled for the pods in the workload.
	HostPID *bool

	// Kubernetes workload name.
	Name *string

	// Kubernetes namespace that the workload is part of.
	Namespace *string

	// The service account name that is associated with a Kubernetes workload.
	ServiceAccountName *string

	// Kubernetes workload type (e.g. Pod, Deployment, etc.).
	Type *string

	// Kubernetes workload ID.
	Uid *string

	// Volumes used by the Kubernetes workload.
	Volumes []Volume

	noSmithyDocumentSerde
}

// Information about the Lambda function involved in the finding.
type LambdaDetails struct {

	// Description of the Lambda function.
	Description *string

	// Amazon Resource Name (ARN) of the Lambda function.
	FunctionArn *string

	// Name of the Lambda function.
	FunctionName *string

	// The version of the Lambda function.
	FunctionVersion *string

	// The timestamp when the Lambda function was last modified. This field is in the
	// UTC date string format (2023-03-22T19:37:20.168Z) .
	LastModifiedAt *time.Time

	// The revision ID of the Lambda function version.
	RevisionId *string

	// The execution role of the Lambda function.
	Role *string

	// A list of tags attached to this resource, listed in the format of key : value
	// pair.
	Tags []Tag

	// Amazon Virtual Private Cloud configuration details associated with your Lambda
	// function.
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// Information about the runtime process details.
type LineageObject struct {

	// The effective user ID that was used to execute the process.
	Euid *int32

	// The absolute path of the process executable file.
	ExecutablePath *string

	// The name of the process.
	Name *string

	// The process ID of the child process.
	NamespacePid *int32

	// The unique ID of the parent process. This ID is assigned to the parent process
	// by GuardDuty.
	ParentUuid *string

	// The ID of the process.
	Pid *int32

	// The time when the process started. This is in UTC format.
	StartTime *time.Time

	// The user ID of the user that executed the process.
	UserId *int32

	// The unique ID assigned to the process by GuardDuty.
	Uuid *string

	noSmithyDocumentSerde
}

// Represents the criteria used to filter the malware scan entries.
type ListMalwareScansFilterCriteria struct {

	// Represents a condition that when matched will be added to the response of the
	// operation.
	ListMalwareScansFilterCriterion []ListMalwareScansFilterCriterion

	noSmithyDocumentSerde
}

// Represents a condition that when matched will be added to the response of the
// operation. Irrespective of using any filter criteria, an administrator account
// can view the scan entries for all of its member accounts. However, each member
// account can view the scan entries only for their own account.
type ListMalwareScansFilterCriterion struct {

	// Contains information about the condition.
	FilterCondition *FilterCondition

	// An enum value representing possible scan properties to match with given scan
	// entries.
	ListMalwareScansCriterionKey ListMalwareScansCriterionKey

	noSmithyDocumentSerde
}

// Contains information about the local IP address of the connection.
type LocalIpDetails struct {

	// The IPv4 local address of the connection.
	IpAddressV4 *string

	// The IPv6 local address of the connection.
	IpAddressV6 *string

	noSmithyDocumentSerde
}

// Contains information about the port for the local connection.
type LocalPortDetails struct {

	// The port number of the local connection.
	Port *int32

	// The port name of the local connection.
	PortName *string

	noSmithyDocumentSerde
}

// Information about the login attempts.
type LoginAttribute struct {

	// Indicates the application name used to attempt log in.
	Application *string

	// Represents the sum of failed (unsuccessful) login attempts made to establish a
	// connection to the database instance.
	FailedLoginAttempts *int32

	// Represents the sum of successful connections (a correct combination of login
	// attributes) made to the database instance by the actor.
	SuccessfulLoginAttempts *int32

	// Indicates the user name which attempted to log in.
	User *string

	noSmithyDocumentSerde
}

// Describes whether Malware Protection will be enabled as a data source.
type MalwareProtectionConfiguration struct {

	// Describes the configuration of Malware Protection for EC2 instances with
	// findings.
	ScanEc2InstanceWithFindings *ScanEc2InstanceWithFindings

	noSmithyDocumentSerde
}

// An object that contains information on the status of all Malware Protection
// data sources.
type MalwareProtectionConfigurationResult struct {

	// Describes the configuration of Malware Protection for EC2 instances with
	// findings.
	ScanEc2InstanceWithFindings *ScanEc2InstanceWithFindingsResult

	// The GuardDuty Malware Protection service role.
	ServiceRole *string

	noSmithyDocumentSerde
}

// Provides details about Malware Protection when it is enabled as a data source.
type MalwareProtectionDataSourceFreeTrial struct {

	// Describes whether Malware Protection for EC2 instances with findings is enabled
	// as a data source.
	ScanEc2InstanceWithFindings *DataSourceFreeTrial

	noSmithyDocumentSerde
}

// Contains finding configuration details about the malware scan.
type MalwareProtectionFindingsScanConfiguration struct {

	// Contains information about the incremental scan configuration.
	IncrementalScanDetails *IncrementalScanDetails

	// The event that triggered the malware scan.
	TriggerType TriggerType

	noSmithyDocumentSerde
}

// Information about whether the tags will be added to the S3 object after
// scanning.
type MalwareProtectionPlanActions struct {

	// Indicates whether the scanned S3 object will have tags about the scan result.
	Tagging *MalwareProtectionPlanTaggingAction

	noSmithyDocumentSerde
}

// Information about the issue code and message associated to the status of your
// Malware Protection plan.
type MalwareProtectionPlanStatusReason struct {

	// Issue code.
	Code *string

	// Issue message that specifies the reason. For information about potential
	// troubleshooting steps, see [Troubleshooting Malware Protection for S3 status issues]in the Amazon GuardDuty User Guide.
	//
	// [Troubleshooting Malware Protection for S3 status issues]: https://docs.aws.amazon.com/guardduty/latest/ug/troubleshoot-s3-malware-protection-status-errors.html
	Message *string

	noSmithyDocumentSerde
}

// Information about the Malware Protection plan resource.
type MalwareProtectionPlanSummary struct {

	// A unique identifier associated with Malware Protection plan.
	MalwareProtectionPlanId *string

	noSmithyDocumentSerde
}

// Information about adding tags to the scanned S3 object after the scan result.
type MalwareProtectionPlanTaggingAction struct {

	// Indicates whether or not the tags will added.
	Status MalwareProtectionPlanTaggingActionStatus

	noSmithyDocumentSerde
}

// Contains information about a particular malware scan.
type MalwareScan struct {

	// Amazon Resource Name (ARN) of the resource for the given malware scan.
	ResourceArn *string

	// The type of resource that was scanned for malware.
	ResourceType MalwareProtectionResourceType

	// The timestamp representing when the malware scan was completed.
	ScanCompletedAt *time.Time

	// A unique identifier that gets generated when you invoke the API without any
	// error. Each malware scan has a corresponding scan ID. Using this scan ID, you
	// can monitor the status of your malware scan.
	ScanId *string

	// An enum value representing the result of the malware scan.
	ScanResultStatus ScanResultStatus

	// The timestamp representing when the malware scan was started.
	ScanStartedAt *time.Time

	// An enum value representing the current status of the malware scan.
	ScanStatus MalwareProtectionScanStatus

	// An enum value representing the type of scan that was initiated.
	ScanType MalwareProtectionScanType

	noSmithyDocumentSerde
}

// Information about the malware scan that generated a GuardDuty finding.
type MalwareScanDetails struct {

	// The category of the malware scan.
	ScanCategory ScanCategory

	// The configuration settings used for the malware scan.
	ScanConfiguration *MalwareProtectionFindingsScanConfiguration

	// The unique identifier for the malware scan.
	ScanId *string

	// The type of malware scan performed.
	ScanType MalwareProtectionScanType

	// Information about the detected threats associated with the generated GuardDuty
	// finding.
	Threats []Threat

	// The number of unique malware threats detected during the scan.
	UniqueThreatCount *int32

	noSmithyDocumentSerde
}

// Contains information about the administrator account and invitation.
type Master struct {

	// The ID of the account used as the administrator account.
	AccountId *string

	// The value used to validate the administrator account to the member account.
	InvitationId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	// The status of the relationship between the administrator and member accounts.
	RelationshipStatus *string

	noSmithyDocumentSerde
}

// Contains information about the member account.
type Member struct {

	// The ID of the member account.
	//
	// This member is required.
	AccountId *string

	// The email address of the member account.
	//
	// This member is required.
	Email *string

	// The administrator account ID.
	//
	// This member is required.
	MasterId *string

	// The status of the relationship between the member and the administrator.
	//
	// This member is required.
	RelationshipStatus *string

	// The last-updated timestamp of the member.
	//
	// This member is required.
	UpdatedAt *string

	// The administrator account ID.
	AdministratorId *string

	// The detector ID of the member account.
	DetectorId *string

	// The timestamp when the invitation was sent.
	InvitedAt *string

	noSmithyDocumentSerde
}

// Information about the additional configuration for the member account.
type MemberAdditionalConfiguration struct {

	// Name of the additional configuration.
	Name OrgFeatureAdditionalConfiguration

	// Status of the additional configuration.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Information about the additional configuration for the member account.
type MemberAdditionalConfigurationResult struct {

	// Indicates the name of the additional configuration that is set for the member
	// account.
	Name OrgFeatureAdditionalConfiguration

	// Indicates the status of the additional configuration that is set for the member
	// account.
	Status FeatureStatus

	// The timestamp at which the additional configuration was set for the member
	// account. This is in UTC format.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information on which data sources are enabled for a member account.
type MemberDataSourceConfiguration struct {

	// The account ID for the member account.
	//
	// This member is required.
	AccountId *string

	// Contains information on the status of data sources for the account.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources *DataSourceConfigurationsResult

	// Contains information about the status of the features for the member account.
	Features []MemberFeaturesConfigurationResult

	noSmithyDocumentSerde
}

// Contains information about the features for the member account.
type MemberFeaturesConfiguration struct {

	// Additional configuration of the feature for the member account.
	AdditionalConfiguration []MemberAdditionalConfiguration

	// The name of the feature.
	Name OrgFeature

	// The status of the feature.
	Status FeatureStatus

	noSmithyDocumentSerde
}

// Contains information about the features for the member account.
type MemberFeaturesConfigurationResult struct {

	// Indicates the additional configuration of the feature that is configured for
	// the member account.
	AdditionalConfiguration []MemberAdditionalConfigurationResult

	// Indicates the name of the feature that is enabled for the detector.
	Name OrgFeature

	// Indicates the status of the feature that is enabled for the detector.
	Status FeatureStatus

	// The timestamp at which the feature object was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains information about the network connection.
type NetworkConnection struct {

	// The direction in which the network traffic is flowing.
	//
	// This member is required.
	Direction NetworkDirection

	noSmithyDocumentSerde
}

// Contains information about the NETWORK_CONNECTION action described in the
// finding.
type NetworkConnectionAction struct {

	// Indicates whether EC2 blocked the network connection to your instance.
	Blocked *bool

	// The network connection direction.
	ConnectionDirection *string

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The EC2 instance's local elastic network interface utilized for the connection.
	LocalNetworkInterface *string

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The network connection protocol.
	Protocol *string

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	// The remote port information of the connection.
	RemotePortDetails *RemotePortDetails

	noSmithyDocumentSerde
}

// Contains information about network endpoints that were observed in the attack
// sequence.
type NetworkEndpoint struct {

	// The ID of the network endpoint.
	//
	// This member is required.
	Id *string

	// The Autonomous System (AS) of the network endpoint.
	AutonomousSystem *AutonomousSystem

	// Information about the network connection.
	Connection *NetworkConnection

	// The domain information for the network endpoint.
	Domain *string

	// The IP address associated with the network endpoint.
	Ip *string

	// Information about the location of the network endpoint.
	Location *NetworkGeoLocation

	// The port number associated with the network endpoint.
	Port *int32

	noSmithyDocumentSerde
}

// Contains information about network endpoint location.
type NetworkGeoLocation struct {

	// The name of the city.
	//
	// This member is required.
	City *string

	// The name of the country.
	//
	// This member is required.
	Country *string

	// The latitude information of the endpoint location.
	//
	// This member is required.
	Latitude *float64

	// The longitude information of the endpoint location.
	//
	// This member is required.
	Longitude *float64

	noSmithyDocumentSerde
}

// Contains information about the elastic network interface of the EC2 instance.
type NetworkInterface struct {

	// A list of IPv6 addresses for the EC2 instance.
	Ipv6Addresses []string

	// The ID of the network interface.
	NetworkInterfaceId *string

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails

	// The public DNS name of the EC2 instance.
	PublicDnsName *string

	// The public IP address of the EC2 instance.
	PublicIp *string

	// The security groups associated with the EC2 instance.
	SecurityGroups []SecurityGroup

	// The subnet ID of the EC2 instance.
	SubnetId *string

	// The VPC ID of the EC2 instance.
	VpcId *string

	noSmithyDocumentSerde
}

// Contains information about the observed behavior.
type Observations struct {

	// The text that was unusual.
	Text []string

	noSmithyDocumentSerde
}

// Contains information about the ISP organization of the remote IP address.
type Organization struct {

	// The Autonomous System Number (ASN) of the internet provider of the remote IP
	// address.
	Asn *string

	// The organization that registered this ASN.
	AsnOrg *string

	// The ISP information for the internet provider.
	Isp *string

	// The name of the internet provider.
	Org *string

	noSmithyDocumentSerde
}

// A list of additional configurations which will be configured for the
// organization.
//
// Additional configuration applies to only GuardDuty Runtime Monitoring
// protection plan.
type OrganizationAdditionalConfiguration struct {

	// The status of the additional configuration that will be configured for the
	// organization. Use one of the following values to configure the feature status
	// for the entire organization:
	//
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have the additional configuration enabled automatically.
	//
	//   - ALL : Indicates that all accounts in the organization have the additional
	//   configuration enabled automatically. This includes NEW accounts that join the
	//   organization and accounts that may have been suspended or removed from the
	//   organization in GuardDuty.
	//
	// It may take up to 24 hours to update the configuration for all the member
	//   accounts.
	//
	//   - NONE : Indicates that the additional configuration will not be automatically
	//   enabled for any account in the organization. The administrator must manage the
	//   additional configuration for each account individually.
	AutoEnable OrgFeatureStatus

	// The name of the additional configuration that will be configured for the
	// organization. These values are applicable to only Runtime Monitoring protection
	// plan.
	Name OrgFeatureAdditionalConfiguration

	noSmithyDocumentSerde
}

// A list of additional configuration which will be configured for the
// organization.
type OrganizationAdditionalConfigurationResult struct {

	// Describes the status of the additional configuration that is configured for the
	// member accounts within the organization. One of the following values is the
	// status for the entire organization:
	//
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have the additional configuration enabled automatically.
	//
	//   - ALL : Indicates that all accounts in the organization have the additional
	//   configuration enabled automatically. This includes NEW accounts that join the
	//   organization and accounts that may have been suspended or removed from the
	//   organization in GuardDuty.
	//
	// It may take up to 24 hours to update the configuration for all the member
	//   accounts.
	//
	//   - NONE : Indicates that the additional configuration will not be automatically
	//   enabled for any account in the organization. The administrator must manage the
	//   additional configuration for each account individually.
	AutoEnable OrgFeatureStatus

	// The name of the additional configuration that is configured for the member
	// accounts within the organization. These values are applicable to only Runtime
	// Monitoring protection plan.
	Name OrgFeatureAdditionalConfiguration

	noSmithyDocumentSerde
}

// An object that contains information on which data sources will be configured to
// be automatically enabled for new members within the organization.
type OrganizationDataSourceConfigurations struct {

	// Describes the configuration of Kubernetes data sources for new members of the
	// organization.
	Kubernetes *OrganizationKubernetesConfiguration

	// Describes the configuration of Malware Protection for new members of the
	// organization.
	MalwareProtection *OrganizationMalwareProtectionConfiguration

	// Describes whether S3 data event logs are enabled for new members of the
	// organization.
	S3Logs *OrganizationS3LogsConfiguration

	noSmithyDocumentSerde
}

// An object that contains information on which data sources are automatically
// enabled for new members within the organization.
type OrganizationDataSourceConfigurationsResult struct {

	// Describes whether S3 data event logs are enabled as a data source.
	//
	// This member is required.
	S3Logs *OrganizationS3LogsConfigurationResult

	// Describes the configuration of Kubernetes data sources.
	Kubernetes *OrganizationKubernetesConfigurationResult

	// Describes the configuration of Malware Protection data source for an
	// organization.
	MalwareProtection *OrganizationMalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Information about GuardDuty coverage statistics for members in your Amazon Web
// Services organization.
type OrganizationDetails struct {

	// Information about the GuardDuty coverage statistics for members in your Amazon
	// Web Services organization.
	OrganizationStatistics *OrganizationStatistics

	// The timestamp at which the organization statistics was last updated. This is in
	// UTC format.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Organization-wide EBS volumes scan configuration.
type OrganizationEbsVolumes struct {

	// Whether scanning EBS volumes should be auto-enabled for new members joining the
	// organization.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// An object that contains information on the status of whether EBS volumes
// scanning will be enabled as a data source for an organization.
type OrganizationEbsVolumesResult struct {

	// An object that contains the status of whether scanning EBS volumes should be
	// auto-enabled for new members joining the organization.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// A list of features which will be configured for the organization.
type OrganizationFeatureConfiguration struct {

	// The additional information that will be configured for the organization.
	AdditionalConfiguration []OrganizationAdditionalConfiguration

	// Describes the status of the feature that is configured for the member accounts
	// within the organization. One of the following values is the status for the
	// entire organization:
	//
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have the feature enabled automatically.
	//
	//   - ALL : Indicates that all accounts in the organization have the feature
	//   enabled automatically. This includes NEW accounts that join the organization
	//   and accounts that may have been suspended or removed from the organization in
	//   GuardDuty.
	//
	// It may take up to 24 hours to update the configuration for all the member
	//   accounts.
	//
	//   - NONE : Indicates that the feature will not be automatically enabled for any
	//   account in the organization. The administrator must manage the feature for each
	//   account individually.
	AutoEnable OrgFeatureStatus

	// The name of the feature that will be configured for the organization.
	Name OrgFeature

	noSmithyDocumentSerde
}

// A list of features which will be configured for the organization.
type OrganizationFeatureConfigurationResult struct {

	// The additional configuration that is configured for the member accounts within
	// the organization.
	AdditionalConfiguration []OrganizationAdditionalConfigurationResult

	// Describes the status of the feature that is configured for the member accounts
	// within the organization.
	//
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have the feature enabled automatically.
	//
	//   - ALL : Indicates that all accounts in the organization have the feature
	//   enabled automatically. This includes NEW accounts that join the organization
	//   and accounts that may have been suspended or removed from the organization in
	//   GuardDuty.
	//
	//   - NONE : Indicates that the feature will not be automatically enabled for any
	//   account in the organization. In this case, each account will be managed
	//   individually by the administrator.
	AutoEnable OrgFeatureStatus

	// The name of the feature that is configured for the member accounts within the
	// organization.
	Name OrgFeature

	noSmithyDocumentSerde
}

// Information about the number of accounts that have enabled a specific feature.
type OrganizationFeatureStatistics struct {

	// Name of the additional configuration.
	AdditionalConfiguration []OrganizationFeatureStatisticsAdditionalConfiguration

	// Total number of accounts that have enabled a specific feature.
	EnabledAccountsCount *int32

	// Name of the feature.
	Name OrgFeature

	noSmithyDocumentSerde
}

// Information about the coverage statistic for the additional configuration of
// the feature.
type OrganizationFeatureStatisticsAdditionalConfiguration struct {

	// Total number of accounts that have enabled the additional configuration.
	EnabledAccountsCount *int32

	// Name of the additional configuration within a feature.
	Name OrgFeatureAdditionalConfiguration

	noSmithyDocumentSerde
}

// Organization-wide Kubernetes audit logs configuration.
type OrganizationKubernetesAuditLogsConfiguration struct {

	// A value that contains information on whether Kubernetes audit logs should be
	// enabled automatically as a data source for the organization.
	//
	// This member is required.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// The current configuration of Kubernetes audit logs as a data source for the
// organization.
type OrganizationKubernetesAuditLogsConfigurationResult struct {

	// Whether Kubernetes audit logs data source should be auto-enabled for new
	// members joining the organization.
	//
	// This member is required.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// Organization-wide Kubernetes data sources configurations.
type OrganizationKubernetesConfiguration struct {

	// Whether Kubernetes audit logs data source should be auto-enabled for new
	// members joining the organization.
	//
	// This member is required.
	AuditLogs *OrganizationKubernetesAuditLogsConfiguration

	noSmithyDocumentSerde
}

// The current configuration of all Kubernetes data sources for the organization.
type OrganizationKubernetesConfigurationResult struct {

	// The current configuration of Kubernetes audit logs as a data source for the
	// organization.
	//
	// This member is required.
	AuditLogs *OrganizationKubernetesAuditLogsConfigurationResult

	noSmithyDocumentSerde
}

// Organization-wide Malware Protection configurations.
type OrganizationMalwareProtectionConfiguration struct {

	// Whether Malware Protection for EC2 instances with findings should be
	// auto-enabled for new members joining the organization.
	ScanEc2InstanceWithFindings *OrganizationScanEc2InstanceWithFindings

	noSmithyDocumentSerde
}

// An object that contains information on the status of all Malware Protection
// data source for an organization.
type OrganizationMalwareProtectionConfigurationResult struct {

	// Describes the configuration for scanning EC2 instances with findings for an
	// organization.
	ScanEc2InstanceWithFindings *OrganizationScanEc2InstanceWithFindingsResult

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be automatically enabled for new
// members of the organization.
type OrganizationS3LogsConfiguration struct {

	// A value that contains information on whether S3 data event logs will be enabled
	// automatically as a data source for the organization.
	//
	// This member is required.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// The current configuration of S3 data event logs as a data source for the
// organization.
type OrganizationS3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	AutoEnable *bool

	noSmithyDocumentSerde
}

// Organization-wide EC2 instances with findings scan configuration.
type OrganizationScanEc2InstanceWithFindings struct {

	// Whether scanning EBS volumes should be auto-enabled for new members joining the
	// organization.
	EbsVolumes *OrganizationEbsVolumes

	noSmithyDocumentSerde
}

// An object that contains information on the status of scanning EC2 instances
// with findings for an organization.
type OrganizationScanEc2InstanceWithFindingsResult struct {

	// Describes the configuration for scanning EBS volumes for an organization.
	EbsVolumes *OrganizationEbsVolumesResult

	noSmithyDocumentSerde
}

// Information about the coverage statistics of the features for the entire Amazon
// Web Services organization.
//
// When you create a new Amazon Web Services organization, it might take up to 24
// hours to generate the statistics summary for this organization.
type OrganizationStatistics struct {

	// Total number of active accounts in your Amazon Web Services organization that
	// are associated with GuardDuty.
	ActiveAccountsCount *int32

	// Retrieves the coverage statistics for each feature.
	CountByFeature []OrganizationFeatureStatistics

	// Total number of accounts that have enabled GuardDuty.
	EnabledAccountsCount *int32

	// Total number of accounts in your Amazon Web Services organization that are
	// associated with GuardDuty.
	MemberAccountsCount *int32

	// Total number of accounts in your Amazon Web Services organization.
	TotalAccountsCount *int32

	noSmithyDocumentSerde
}

// Contains information on the owner of the bucket.
type Owner struct {

	// The canonical user ID of the bucket owner. For information about locating your
	// canonical user ID see [Finding Your Account Canonical User ID.]
	//
	// [Finding Your Account Canonical User ID.]: https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html#FindingCanonicalId
	Id *string

	noSmithyDocumentSerde
}

// Contains information about how permissions are configured for the S3 bucket.
type PermissionConfiguration struct {

	// Contains information about the account level permissions on the S3 bucket.
	AccountLevelPermissions *AccountLevelPermissions

	// Contains information about the bucket level permissions for the S3 bucket.
	BucketLevelPermissions *BucketLevelPermissions

	noSmithyDocumentSerde
}

// Contains information about the PORT_PROBE action described in the finding.
type PortProbeAction struct {

	// Indicates whether EC2 blocked the port probe to the instance, such as with an
	// ACL.
	Blocked *bool

	// A list of objects related to port probe details.
	PortProbeDetails []PortProbeDetail

	noSmithyDocumentSerde
}

// Contains information about the port probe details.
type PortProbeDetail struct {

	// The local IP information of the connection.
	LocalIpDetails *LocalIpDetails

	// The local port information of the connection.
	LocalPortDetails *LocalPortDetails

	// The remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails

	noSmithyDocumentSerde
}

// Contains other private IP address information of the EC2 instance.
type PrivateIpAddressDetails struct {

	// The private DNS name of the EC2 instance.
	PrivateDnsName *string

	// The private IP address of the EC2 instance.
	PrivateIpAddress *string

	noSmithyDocumentSerde
}

// Information about the observed process.
type ProcessDetails struct {

	// The effective user ID of the user that executed the process.
	Euid *int32

	// The absolute path of the process executable file.
	ExecutablePath *string

	// The SHA256 hash of the process executable.
	ExecutableSha256 *string

	// Information about the process's lineage.
	Lineage []LineageObject

	// The name of the process.
	Name *string

	// The ID of the child process.
	NamespacePid *int32

	// The unique ID of the parent process. This ID is assigned to the parent process
	// by GuardDuty.
	ParentUuid *string

	// The ID of the process.
	Pid *int32

	// The present working directory of the process.
	Pwd *string

	// The time when the process started. This is in UTC format.
	StartTime *time.Time

	// The user that executed the process.
	User *string

	// The unique ID of the user that executed the process.
	UserId *int32

	// The unique ID assigned to the process by GuardDuty.
	Uuid *string

	noSmithyDocumentSerde
}

// Contains information about the product code for the EC2 instance.
type ProductCode struct {

	// The product code information.
	Code *string

	// The product code type.
	ProductType *string

	noSmithyDocumentSerde
}

// Describes the public access policies that apply to the S3 bucket.
type PublicAccess struct {

	// Describes the effective permission on this bucket after factoring all attached
	// policies.
	EffectivePermission *string

	// Contains information about how permissions are configured for the S3 bucket.
	PermissionConfiguration *PermissionConfiguration

	noSmithyDocumentSerde
}

// Describes public access policies that apply to the Amazon S3 bucket.
//
// For information about each of the following settings, see [Blocking public access to your Amazon S3 storage] in the Amazon S3
// User Guide.
//
// [Blocking public access to your Amazon S3 storage]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html
type PublicAccessConfiguration struct {

	// Indicates whether or not there is a setting that allows public access to the
	// Amazon S3 buckets through access control lists (ACLs).
	PublicAclAccess PublicAccessStatus

	// Indicates whether or not there is a setting that ignores all public access
	// control lists (ACLs) on the Amazon S3 bucket and the objects that it contains.
	PublicAclIgnoreBehavior PublicAclIgnoreBehavior

	// Indicates whether or not there is a setting that restricts access to the bucket
	// with specified policies.
	PublicBucketRestrictBehavior PublicBucketRestrictBehavior

	// Indicates whether or not there is a setting that allows public access to the
	// Amazon S3 bucket policy.
	PublicPolicyAccess PublicAccessStatus

	noSmithyDocumentSerde
}

// Contains information about the resource type RDSDBInstance involved in a
// GuardDuty finding.
type RdsDbInstanceDetails struct {

	// The identifier of the database cluster that contains the database instance ID
	// involved in the finding.
	DbClusterIdentifier *string

	// The Amazon Resource Name (ARN) that identifies the database instance involved
	// in the finding.
	DbInstanceArn *string

	// The identifier associated to the database instance that was involved in the
	// finding.
	DbInstanceIdentifier *string

	// The database engine of the database instance involved in the finding.
	Engine *string

	// The version of the database engine that was involved in the finding.
	EngineVersion *string

	// Information about the tag key-value pairs.
	Tags []Tag

	noSmithyDocumentSerde
}

// Contains information about the user and authentication details for a database
// instance involved in the finding.
type RdsDbUserDetails struct {

	// The application name used in the anomalous login attempt.
	Application *string

	// The authentication method used by the user involved in the finding.
	AuthMethod *string

	// The name of the database instance involved in the anomalous login attempt.
	Database *string

	// The version of the Secure Socket Layer (SSL) used for the network.
	Ssl *string

	// The user name used in the anomalous login attempt.
	User *string

	noSmithyDocumentSerde
}

// Contains information about the resource type RDSLimitlessDB that is involved in
// a GuardDuty finding.
type RdsLimitlessDbDetails struct {

	// The name of the database cluster that is a part of the Limitless Database.
	DbClusterIdentifier *string

	// The Amazon Resource Name (ARN) that identifies the DB shard group.
	DbShardGroupArn *string

	// The name associated with the Limitless DB shard group.
	DbShardGroupIdentifier *string

	// The resource identifier of the DB shard group within the Limitless Database.
	DbShardGroupResourceId *string

	// The database engine of the database instance involved in the finding.
	Engine *string

	// The version of the database engine.
	EngineVersion *string

	// Information about the tag key-value pair.
	Tags []Tag

	noSmithyDocumentSerde
}

// Indicates that a login attempt was made to the potentially compromised database
// from a remote IP address.
type RdsLoginAttemptAction struct {

	// Indicates the login attributes used in the login attempt.
	LoginAttributes []LoginAttribute

	// Contains information about the remote IP address of the connection.
	RemoteIpDetails *RemoteIpDetails

	noSmithyDocumentSerde
}

// Contains information about the recovery point configuration for scanning backup
// data from Amazon Web Services Backup.
type RecoveryPoint struct {

	// The name of the Amazon Web Services Backup vault that contains the name of the
	// recovery point to be scanned.
	//
	// This member is required.
	BackupVaultName *string

	noSmithyDocumentSerde
}

// Contains details about the backup recovery point.
type RecoveryPointDetails struct {

	// The name of the backup vault containing the recovery point.
	BackupVaultName *string

	// The Amazon Resource Name (ARN) of the recovery point.
	RecoveryPointArn *string

	noSmithyDocumentSerde
}

// Contains details about the remote Amazon Web Services account that made the API
// call.
type RemoteAccountDetails struct {

	// The Amazon Web Services account ID of the remote API caller.
	AccountId *string

	// Details on whether the Amazon Web Services account of the remote API caller is
	// related to your GuardDuty environment. If this value is True the API caller is
	// affiliated to your account in some way. If it is False the API caller is from
	// outside your environment.
	Affiliated *bool

	noSmithyDocumentSerde
}

// Contains information about the remote IP address of the connection.
type RemoteIpDetails struct {

	// The city information of the remote IP address.
	City *City

	// The country code of the remote IP address.
	Country *Country

	// The location information of the remote IP address.
	GeoLocation *GeoLocation

	// The IPv4 remote address of the connection.
	IpAddressV4 *string

	// The IPv6 remote address of the connection.
	IpAddressV6 *string

	// The ISP organization information of the remote IP address.
	Organization *Organization

	noSmithyDocumentSerde
}

// Contains information about the remote port.
type RemotePortDetails struct {

	// The port number of the remote connection.
	Port *int32

	// The port name of the remote connection.
	PortName *string

	noSmithyDocumentSerde
}

// Contains information about the Amazon Web Services resource associated with the
// activity that prompted GuardDuty to generate a finding.
type Resource struct {

	// The IAM access key details (user information) of a user that engaged in the
	// activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails

	// Details of a container.
	ContainerDetails *Container

	// Contains details about the EBS snapshot that was scanned.
	EbsSnapshotDetails *EbsSnapshotDetails

	// Contains list of scanned and skipped EBS volumes with details.
	EbsVolumeDetails *EbsVolumeDetails

	// Contains details about the EC2 image that was scanned.
	Ec2ImageDetails *Ec2ImageDetails

	// Contains information about the details of the ECS Cluster.
	EcsClusterDetails *EcsClusterDetails

	// Details about the EKS cluster involved in a Kubernetes finding.
	EksClusterDetails *EksClusterDetails

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails

	// Details about the Kubernetes user and workload involved in a Kubernetes finding.
	KubernetesDetails *KubernetesDetails

	// Contains information about the Lambda function that was involved in a finding.
	LambdaDetails *LambdaDetails

	// Contains information about the database instance to which an anomalous login
	// attempt was made.
	RdsDbInstanceDetails *RdsDbInstanceDetails

	// Contains information about the user details through which anomalous login
	// attempt was made.
	RdsDbUserDetails *RdsDbUserDetails

	// Contains information about the RDS Limitless database that was involved in a
	// GuardDuty finding.
	RdsLimitlessDbDetails *RdsLimitlessDbDetails

	// Contains details about the backup recovery point that was scanned.
	RecoveryPointDetails *RecoveryPointDetails

	// The type of Amazon Web Services resource.
	ResourceType *string

	// Contains information on the S3 bucket.
	S3BucketDetails []S3BucketDetail

	noSmithyDocumentSerde
}

// Contains information about the Amazon Web Services resource that is associated
// with the activity that prompted GuardDuty to generate a finding.
type ResourceData struct {

	// Contains information about the IAM access key details of a user that involved
	// in the GuardDuty finding.
	AccessKey *AccessKey

	// Contains detailed information about the Auto Scaling Group associated with the
	// activity that prompted GuardDuty to generate a finding.
	AutoscalingAutoScalingGroup *AutoscalingAutoScalingGroup

	// Contains detailed information about the CloudFormation stack associated with
	// the activity that prompted GuardDuty to generate a finding.
	CloudformationStack *CloudformationStack

	// Contains detailed information about the container associated with the activity
	// that prompted GuardDuty to generate a finding.
	Container *ContainerFindingResource

	// Contains detailed information about the EC2 Image associated with the activity
	// that prompted GuardDuty to generate a finding.
	Ec2Image *Ec2Image

	// Contains information about the Amazon EC2 instance.
	Ec2Instance *Ec2Instance

	// Contains detailed information about the EC2 launch template associated with the
	// activity that prompted GuardDuty to generate a finding.
	Ec2LaunchTemplate *Ec2LaunchTemplate

	// Contains information about the elastic network interface of the Amazon EC2
	// instance.
	Ec2NetworkInterface *Ec2NetworkInterface

	// Contains detailed information about the EC2 VPC associated with the activity
	// that prompted GuardDuty to generate a finding.
	Ec2Vpc *Ec2Vpc

	// Contains detailed information about the Amazon ECS cluster associated with the
	// activity that prompted GuardDuty to generate a finding.
	EcsCluster *EcsCluster

	// Contains detailed information about the Amazon ECS task associated with the
	// activity that prompted GuardDuty to generate a finding.
	EcsTask *EcsTask

	// Contains detailed information about the Amazon EKS cluster associated with the
	// activity that prompted GuardDuty to generate a finding.
	EksCluster *EksCluster

	// Contains detailed information about the IAM instance profile associated with
	// the activity that prompted GuardDuty to generate a finding.
	IamInstanceProfile *IamInstanceProfileV2

	// Contains detailed information about the Kubernetes workload associated with the
	// activity that prompted GuardDuty to generate a finding.
	KubernetesWorkload *KubernetesWorkload

	// Contains information about the Amazon S3 bucket.
	S3Bucket *S3Bucket

	// Contains information about the Amazon S3 object.
	S3Object *S3Object

	noSmithyDocumentSerde
}

// Represents the resources that were scanned in the scan entry.
type ResourceDetails struct {

	// Instance ARN that was scanned in the scan entry.
	InstanceArn *string

	noSmithyDocumentSerde
}

// Information about each resource type associated with the groupedByResource
// statistics.
type ResourceStatistics struct {

	// The ID of the Amazon Web Services account.
	AccountId *string

	// The timestamp at which the statistics for this resource was last generated.
	LastGeneratedAt *time.Time

	// ID associated with each resource. The following list provides the mapping of
	// the resource type and resource ID.
	//
	// Mapping of resource and resource ID
	//
	//   - AccessKey - resource.accessKeyDetails.accessKeyId
	//
	//   - Container - resource.containerDetails.id
	//
	//   - ECSCluster - resource.ecsClusterDetails.name
	//
	//   - EKSCluster - resource.eksClusterDetails.name
	//
	//   - Instance - resource.instanceDetails.instanceId
	//
	//   - KubernetesCluster -
	//   resource.kubernetesDetails.kubernetesWorkloadDetails.name
	//
	//   - Lambda - resource.lambdaDetails.functionName
	//
	//   - RDSDBInstance - resource.rdsDbInstanceDetails.dbInstanceIdentifier
	//
	//   - S3Bucket - resource.s3BucketDetails.name
	//
	//   - S3Object - resource.s3BucketDetails.name
	ResourceId *string

	// The type of resource.
	ResourceType *string

	// The total number of findings associated with this resource.
	TotalFindings *int32

	noSmithyDocumentSerde
}

// Contains information about the Amazon Web Services resource that is associated
// with the GuardDuty finding.
type ResourceV2 struct {

	// The type of the Amazon Web Services resource.
	//
	// This member is required.
	ResourceType FindingResourceType

	// The unique identifier of the resource.
	//
	// This member is required.
	Uid *string

	// The Amazon Web Services account ID to which the resource belongs.
	AccountId *string

	// The cloud partition within the Amazon Web Services Region to which the resource
	// belongs.
	CloudPartition *string

	// Contains information about the Amazon Web Services resource associated with the
	// activity that prompted GuardDuty to generate a finding.
	Data *ResourceData

	// The name of the resource.
	Name *string

	// The Amazon Web Services Region where the resource belongs.
	Region *string

	// The Amazon Web Services service of the resource.
	Service *string

	// Contains information about the tags associated with the resource.
	Tags []Tag

	noSmithyDocumentSerde
}

// Additional information about the suspicious activity.
type RuntimeContext struct {

	// Represents the communication protocol associated with the address. For example,
	// the address family AF_INET is used for IP version of 4 protocol.
	AddressFamily *string

	// Example of the command line involved in the suspicious activity.
	CommandLineExample *string

	// Represents the type of mounted fileSystem.
	FileSystemType *string

	// Represents options that control the behavior of a runtime operation or action.
	// For example, a filesystem mount operation may contain a read-only flag.
	Flags []string

	// Specifies a particular protocol within the address family. Usually there is a
	// single protocol in address families. For example, the address family AF_INET
	// only has the IP protocol.
	IanaProtocolNumber *int32

	// The value of the LD_PRELOAD environment variable.
	LdPreloadValue *string

	// The path to the new library that was loaded.
	LibraryPath *string

	// Specifies the Region of a process's address space such as stack and heap.
	MemoryRegions []string

	// The timestamp at which the process modified the current process. The timestamp
	// is in UTC date string format.
	ModifiedAt *time.Time

	// Information about the process that modified the current process. This is
	// available for multiple finding types.
	ModifyingProcess *ProcessDetails

	// The path to the module loaded into the kernel.
	ModuleFilePath *string

	// The name of the module loaded into the kernel.
	ModuleName *string

	// The SHA256 hash of the module.
	ModuleSha256 *string

	// The path on the host that is mounted by the container.
	MountSource *string

	// The path in the container that is mapped to the host directory.
	MountTarget *string

	// The path in the container that modified the release agent file.
	ReleaseAgentPath *string

	// The path to the leveraged runc implementation.
	RuncBinaryPath *string

	// The path to the script that was executed.
	ScriptPath *string

	// Name of the security service that has been potentially disabled.
	ServiceName *string

	// The path to the modified shell history file.
	ShellHistoryFilePath *string

	// The path to the docket socket that was accessed.
	SocketPath *string

	// Information about the process that had its memory overwritten by the current
	// process.
	TargetProcess *ProcessDetails

	// The suspicious file path for which the threat intelligence details were found.
	ThreatFilePath *string

	// Category that the tool belongs to. Some of the examples are Backdoor Tool,
	// Pentest Tool, Network Scanner, and Network Sniffer.
	ToolCategory *string

	// Name of the potentially suspicious tool.
	ToolName *string

	noSmithyDocumentSerde
}

// Information about the process and any required context values for a specific
// finding.
type RuntimeDetails struct {

	// Additional information about the suspicious activity.
	Context *RuntimeContext

	// Information about the observed process.
	Process *ProcessDetails

	noSmithyDocumentSerde
}

// Contains information about the Amazon S3 bucket policies and encryption.
type S3Bucket struct {

	// Contains information about the public access policies that apply to the Amazon
	// S3 bucket at the account level.
	AccountPublicAccess *PublicAccessConfiguration

	// Contains information about public access policies that apply to the Amazon S3
	// bucket.
	BucketPublicAccess *PublicAccessConfiguration

	// The timestamp at which the Amazon S3 bucket was created.
	CreatedAt *time.Time

	// Describes the effective permissions on this S3 bucket, after factoring all the
	// attached policies.
	EffectivePermission *string

	// The Amazon Resource Name (ARN) of the encryption key that is used to encrypt
	// the Amazon S3 bucket and its objects.
	EncryptionKeyArn *string

	// The type of encryption used for the Amazon S3 buckets and its objects. For more
	// information, see [Protecting data with server-side encryption]in the Amazon S3 User Guide.
	//
	// [Protecting data with server-side encryption]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/serv-side-encryption.html
	EncryptionType *string

	// The owner ID of the associated S3Amazon S3bucket.
	OwnerId *string

	// Indicates whether or not the public read access is allowed for an Amazon S3
	// bucket.
	PublicReadAccess PublicAccessStatus

	// Indicates whether or not the public write access is allowed for an Amazon S3
	// bucket.
	PublicWriteAccess PublicAccessStatus

	// Represents a list of Amazon S3 object identifiers.
	S3ObjectUids []string

	noSmithyDocumentSerde
}

// Contains information on the S3 bucket.
type S3BucketDetail struct {

	// The Amazon Resource Name (ARN) of the S3 bucket.
	Arn *string

	// The date and time the bucket was created at.
	CreatedAt *time.Time

	// Describes the server side encryption method used in the S3 bucket.
	DefaultServerSideEncryption *DefaultServerSideEncryption

	// The name of the S3 bucket.
	Name *string

	// The owner of the S3 bucket.
	Owner *Owner

	// Describes the public access policies that apply to the S3 bucket.
	PublicAccess *PublicAccess

	// Information about the S3 object that was scanned.
	S3ObjectDetails []S3ObjectDetail

	// All tags attached to the S3 bucket
	Tags []Tag

	// Describes whether the bucket is a source or destination bucket.
	Type *string

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfiguration struct {

	//  The status of S3 data event logs as a data source.
	//
	// This member is required.
	Enable *bool

	noSmithyDocumentSerde
}

// Describes whether S3 data event logs will be enabled as a data source.
type S3LogsConfigurationResult struct {

	// A value that describes whether S3 data event logs are automatically enabled for
	// new members of the organization.
	//
	// This member is required.
	Status DataSourceStatus

	noSmithyDocumentSerde
}

// Contains information about the Amazon S3 object.
type S3Object struct {

	// The entity tag is a hash of the Amazon S3 object. The ETag reflects changes
	// only to the contents of an object, and not its metadata.
	ETag *string

	// The key of the Amazon S3 object.
	Key *string

	// The version Id of the Amazon S3 object.
	VersionId *string

	noSmithyDocumentSerde
}

// Information about the S3 object that was scanned
type S3ObjectDetail struct {

	// The entity tag is a hash of the S3 object. The ETag reflects changes only to
	// the contents of an object, and not its metadata.
	ETag *string

	// Hash of the threat detected in this finding.
	Hash *string

	// Key of the S3 object.
	Key *string

	// Amazon Resource Name (ARN) of the S3 object.
	ObjectArn *string

	// Version ID of the object.
	VersionId *string

	noSmithyDocumentSerde
}

// The S3 object path to initiate a scan, including bucket name, object key, and
// optional version ID.
type S3ObjectForSendObjectMalwareScan struct {

	// The name of the S3 bucket containing the object to scan. The bucket must have
	// GuardDuty Malware Protection enabled.
	Bucket *string

	// The key (name) of the S3 object to scan for malware. This must be the full key
	// path of the object within the bucket.
	Key *string

	// The version ID of the S3 object to scan. If not specified, the latest version
	// of the object is scanned.
	VersionId *string

	noSmithyDocumentSerde
}

// Contains information about malware scans associated with GuardDuty Malware
// Protection for EC2.
type Scan struct {

	// The ID for the account that belongs to the scan.
	AccountId *string

	// The unique detector ID of the administrator account that the request is
	// associated with. If the account is an administrator, the AdminDetectorId will
	// be the same as the one used for DetectorId .
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	AdminDetectorId *string

	// List of volumes that were attached to the original instance to be scanned.
	AttachedVolumes []VolumeDetail

	// The unique ID of the detector that is associated with the request.
	//
	// To find the detectorId in the current Region, see the Settings page in the
	// GuardDuty console, or run the [ListDetectors]API.
	//
	// [ListDetectors]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListDetectors.html
	DetectorId *string

	// Represents the reason for FAILED scan status.
	FailureReason *string

	// Represents the number of files that were scanned.
	FileCount *int64

	// Represents the resources that were scanned in the scan entry.
	ResourceDetails *ResourceDetails

	// The timestamp of when the scan was finished.
	ScanEndTime *time.Time

	// The unique scan ID associated with a scan entry.
	ScanId *string

	// Represents the result of the scan.
	ScanResultDetails *ScanResultDetails

	// The timestamp of when the scan was triggered.
	ScanStartTime *time.Time

	// An enum value representing possible scan statuses.
	ScanStatus ScanStatus

	// Specifies the scan type that invoked the malware scan.
	ScanType ScanType

	// Represents total bytes that were scanned.
	TotalBytes *int64

	// Specifies the reason why the scan was initiated.
	TriggerDetails *TriggerDetails

	noSmithyDocumentSerde
}

// Contains information about the condition.
type ScanCondition struct {

	// Represents an mapEqual condition to be applied to a single field when
	// triggering for malware scan.
	//
	// This member is required.
	MapEquals []ScanConditionPair

	noSmithyDocumentSerde
}

// Represents the key:value pair to be matched against given resource property.
type ScanConditionPair struct {

	// Represents the key in the map condition.
	//
	// This member is required.
	Key *string

	// Represents optional value in the map condition. If not specified, only the key
	// will be matched.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the configuration used for the malware scan.
type ScanConfiguration struct {

	// Information about the incremental scan configuration, if applicable.
	IncrementalScanDetails *IncrementalScanDetails

	// Information about the recovery point configuration used for the scan, if
	// applicable.
	RecoveryPoint *ScanConfigurationRecoveryPoint

	// Amazon Resource Name (ARN) of the IAM role that should contain the required
	// permissions for the scan.
	Role *string

	// Information about the entity that triggered the malware scan.
	TriggerDetails *TriggerDetails

	noSmithyDocumentSerde
}

// Contains information about the recovery point configuration used in the scan.
type ScanConfigurationRecoveryPoint struct {

	// The name of the Amazon Web Services Backup vault that contains the recovery
	// point for the scanned.
	BackupVaultName *string

	noSmithyDocumentSerde
}

// Contains a complete view providing malware scan result details.
type ScanDetections struct {

	// Details of the highest severity threat detected during malware scan and number
	// of infected files.
	HighestSeverityThreatDetails *HighestSeverityThreatDetails

	// Total number of scanned files.
	ScannedItemCount *ScannedItemCount

	// Contains details about identified threats organized by threat name.
	ThreatDetectedByName *ThreatDetectedByName

	// Total number of infected files.
	ThreatsDetectedItemCount *ThreatsDetectedItemCount

	noSmithyDocumentSerde
}

// Describes whether Malware Protection for EC2 instances with findings will be
// enabled as a data source.
type ScanEc2InstanceWithFindings struct {

	// Describes the configuration for scanning EBS volumes as data source.
	EbsVolumes *bool

	noSmithyDocumentSerde
}

// An object that contains information on the status of whether Malware Protection
// for EC2 instances with findings will be enabled as a data source.
type ScanEc2InstanceWithFindingsResult struct {

	// Describes the configuration of scanning EBS volumes as a data source.
	EbsVolumes *EbsVolumesResult

	noSmithyDocumentSerde
}

// Contains details of infected file including name, file path and hash.
type ScanFilePath struct {

	// File name of the infected file.
	FileName *string

	// The file path of the infected file.
	FilePath *string

	// The hash value of the infected file.
	Hash *string

	// EBS volume ARN details of the infected file.
	VolumeArn *string

	noSmithyDocumentSerde
}

// Total number of scanned files.
type ScannedItemCount struct {

	// Number of files scanned.
	Files *int32

	// Total GB of files scanned for malware.
	TotalGb *int32

	// Total number of scanned volumes.
	Volumes *int32

	noSmithyDocumentSerde
}

// Contains information about a resource that was scanned as part of the malware
// scan operation.
type ScannedResource struct {

	// Information about the scanned resource.
	ResourceDetails *ScannedResourceDetails

	// The reason for the scan status of this particular resource, if applicable.
	ScanStatusReason ScanStatusReason

	// Amazon Resource Name (ARN) of the scanned resource.
	ScannedResourceArn *string

	// The status of the scanned resource.
	ScannedResourceStatus MalwareProtectionScanStatus

	// The resource type of the scanned resource.
	ScannedResourceType MalwareProtectionResourceType

	noSmithyDocumentSerde
}

// Contains additional information about a resource that was scanned.
type ScannedResourceDetails struct {

	// Contains information about the EBS snapshot that was scanned.
	EbsSnapshot *EbsSnapshot

	// Contains information about the EBS volume that was scanned.
	EbsVolume *VolumeDetail

	noSmithyDocumentSerde
}

// Contains information about criteria used to filter resources before triggering
// malware scan.
type ScanResourceCriteria struct {

	// Represents condition that when matched will prevent a malware scan for a
	// certain resource.
	Exclude map[string]ScanCondition

	// Represents condition that when matched will allow a malware scan for a certain
	// resource.
	Include map[string]ScanCondition

	noSmithyDocumentSerde
}

// Represents the result of the scan.
type ScanResultDetails struct {

	// An enum value representing possible scan results.
	ScanResult ScanResult

	noSmithyDocumentSerde
}

// Contains information about a specific threat that was detected during the
// malware scan.
type ScanResultThreat struct {

	// The number of instances of this threat that were detected.
	Count *int64

	// The hash value associated with the detected threat.
	Hash *string

	// Additional information about where this threat was detected.
	ItemDetails []ItemDetails

	// The name of the detected threat.
	Name *string

	// The source that detected this threat.
	Source DetectionSource

	noSmithyDocumentSerde
}

// Contains files infected with the given threat providing details of malware name
// and severity.
type ScanThreatName struct {

	// List of infected files in EBS volume with details.
	FilePaths []ScanFilePath

	// Total number of files infected with given threat.
	ItemCount *int32

	// The name of the identified threat.
	Name *string

	// Severity of threat identified as part of the malware scan.
	Severity *string

	noSmithyDocumentSerde
}

// Container security context.
type SecurityContext struct {

	// Whether or not a container or a Kubernetes pod is allowed to gain more
	// privileges than its parent process.
	AllowPrivilegeEscalation *bool

	// Whether the container is privileged.
	Privileged *bool

	noSmithyDocumentSerde
}

// Contains information about the security groups associated with the EC2 instance.
type SecurityGroup struct {

	// The security group ID of the EC2 instance.
	GroupId *string

	// The security group name of the EC2 instance.
	GroupName *string

	noSmithyDocumentSerde
}

// Contains information about the GuardDuty attack sequence finding.
type Sequence struct {

	// Description of the attack sequence.
	//
	// This member is required.
	Description *string

	// Contains information about the signals involved in the attack sequence.
	//
	// This member is required.
	Signals []Signal

	// Unique identifier of the attack sequence.
	//
	// This member is required.
	Uid *string

	// Contains information about the actors involved in the attack sequence.
	Actors []Actor

	// Additional types of sequences that may be associated with the attack sequence
	// finding, providing further context about the nature of the detected threat.
	AdditionalSequenceTypes []string

	// Contains information about the network endpoints that were used in the attack
	// sequence.
	Endpoints []NetworkEndpoint

	// Contains information about the resources involved in the attack sequence.
	Resources []ResourceV2

	// Contains information about the indicators observed in the attack sequence.
	SequenceIndicators []Indicator

	noSmithyDocumentSerde
}

// Contains additional information about the generated finding.
type Service struct {

	// Information about the activity that is described in a finding.
	Action *Action

	// Contains additional information about the generated finding.
	AdditionalInfo *ServiceAdditionalInfo

	// Indicates whether this finding is archived.
	Archived *bool

	// The total count of the occurrences of this finding type.
	Count *int32

	// Contains information about the detected unusual behavior.
	Detection *Detection

	// The detector ID for the GuardDuty service.
	DetectorId *string

	// Returns details from the malware scan that created a finding.
	EbsVolumeScanDetails *EbsVolumeScanDetails

	// The first-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string

	// The last-seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventLastSeen *string

	// An evidence object associated with the service.
	Evidence *Evidence

	// The name of the feature that generated a finding.
	FeatureName *string

	// Returns details from the malware scan that generated a GuardDuty finding.
	MalwareScanDetails *MalwareScanDetails

	// The resource role information for this finding.
	ResourceRole *string

	// Information about the process and any required context values for a specific
	// finding
	RuntimeDetails *RuntimeDetails

	// The name of the Amazon Web Services service (GuardDuty) that generated a
	// finding.
	ServiceName *string

	// Feedback that was submitted about the finding.
	UserFeedback *string

	noSmithyDocumentSerde
}

// Additional information about the generated finding.
type ServiceAdditionalInfo struct {

	// Describes the type of the additional information.
	Type *string

	// This field specifies the value of the additional information.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the authenticated session.
type Session struct {

	// The timestamp for when the session was created.
	//
	// In Amazon Web Services CloudTrail, you can find this value as
	// userIdentity.sessionContext.attributes.creationDate .
	CreatedTime *time.Time

	// Identifier of the session issuer.
	//
	// In Amazon Web Services CloudTrail, you can find this value as
	// userIdentity.sessionContext.sessionIssuer.arn .
	Issuer *string

	// Indicates whether or not multi-factor authencation (MFA) was used during
	// authentication.
	//
	// In Amazon Web Services CloudTrail, you can find this value as
	// userIdentity.sessionContext.attributes.mfaAuthenticated .
	MfaStatus MfaStatus

	// The unique identifier of the session.
	Uid *string

	noSmithyDocumentSerde
}

// Information about severity level for each finding type.
type SeverityStatistics struct {

	// The timestamp at which a finding type for a specific severity was last
	// generated.
	LastGeneratedAt *time.Time

	// The severity level associated with each finding type.
	Severity *float64

	// The total number of findings associated with this severity.
	TotalFindings *int32

	noSmithyDocumentSerde
}

// Contains information about the signals involved in the attack sequence.
type Signal struct {

	// The number of times this signal was observed.
	//
	// This member is required.
	Count *int32

	// The timestamp when the first finding or activity related to this signal was
	// observed.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the first finding or activity related to this signal was
	// observed.
	//
	// This member is required.
	FirstSeenAt *time.Time

	// The timestamp when the last finding or activity related to this signal was
	// observed.
	//
	// This member is required.
	LastSeenAt *time.Time

	// The name of the signal. For example, when signal type is FINDING , the signal
	// name is the name of the finding.
	//
	// This member is required.
	Name *string

	// The type of the signal used to identify an attack sequence.
	//
	// Signals can be GuardDuty findings or activities observed in data sources that
	// GuardDuty monitors. For more information, see [Foundational data sources]in the Amazon GuardDuty User
	// Guide.
	//
	// A signal type can be one of the valid values listed in this API. Here are the
	// related descriptions:
	//
	//   - FINDING - Individually generated GuardDuty finding.
	//
	//   - CLOUD_TRAIL - Activity observed from CloudTrail logs
	//
	//   - S3_DATA_EVENTS - Activity observed from CloudTrail data events for S3.
	//   Activities associated with this type will show up only when you have enabled
	//   GuardDuty S3 Protection feature in your account. For more information about S3
	//   Protection and steps to enable it, see [S3 Protection]in the Amazon GuardDuty User Guide.
	//
	// [S3 Protection]: https://docs.aws.amazon.com/guardduty/latest/ug/s3-protection.html
	// [Foundational data sources]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_data-sources.html
	//
	// This member is required.
	Type SignalType

	// The unique identifier of the signal.
	//
	// This member is required.
	Uid *string

	// The timestamp when this signal was last observed.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Information about the IDs of the threat actors involved in the signal.
	ActorIds []string

	// The description of the signal.
	Description *string

	// Information about the endpoint IDs associated with this signal.
	EndpointIds []string

	// Information about the unique identifiers of the resources involved in the
	// signal.
	ResourceUids []string

	// The severity associated with the signal. For more information about severity,
	// see [Findings severity levels]in the Amazon GuardDuty User Guide.
	//
	// [Findings severity levels]: https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_findings-severity.html
	Severity *float64

	// Contains information about the indicators associated with the signals.
	SignalIndicators []Indicator

	noSmithyDocumentSerde
}

// Contains information about the criteria used for sorting findings.
type SortCriteria struct {

	// Represents the finding attribute, such as accountId , that sorts the findings.
	AttributeName *string

	// The order by which the sorted findings are to be displayed.
	OrderBy OrderBy

	noSmithyDocumentSerde
}

// Contains information about the configuration to be used for the malware scan.
type StartMalwareScanConfiguration struct {

	// Amazon Resource Name (ARN) of the IAM role that is used for scanning the
	// resource.
	//
	// This member is required.
	Role *string

	// Contains information about the incremental scan configuration. When specified,
	// the scan will only process changes since the baseline resource.
	IncrementalScanDetails *IncrementalScanDetails

	// Contains information about the recovery point configuration for the requested
	// scan.
	RecoveryPoint *RecoveryPoint

	noSmithyDocumentSerde
}

// Contains information about a tag key-value pair.
type Tag struct {

	// Describes the key associated with the tag.
	Key *string

	// Describes the value associated with the tag key.
	Value *string

	noSmithyDocumentSerde
}

// Information about the detected threats associated with the generated finding.
type Threat struct {

	// The number of occurrences of this specific threat detected during the scan.
	Count *int64

	// The hash identifier of the detected malware threat.
	Hash *string

	// Detailed information about the detected malware threat.
	ItemDetails []ItemDetails

	// Information about the nested item path and hash of the protected resource.
	ItemPaths []ItemPath

	// Name of the detected threat that caused GuardDuty to generate this finding.
	Name *string

	// Source of the threat that generated this finding.
	Source *string

	noSmithyDocumentSerde
}

// Contains details about identified threats organized by threat name.
type ThreatDetectedByName struct {

	// Total number of infected files identified.
	ItemCount *int32

	// Flag to determine if the finding contains every single infected file-path
	// and/or every threat.
	Shortened *bool

	// List of identified threats with details, organized by threat name.
	ThreatNames []ScanThreatName

	// Total number of unique threats by name identified, as part of the malware scan.
	UniqueThreatNameCount *int32

	noSmithyDocumentSerde
}

// An instance of a threat intelligence detail that constitutes evidence for the
// finding.
type ThreatIntelligenceDetail struct {

	// SHA256 of the file that generated the finding.
	ThreatFileSha256 *string

	// The name of the threat intelligence list that triggered the finding.
	ThreatListName *string

	// A list of names of the threats in the threat intelligence list that triggered
	// the finding.
	ThreatNames []string

	noSmithyDocumentSerde
}

// Contains total number of infected files.
type ThreatsDetectedItemCount struct {

	// Total number of infected files.
	Files *int32

	noSmithyDocumentSerde
}

// Contains the total usage with the corresponding currency unit for that value.
type Total struct {

	// The total usage.
	Amount *string

	// The currency unit that the amount is given in.
	Unit *string

	noSmithyDocumentSerde
}

// Represents the reason the scan was triggered.
type TriggerDetails struct {

	// The description of the scan trigger.
	Description *string

	// The ID of the GuardDuty finding that triggered the malware scan.
	GuardDutyFindingId *string

	// Specifies the trigger type that started the malware scan.
	TriggerType TriggerType

	noSmithyDocumentSerde
}

// Contains information about the accounts that weren't processed.
type UnprocessedAccount struct {

	// The Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// A reason why the account hasn't been processed.
	//
	// This member is required.
	Result *string

	noSmithyDocumentSerde
}

// Specifies the names of the data sources that couldn't be enabled.
type UnprocessedDataSourcesResult struct {

	// An object that contains information on the status of all Malware Protection
	// data sources.
	MalwareProtection *MalwareProtectionConfigurationResult

	noSmithyDocumentSerde
}

// Information about the protected resource that is associated with the created
// Malware Protection plan. Presently, S3Bucket is the only supported protected
// resource.
type UpdateProtectedResource struct {

	// Information about the protected S3 bucket resource.
	S3Bucket *UpdateS3BucketResource

	noSmithyDocumentSerde
}

// Information about the protected S3 bucket resource.
type UpdateS3BucketResource struct {

	// Information about the specified object prefixes. The S3 object will be scanned
	// only if it belongs to any of the specified object prefixes.
	ObjectPrefixes []string

	noSmithyDocumentSerde
}

// Contains information on the total of usage based on account IDs.
type UsageAccountResult struct {

	// The Account ID that generated usage.
	AccountId *string

	// Represents the total of usage for the Account ID.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information about the criteria used to query usage statistics.
type UsageCriteria struct {

	// The account IDs to aggregate usage statistics from.
	AccountIds []string

	// The data sources to aggregate usage statistics from.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources []DataSource

	// The features to aggregate usage statistics from.
	Features []UsageFeature

	// The resources to aggregate usage statistics from. Only accepts exact resource
	// names.
	Resources []string

	noSmithyDocumentSerde
}

// Contains information on the result of usage based on data source type.
type UsageDataSourceResult struct {

	// The data source type that generated usage.
	DataSource DataSource

	// Represents the total of usage for the specified data source.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information about the result of the total usage based on the feature.
type UsageFeatureResult struct {

	// The feature that generated the usage cost.
	Feature UsageFeature

	// Contains the total usage with the corresponding currency unit for that value.
	Total *Total

	noSmithyDocumentSerde
}

// Contains information on the sum of usage based on an Amazon Web Services
// resource.
type UsageResourceResult struct {

	// The Amazon Web Services resource that generated usage.
	Resource *string

	// Represents the sum total of usage for the specified resource type.
	Total *Total

	noSmithyDocumentSerde
}

// Contains the result of GuardDuty usage. If a UsageStatisticType is provided the
// result for other types will be null.
type UsageStatistics struct {

	// The usage statistic sum organized by account ID.
	SumByAccount []UsageAccountResult

	// The usage statistic sum organized by on data source.
	SumByDataSource []UsageDataSourceResult

	// The usage statistic sum organized by feature.
	SumByFeature []UsageFeatureResult

	// The usage statistic sum organized by resource.
	SumByResource []UsageResourceResult

	// Lists the top 50 accounts by feature that have generated the most GuardDuty
	// usage, in the order from most to least expensive.
	//
	// Currently, this doesn't support RDS_LOGIN_EVENTS .
	TopAccountsByFeature []UsageTopAccountsResult

	// Lists the top 50 resources that have generated the most GuardDuty usage, in
	// order from most to least expensive.
	TopResources []UsageResourceResult

	noSmithyDocumentSerde
}

// Contains information on the total of usage based on the topmost 50 account IDs.
type UsageTopAccountResult struct {

	// The unique account ID.
	AccountId *string

	// Contains the total usage with the corresponding currency unit for that value.
	Total *Total

	noSmithyDocumentSerde
}

// Information about the usage statistics, calculated by top accounts by feature.
type UsageTopAccountsResult struct {

	// The accounts that contributed to the total usage cost.
	Accounts []UsageTopAccountResult

	// Features by which you can generate the usage statistics.
	//
	// RDS_LOGIN_EVENTS is currently not supported with topAccountsByFeature .
	Feature UsageFeature

	noSmithyDocumentSerde
}

// Contains information about the user involved in the attack sequence.
type User struct {

	// The name of the user.
	//
	// This member is required.
	Name *string

	// The type of the user.
	//
	// This member is required.
	Type *string

	// The unique identifier of the user.
	//
	// This member is required.
	Uid *string

	// Contains information about the Amazon Web Services account.
	Account *Account

	// The credentials of the user ID.
	CredentialUid *string

	noSmithyDocumentSerde
}

// Volume used by the Kubernetes workload.
type Volume struct {

	// Represents a pre-existing file or directory on the host machine that the volume
	// maps to.
	HostPath *HostPath

	// Volume name.
	Name *string

	noSmithyDocumentSerde
}

// Contains EBS volume details.
type VolumeDetail struct {

	// The device name for the EBS volume.
	DeviceName *string

	// EBS volume encryption type.
	EncryptionType *string

	// KMS key ARN used to encrypt the EBS volume.
	KmsKeyArn *string

	// Snapshot ARN of the EBS volume.
	SnapshotArn *string

	// EBS volume ARN information.
	VolumeArn *string

	// EBS volume size in GB.
	VolumeSizeInGB *int32

	// The EBS volume type.
	VolumeType *string

	noSmithyDocumentSerde
}

// Container volume mount.
type VolumeMount struct {

	// Volume mount path.
	MountPath *string

	// Volume mount name.
	Name *string

	noSmithyDocumentSerde
}

// Amazon Virtual Private Cloud configuration details associated with your Lambda
// function.
type VpcConfig struct {

	// The identifier of the security group attached to the Lambda function.
	SecurityGroups []SecurityGroup

	// The identifiers of the subnets that are associated with your Lambda function.
	SubnetIds []string

	// The identifier of the Amazon Virtual Private Cloud.
	VpcId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
