// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initiates the malware scan. Invoking this API will automatically create the [Service-linked role] in
// the corresponding account if the resourceArn belongs to an EC2 instance.
//
// When the malware scan starts, you can use the associated scan ID to track the
// status of the scan. For more information, see [ListMalwareScans]and [GetMalwareScan].
//
// When you use this API, the Amazon Web Services service terms for GuardDuty
// Malware Protection apply. For more information, see [Amazon Web Services service terms for GuardDuty Malware Protection].
//
// [Service-linked role]: https://docs.aws.amazon.com/guardduty/latest/ug/slr-permissions-malware-protection.html
// [GetMalwareScan]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_GetMalwareScan.html
// [Amazon Web Services service terms for GuardDuty Malware Protection]: http://aws.amazon.com/service-terms/#87._Amazon_GuardDuty
// [ListMalwareScans]: https://docs.aws.amazon.com/guardduty/latest/APIReference/API_ListMalwareScans.html
func (c *Client) StartMalwareScan(ctx context.Context, params *StartMalwareScanInput, optFns ...func(*Options)) (*StartMalwareScanOutput, error) {
	if params == nil {
		params = &StartMalwareScanInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartMalwareScan", params, optFns, c.addOperationStartMalwareScanMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartMalwareScanOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartMalwareScanInput struct {

	// Amazon Resource Name (ARN) of the resource for which you invoked the API.
	//
	// This member is required.
	ResourceArn *string

	// The idempotency token for the create request.
	ClientToken *string

	// Contains information about the configuration to be used for the malware scan.
	ScanConfiguration *types.StartMalwareScanConfiguration

	noSmithyDocumentSerde
}

type StartMalwareScanOutput struct {

	// A unique identifier that gets generated when you invoke the API without any
	// error. Each malware scan has a corresponding scan ID. Using this scan ID, you
	// can monitor the status of your malware scan.
	ScanId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartMalwareScanMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartMalwareScan{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartMalwareScan{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartMalwareScan"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartMalwareScanMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartMalwareScanValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartMalwareScan(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartMalwareScan struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartMalwareScan) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartMalwareScan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartMalwareScanInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartMalwareScanInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartMalwareScanMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartMalwareScan{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartMalwareScan(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartMalwareScan",
	}
}
