// Code generated by smithy-go-codegen DO NOT EDIT.

package groundstation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/groundstation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of mission profiles.
func (c *Client) ListMissionProfiles(ctx context.Context, params *ListMissionProfilesInput, optFns ...func(*Options)) (*ListMissionProfilesOutput, error) {
	if params == nil {
		params = &ListMissionProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMissionProfiles", params, optFns, c.addOperationListMissionProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMissionProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMissionProfilesInput struct {

	// Maximum number of mission profiles returned.
	MaxResults *int32

	// Next token returned in the request of a previous ListMissionProfiles call. Used
	// to get the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMissionProfilesOutput struct {

	// List of mission profiles.
	MissionProfileList []types.MissionProfileListItem

	// Next token returned in the response of a previous ListMissionProfiles call.
	// Used to get the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMissionProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMissionProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMissionProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMissionProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMissionProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMissionProfilesPaginatorOptions is the paginator options for
// ListMissionProfiles
type ListMissionProfilesPaginatorOptions struct {
	// Maximum number of mission profiles returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMissionProfilesPaginator is a paginator for ListMissionProfiles
type ListMissionProfilesPaginator struct {
	options   ListMissionProfilesPaginatorOptions
	client    ListMissionProfilesAPIClient
	params    *ListMissionProfilesInput
	nextToken *string
	firstPage bool
}

// NewListMissionProfilesPaginator returns a new ListMissionProfilesPaginator
func NewListMissionProfilesPaginator(client ListMissionProfilesAPIClient, params *ListMissionProfilesInput, optFns ...func(*ListMissionProfilesPaginatorOptions)) *ListMissionProfilesPaginator {
	if params == nil {
		params = &ListMissionProfilesInput{}
	}

	options := ListMissionProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMissionProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMissionProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMissionProfiles page.
func (p *ListMissionProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMissionProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMissionProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMissionProfilesAPIClient is a client that implements the
// ListMissionProfiles operation.
type ListMissionProfilesAPIClient interface {
	ListMissionProfiles(context.Context, *ListMissionProfilesInput, ...func(*Options)) (*ListMissionProfilesOutput, error)
}

var _ ListMissionProfilesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMissionProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMissionProfiles",
	}
}
