// Code generated by smithy-go-codegen DO NOT EDIT.

package gameliftstreams

import (
	"context"
	"errors"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gameliftstreams/types"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	smithywaiter "github.com/aws/smithy-go/waiter"
	"time"
)

// Retrieves properties for a Amazon GameLift Streams stream group resource.
// Specify the ID of the stream group that you want to retrieve. If the operation
// is successful, it returns properties for the requested stream group.
func (c *Client) GetStreamGroup(ctx context.Context, params *GetStreamGroupInput, optFns ...func(*Options)) (*GetStreamGroupOutput, error) {
	if params == nil {
		params = &GetStreamGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetStreamGroup", params, optFns, c.addOperationGetStreamGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetStreamGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetStreamGroupInput struct {

	// An [Amazon Resource Name (ARN)] or ID that uniquely identifies the stream group resource. Example ARN:
	// arn:aws:gameliftstreams:us-west-2:111122223333:streamgroup/sg-1AB2C3De4 .
	// Example ID: sg-1AB2C3De4 .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetStreamGroupOutput struct {

	// The [Amazon Resource Name (ARN)] that is assigned to the stream group resource and that uniquely identifies
	// the group across all Amazon Web Services Regions. Format is
	// arn:aws:gameliftstreams:[AWS Region]:[AWS account]:streamgroup/[resource ID] .
	//
	// [Amazon Resource Name (ARN)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	//
	// This member is required.
	Arn *string

	//  A set of applications that this stream group is associated to. You can stream
	// any of these applications by using this stream group.
	//
	// This value is a set of [Amazon Resource Names (ARNs)] that uniquely identify application resources. Example
	// ARN: arn:aws:gameliftstreams:us-west-2:111122223333:application/a-9ZY8X7Wv6 .
	//
	// [Amazon Resource Names (ARNs)]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html
	AssociatedApplications []string

	// A timestamp that indicates when this resource was created. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	CreatedAt *time.Time

	// The default Amazon GameLift Streams application that is associated with this
	// stream group.
	DefaultApplication *types.DefaultApplication

	// A descriptive label for the stream group.
	Description *string

	// The time at which this stream group expires. Timestamps are expressed using in
	// ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC). After this time, you
	// will no longer be able to update this stream group or use it to start stream
	// sessions. Only Get and Delete operations will work on an expired stream group.
	ExpiresAt *time.Time

	// A unique ID value that is assigned to the resource when it's created. Format
	// example: sg-1AB2C3De4 .
	Id *string

	// A timestamp that indicates when this resource was last updated. Timestamps are
	// expressed using in ISO8601 format, such as: 2022-12-27T22:29:40+00:00 (UTC).
	LastUpdatedAt *time.Time

	// This value is the set of locations, including their name, current status, and
	// capacities.
	//
	// A location can be in one of the following states:
	//
	//   - ACTIVATING : Amazon GameLift Streams is preparing the location. You cannot
	//   stream from, scale the capacity of, or remove this location yet.
	//
	//   - ACTIVE : The location is provisioned with initial capacity. You can now
	//   stream from, scale the capacity of, or remove this location.
	//
	//   - ERROR : Amazon GameLift Streams failed to set up this location. The
	//   StatusReason field describes the error. You can remove this location and try
	//   to add it again.
	//
	//   - REMOVING : Amazon GameLift Streams is working to remove this location. This
	//   will release all provisioned capacity for this location in this stream group.
	LocationStates []types.LocationState

	// The current status of the stream group resource. Possible statuses include the
	// following:
	//
	//   - ACTIVATING : The stream group is deploying and isn't ready to host streams.
	//
	//   - ACTIVE : The stream group is ready to host streams.
	//
	//   - ACTIVE_WITH_ERRORS : One or more locations in the stream group are in an
	//   error state. Verify the details of individual locations and remove any locations
	//   which are in error.
	//
	//   - DELETING : Amazon GameLift Streams is in the process of deleting the stream
	//   group.
	//
	//   - ERROR : An error occurred when the stream group deployed. See StatusReason
	//   (returned by CreateStreamGroup , GetStreamGroup , and UpdateStreamGroup ) for
	//   more information.
	//
	//   - EXPIRED : The stream group is expired and can no longer host streams. This
	//   typically occurs when a stream group is 365 days old, as indicated by the value
	//   of ExpiresAt . Create a new stream group to resume streaming capabilities.
	//
	//   - UPDATING_LOCATIONS : One or more locations in the stream group are in the
	//   process of updating (either activating or deleting).
	Status types.StreamGroupStatus

	//  A short description of the reason that the stream group is in ERROR status.
	// The possible reasons can be one of the following:
	//
	//   - internalError : The request can't process right now because of an issue with
	//   the server. Try again later.
	//
	//   - noAvailableInstances : Amazon GameLift Streams does not currently have
	//   enough available on-demand capacity to fulfill your request. Wait a few minutes
	//   and retry the request as capacity can shift frequently. You can also try to make
	//   the request using a different stream class or in another region.
	StatusReason types.StreamGroupStatusReason

	// The target stream quality for the stream group.
	//
	// A stream class can be one of the following:
	//
	//   - gen5n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen5n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 12 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen5n_ultra (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Uses dedicated NVIDIA A10G Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 24 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_win2022 (NVIDIA, ultra) Supports applications with extremely high 3D
	//   scene complexity. Runs applications on Microsoft Windows Server 2022 Base and
	//   supports DirectX 12. Compatible with Unreal Engine versions up through 5.4, 32
	//   and 64-bit applications, and anti-cheat technology. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	//
	//   - gen4n_high (NVIDIA, high) Supports applications with moderate to high 3D
	//   scene complexity. Uses NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 4 vCPUs, 16 GB RAM, 8 GB VRAM
	//
	//   - Tenancy: Supports up to 2 concurrent stream sessions
	//
	//   - gen4n_ultra (NVIDIA, ultra) Supports applications with high 3D scene
	//   complexity. Uses dedicated NVIDIA T4 Tensor GPU.
	//
	//   - Reference resolution: 1080p
	//
	//   - Reference frame rate: 60 fps
	//
	//   - Workload specifications: 8 vCPUs, 32 GB RAM, 16 GB VRAM
	//
	//   - Tenancy: Supports 1 concurrent stream session
	StreamClass types.StreamClass

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetStreamGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetStreamGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetStreamGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetStreamGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetStreamGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// StreamGroupActiveWaiterOptions are waiter options for StreamGroupActiveWaiter
type StreamGroupActiveWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// StreamGroupActiveWaiter will use default minimum delay of 30 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, StreamGroupActiveWaiter will use default max delay of 3600 seconds.
	// Note that MaxDelay must resolve to value greater than or equal to the MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetStreamGroupInput, *GetStreamGroupOutput, error) (bool, error)
}

// StreamGroupActiveWaiter defines the waiters for StreamGroupActive
type StreamGroupActiveWaiter struct {
	client GetStreamGroupAPIClient

	options StreamGroupActiveWaiterOptions
}

// NewStreamGroupActiveWaiter constructs a StreamGroupActiveWaiter.
func NewStreamGroupActiveWaiter(client GetStreamGroupAPIClient, optFns ...func(*StreamGroupActiveWaiterOptions)) *StreamGroupActiveWaiter {
	options := StreamGroupActiveWaiterOptions{}
	options.MinDelay = 30 * time.Second
	options.MaxDelay = 3600 * time.Second
	options.Retryable = streamGroupActiveStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &StreamGroupActiveWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for StreamGroupActive waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *StreamGroupActiveWaiter) Wait(ctx context.Context, params *GetStreamGroupInput, maxWaitDur time.Duration, optFns ...func(*StreamGroupActiveWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for StreamGroupActive waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *StreamGroupActiveWaiter) WaitForOutput(ctx context.Context, params *GetStreamGroupInput, maxWaitDur time.Duration, optFns ...func(*StreamGroupActiveWaiterOptions)) (*GetStreamGroupOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 3600 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetStreamGroup(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for StreamGroupActive waiter")
}

func streamGroupActiveStateRetryable(ctx context.Context, input *GetStreamGroupInput, output *GetStreamGroupOutput, err error) (bool, error) {

	if err == nil {
		v1 := output.Status
		expectedValue := "ACTIVE"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, nil
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "ERROR"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "ACTIVE_WITH_ERRORS"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err == nil {
		v1 := output.Status
		expectedValue := "DELETING"
		var pathValue string
		pathValue = string(v1)
		if pathValue == expectedValue {
			return false, fmt.Errorf("waiter state transitioned to Failure")
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// StreamGroupDeletedWaiterOptions are waiter options for StreamGroupDeletedWaiter
type StreamGroupDeletedWaiterOptions struct {

	// Set of options to modify how an operation is invoked. These apply to all
	// operations invoked for this client. Use functional options on operation call to
	// modify this list for per operation behavior.
	//
	// Passing options here is functionally equivalent to passing values to this
	// config's ClientOptions field that extend the inner client's APIOptions directly.
	APIOptions []func(*middleware.Stack) error

	// Functional options to be passed to all operations invoked by this client.
	//
	// Function values that modify the inner APIOptions are applied after the waiter
	// config's own APIOptions modifiers.
	ClientOptions []func(*Options)

	// MinDelay is the minimum amount of time to delay between retries. If unset,
	// StreamGroupDeletedWaiter will use default minimum delay of 30 seconds. Note that
	// MinDelay must resolve to a value lesser than or equal to the MaxDelay.
	MinDelay time.Duration

	// MaxDelay is the maximum amount of time to delay between retries. If unset or
	// set to zero, StreamGroupDeletedWaiter will use default max delay of 1800
	// seconds. Note that MaxDelay must resolve to value greater than or equal to the
	// MinDelay.
	MaxDelay time.Duration

	// LogWaitAttempts is used to enable logging for waiter retry attempts
	LogWaitAttempts bool

	// Retryable is function that can be used to override the service defined
	// waiter-behavior based on operation output, or returned error. This function is
	// used by the waiter to decide if a state is retryable or a terminal state.
	//
	// By default service-modeled logic will populate this option. This option can
	// thus be used to define a custom waiter state with fall-back to service-modeled
	// waiter state mutators.The function returns an error in case of a failure state.
	// In case of retry state, this function returns a bool value of true and nil
	// error, while in case of success it returns a bool value of false and nil error.
	Retryable func(context.Context, *GetStreamGroupInput, *GetStreamGroupOutput, error) (bool, error)
}

// StreamGroupDeletedWaiter defines the waiters for StreamGroupDeleted
type StreamGroupDeletedWaiter struct {
	client GetStreamGroupAPIClient

	options StreamGroupDeletedWaiterOptions
}

// NewStreamGroupDeletedWaiter constructs a StreamGroupDeletedWaiter.
func NewStreamGroupDeletedWaiter(client GetStreamGroupAPIClient, optFns ...func(*StreamGroupDeletedWaiterOptions)) *StreamGroupDeletedWaiter {
	options := StreamGroupDeletedWaiterOptions{}
	options.MinDelay = 30 * time.Second
	options.MaxDelay = 1800 * time.Second
	options.Retryable = streamGroupDeletedStateRetryable

	for _, fn := range optFns {
		fn(&options)
	}
	return &StreamGroupDeletedWaiter{
		client:  client,
		options: options,
	}
}

// Wait calls the waiter function for StreamGroupDeleted waiter. The maxWaitDur is
// the maximum wait duration the waiter will wait. The maxWaitDur is required and
// must be greater than zero.
func (w *StreamGroupDeletedWaiter) Wait(ctx context.Context, params *GetStreamGroupInput, maxWaitDur time.Duration, optFns ...func(*StreamGroupDeletedWaiterOptions)) error {
	_, err := w.WaitForOutput(ctx, params, maxWaitDur, optFns...)
	return err
}

// WaitForOutput calls the waiter function for StreamGroupDeleted waiter and
// returns the output of the successful operation. The maxWaitDur is the maximum
// wait duration the waiter will wait. The maxWaitDur is required and must be
// greater than zero.
func (w *StreamGroupDeletedWaiter) WaitForOutput(ctx context.Context, params *GetStreamGroupInput, maxWaitDur time.Duration, optFns ...func(*StreamGroupDeletedWaiterOptions)) (*GetStreamGroupOutput, error) {
	if maxWaitDur <= 0 {
		return nil, fmt.Errorf("maximum wait time for waiter must be greater than zero")
	}

	options := w.options
	for _, fn := range optFns {
		fn(&options)
	}

	if options.MaxDelay <= 0 {
		options.MaxDelay = 1800 * time.Second
	}

	if options.MinDelay > options.MaxDelay {
		return nil, fmt.Errorf("minimum waiter delay %v must be lesser than or equal to maximum waiter delay of %v.", options.MinDelay, options.MaxDelay)
	}

	ctx, cancelFn := context.WithTimeout(ctx, maxWaitDur)
	defer cancelFn()

	logger := smithywaiter.Logger{}
	remainingTime := maxWaitDur

	var attempt int64
	for {

		attempt++
		apiOptions := options.APIOptions
		start := time.Now()

		if options.LogWaitAttempts {
			logger.Attempt = attempt
			apiOptions = append([]func(*middleware.Stack) error{}, options.APIOptions...)
			apiOptions = append(apiOptions, logger.AddLogger)
		}

		out, err := w.client.GetStreamGroup(ctx, params, func(o *Options) {
			baseOpts := []func(*Options){
				addIsWaiterUserAgent,
			}
			o.APIOptions = append(o.APIOptions, apiOptions...)
			for _, opt := range baseOpts {
				opt(o)
			}
			for _, opt := range options.ClientOptions {
				opt(o)
			}
		})

		retryable, err := options.Retryable(ctx, params, out, err)
		if err != nil {
			return nil, err
		}
		if !retryable {
			return out, nil
		}

		remainingTime -= time.Since(start)
		if remainingTime < options.MinDelay || remainingTime <= 0 {
			break
		}

		// compute exponential backoff between waiter retries
		delay, err := smithywaiter.ComputeDelay(
			attempt, options.MinDelay, options.MaxDelay, remainingTime,
		)
		if err != nil {
			return nil, fmt.Errorf("error computing waiter delay, %w", err)
		}

		remainingTime -= delay
		// sleep for the delay amount before invoking a request
		if err := smithytime.SleepWithContext(ctx, delay); err != nil {
			return nil, fmt.Errorf("request cancelled while waiting, %w", err)
		}
	}
	return nil, fmt.Errorf("exceeded max wait time for StreamGroupDeleted waiter")
}

func streamGroupDeletedStateRetryable(ctx context.Context, input *GetStreamGroupInput, output *GetStreamGroupOutput, err error) (bool, error) {

	if err != nil {
		var errorType *types.ResourceNotFoundException
		if errors.As(err, &errorType) {
			return false, nil
		}
	}

	if err != nil {
		return false, err
	}
	return true, nil
}

// GetStreamGroupAPIClient is a client that implements the GetStreamGroup
// operation.
type GetStreamGroupAPIClient interface {
	GetStreamGroup(context.Context, *GetStreamGroupInput, ...func(*Options)) (*GetStreamGroupOutput, error)
}

var _ GetStreamGroupAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetStreamGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetStreamGroup",
	}
}
