// Code generated by smithy-go-codegen DO NOT EDIT.

package freetier

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/freetier/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns a specific activity record that is available to the customer.
func (c *Client) GetAccountActivity(ctx context.Context, params *GetAccountActivityInput, optFns ...func(*Options)) (*GetAccountActivityOutput, error) {
	if params == nil {
		params = &GetAccountActivityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAccountActivity", params, optFns, c.addOperationGetAccountActivityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAccountActivityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAccountActivityInput struct {

	//  A unique identifier that identifies the activity.
	//
	// This member is required.
	ActivityId *string

	//  The language code used to return translated title and description fields.
	LanguageCode types.LanguageCode

	noSmithyDocumentSerde
}

type GetAccountActivityOutput struct {

	//  A unique identifier that identifies the activity.
	//
	// This member is required.
	ActivityId *string

	//  Provides detailed information about the activity and its expected outcomes.
	//
	// This member is required.
	Description *string

	//  The URL resource that provides guidance on activity requirements and
	// completion.
	//
	// This member is required.
	InstructionsUrl *string

	//  A reward granted upon activity completion.
	//
	// This member is required.
	Reward types.ActivityReward

	//  The current activity status.
	//
	// This member is required.
	Status types.ActivityStatus

	//  A short activity title.
	//
	// This member is required.
	Title *string

	//  The timestamp when the activity is completed. This field appears only for
	// activities in the COMPLETED state.
	CompletedAt *time.Time

	//  The estimated time to complete the activity. This is the duration in minutes.
	EstimatedTimeToCompleteInMinutes *int32

	//  The time by which the activity must be completed to receive a reward.
	ExpiresAt *time.Time

	//  The timestamp when the activity started. This field appears only for
	// activities in the IN_PROGRESS or COMPLETED states.
	StartedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAccountActivityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetAccountActivity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetAccountActivity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAccountActivity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAccountActivityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAccountActivity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAccountActivity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAccountActivity",
	}
}
