// Code generated by smithy-go-codegen DO NOT EDIT.

package emr

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/emr/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The presigned URL properties for the cluster's application user interface.
func (c *Client) GetPersistentAppUIPresignedURL(ctx context.Context, params *GetPersistentAppUIPresignedURLInput, optFns ...func(*Options)) (*GetPersistentAppUIPresignedURLOutput, error) {
	if params == nil {
		params = &GetPersistentAppUIPresignedURLInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetPersistentAppUIPresignedURL", params, optFns, c.addOperationGetPersistentAppUIPresignedURLMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetPersistentAppUIPresignedURLOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetPersistentAppUIPresignedURLInput struct {

	// The persistent application user interface ID associated with the presigned URL.
	//
	// This member is required.
	PersistentAppUIId *string

	// The application ID associated with the presigned URL.
	ApplicationId *string

	// A boolean that represents if the caller is an authentication proxy call.
	AuthProxyCall *bool

	// The execution role ARN associated with the presigned URL.
	ExecutionRoleArn *string

	// The persistent application user interface type associated with the presigned
	// URL.
	PersistentAppUIType types.PersistentAppUIType

	noSmithyDocumentSerde
}

type GetPersistentAppUIPresignedURLOutput struct {

	// The returned presigned URL.
	PresignedURL *string

	// Used to determine if the presigned URL is ready.
	PresignedURLReady *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetPersistentAppUIPresignedURLMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetPersistentAppUIPresignedURL{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetPersistentAppUIPresignedURL{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetPersistentAppUIPresignedURL"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetPersistentAppUIPresignedURLValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetPersistentAppUIPresignedURL(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetPersistentAppUIPresignedURL(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetPersistentAppUIPresignedURL",
	}
}
