// Code generated by smithy-go-codegen DO NOT EDIT.

package ecs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ecs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing Express service configuration. Modifies container settings,
// resource allocation, auto-scaling configuration, and other service parameters
// without recreating the service.
//
// Amazon ECS creates a new service revision with updated configuration and
// performs a rolling deployment to replace existing tasks. The service remains
// available during updates, ensuring zero-downtime deployments.
//
// Some parameters like the infrastructure role cannot be modified after service
// creation and require creating a new service.
func (c *Client) UpdateExpressGatewayService(ctx context.Context, params *UpdateExpressGatewayServiceInput, optFns ...func(*Options)) (*UpdateExpressGatewayServiceOutput, error) {
	if params == nil {
		params = &UpdateExpressGatewayServiceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateExpressGatewayService", params, optFns, c.addOperationUpdateExpressGatewayServiceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateExpressGatewayServiceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateExpressGatewayServiceInput struct {

	// The Amazon Resource Name (ARN) of the Express service to update.
	//
	// This member is required.
	ServiceArn *string

	// The number of CPU units used by the task.
	Cpu *string

	// The Amazon Resource Name (ARN) of the task execution role for the Express
	// service.
	ExecutionRoleArn *string

	// The path on the container for Application Load Balancer health checks.
	HealthCheckPath *string

	// The amount of memory (in MiB) used by the task.
	Memory *string

	// The network configuration for the Express service tasks. By default, the
	// network configuration for an Express service uses the default VPC.
	NetworkConfiguration *types.ExpressGatewayServiceNetworkConfiguration

	// The primary container configuration for the Express service.
	PrimaryContainer *types.ExpressGatewayContainer

	// The auto-scaling configuration for the Express service.
	ScalingTarget *types.ExpressGatewayScalingTarget

	// The Amazon Resource Name (ARN) of the IAM role for containers in this task.
	TaskRoleArn *string

	noSmithyDocumentSerde
}

type UpdateExpressGatewayServiceOutput struct {

	// The full description of your express gateway service following the update call.
	Service *types.UpdatedExpressGatewayService

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateExpressGatewayServiceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateExpressGatewayService{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateExpressGatewayService{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateExpressGatewayService"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateExpressGatewayServiceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateExpressGatewayService(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateExpressGatewayService(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateExpressGatewayService",
	}
}
