// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists job runs.
func (c *Client) ListJobRuns(ctx context.Context, params *ListJobRunsInput, optFns ...func(*Options)) (*ListJobRunsOutput, error) {
	if params == nil {
		params = &ListJobRunsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListJobRuns", params, optFns, c.addOperationListJobRunsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListJobRunsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListJobRunsInput struct {

	// The ID of the domain where you want to list job runs.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the job run.
	//
	// This member is required.
	JobIdentifier *string

	// The maximum number of job runs to return in a single call to ListJobRuns. When
	// the number of job runs to be listed is greater than the value of MaxResults, the
	// response contains a NextToken value that you can use in a subsequent call to
	// ListJobRuns to list the next set of job runs.
	MaxResults *int32

	// When the number of job runs is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of job runs, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListJobRuns to list the next set of job runs.
	NextToken *string

	// Specifies the order in which job runs are to be sorted.
	SortOrder types.SortOrder

	// The status of a job run.
	Status types.JobRunStatus

	noSmithyDocumentSerde
}

type ListJobRunsOutput struct {

	// The results of the ListJobRuns action.
	Items []types.JobRunSummary

	// When the number of job runs is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of job runs, the response includes a pagination token
	// named NextToken. You can specify this NextToken value in a subsequent call to
	// ListJobRuns to list the next set of job runs.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListJobRunsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListJobRuns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListJobRuns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListJobRuns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListJobRunsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListJobRuns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListJobRunsPaginatorOptions is the paginator options for ListJobRuns
type ListJobRunsPaginatorOptions struct {
	// The maximum number of job runs to return in a single call to ListJobRuns. When
	// the number of job runs to be listed is greater than the value of MaxResults, the
	// response contains a NextToken value that you can use in a subsequent call to
	// ListJobRuns to list the next set of job runs.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListJobRunsPaginator is a paginator for ListJobRuns
type ListJobRunsPaginator struct {
	options   ListJobRunsPaginatorOptions
	client    ListJobRunsAPIClient
	params    *ListJobRunsInput
	nextToken *string
	firstPage bool
}

// NewListJobRunsPaginator returns a new ListJobRunsPaginator
func NewListJobRunsPaginator(client ListJobRunsAPIClient, params *ListJobRunsInput, optFns ...func(*ListJobRunsPaginatorOptions)) *ListJobRunsPaginator {
	if params == nil {
		params = &ListJobRunsInput{}
	}

	options := ListJobRunsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListJobRunsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListJobRunsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListJobRuns page.
func (p *ListJobRunsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListJobRunsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListJobRuns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListJobRunsAPIClient is a client that implements the ListJobRuns operation.
type ListJobRunsAPIClient interface {
	ListJobRuns(context.Context, *ListJobRunsInput, ...func(*Options)) (*ListJobRunsOutput, error)
}

var _ ListJobRunsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListJobRuns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListJobRuns",
	}
}
