// Code generated by smithy-go-codegen DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	End of support notice: On May 20, 2026, Amazon Web Services will end support
//
// for Amazon Web Services DMS Fleet Advisor;. After May 20, 2026, you will no
// longer be able to access the Amazon Web Services DMS Fleet Advisor; console or
// Amazon Web Services DMS Fleet Advisor; resources. For more information, see [Amazon Web Services DMS Fleet Advisor end of support].
//
// Provides descriptions of large-scale assessment (LSA) analyses produced by your
// Fleet Advisor collectors.
//
// [Amazon Web Services DMS Fleet Advisor end of support]: https://docs.aws.amazon.com/dms/latest/userguide/dms_fleet.advisor-end-of-support.html
func (c *Client) DescribeFleetAdvisorLsaAnalysis(ctx context.Context, params *DescribeFleetAdvisorLsaAnalysisInput, optFns ...func(*Options)) (*DescribeFleetAdvisorLsaAnalysisOutput, error) {
	if params == nil {
		params = &DescribeFleetAdvisorLsaAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeFleetAdvisorLsaAnalysis", params, optFns, c.addOperationDescribeFleetAdvisorLsaAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeFleetAdvisorLsaAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeFleetAdvisorLsaAnalysisInput struct {

	// Sets the maximum number of records returned in the response.
	MaxRecords *int32

	// If NextToken is returned by a previous response, there are more results
	// available. The value of NextToken is a unique pagination token for each page.
	// Make the call again using the returned token to retrieve the next page. Keep all
	// other arguments unchanged.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeFleetAdvisorLsaAnalysisOutput struct {

	// A list of FleetAdvisorLsaAnalysisResponse objects.
	Analysis []types.FleetAdvisorLsaAnalysisResponse

	// If NextToken is returned, there are more results available. The value of
	// NextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page. Keep all other arguments
	// unchanged.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeFleetAdvisorLsaAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeFleetAdvisorLsaAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeFleetAdvisorLsaAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeFleetAdvisorLsaAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeFleetAdvisorLsaAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeFleetAdvisorLsaAnalysisPaginatorOptions is the paginator options for
// DescribeFleetAdvisorLsaAnalysis
type DescribeFleetAdvisorLsaAnalysisPaginatorOptions struct {
	// Sets the maximum number of records returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeFleetAdvisorLsaAnalysisPaginator is a paginator for
// DescribeFleetAdvisorLsaAnalysis
type DescribeFleetAdvisorLsaAnalysisPaginator struct {
	options   DescribeFleetAdvisorLsaAnalysisPaginatorOptions
	client    DescribeFleetAdvisorLsaAnalysisAPIClient
	params    *DescribeFleetAdvisorLsaAnalysisInput
	nextToken *string
	firstPage bool
}

// NewDescribeFleetAdvisorLsaAnalysisPaginator returns a new
// DescribeFleetAdvisorLsaAnalysisPaginator
func NewDescribeFleetAdvisorLsaAnalysisPaginator(client DescribeFleetAdvisorLsaAnalysisAPIClient, params *DescribeFleetAdvisorLsaAnalysisInput, optFns ...func(*DescribeFleetAdvisorLsaAnalysisPaginatorOptions)) *DescribeFleetAdvisorLsaAnalysisPaginator {
	if params == nil {
		params = &DescribeFleetAdvisorLsaAnalysisInput{}
	}

	options := DescribeFleetAdvisorLsaAnalysisPaginatorOptions{}
	if params.MaxRecords != nil {
		options.Limit = *params.MaxRecords
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeFleetAdvisorLsaAnalysisPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeFleetAdvisorLsaAnalysisPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeFleetAdvisorLsaAnalysis page.
func (p *DescribeFleetAdvisorLsaAnalysisPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeFleetAdvisorLsaAnalysisOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxRecords = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeFleetAdvisorLsaAnalysis(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeFleetAdvisorLsaAnalysisAPIClient is a client that implements the
// DescribeFleetAdvisorLsaAnalysis operation.
type DescribeFleetAdvisorLsaAnalysisAPIClient interface {
	DescribeFleetAdvisorLsaAnalysis(context.Context, *DescribeFleetAdvisorLsaAnalysisInput, ...func(*Options)) (*DescribeFleetAdvisorLsaAnalysisOutput, error)
}

var _ DescribeFleetAdvisorLsaAnalysisAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeFleetAdvisorLsaAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeFleetAdvisorLsaAnalysis",
	}
}
