// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Fetch the possible attribute values given the attribute name.
func (c *Client) ListObjectTypeAttributes(ctx context.Context, params *ListObjectTypeAttributesInput, optFns ...func(*Options)) (*ListObjectTypeAttributesOutput, error) {
	if params == nil {
		params = &ListObjectTypeAttributesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListObjectTypeAttributes", params, optFns, c.addOperationListObjectTypeAttributesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListObjectTypeAttributesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListObjectTypeAttributesInput struct {

	// The unique identifier of the domain.
	//
	// This member is required.
	DomainName *string

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The maximum number of objects returned per page.
	MaxResults *int32

	// The pagination token from the previous call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListObjectTypeAttributesOutput struct {

	// The items returned as part of the response.
	Items []types.ListObjectTypeAttributeItem

	// The pagination token from the previous call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListObjectTypeAttributesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListObjectTypeAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListObjectTypeAttributes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListObjectTypeAttributes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListObjectTypeAttributesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListObjectTypeAttributes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListObjectTypeAttributesPaginatorOptions is the paginator options for
// ListObjectTypeAttributes
type ListObjectTypeAttributesPaginatorOptions struct {
	// The maximum number of objects returned per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListObjectTypeAttributesPaginator is a paginator for ListObjectTypeAttributes
type ListObjectTypeAttributesPaginator struct {
	options   ListObjectTypeAttributesPaginatorOptions
	client    ListObjectTypeAttributesAPIClient
	params    *ListObjectTypeAttributesInput
	nextToken *string
	firstPage bool
}

// NewListObjectTypeAttributesPaginator returns a new
// ListObjectTypeAttributesPaginator
func NewListObjectTypeAttributesPaginator(client ListObjectTypeAttributesAPIClient, params *ListObjectTypeAttributesInput, optFns ...func(*ListObjectTypeAttributesPaginatorOptions)) *ListObjectTypeAttributesPaginator {
	if params == nil {
		params = &ListObjectTypeAttributesInput{}
	}

	options := ListObjectTypeAttributesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListObjectTypeAttributesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListObjectTypeAttributesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListObjectTypeAttributes page.
func (p *ListObjectTypeAttributesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListObjectTypeAttributesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListObjectTypeAttributes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListObjectTypeAttributesAPIClient is a client that implements the
// ListObjectTypeAttributes operation.
type ListObjectTypeAttributesAPIClient interface {
	ListObjectTypeAttributes(context.Context, *ListObjectTypeAttributesInput, ...func(*Options)) (*ListObjectTypeAttributesOutput, error)
}

var _ ListObjectTypeAttributesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListObjectTypeAttributes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListObjectTypeAttributes",
	}
}
