// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This API retrieves the pre-signed URL and client token for uploading the file
// associated with the upload job.
func (c *Client) GetUploadJobPath(ctx context.Context, params *GetUploadJobPathInput, optFns ...func(*Options)) (*GetUploadJobPathOutput, error) {
	if params == nil {
		params = &GetUploadJobPathInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUploadJobPath", params, optFns, c.addOperationGetUploadJobPathMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUploadJobPathOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUploadJobPathInput struct {

	// The unique name of the domain containing the upload job.
	//
	// This member is required.
	DomainName *string

	// The unique identifier of the upload job to retrieve the upload path for. This
	// is generated from the CreateUploadJob API.
	//
	// This member is required.
	JobId *string

	noSmithyDocumentSerde
}

type GetUploadJobPathOutput struct {

	// The pre-signed S3 URL for uploading the CSV file associated with the upload
	// job.
	//
	// This member is required.
	Url *string

	// The plaintext data key used to encrypt the upload file.
	//
	// To persist to the pre-signed url, use the client token and MD5 client token as
	// header. The required headers are as follows:
	//
	//   - x-amz-server-side-encryption-customer-key: Client Token
	//
	//   - x-amz-server-side-encryption-customer-key-MD5: MD5 Client Token
	//
	//   - x-amz-server-side-encryption-customer-algorithm: AES256
	ClientToken *string

	// The expiry timestamp for the pre-signed URL, after which the URL will no longer
	// be valid.
	ValidUntil *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUploadJobPathMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetUploadJobPath{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetUploadJobPath{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetUploadJobPath"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetUploadJobPathValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUploadJobPath(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetUploadJobPath(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetUploadJobPath",
	}
}
