// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an event trigger, which specifies the rules when to perform action
// based on customer's ingested data.
//
// Each event stream can be associated with only one integration in the same
// region and AWS account as the event stream.
func (c *Client) CreateEventTrigger(ctx context.Context, params *CreateEventTriggerInput, optFns ...func(*Options)) (*CreateEventTriggerOutput, error) {
	if params == nil {
		params = &CreateEventTriggerInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEventTrigger", params, optFns, c.addOperationCreateEventTriggerMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEventTriggerOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEventTriggerInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// A list of conditions that determine when an event should trigger the
	// destination.
	//
	// This member is required.
	EventTriggerConditions []types.EventTriggerCondition

	// The unique name of the event trigger.
	//
	// This member is required.
	EventTriggerName *string

	// The unique name of the object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The description of the event trigger.
	Description *string

	// Defines limits controlling whether an event triggers the destination, based on
	// ingestion latency and the number of invocations per profile over specific time
	// periods.
	EventTriggerLimits *types.EventTriggerLimits

	// The destination is triggered only for profiles that meet the criteria of a
	// segment definition.
	SegmentFilter *string

	// An array of key-value pairs to apply to this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateEventTriggerOutput struct {

	// The timestamp of when the event trigger was created.
	CreatedAt *time.Time

	// The description of the event trigger.
	Description *string

	// A list of conditions that determine when an event should trigger the
	// destination.
	EventTriggerConditions []types.EventTriggerCondition

	// Defines limits controlling whether an event triggers the destination, based on
	// ingestion latency and the number of invocations per profile over specific time
	// periods.
	EventTriggerLimits *types.EventTriggerLimits

	// The unique name of the event trigger.
	EventTriggerName *string

	// The timestamp of when the event trigger was most recently updated.
	LastUpdatedAt *time.Time

	// The unique name of the object type.
	ObjectTypeName *string

	// The destination is triggered only for profiles that meet the criteria of a
	// segment definition.
	SegmentFilter *string

	// An array of key-value pairs to apply to this resource.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEventTriggerMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateEventTrigger{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateEventTrigger{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEventTrigger"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEventTriggerValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEventTrigger(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateEventTrigger(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEventTrigger",
	}
}
