// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Agentless config
type AgentlessConfig struct {
	noSmithyDocumentSerde
}

// Answering Machine Detection config
type AnswerMachineDetectionConfig struct {

	// Enable or disable answering machine detection
	//
	// This member is required.
	EnableAnswerMachineDetection *bool

	// Enable or disable await answer machine prompt
	AwaitAnswerMachinePrompt *bool

	noSmithyDocumentSerde
}

// An Amazon Connect campaign.
type Campaign struct {

	// The resource name of an Amazon Connect campaign.
	//
	// This member is required.
	Arn *string

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Identifier representing a Campaign
	//
	// This member is required.
	Id *string

	// The name of an Amazon Connect Campaign name.
	//
	// This member is required.
	Name *string

	// Campaign Channel Subtype config
	ChannelSubtypeConfig *ChannelSubtypeConfig

	// Communication limits config
	CommunicationLimitsOverride *CommunicationLimitsConfig

	// Campaign communication time config
	CommunicationTimeConfig *CommunicationTimeConfig

	// Amazon Resource Names(ARN)
	ConnectCampaignFlowArn *string

	// Campaign schedule
	Schedule *Schedule

	// Source of the campaign
	Source Source

	// Tag map with key and value.
	Tags map[string]string

	// The type of campaign externally exposed in APIs.
	Type ExternalCampaignType

	noSmithyDocumentSerde
}

// Filter model by type
type CampaignFilters struct {

	// Connect instance identifier filter
	InstanceIdFilter *InstanceIdFilter

	noSmithyDocumentSerde
}

// An Amazon Connect campaign summary.
type CampaignSummary struct {

	// The resource name of an Amazon Connect campaign.
	//
	// This member is required.
	Arn *string

	// Channel subtype list
	//
	// This member is required.
	ChannelSubtypes []ChannelSubtype

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Identifier representing a Campaign
	//
	// This member is required.
	Id *string

	// The name of an Amazon Connect Campaign name.
	//
	// This member is required.
	Name *string

	// Amazon Resource Names(ARN)
	ConnectCampaignFlowArn *string

	// Campaign schedule
	Schedule *Schedule

	// The type of campaign externally exposed in APIs.
	Type ExternalCampaignType

	noSmithyDocumentSerde
}

// Campaign Channel Subtype config
type ChannelSubtypeConfig struct {

	// Email Channel Subtype config
	Email *EmailChannelSubtypeConfig

	// SMS Channel Subtype config
	Sms *SmsChannelSubtypeConfig

	// Telephony Channel Subtype config
	Telephony *TelephonyChannelSubtypeConfig

	// WhatsApp Channel Subtype config
	WhatsApp *WhatsAppChannelSubtypeConfig

	noSmithyDocumentSerde
}

// ChannelSubtypeParameters for an outbound request
//
// The following types satisfy this interface:
//
//	ChannelSubtypeParametersMemberEmail
//	ChannelSubtypeParametersMemberSms
//	ChannelSubtypeParametersMemberTelephony
//	ChannelSubtypeParametersMemberWhatsApp
type ChannelSubtypeParameters interface {
	isChannelSubtypeParameters()
}

// Parameters for the Email Channel Subtype
type ChannelSubtypeParametersMemberEmail struct {
	Value EmailChannelSubtypeParameters

	noSmithyDocumentSerde
}

func (*ChannelSubtypeParametersMemberEmail) isChannelSubtypeParameters() {}

// Parameters for the SMS Channel Subtype
type ChannelSubtypeParametersMemberSms struct {
	Value SmsChannelSubtypeParameters

	noSmithyDocumentSerde
}

func (*ChannelSubtypeParametersMemberSms) isChannelSubtypeParameters() {}

// Parameters for the Telephony Channel Subtype
type ChannelSubtypeParametersMemberTelephony struct {
	Value TelephonyChannelSubtypeParameters

	noSmithyDocumentSerde
}

func (*ChannelSubtypeParametersMemberTelephony) isChannelSubtypeParameters() {}

// Parameters for the WhatsApp Channel Subtype
type ChannelSubtypeParametersMemberWhatsApp struct {
	Value WhatsAppChannelSubtypeParameters

	noSmithyDocumentSerde
}

func (*ChannelSubtypeParametersMemberWhatsApp) isChannelSubtypeParameters() {}

// Communication Limit
type CommunicationLimit struct {

	// The number of days to consider with regards to this limit.
	//
	// This member is required.
	Frequency *int32

	// Maximum number of contacts allowed for a given target within the given
	// frequency.
	//
	// This member is required.
	MaxCountPerRecipient *int32

	// The communication limit time unit.
	//
	// This member is required.
	Unit CommunicationLimitTimeUnit

	noSmithyDocumentSerde
}

// Communication limits
//
// The following types satisfy this interface:
//
//	CommunicationLimitsMemberCommunicationLimitsList
type CommunicationLimits interface {
	isCommunicationLimits()
}

// List of communication limit
type CommunicationLimitsMemberCommunicationLimitsList struct {
	Value []CommunicationLimit

	noSmithyDocumentSerde
}

func (*CommunicationLimitsMemberCommunicationLimitsList) isCommunicationLimits() {}

// Communication limits config
type CommunicationLimitsConfig struct {

	// Communication limits
	AllChannelSubtypes CommunicationLimits

	// Instance limits handling
	InstanceLimitsHandling InstanceLimitsHandling

	noSmithyDocumentSerde
}

// Campaign communication time config
type CommunicationTimeConfig struct {

	// Local time zone config
	//
	// This member is required.
	LocalTimeZoneConfig *LocalTimeZoneConfig

	// Time window config
	Email *TimeWindow

	// Time window config
	Sms *TimeWindow

	// Time window config
	Telephony *TimeWindow

	// Time window config
	WhatsApp *TimeWindow

	noSmithyDocumentSerde
}

// Customer Profiles integration config
type CustomerProfilesIntegrationConfig struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	DomainArn *string

	// Object type names map.
	//
	// This member is required.
	ObjectTypeNames map[string]string

	noSmithyDocumentSerde
}

// Customer Profiles integration identifier
type CustomerProfilesIntegrationIdentifier struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	DomainArn *string

	noSmithyDocumentSerde
}

// Customer Profiles integration summary
type CustomerProfilesIntegrationSummary struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	DomainArn *string

	// Object type names map.
	//
	// This member is required.
	ObjectTypeNames map[string]string

	noSmithyDocumentSerde
}

// Email Channel Subtype config
type EmailChannelSubtypeConfig struct {

	// Default Email Outbound config
	//
	// This member is required.
	DefaultOutboundConfig *EmailOutboundConfig

	// Email Outbound Mode
	//
	// This member is required.
	OutboundMode EmailOutboundMode

	// Allocates outbound capacity for the specific channel subtype of this campaign
	// between multiple active campaigns
	Capacity *float64

	noSmithyDocumentSerde
}

// Parameters for the Email Channel Subtype
type EmailChannelSubtypeParameters struct {

	// Source/Destination Email address used for Email messages
	//
	// This member is required.
	DestinationEmailAddress *string

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like any
	// other contact attributes.
	//
	// This member is required.
	TemplateParameters map[string]string

	// Source/Destination Email address used for Email messages
	ConnectSourceEmailAddress *string

	// Amazon Resource Names(ARN)
	TemplateArn *string

	noSmithyDocumentSerde
}

// Default Email Outbound config
type EmailOutboundConfig struct {

	// Source/Destination Email address used for Email messages
	//
	// This member is required.
	ConnectSourceEmailAddress *string

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	WisdomTemplateArn *string

	// Display name for Email Address
	SourceEmailAddressDisplayName *string

	noSmithyDocumentSerde
}

// Email Outbound Mode
//
// The following types satisfy this interface:
//
//	EmailOutboundModeMemberAgentless
type EmailOutboundMode interface {
	isEmailOutboundMode()
}

// Agentless config
type EmailOutboundModeMemberAgentless struct {
	Value AgentlessConfig

	noSmithyDocumentSerde
}

func (*EmailOutboundModeMemberAgentless) isEmailOutboundMode() {}

// Encryption config for Connect Instance. Note that sensitive data will always be
// encrypted. If disabled, service will perform encryption with its own key. If
// enabled, a KMS key id needs to be provided and KMS charges will apply. KMS is
// only type supported
type EncryptionConfig struct {

	// Boolean to indicate if custom encryption has been enabled.
	//
	// This member is required.
	Enabled bool

	// Server-side encryption type.
	EncryptionType EncryptionType

	// KMS key id/arn for encryption config.
	KeyArn *string

	noSmithyDocumentSerde
}

// Event trigger of the campaign
type EventTrigger struct {

	// Amazon Resource Names(ARN)
	CustomerProfilesDomainArn *string

	noSmithyDocumentSerde
}

// Failed response of campaign state
type FailedCampaignStateResponse struct {

	// Identifier representing a Campaign
	CampaignId *string

	// A predefined code indicating the error that caused the failure in getting state
	// of campaigns
	FailureCode GetCampaignStateBatchFailureCode

	noSmithyDocumentSerde
}

// Failure details for a profile outbound request
type FailedProfileOutboundRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// Predefined code indicating the error that caused the failure
	FailureCode ProfileOutboundRequestFailureCode

	// Identifier of the profile outbound request
	Id *string

	noSmithyDocumentSerde
}

// A failed request identified by the unique client token.
type FailedRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// A predefined code indicating the error that caused the failure.
	FailureCode FailureCode

	// Identifier representing a Dial request
	Id *string

	noSmithyDocumentSerde
}

// Instance Communication limits config
type InstanceCommunicationLimitsConfig struct {

	// Communication limits
	AllChannelSubtypes CommunicationLimits

	noSmithyDocumentSerde
}

// Instance config object
type InstanceConfig struct {

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Encryption config for Connect Instance. Note that sensitive data will always be
	// encrypted. If disabled, service will perform encryption with its own key. If
	// enabled, a KMS key id needs to be provided and KMS charges will apply. KMS is
	// only type supported
	//
	// This member is required.
	EncryptionConfig *EncryptionConfig

	// Service linked role arn
	//
	// This member is required.
	ServiceLinkedRoleArn *string

	noSmithyDocumentSerde
}

// Connect instance identifier filter
type InstanceIdFilter struct {

	// Operators for Connect instance identifier filter
	//
	// This member is required.
	Operator InstanceIdFilterOperator

	// Amazon Connect Instance Id
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Instance onboarding job status object
type InstanceOnboardingJobStatus struct {

	// Amazon Connect Instance Id
	//
	// This member is required.
	ConnectInstanceId *string

	// Enumeration of the possible states for instance onboarding job
	//
	// This member is required.
	Status InstanceOnboardingJobStatusCode

	// Enumeration of the possible failure codes for instance onboarding job
	FailureCode InstanceOnboardingJobFailureCode

	noSmithyDocumentSerde
}

// Integration config for Connect Instance
//
// The following types satisfy this interface:
//
//	IntegrationConfigMemberCustomerProfiles
//	IntegrationConfigMemberLambda
//	IntegrationConfigMemberQConnect
type IntegrationConfig interface {
	isIntegrationConfig()
}

// Customer Profiles integration config
type IntegrationConfigMemberCustomerProfiles struct {
	Value CustomerProfilesIntegrationConfig

	noSmithyDocumentSerde
}

func (*IntegrationConfigMemberCustomerProfiles) isIntegrationConfig() {}

// Lambda integration config
type IntegrationConfigMemberLambda struct {
	Value LambdaIntegrationConfig

	noSmithyDocumentSerde
}

func (*IntegrationConfigMemberLambda) isIntegrationConfig() {}

// Q Connect integration config
type IntegrationConfigMemberQConnect struct {
	Value QConnectIntegrationConfig

	noSmithyDocumentSerde
}

func (*IntegrationConfigMemberQConnect) isIntegrationConfig() {}

// Integration identifier for Connect instance
//
// The following types satisfy this interface:
//
//	IntegrationIdentifierMemberCustomerProfiles
//	IntegrationIdentifierMemberLambda
//	IntegrationIdentifierMemberQConnect
type IntegrationIdentifier interface {
	isIntegrationIdentifier()
}

// Customer Profiles integration identifier
type IntegrationIdentifierMemberCustomerProfiles struct {
	Value CustomerProfilesIntegrationIdentifier

	noSmithyDocumentSerde
}

func (*IntegrationIdentifierMemberCustomerProfiles) isIntegrationIdentifier() {}

// Lambda integration identifier
type IntegrationIdentifierMemberLambda struct {
	Value LambdaIntegrationIdentifier

	noSmithyDocumentSerde
}

func (*IntegrationIdentifierMemberLambda) isIntegrationIdentifier() {}

// Q Connect integration identifier
type IntegrationIdentifierMemberQConnect struct {
	Value QConnectIntegrationIdentifier

	noSmithyDocumentSerde
}

func (*IntegrationIdentifierMemberQConnect) isIntegrationIdentifier() {}

// Integration summary for Connect instance.
//
// The following types satisfy this interface:
//
//	IntegrationSummaryMemberCustomerProfiles
//	IntegrationSummaryMemberLambda
//	IntegrationSummaryMemberQConnect
type IntegrationSummary interface {
	isIntegrationSummary()
}

// Customer Profiles integration summary
type IntegrationSummaryMemberCustomerProfiles struct {
	Value CustomerProfilesIntegrationSummary

	noSmithyDocumentSerde
}

func (*IntegrationSummaryMemberCustomerProfiles) isIntegrationSummary() {}

// Lambda integration summary
type IntegrationSummaryMemberLambda struct {
	Value LambdaIntegrationSummary

	noSmithyDocumentSerde
}

func (*IntegrationSummaryMemberLambda) isIntegrationSummary() {}

// Q Connect integration summary
type IntegrationSummaryMemberQConnect struct {
	Value QConnectIntegrationSummary

	noSmithyDocumentSerde
}

func (*IntegrationSummaryMemberQConnect) isIntegrationSummary() {}

// Lambda integration config
type LambdaIntegrationConfig struct {

	// Lambda ARN for integration with Connect instances
	//
	// This member is required.
	FunctionArn *string

	noSmithyDocumentSerde
}

// Lambda integration identifier
type LambdaIntegrationIdentifier struct {

	// Lambda ARN for integration with Connect instances
	//
	// This member is required.
	FunctionArn *string

	noSmithyDocumentSerde
}

// Lambda integration summary
type LambdaIntegrationSummary struct {

	// Lambda ARN for integration with Connect instances
	//
	// This member is required.
	FunctionArn *string

	noSmithyDocumentSerde
}

// Local time zone config
type LocalTimeZoneConfig struct {

	// Time Zone Id in the IANA format
	DefaultTimeZone *string

	// Local TimeZone Detection method list
	LocalTimeZoneDetection []LocalTimeZoneDetectionType

	noSmithyDocumentSerde
}

// Open Hours config
//
// The following types satisfy this interface:
//
//	OpenHoursMemberDailyHours
type OpenHours interface {
	isOpenHours()
}

// Daily Hours map
type OpenHoursMemberDailyHours struct {
	Value map[string][]TimeRange

	noSmithyDocumentSerde
}

func (*OpenHoursMemberDailyHours) isOpenHours() {}

// An outbound request for a campaign.
type OutboundRequest struct {

	// ChannelSubtypeParameters for an outbound request
	//
	// This member is required.
	ChannelSubtypeParameters ChannelSubtypeParameters

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	//
	// This member is required.
	ClientToken *string

	// Timestamp with no UTC offset or timezone
	//
	// This member is required.
	ExpirationTime *time.Time

	noSmithyDocumentSerde
}

// Predictive config
type PredictiveConfig struct {

	// The bandwidth allocation of a queue resource.
	//
	// This member is required.
	BandwidthAllocation *float64

	noSmithyDocumentSerde
}

// Preview config
type PreviewConfig struct {

	// The bandwidth allocation of a queue resource.
	//
	// This member is required.
	BandwidthAllocation *float64

	// Timeout Config for preview contacts.
	//
	// This member is required.
	TimeoutConfig *TimeoutConfig

	// Actions that can be performed by agent during preview phase.
	AgentActions []AgentAction

	noSmithyDocumentSerde
}

// Information about a profile outbound request
type ProfileOutboundRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	//
	// This member is required.
	ClientToken *string

	// Identifier of the customer profile
	//
	// This member is required.
	ProfileId *string

	// Timestamp with no UTC offset or timezone
	ExpirationTime *time.Time

	noSmithyDocumentSerde
}

// Progressive config
type ProgressiveConfig struct {

	// The bandwidth allocation of a queue resource.
	//
	// This member is required.
	BandwidthAllocation *float64

	noSmithyDocumentSerde
}

// Q Connect integration config
type QConnectIntegrationConfig struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	KnowledgeBaseArn *string

	noSmithyDocumentSerde
}

// Q Connect integration identifier
type QConnectIntegrationIdentifier struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	KnowledgeBaseArn *string

	noSmithyDocumentSerde
}

// Q Connect integration summary
type QConnectIntegrationSummary struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	KnowledgeBaseArn *string

	noSmithyDocumentSerde
}

// Restricted period
type RestrictedPeriod struct {

	// Date in ISO 8601 format, e.g. 2024-01-01
	//
	// This member is required.
	EndDate *string

	// Date in ISO 8601 format, e.g. 2024-01-01
	//
	// This member is required.
	StartDate *string

	// The name of a restricted period.
	Name *string

	noSmithyDocumentSerde
}

// Restricted period config
//
// The following types satisfy this interface:
//
//	RestrictedPeriodsMemberRestrictedPeriodList
type RestrictedPeriods interface {
	isRestrictedPeriods()
}

// List of restricted period
type RestrictedPeriodsMemberRestrictedPeriodList struct {
	Value []RestrictedPeriod

	noSmithyDocumentSerde
}

func (*RestrictedPeriodsMemberRestrictedPeriodList) isRestrictedPeriods() {}

// Campaign schedule
type Schedule struct {

	// Timestamp with no UTC offset or timezone
	//
	// This member is required.
	EndTime *time.Time

	// Timestamp with no UTC offset or timezone
	//
	// This member is required.
	StartTime *time.Time

	// Time duration in ISO 8601 format
	RefreshFrequency *string

	noSmithyDocumentSerde
}

// SMS Channel Subtype config
type SmsChannelSubtypeConfig struct {

	// Default SMS Outbound config
	//
	// This member is required.
	DefaultOutboundConfig *SmsOutboundConfig

	// SMS Outbound Mode
	//
	// This member is required.
	OutboundMode SmsOutboundMode

	// Allocates outbound capacity for the specific channel subtype of this campaign
	// between multiple active campaigns
	Capacity *float64

	noSmithyDocumentSerde
}

// Parameters for the SMS Channel Subtype
type SmsChannelSubtypeParameters struct {

	// The phone number of the customer, in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like any
	// other contact attributes.
	//
	// This member is required.
	TemplateParameters map[string]string

	// Amazon Resource Names(ARN)
	ConnectSourcePhoneNumberArn *string

	// Amazon Resource Names(ARN)
	TemplateArn *string

	noSmithyDocumentSerde
}

// Default SMS Outbound config
type SmsOutboundConfig struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	ConnectSourcePhoneNumberArn *string

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	WisdomTemplateArn *string

	noSmithyDocumentSerde
}

// SMS Outbound Mode
//
// The following types satisfy this interface:
//
//	SmsOutboundModeMemberAgentless
type SmsOutboundMode interface {
	isSmsOutboundMode()
}

// Agentless config
type SmsOutboundModeMemberAgentless struct {
	Value AgentlessConfig

	noSmithyDocumentSerde
}

func (*SmsOutboundModeMemberAgentless) isSmsOutboundMode() {}

// Source of the campaign
//
// The following types satisfy this interface:
//
//	SourceMemberCustomerProfilesSegmentArn
//	SourceMemberEventTrigger
type Source interface {
	isSource()
}

// Amazon Resource Names(ARN)
type SourceMemberCustomerProfilesSegmentArn struct {
	Value string

	noSmithyDocumentSerde
}

func (*SourceMemberCustomerProfilesSegmentArn) isSource() {}

// Event trigger of the campaign
type SourceMemberEventTrigger struct {
	Value EventTrigger

	noSmithyDocumentSerde
}

func (*SourceMemberEventTrigger) isSource() {}

// Successful response of campaign state
type SuccessfulCampaignStateResponse struct {

	// Identifier representing a Campaign
	CampaignId *string

	// State of a campaign
	State CampaignState

	noSmithyDocumentSerde
}

// Success details for a profile outbound request
type SuccessfulProfileOutboundRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// Identifier of the profile outbound request
	Id *string

	noSmithyDocumentSerde
}

// A successful request identified by the unique client token.
type SuccessfulRequest struct {

	// Client provided parameter used for idempotency. Its value must be unique for
	// each request.
	ClientToken *string

	// Identifier representing a Dial request
	Id *string

	noSmithyDocumentSerde
}

// Telephony Channel Subtype config
type TelephonyChannelSubtypeConfig struct {

	// Default Telephony Outbound config
	//
	// This member is required.
	DefaultOutboundConfig *TelephonyOutboundConfig

	// Telephony Outbound Mode
	//
	// This member is required.
	OutboundMode TelephonyOutboundMode

	// Allocates outbound capacity for the specific channel subtype of this campaign
	// between multiple active campaigns
	Capacity *float64

	// The queue for the call. If you specify a queue, the phone displayed for caller
	// ID is the phone number specified in the queue. If you do not specify a queue,
	// the queue defined in the contact flow is used. If you do not specify a queue,
	// you must specify a source phone number.
	ConnectQueueId *string

	noSmithyDocumentSerde
}

// Parameters for the Telephony Channel Subtype
type TelephonyChannelSubtypeParameters struct {

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like any
	// other contact attributes.
	//
	// This member is required.
	Attributes map[string]string

	// The phone number of the customer, in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// Answering Machine Detection config
	AnswerMachineDetectionConfig *AnswerMachineDetectionConfig

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	ConnectSourcePhoneNumber *string

	// Ring timeout for outbound calls
	RingTimeout *int32

	noSmithyDocumentSerde
}

// Default Telephony Outbound config
type TelephonyOutboundConfig struct {

	// The identifier of the contact flow for the outbound call.
	//
	// This member is required.
	ConnectContactFlowId *string

	// Answering Machine Detection config
	AnswerMachineDetectionConfig *AnswerMachineDetectionConfig

	// The phone number associated with the Amazon Connect instance, in E.164 format.
	// If you do not specify a source phone number, you must specify a queue.
	ConnectSourcePhoneNumber *string

	// Ring timeout for outbound calls
	RingTimeout *int32

	noSmithyDocumentSerde
}

// Telephony Outbound Mode
//
// The following types satisfy this interface:
//
//	TelephonyOutboundModeMemberAgentless
//	TelephonyOutboundModeMemberPredictive
//	TelephonyOutboundModeMemberPreview
//	TelephonyOutboundModeMemberProgressive
type TelephonyOutboundMode interface {
	isTelephonyOutboundMode()
}

// Agentless config
type TelephonyOutboundModeMemberAgentless struct {
	Value AgentlessConfig

	noSmithyDocumentSerde
}

func (*TelephonyOutboundModeMemberAgentless) isTelephonyOutboundMode() {}

// Predictive config
type TelephonyOutboundModeMemberPredictive struct {
	Value PredictiveConfig

	noSmithyDocumentSerde
}

func (*TelephonyOutboundModeMemberPredictive) isTelephonyOutboundMode() {}

// Preview config
type TelephonyOutboundModeMemberPreview struct {
	Value PreviewConfig

	noSmithyDocumentSerde
}

func (*TelephonyOutboundModeMemberPreview) isTelephonyOutboundMode() {}

// Progressive config
type TelephonyOutboundModeMemberProgressive struct {
	Value ProgressiveConfig

	noSmithyDocumentSerde
}

func (*TelephonyOutboundModeMemberProgressive) isTelephonyOutboundMode() {}

// Timeout Config for preview contacts.
type TimeoutConfig struct {

	// Timeout duration for a preview contact in seconds.
	//
	// This member is required.
	DurationInSeconds *int32

	noSmithyDocumentSerde
}

// Time range in 24 hour format
type TimeRange struct {

	// Time in ISO 8601 format, e.g. T23:11
	//
	// This member is required.
	EndTime *string

	// Time in ISO 8601 format, e.g. T23:11
	//
	// This member is required.
	StartTime *string

	noSmithyDocumentSerde
}

// Time window config
type TimeWindow struct {

	// Open Hours config
	//
	// This member is required.
	OpenHours OpenHours

	// Restricted period config
	RestrictedPeriods RestrictedPeriods

	noSmithyDocumentSerde
}

// WhatsApp Channel Subtype config
type WhatsAppChannelSubtypeConfig struct {

	// Default WhatsApp Outbound config
	//
	// This member is required.
	DefaultOutboundConfig *WhatsAppOutboundConfig

	// WhatsApp Outbound Mode
	//
	// This member is required.
	OutboundMode WhatsAppOutboundMode

	// Allocates outbound capacity for the specific channel subtype of this campaign
	// between multiple active campaigns
	Capacity *float64

	noSmithyDocumentSerde
}

// Parameters for the WhatsApp Channel Subtype
type WhatsAppChannelSubtypeParameters struct {

	// The phone number of the customer, in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// A custom key-value pair using an attribute map. The attributes are standard
	// Amazon Connect attributes, and can be accessed in contact flows just like any
	// other contact attributes.
	//
	// This member is required.
	TemplateParameters map[string]string

	// Amazon Resource Names(ARN)
	ConnectSourcePhoneNumberArn *string

	// Amazon Resource Names(ARN)
	TemplateArn *string

	noSmithyDocumentSerde
}

// Default WhatsApp Outbound config
type WhatsAppOutboundConfig struct {

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	ConnectSourcePhoneNumberArn *string

	// Amazon Resource Names(ARN)
	//
	// This member is required.
	WisdomTemplateArn *string

	noSmithyDocumentSerde
}

// WhatsApp Outbound Mode
//
// The following types satisfy this interface:
//
//	WhatsAppOutboundModeMemberAgentless
type WhatsAppOutboundMode interface {
	isWhatsAppOutboundMode()
}

// Agentless config
type WhatsAppOutboundModeMemberAgentless struct {
	Value AgentlessConfig

	noSmithyDocumentSerde
}

func (*WhatsAppOutboundModeMemberAgentless) isWhatsAppOutboundMode() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isChannelSubtypeParameters() {}
func (*UnknownUnionMember) isCommunicationLimits()      {}
func (*UnknownUnionMember) isEmailOutboundMode()        {}
func (*UnknownUnionMember) isIntegrationConfig()        {}
func (*UnknownUnionMember) isIntegrationIdentifier()    {}
func (*UnknownUnionMember) isIntegrationSummary()       {}
func (*UnknownUnionMember) isOpenHours()                {}
func (*UnknownUnionMember) isRestrictedPeriods()        {}
func (*UnknownUnionMember) isSmsOutboundMode()          {}
func (*UnknownUnionMember) isSource()                   {}
func (*UnknownUnionMember) isTelephonyOutboundMode()    {}
func (*UnknownUnionMember) isWhatsAppOutboundMode()     {}
