// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches for data tables based on the table's ID, name, and description. In the
// future, this operation can support searching on attribute names and possibly
// primary values. Follows other search operations closely and supports both search
// criteria and filters.
func (c *Client) SearchDataTables(ctx context.Context, params *SearchDataTablesInput, optFns ...func(*Options)) (*SearchDataTablesOutput, error) {
	if params == nil {
		params = &SearchDataTablesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchDataTables", params, optFns, c.addOperationSearchDataTablesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchDataTablesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchDataTablesInput struct {

	// The unique identifier for the Amazon Connect instance to search within.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of data tables to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Search criteria including string conditions for matching table names,
	// descriptions, or resource IDs. Supports STARTS_WITH, CONTAINS, and EXACT
	// comparison types.
	SearchCriteria *types.DataTableSearchCriteria

	// Optional filters to apply to the search results, such as tag-based filtering
	// for attribute-based access control.
	SearchFilter *types.DataTableSearchFilter

	noSmithyDocumentSerde
}

type SearchDataTablesOutput struct {

	// The approximate number of data tables that matched the search criteria.
	ApproximateTotalCount *int64

	// An array of data tables matching the search criteria with the same structure as
	// DescribeTable except Version, VersionDescription, and LockVersion are omitted.
	DataTables []types.DataTable

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchDataTablesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchDataTables{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchDataTables{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchDataTables"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchDataTablesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchDataTables(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchDataTablesPaginatorOptions is the paginator options for SearchDataTables
type SearchDataTablesPaginatorOptions struct {
	// The maximum number of data tables to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchDataTablesPaginator is a paginator for SearchDataTables
type SearchDataTablesPaginator struct {
	options   SearchDataTablesPaginatorOptions
	client    SearchDataTablesAPIClient
	params    *SearchDataTablesInput
	nextToken *string
	firstPage bool
}

// NewSearchDataTablesPaginator returns a new SearchDataTablesPaginator
func NewSearchDataTablesPaginator(client SearchDataTablesAPIClient, params *SearchDataTablesInput, optFns ...func(*SearchDataTablesPaginatorOptions)) *SearchDataTablesPaginator {
	if params == nil {
		params = &SearchDataTablesInput{}
	}

	options := SearchDataTablesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchDataTablesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchDataTablesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchDataTables page.
func (p *SearchDataTablesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchDataTablesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchDataTables(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchDataTablesAPIClient is a client that implements the SearchDataTables
// operation.
type SearchDataTablesAPIClient interface {
	SearchDataTables(context.Context, *SearchDataTablesInput, ...func(*Options)) (*SearchDataTablesOutput, error)
}

var _ SearchDataTablesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchDataTables(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchDataTables",
	}
}
