// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists values stored in a data table with optional filtering by record IDs or
// primary attribute values. Returns the raw stored values along with metadata such
// as lock versions and modification timestamps.
func (c *Client) ListDataTableValues(ctx context.Context, params *ListDataTableValuesInput, optFns ...func(*Options)) (*ListDataTableValuesOutput, error) {
	if params == nil {
		params = &ListDataTableValuesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataTableValues", params, optFns, c.addOperationListDataTableValuesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataTableValuesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDataTableValuesInput struct {

	// The unique identifier for the data table whose values should be listed.
	//
	// This member is required.
	DataTableId *string

	// The unique identifier for the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of data table values to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Optional filter to retrieve values for records matching specific primary
	// attribute criteria.
	PrimaryAttributeValues []types.PrimaryAttributeValueFilter

	// Optional list of specific record IDs to retrieve values for.
	RecordIds []string

	noSmithyDocumentSerde
}

type ListDataTableValuesOutput struct {

	// A list of data table values with their associated metadata, lock versions, and
	// modification details.
	//
	// This member is required.
	Values []types.DataTableValueSummary

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataTableValuesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataTableValues{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataTableValues{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataTableValues"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataTableValuesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataTableValues(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataTableValuesPaginatorOptions is the paginator options for
// ListDataTableValues
type ListDataTableValuesPaginatorOptions struct {
	// The maximum number of data table values to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataTableValuesPaginator is a paginator for ListDataTableValues
type ListDataTableValuesPaginator struct {
	options   ListDataTableValuesPaginatorOptions
	client    ListDataTableValuesAPIClient
	params    *ListDataTableValuesInput
	nextToken *string
	firstPage bool
}

// NewListDataTableValuesPaginator returns a new ListDataTableValuesPaginator
func NewListDataTableValuesPaginator(client ListDataTableValuesAPIClient, params *ListDataTableValuesInput, optFns ...func(*ListDataTableValuesPaginatorOptions)) *ListDataTableValuesPaginator {
	if params == nil {
		params = &ListDataTableValuesInput{}
	}

	options := ListDataTableValuesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataTableValuesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataTableValuesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataTableValues page.
func (p *ListDataTableValuesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataTableValuesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataTableValues(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataTableValuesAPIClient is a client that implements the
// ListDataTableValues operation.
type ListDataTableValuesAPIClient interface {
	ListDataTableValues(context.Context, *ListDataTableValuesInput, ...func(*Options)) (*ListDataTableValuesOutput, error)
}

var _ ListDataTableValuesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataTableValues(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataTableValues",
	}
}
