// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Associates an email address alias with an existing email address in an Amazon
// Connect instance. This creates a forwarding relationship where emails sent to
// the alias email address are automatically forwarded to the primary email
// address.
//
// # Use cases
//
// Following are common uses cases for this API:
//
//   - Unified customer support: Create multiple entry points (for example,
//     support@example.com, help@example.com, customercare@example.com) that all
//     forward to a single agent queue for streamlined management.
//
//   - Department consolidation: Forward emails from legacy department addresses
//     (for example, sales@example.com, info@example.com) to a centralized customer
//     service email during organizational restructuring.
//
//   - Brand management: Enable you to use familiar brand-specific email addresses
//     that forward to the appropriate Amazon Connect instance email address.
//
// Important things to know
//
//   - Each email address can have a maximum of one alias. You cannot create
//     multiple aliases for the same email address.
//
//   - If the alias email address already receives direct emails, it continues to
//     receive direct emails plus forwarded emails.
//
//   - You cannot chain email aliases together (that is, create an alias of an
//     alias).
//
// AssociateEmailAddressAlias does not return the following information:
//
//   - A confirmation of the alias relationship details (you must call [DescribeEmailAddress]to verify).
//
//   - The timestamp of when the association occurred.
//
//   - The status of the forwarding configuration.
//
// Endpoints: See [Amazon Connect endpoints and quotas].
//
// # Related operations
//
// [DisassociateEmailAddressAlias]
//   - : Removes the alias association between two email addresses in an Amazon
//     Connect instance.
//
// [DescribeEmailAddress]
//   - : View current alias configurations for an email address.
//
// [SearchEmailAddresses]
//   - : Find email addresses and their alias relationships across an instance.
//
// [CreateEmailAddress]
//   - : Create new email addresses that can participate in alias relationships.
//
// [DeleteEmailAddress]
//   - : Remove email addresses (automatically removes any alias relationships).
//
// [UpdateEmailAddressMetadata]
//   - : Modify email address properties (does not affect alias relationships).
//
// [DescribeEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribeEmailAddress.html
// [DeleteEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteEmailAddress.html
// [DisassociateEmailAddressAlias]: https://docs.aws.amazon.com/connect/latest/APIReference/API_DisassociateEmailAddressAlias.html
// [SearchEmailAddresses]: https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchEmailAddresses.html
// [UpdateEmailAddressMetadata]: https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateEmailAddressMetadata.html
// [Amazon Connect endpoints and quotas]: https://docs.aws.amazon.com/general/latest/gr/connect_region.html
// [CreateEmailAddress]: https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateEmailAddress.html
func (c *Client) AssociateEmailAddressAlias(ctx context.Context, params *AssociateEmailAddressAliasInput, optFns ...func(*Options)) (*AssociateEmailAddressAliasOutput, error) {
	if params == nil {
		params = &AssociateEmailAddressAliasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateEmailAddressAlias", params, optFns, c.addOperationAssociateEmailAddressAliasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateEmailAddressAliasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type AssociateEmailAddressAliasInput struct {

	// Configuration object that specifies which email address will serve as the
	// alias. The specified email address must already exist in the Amazon Connect
	// instance and cannot already be configured as an alias or have an alias of its
	// own.
	//
	// This member is required.
	AliasConfiguration *types.AliasConfiguration

	// The identifier of the email address.
	//
	// This member is required.
	EmailAddressId *string

	// The identifier of the Amazon Connect instance. You can [find the instance ID] in the Amazon Resource
	// Name (ARN) of the instance.
	//
	// [find the instance ID]: https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html
	//
	// This member is required.
	InstanceId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see [Making retries safe with idempotent APIs].
	//
	// [Making retries safe with idempotent APIs]: https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/
	ClientToken *string

	noSmithyDocumentSerde
}

type AssociateEmailAddressAliasOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateEmailAddressAliasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpAssociateEmailAddressAlias{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpAssociateEmailAddressAlias{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "AssociateEmailAddressAlias"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opAssociateEmailAddressAliasMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateEmailAddressAliasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateEmailAddressAlias(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpAssociateEmailAddressAlias struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpAssociateEmailAddressAlias) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpAssociateEmailAddressAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*AssociateEmailAddressAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *AssociateEmailAddressAliasInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opAssociateEmailAddressAliasMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpAssociateEmailAddressAlias{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opAssociateEmailAddressAlias(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "AssociateEmailAddressAlias",
	}
}
