// Code generated by smithy-go-codegen DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/configservice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of authorizations granted to various aggregator accounts and
// regions.
func (c *Client) DescribeAggregationAuthorizations(ctx context.Context, params *DescribeAggregationAuthorizationsInput, optFns ...func(*Options)) (*DescribeAggregationAuthorizationsOutput, error) {
	if params == nil {
		params = &DescribeAggregationAuthorizationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAggregationAuthorizations", params, optFns, c.addOperationDescribeAggregationAuthorizationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAggregationAuthorizationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAggregationAuthorizationsInput struct {

	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, Config uses the default.
	Limit int32

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeAggregationAuthorizationsOutput struct {

	// Returns a list of authorizations granted to various aggregator accounts and
	// regions.
	AggregationAuthorizations []types.AggregationAuthorization

	// The nextToken string returned on a previous page that you use to get the next
	// page of results in a paginated response.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAggregationAuthorizationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeAggregationAuthorizations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeAggregationAuthorizations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAggregationAuthorizations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAggregationAuthorizations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeAggregationAuthorizationsPaginatorOptions is the paginator options for
// DescribeAggregationAuthorizations
type DescribeAggregationAuthorizationsPaginatorOptions struct {
	// The maximum number of AggregationAuthorizations returned on each page. The
	// default is maximum. If you specify 0, Config uses the default.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeAggregationAuthorizationsPaginator is a paginator for
// DescribeAggregationAuthorizations
type DescribeAggregationAuthorizationsPaginator struct {
	options   DescribeAggregationAuthorizationsPaginatorOptions
	client    DescribeAggregationAuthorizationsAPIClient
	params    *DescribeAggregationAuthorizationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeAggregationAuthorizationsPaginator returns a new
// DescribeAggregationAuthorizationsPaginator
func NewDescribeAggregationAuthorizationsPaginator(client DescribeAggregationAuthorizationsAPIClient, params *DescribeAggregationAuthorizationsInput, optFns ...func(*DescribeAggregationAuthorizationsPaginatorOptions)) *DescribeAggregationAuthorizationsPaginator {
	if params == nil {
		params = &DescribeAggregationAuthorizationsInput{}
	}

	options := DescribeAggregationAuthorizationsPaginatorOptions{}
	if params.Limit != 0 {
		options.Limit = params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeAggregationAuthorizationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeAggregationAuthorizationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeAggregationAuthorizations page.
func (p *DescribeAggregationAuthorizationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeAggregationAuthorizationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.Limit = p.options.Limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeAggregationAuthorizations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeAggregationAuthorizationsAPIClient is a client that implements the
// DescribeAggregationAuthorizations operation.
type DescribeAggregationAuthorizationsAPIClient interface {
	DescribeAggregationAuthorizations(context.Context, *DescribeAggregationAuthorizationsInput, ...func(*Options)) (*DescribeAggregationAuthorizationsOutput, error)
}

var _ DescribeAggregationAuthorizationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeAggregationAuthorizations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAggregationAuthorizations",
	}
}
