// Code generated by smithy-go-codegen DO NOT EDIT.

package computeoptimizerautomation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/computeoptimizerautomation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Creates a new automation rule to apply recommended actions to resources based
//
// on specified criteria.
func (c *Client) CreateAutomationRule(ctx context.Context, params *CreateAutomationRuleInput, optFns ...func(*Options)) (*CreateAutomationRuleOutput, error) {
	if params == nil {
		params = &CreateAutomationRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAutomationRule", params, optFns, c.addOperationCreateAutomationRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAutomationRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAutomationRuleInput struct {

	//  The name of the automation rule.
	//
	// This member is required.
	Name *string

	//  The types of recommended actions this rule will automate.
	//
	// This member is required.
	RecommendedActionTypes []types.RecommendedActionType

	//  The type of rule.
	//
	// Only the management account or a delegated administrator can set the ruleType
	// to be OrganizationRule.
	//
	// This member is required.
	RuleType types.RuleType

	//  The schedule for when the rule should run.
	//
	// This member is required.
	Schedule *types.Schedule

	// The status of the rule
	//
	// This member is required.
	Status types.RuleStatus

	//  A unique identifier to ensure idempotency of the request.
	ClientToken *string

	// A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time.
	Criteria *types.Criteria

	//  A description of the automation rule.
	Description *string

	//  Configuration for organization-level rules. Required for OrganizationRule
	// type.
	OrganizationConfiguration *types.OrganizationConfiguration

	// A string representation of a decimal number between 0 and 1 (having up to 30
	// digits after the decimal point) that determines the priority of the rule. When
	// multiple rules match the same recommended action, Compute Optimizer assigns the
	// action to the rule with the lowest priority value (highest priority), even if
	// that rule is scheduled to run later than other matching rules.
	Priority *string

	//  The tags to associate with the rule.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateAutomationRuleOutput struct {

	// The timestamp when the automation rule was created.
	CreatedTimestamp *time.Time

	//  A set of conditions that specify which recommended action qualify for
	// implementation. When a rule is active and a recommended action matches these
	// criteria, Compute Optimizer implements the action at the scheduled run time. You
	// can specify up to 20 conditions per filter criteria and 20 values per condition.
	Criteria *types.Criteria

	// A description of the automation rule. Can be up to 1024 characters long and
	// contain alphanumeric characters, underscores, hyphens, spaces, and certain
	// special characters.
	Description *string

	// The name of the automation rule. Must be 1-128 characters long and contain only
	// alphanumeric characters, underscores, and hyphens.
	Name *string

	// Configuration settings for organization-wide rules, including rule application
	// order and target account IDs.
	OrganizationConfiguration *types.OrganizationConfiguration

	// The priority level of the automation rule, used to determine execution order
	// when multiple rules apply to the same resource.
	Priority *string

	// List of recommended action types that this rule can execute, such as
	// SnapshotAndDeleteUnattachedEbsVolume or UpgradeEbsVolumeType.
	RecommendedActionTypes []types.RecommendedActionType

	//  The Amazon Resource Name (ARN) of the created rule.
	RuleArn *string

	//  The unique identifier of the created rule.
	RuleId *string

	// The revision number of the automation rule. This is incremented each time the
	// rule is updated.
	RuleRevision *int64

	// The type of automation rule. Can be either OrganizationRule for
	// organization-wide rules or AccountRule for account-specific rules.
	RuleType types.RuleType

	// The schedule configuration for when the automation rule should execute,
	// including cron expression, timezone, and execution window.
	Schedule *types.Schedule

	// The current status of the automation rule. Can be Active or Inactive.
	Status types.RuleStatus

	// A list of key-value pairs used to categorize and organize the automation rule.
	// Maximum of 200 tags allowed.
	Tags []types.Tag

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAutomationRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateAutomationRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAutomationRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateAutomationRuleMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateAutomationRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAutomationRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateAutomationRule struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateAutomationRule) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateAutomationRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateAutomationRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateAutomationRuleInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateAutomationRuleMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateAutomationRule{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateAutomationRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAutomationRule",
	}
}
