// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an ML input channel.
func (c *Client) GetMLInputChannel(ctx context.Context, params *GetMLInputChannelInput, optFns ...func(*Options)) (*GetMLInputChannelOutput, error) {
	if params == nil {
		params = &GetMLInputChannelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetMLInputChannel", params, optFns, c.addOperationGetMLInputChannelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetMLInputChannelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetMLInputChannelInput struct {

	// The membership ID of the membership that contains the ML input channel that you
	// want to get.
	//
	// This member is required.
	MembershipIdentifier *string

	// The Amazon Resource Name (ARN) of the ML input channel that you want to get.
	//
	// This member is required.
	MlInputChannelArn *string

	noSmithyDocumentSerde
}

type GetMLInputChannelOutput struct {

	// The collaboration ID of the collaboration that contains the ML input channel.
	//
	// This member is required.
	CollaborationIdentifier *string

	// The configured model algorithm associations that were used to create the ML
	// input channel.
	//
	// This member is required.
	ConfiguredModelAlgorithmAssociations []string

	// The time at which the ML input channel was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The input channel that was used to create the ML input channel.
	//
	// This member is required.
	InputChannel *types.InputChannel

	// The membership ID of the membership that contains the ML input channel.
	//
	// This member is required.
	MembershipIdentifier *string

	// The Amazon Resource Name (ARN) of the ML input channel.
	//
	// This member is required.
	MlInputChannelArn *string

	// The name of the ML input channel.
	//
	// This member is required.
	Name *string

	// The number of days to keep the data in the ML input channel.
	//
	// This member is required.
	RetentionInDays *int32

	// The status of the ML input channel.
	//
	// This member is required.
	Status types.MLInputChannelStatus

	// The most recent time at which the ML input channel was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the ML input channel.
	Description *string

	// The Amazon Resource Name (ARN) of the KMS key that was used to create the ML
	// input channel.
	KmsKeyArn *string

	// The number of files in the ML input channel.
	NumberOfFiles *float64

	// The number of records in the ML input channel.
	NumberOfRecords *int64

	// Returns the privacy budgets that control access to this Clean Rooms ML input
	// channel. Use these budgets to monitor and limit resource consumption over
	// specified time periods.
	PrivacyBudgets types.PrivacyBudgets

	// The ID of the protected query that was used to create the ML input channel.
	ProtectedQueryIdentifier *string

	// The size, in GB, of the ML input channel.
	SizeInGb *float64

	// Details about the status of a resource.
	StatusDetails *types.StatusDetails

	// The synthetic data configuration for this ML input channel, including
	// parameters for generating privacy-preserving synthetic data and evaluation
	// scores for measuring the privacy of the generated data.
	SyntheticDataConfiguration *types.SyntheticDataConfiguration

	// The optional metadata that you applied to the resource to help you categorize
	// and organize them. Each tag consists of a key and an optional value, both of
	// which you define.
	//
	// The following basic restrictions apply to tags:
	//
	//   - Maximum number of tags per resource - 50.
	//
	//   - For each resource, each tag key must be unique, and each tag key can have
	//   only one value.
	//
	//   - Maximum key length - 128 Unicode characters in UTF-8.
	//
	//   - Maximum value length - 256 Unicode characters in UTF-8.
	//
	//   - If your tagging schema is used across multiple services and resources,
	//   remember that other services may have restrictions on allowed characters.
	//   Generally allowed characters are: letters, numbers, and spaces representable in
	//   UTF-8, and the following characters: + - = . _ : / @.
	//
	//   - Tag keys and values are case sensitive.
	//
	//   - Do not use aws:, AWS:, or any upper or lowercase combination of such as a
	//   prefix for keys as it is reserved for AWS use. You cannot edit or delete tag
	//   keys with this prefix. Values can have this prefix. If a tag value has aws as
	//   its prefix but the key does not, then Clean Rooms ML considers it to be a user
	//   tag and will count against the limit of 50 tags. Tags with only the key prefix
	//   of aws do not count against your tags per resource limit.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetMLInputChannelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetMLInputChannel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetMLInputChannel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetMLInputChannel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetMLInputChannelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetMLInputChannel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetMLInputChannel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetMLInputChannel",
	}
}
