// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/cleanrooms/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Controls and tracks usage limits for associated configured tables within a
// collaboration across queries and job. Supports both period-based budgets that
// can renew (daily, weekly, or monthly) and fixed lifetime budgets. Contains the
// resource ARN, remaining budget information, and up to two budget configurations
// (period-based and lifetime). By default, table usage is unlimited unless a
// budget is configured.
type AccessBudget struct {

	// The total remaining budget across all budget parameters, showing the lower
	// value between the per-period budget and lifetime budget for this access budget.
	// For individual parameter budgets, see remainingBudget .
	//
	// This member is required.
	AggregateRemainingBudget *int32

	// Detailed budget information including time bounds, remaining budget, and
	// refresh settings.
	//
	// This member is required.
	Details []AccessBudgetDetails

	// The Amazon Resource Name (ARN) of the access budget resource.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Detailed information about an access budget including time bounds, budget
// allocation, and configuration settings.
type AccessBudgetDetails struct {

	// The total budget allocation amount for this access budget.
	//
	// This member is required.
	Budget *int32

	// Specifies the time period for limiting table usage in queries and jobs. For
	// calendar-based periods, the budget can renew if auto refresh is enabled. For
	// lifetime budgets, the limit applies to the total usage throughout the
	// collaboration. Valid values are:
	//
	// CALENDAR_DAY - Limit table usage per day.
	//
	// CALENDAR_WEEK - Limit table usage per week.
	//
	// CALENDAR_MONTH - Limit table usage per month.
	//
	// LIFETIME - Limit total table usage for the collaboration duration.
	//
	// This member is required.
	BudgetType AccessBudgetType

	// The remaining budget amount available for use within this access budget.
	//
	// This member is required.
	RemainingBudget *int32

	// The start time for the access budget period.
	//
	// This member is required.
	StartTime *time.Time

	// Indicates whether the budget automatically refreshes for each time period
	// specified in budgetType . Valid values are:
	//
	// ENABLED - The budget refreshes automatically at the start of each period.
	//
	// DISABLED - The budget must be refreshed manually.
	//
	// NULL - The value is null when budgetType is set to LIFETIME .
	AutoRefresh AutoRefreshMode

	// The end time for the access budget period.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// Input parameters for privacy budget templates that support access budgets
// functionality, enabling enhanced budget management capabilities.
type AccessBudgetsPrivacyTemplateParametersInput struct {

	// An array of budget parameters that define the access budget configuration for
	// the privacy template.
	//
	// This member is required.
	BudgetParameters []BudgetParameter

	// The Amazon Resource Name (ARN) of the resource associated with this privacy
	// budget template.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Output parameters for privacy budget templates with access budgets support,
// containing the configured budget information.
type AccessBudgetsPrivacyTemplateParametersOutput struct {

	// An array of budget parameters returned from the access budget configuration.
	//
	// This member is required.
	BudgetParameters []BudgetParameter

	// The Amazon Resource Name (ARN) of the resource associated with this privacy
	// budget template.
	//
	// This member is required.
	ResourceArn *string

	noSmithyDocumentSerde
}

// Update parameters for privacy budget templates with access budgets
// functionality, allowing modification of existing budget configurations.
type AccessBudgetsPrivacyTemplateUpdateParameters struct {

	// Updated array of budget parameters for the access budget configuration.
	//
	// This member is required.
	BudgetParameters []BudgetParameter

	noSmithyDocumentSerde
}

// Column in configured table that can be used in aggregate function in query.
type AggregateColumn struct {

	// Column names in configured table of aggregate columns.
	//
	// This member is required.
	ColumnNames []string

	// Aggregation function that can be applied to aggregate column in query.
	//
	// This member is required.
	Function AggregateFunctionName

	noSmithyDocumentSerde
}

// Constraint on query output removing output rows that do not meet a minimum
// number of distinct values of a specified column.
type AggregationConstraint struct {

	// Column in aggregation constraint for which there must be a minimum number of
	// distinct values in an output row for it to be in the query output.
	//
	// This member is required.
	ColumnName *string

	// The minimum number of distinct values that an output row must be an aggregation
	// of. Minimum threshold of distinct values for a specified column that must exist
	// in an output row for it to be in the query output.
	//
	// This member is required.
	Minimum *int32

	// The type of aggregation the constraint allows. The only valid value is
	// currently `COUNT_DISTINCT`.
	//
	// This member is required.
	Type AggregationType

	noSmithyDocumentSerde
}

// Optional. The member who can query can provide this placeholder for a literal
// data value in an analysis template.
type AnalysisParameter struct {

	// The name of the parameter. The name must use only alphanumeric, underscore (_),
	// or hyphen (-) characters but cannot start or end with a hyphen.
	//
	// This member is required.
	Name *string

	// The type of parameter.
	//
	// This member is required.
	Type ParameterType

	// Optional. The default value that is applied in the analysis template. The
	// member who can query can override this value in the query editor.
	DefaultValue *string

	noSmithyDocumentSerde
}

// A specification about how data from the configured table can be used in a query.
type AnalysisRule struct {

	// The unique ID for the associated collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The time the analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The name for the analysis rule.
	//
	// This member is required.
	Name *string

	// A policy that describes the associated data usage limitations.
	//
	// This member is required.
	Policy AnalysisRulePolicy

	// The type of analysis rule.
	//
	// This member is required.
	Type AnalysisRuleType

	// The time the analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	//  Controls on the query specifications that can be run on an associated
	// configured table.
	CollaborationPolicy ConfiguredTableAssociationAnalysisRulePolicy

	//  The consolidated policy for the analysis rule.
	ConsolidatedPolicy ConsolidatedPolicy

	noSmithyDocumentSerde
}

// A type of analysis rule that enables query structure and specified queries that
// produce aggregate statistics.
type AnalysisRuleAggregation struct {

	// The columns that query runners are allowed to use in aggregation queries.
	//
	// This member is required.
	AggregateColumns []AggregateColumn

	// The columns that query runners are allowed to select, group by, or filter by.
	//
	// This member is required.
	DimensionColumns []string

	// Columns in configured table that can be used in join statements and/or as
	// aggregate columns. They can never be outputted directly.
	//
	// This member is required.
	JoinColumns []string

	// Columns that must meet a specific threshold value (after an aggregation
	// function is applied to it) for each output row to be returned.
	//
	// This member is required.
	OutputConstraints []AggregationConstraint

	// Set of scalar functions that are allowed to be used on dimension columns and
	// the output of aggregation of metrics.
	//
	// This member is required.
	ScalarFunctions []ScalarFunctions

	//  An indicator as to whether additional analyses (such as Clean Rooms ML) can be
	// applied to the output of the direct query.
	//
	// The additionalAnalyses parameter is currently supported for the list analysis
	// rule ( AnalysisRuleList ) and the custom analysis rule ( AnalysisRuleCustom ).
	AdditionalAnalyses AdditionalAnalyses

	// Which logical operators (if any) are to be used in an INNER JOIN match
	// condition. Default is AND .
	AllowedJoinOperators []JoinOperator

	// Control that requires member who runs query to do a join with their configured
	// table and/or other configured table in query.
	JoinRequired JoinRequiredOption

	noSmithyDocumentSerde
}

// A type of analysis rule that enables the table owner to approve custom SQL
// queries on their configured tables. It supports differential privacy.
type AnalysisRuleCustom struct {

	// The ARN of the analysis templates that are allowed by the custom analysis rule.
	//
	// This member is required.
	AllowedAnalyses []string

	//  An indicator as to whether additional analyses (such as Clean Rooms ML) can be
	// applied to the output of the direct query.
	AdditionalAnalyses AdditionalAnalyses

	// The IDs of the Amazon Web Services accounts that are allowed to query by the
	// custom analysis rule. Required when allowedAnalyses is ANY_QUERY .
	AllowedAnalysisProviders []string

	// The differential privacy configuration.
	DifferentialPrivacy *DifferentialPrivacyConfiguration

	//  A list of columns that aren't allowed to be shown in the query output.
	DisallowedOutputColumns []string

	noSmithyDocumentSerde
}

// Defines details for the analysis rule ID mapping table.
type AnalysisRuleIdMappingTable struct {

	// The columns that query runners are allowed to use in an INNER JOIN statement.
	//
	// This member is required.
	JoinColumns []string

	// The query constraints of the analysis rule ID mapping table.
	//
	// This member is required.
	QueryConstraints []QueryConstraint

	// The columns that query runners are allowed to select, group by, or filter by.
	DimensionColumns []string

	noSmithyDocumentSerde
}

// A type of analysis rule that enables row-level analysis.
type AnalysisRuleList struct {

	// Columns that can be used to join a configured table with the table of the
	// member who can query and other members' configured tables.
	//
	// This member is required.
	JoinColumns []string

	// Columns that can be listed in the output.
	//
	// This member is required.
	ListColumns []string

	//  An indicator as to whether additional analyses (such as Clean Rooms ML) can be
	// applied to the output of the direct query.
	AdditionalAnalyses AdditionalAnalyses

	// The logical operators (if any) that are to be used in an INNER JOIN match
	// condition. Default is AND .
	AllowedJoinOperators []JoinOperator

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on configured table.
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyMemberV1
type AnalysisRulePolicy interface {
	isAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on configured table.
type AnalysisRulePolicyMemberV1 struct {
	Value AnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyMemberV1) isAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on configured table.
//
// The following types satisfy this interface:
//
//	AnalysisRulePolicyV1MemberAggregation
//	AnalysisRulePolicyV1MemberCustom
//	AnalysisRulePolicyV1MemberIdMappingTable
//	AnalysisRulePolicyV1MemberList
type AnalysisRulePolicyV1 interface {
	isAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type AnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberAggregation) isAnalysisRulePolicyV1() {}

// Analysis rule type that enables custom SQL queries on a configured table.
type AnalysisRulePolicyV1MemberCustom struct {
	Value AnalysisRuleCustom

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberCustom) isAnalysisRulePolicyV1() {}

// The ID mapping table.
type AnalysisRulePolicyV1MemberIdMappingTable struct {
	Value AnalysisRuleIdMappingTable

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberIdMappingTable) isAnalysisRulePolicyV1() {}

// Analysis rule type that enables only list queries on a configured table.
type AnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*AnalysisRulePolicyV1MemberList) isAnalysisRulePolicyV1() {}

// A relation within an analysis.
type AnalysisSchema struct {

	// The tables referenced in the analysis schema.
	ReferencedTables []string

	noSmithyDocumentSerde
}

// The structure that defines the body of the analysis template.
//
// The following types satisfy this interface:
//
//	AnalysisSourceMemberArtifacts
//	AnalysisSourceMemberText
type AnalysisSource interface {
	isAnalysisSource()
}

// The artifacts of the analysis source.
type AnalysisSourceMemberArtifacts struct {
	Value AnalysisTemplateArtifacts

	noSmithyDocumentSerde
}

func (*AnalysisSourceMemberArtifacts) isAnalysisSource() {}

// The query text.
type AnalysisSourceMemberText struct {
	Value string

	noSmithyDocumentSerde
}

func (*AnalysisSourceMemberText) isAnalysisSource() {}

// The analysis source metadata.
//
// The following types satisfy this interface:
//
//	AnalysisSourceMetadataMemberArtifacts
type AnalysisSourceMetadata interface {
	isAnalysisSourceMetadata()
}

// The artifacts of the analysis source metadata.
type AnalysisSourceMetadataMemberArtifacts struct {
	Value AnalysisTemplateArtifactMetadata

	noSmithyDocumentSerde
}

func (*AnalysisSourceMetadataMemberArtifacts) isAnalysisSourceMetadata() {}

// The analysis template.
type AnalysisTemplate struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the associated collaboration of the analysis template.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The format of the analysis template.
	//
	// This member is required.
	Format AnalysisFormat

	// The identifier for the analysis template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier of a member who created the analysis template.
	//
	// This member is required.
	MembershipId *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The entire schema object.
	//
	// This member is required.
	Schema *AnalysisSchema

	// The source of the analysis template.
	//
	// This member is required.
	Source AnalysisSource

	// The time that the analysis template was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The parameters of the analysis template.
	AnalysisParameters []AnalysisParameter

	// The description of the analysis template.
	Description *string

	// The configuration that specifies the level of detail in error messages returned
	// by analyses using this template. When set to DETAILED , error messages include
	// more information to help troubleshoot issues with PySpark jobs. Detailed error
	// messages may expose underlying data, including sensitive information.
	// Recommended for faster troubleshooting in development and testing environments.
	ErrorMessageConfiguration *ErrorMessageConfiguration

	//  The source metadata for the analysis template.
	SourceMetadata AnalysisSourceMetadata

	// The parameters used to generate synthetic data for this analysis template.
	SyntheticDataParameters SyntheticDataParameters

	// Information about the validations performed on the analysis template.
	Validations []AnalysisTemplateValidationStatusDetail

	noSmithyDocumentSerde
}

// The analysis template artifact.
type AnalysisTemplateArtifact struct {

	//  The artifact location.
	//
	// This member is required.
	Location *S3Location

	noSmithyDocumentSerde
}

// The analysis template artifact metadata.
type AnalysisTemplateArtifactMetadata struct {

	//  The hash of the entry point for the analysis template artifact metadata.
	//
	// This member is required.
	EntryPointHash *Hash

	//  Additional artifact hashes for the analysis template.
	AdditionalArtifactHashes []Hash

	noSmithyDocumentSerde
}

// The analysis template artifacts.
type AnalysisTemplateArtifacts struct {

	//  The entry point for the analysis template artifacts.
	//
	// This member is required.
	EntryPoint *AnalysisTemplateArtifact

	//  The role ARN for the analysis template artifacts.
	//
	// This member is required.
	RoleArn *string

	//  Additional artifacts for the analysis template.
	AdditionalArtifacts []AnalysisTemplateArtifact

	noSmithyDocumentSerde
}

// The metadata of the analysis template.
type AnalysisTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template summary’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis template summary
	// belongs to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template summary was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the analysis template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The time that the analysis template summary was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the analysis template.
	Description *string

	// Indicates if this analysis template summary generated synthetic data.
	IsSyntheticData *bool

	noSmithyDocumentSerde
}

// The status details of the analysis template validation. Clean Rooms
// Differential Privacy uses a general-purpose query structure to support complex
// SQL queries and validates whether an analysis template fits that general-purpose
// query structure. Validation is performed when analysis templates are created and
// fetched. Because analysis templates are immutable by design, we recommend that
// you create analysis templates after you associate the configured tables with
// their analysis rule to your collaboration.
//
// For more information, see [https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy].
//
// [https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy]: https://docs.aws.amazon.com/clean-rooms/latest/userguide/analysis-rules-custom.html#custom-diff-privacy
type AnalysisTemplateValidationStatusDetail struct {

	// The status of the validation.
	//
	// This member is required.
	Status AnalysisTemplateValidationStatus

	// The type of validation that was performed.
	//
	// This member is required.
	Type AnalysisTemplateValidationType

	// The reasons for the validation results.
	Reasons []AnalysisTemplateValidationStatusReason

	noSmithyDocumentSerde
}

// The reasons for the validation results.
type AnalysisTemplateValidationStatusReason struct {

	// The validation message.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// A reference to a table within Athena.
type AthenaTableReference struct {

	//  The database name.
	//
	// This member is required.
	DatabaseName *string

	//  The table reference.
	//
	// This member is required.
	TableName *string

	//  The workgroup of the Athena table reference.
	//
	// This member is required.
	WorkGroup *string

	//  The output location for the Athena table.
	OutputLocation *string

	// The Amazon Web Services Region where the Athena table is located. This
	// parameter is required to uniquely identify and access tables across different
	// Regions.
	Region CommercialRegion

	noSmithyDocumentSerde
}

// Details of errors thrown by the call to retrieve multiple analysis templates
// within a collaboration by their identifiers.
type BatchGetCollaborationAnalysisTemplateError struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the call failed.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// An error that describes why a schema could not be fetched.
type BatchGetSchemaAnalysisRuleError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the call failed.
	//
	// This member is required.
	Message *string

	// An error name for the error.
	//
	// This member is required.
	Name *string

	// The analysis rule type.
	//
	// This member is required.
	Type AnalysisRuleType

	noSmithyDocumentSerde
}

// An error describing why a schema could not be fetched.
type BatchGetSchemaError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// An error message for the error.
	//
	// This member is required.
	Message *string

	// An error name for the error.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

//	Information related to the utilization of resources that have been billed or
//
// charged for in a given context, such as a protected job.
type BilledJobResourceUtilization struct {

	//  The number of Clean Rooms Processing Unit (CRPU) hours that have been billed.
	//
	// This member is required.
	Units *float64

	noSmithyDocumentSerde
}

//	Information related to the utilization of resources that have been billed or
//
// charged for in a given context, such as a protected query.
type BilledResourceUtilization struct {

	//  The number of Clean Rooms Processing Unit (CRPU) hours that have been billed.
	//
	// This member is required.
	Units *float64

	noSmithyDocumentSerde
}

// Individual budget parameter configuration that defines specific budget
// allocation settings for access budgets.
type BudgetParameter struct {

	// The budget allocation amount for this specific parameter.
	//
	// This member is required.
	Budget *int32

	// The type of budget parameter being configured.
	//
	// This member is required.
	Type AccessBudgetType

	// Whether this individual budget parameter automatically refreshes when the
	// budget period resets.
	AutoRefresh AutoRefreshMode

	noSmithyDocumentSerde
}

// Represents a single change within a collaboration change request, containing
// the change identifier and specification.
type Change struct {

	// The specification details for this change.
	//
	// This member is required.
	Specification ChangeSpecification

	// The type of specification for this change.
	//
	// This member is required.
	SpecificationType ChangeSpecificationType

	// The list of change types that were applied.
	//
	// This member is required.
	Types []ChangeType

	noSmithyDocumentSerde
}

// Specifies a change to apply to a collaboration.
type ChangeInput struct {

	// The specification details for the change. The structure depends on the
	// specification type.
	//
	// This member is required.
	Specification ChangeSpecification

	// The type of specification for the change. Currently supports MEMBER for
	// member-related changes.
	//
	// This member is required.
	SpecificationType ChangeSpecificationType

	noSmithyDocumentSerde
}

// A union that contains the specification details for different types of changes.
//
// The following types satisfy this interface:
//
//	ChangeSpecificationMemberMember
type ChangeSpecification interface {
	isChangeSpecification()
}

// The member change specification when the change type is MEMBER .
type ChangeSpecificationMemberMember struct {
	Value MemberChangeSpecification

	noSmithyDocumentSerde
}

func (*ChangeSpecificationMemberMember) isChangeSpecification() {}

// The multi-party data share environment. The collaboration contains metadata
// about its purpose and participants.
type Collaboration struct {

	// The unique ARN for the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// A display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The unique ID for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// An indicator as to whether query logging has been enabled or disabled for the
	// collaboration.
	//
	// When ENABLED , Clean Rooms logs details about queries run within this
	// collaboration and those logs can be viewed in Amazon CloudWatch Logs. The
	// default value is DISABLED .
	//
	// This member is required.
	QueryLogStatus CollaborationQueryLogStatus

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The Amazon Web Services Regions where collaboration query results can be
	// stored. Returns the list of Region identifiers that were specified when the
	// collaboration was created. This list is used to enforce regional storage
	// policies and compliance requirements.
	AllowedResultRegions []SupportedS3Region

	//  The analytics engine for the collaboration.
	//
	// After July 16, 2025, the CLEAN_ROOMS_SQL parameter will no longer be available.
	AnalyticsEngine AnalyticsEngine

	// The types of change requests that are automatically approved for this
	// collaboration.
	AutoApprovedChangeTypes []AutoApprovedChangeType

	// The settings for client-side encryption for cryptographic computing.
	DataEncryptionMetadata *DataEncryptionMetadata

	// A description of the collaboration provided by the collaboration owner.
	Description *string

	// An indicator as to whether job logging has been enabled or disabled for the
	// collaboration.
	//
	// When ENABLED , Clean Rooms logs details about jobs run within this collaboration
	// and those logs can be viewed in Amazon CloudWatch Logs. The default value is
	// DISABLED .
	JobLogStatus CollaborationJobLogStatus

	// The unique ARN for your membership within the collaboration.
	MembershipArn *string

	// The unique ID for your membership within the collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// The analysis template within a collaboration.
type CollaborationAnalysisTemplate struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the analysis template within a collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The format of the analysis template in the collaboration.
	//
	// This member is required.
	Format AnalysisFormat

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The entire schema object.
	//
	// This member is required.
	Schema *AnalysisSchema

	// The time that the analysis template in the collaboration was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis parameters that have been specified in the analysis template.
	AnalysisParameters []AnalysisParameter

	// The description of the analysis template.
	Description *string

	// The configuration that specifies the level of detail in error messages returned
	// by analyses using this template. When set to DETAILED , error messages include
	// more information to help troubleshoot issues with PySpark jobs. Detailed error
	// messages may expose underlying data, including sensitive information.
	// Recommended for faster troubleshooting in development and testing environments.
	ErrorMessageConfiguration *ErrorMessageConfiguration

	// The source of the analysis template within a collaboration.
	Source AnalysisSource

	//  The source metadata for the collaboration analysis template.
	SourceMetadata AnalysisSourceMetadata

	// The synthetic data generation parameters configured for this collaboration
	// analysis template.
	SyntheticDataParameters SyntheticDataParameters

	// The validations that were performed.
	Validations []AnalysisTemplateValidationStatusDetail

	noSmithyDocumentSerde
}

// The metadata of the analysis template within a collaboration.
type CollaborationAnalysisTemplateSummary struct {

	// The Amazon Resource Name (ARN) of the analysis template.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the analysis template’s associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the analysis templates belong
	// to. Currently accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time that the summary of the analysis template in a collaboration was
	// created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the analysis template.
	//
	// This member is required.
	Id *string

	// The name of the analysis template.
	//
	// This member is required.
	Name *string

	// The time that the summary of the analysis template in the collaboration was
	// last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the analysis template.
	Description *string

	// Indicates if this collaboration analysis template uses synthetic data
	// generation.
	IsSyntheticData *bool

	noSmithyDocumentSerde
}

// Represents a request to modify a collaboration. Change requests enable
// structured modifications to collaborations after they have been created.
type CollaborationChangeRequest struct {

	// The list of changes specified in this change request.
	//
	// This member is required.
	Changes []Change

	// The unique identifier for the collaboration being modified.
	//
	// This member is required.
	CollaborationId *string

	// The time when the change request was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier for the change request.
	//
	// This member is required.
	Id *string

	// Whether the change request was automatically approved based on the
	// collaboration's auto-approval settings.
	//
	// This member is required.
	IsAutoApproved *bool

	// The current status of the change request. Valid values are PENDING , APPROVED ,
	// DENIED , COMMITTED , and CANCELLED .
	//
	// This member is required.
	Status ChangeRequestStatus

	// The time when the change request was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Summary information about a collaboration change request.
type CollaborationChangeRequestSummary struct {

	// Summary of the changes in this change request.
	//
	// This member is required.
	Changes []Change

	// The unique identifier for the collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The time when the change request was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier for the change request.
	//
	// This member is required.
	Id *string

	// Whether the change request was automatically approved.
	//
	// This member is required.
	IsAutoApproved *bool

	// The current status of the change request.
	//
	// This member is required.
	Status ChangeRequestStatus

	// The time when the change request was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The configured audience model association within a collaboration.
type CollaborationConfiguredAudienceModelAssociation struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configure audience model.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Only supports
	// Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the configured audience model association in the collaboration.
type CollaborationConfiguredAudienceModelAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured audience model's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier for the collaboration that the configured audience model
	// associations belong to. Accepts collaboration ID.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Only supports
	// Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// Defines details for the collaboration ID namespace association.
type CollaborationIdNamespaceAssociation struct {

	// The Amazon Resource Name (ARN) of the collaboration ID namespace association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains the
	// collaboration ID namespace association.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains the collaboration ID
	// namespace association.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration ID namespace association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the Amazon Web Services account that created the
	// collaboration ID namespace association.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration ID namespace association.
	//
	// This member is required.
	Id *string

	// The input reference configuration that's necessary to create the collaboration
	// ID namespace association.
	//
	// This member is required.
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig

	// The input reference properties that are needed to create the collaboration ID
	// namespace association.
	//
	// This member is required.
	InputReferenceProperties *IdNamespaceAssociationInputReferenceProperties

	// The name of the collaboration ID namespace association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the collaboration ID namespace was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the collaboration ID namespace association.
	Description *string

	// The configuration settings for the ID mapping table.
	IdMappingConfig *IdMappingConfig

	noSmithyDocumentSerde
}

// Provides summary information about the collaboration ID namespace association.
type CollaborationIdNamespaceAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the collaboration ID namespace association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this
	// collaboration ID namespace association.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this collaboration ID
	// namespace association.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration ID namespace association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The Amazon Web Services account that created this collaboration ID namespace
	// association.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration ID namespace association.
	//
	// This member is required.
	Id *string

	// The input reference configuration that's used to create the collaboration ID
	// namespace association.
	//
	// This member is required.
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig

	// The input reference properties that are used to create the collaboration ID
	// namespace association.
	//
	// This member is required.
	InputReferenceProperties *IdNamespaceAssociationInputReferencePropertiesSummary

	// The name of the collaboration ID namespace association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the collaboration ID namespace association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the collaboration ID namepsace association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the collaboration privacy budgets. This summary includes the
// collaboration information, creation information, epsilon provided, and utility
// in terms of aggregations.
type CollaborationPrivacyBudgetSummary struct {

	// The includes epsilon provided and utility in terms of aggregations.
	//
	// This member is required.
	Budget PrivacyBudget

	// The ARN of the collaboration that includes this privacy budget.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that includes this privacy budget.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this privacy budget.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget.
	//
	// This member is required.
	Id *string

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateArn *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateId *string

	// The type of privacy budget template.
	//
	// This member is required.
	Type PrivacyBudgetType

	// The most recent time at which the privacy budget was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// An array that specifies the information for a collaboration's privacy budget
// template.
type CollaborationPrivacyBudgetTemplate struct {

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	Arn *string

	// How often the privacy budget refreshes.
	//
	// If you plan to regularly bring new data into the collaboration, use
	// CALENDAR_MONTH to automatically get a new privacy budget for the collaboration
	// every calendar month. Choosing this option allows arbitrary amounts of
	// information to be revealed about rows of the data when repeatedly queried across
	// refreshes. Avoid choosing this if the same rows will be repeatedly queried
	// between privacy budget refreshes.
	//
	// This member is required.
	AutoRefresh PrivacyBudgetTemplateAutoRefresh

	// The ARN of the collaboration that includes this collaboration privacy budget
	// template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that includes this collaboration
	// privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	Id *string

	// Specifies the epsilon and noise parameters for the privacy budget template.
	//
	// This member is required.
	Parameters PrivacyBudgetTemplateParametersOutput

	// The type of privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// A summary of the collaboration's privacy budget template. This summary includes
// information about who created the privacy budget template and what
// collaborations it belongs to.
type CollaborationPrivacyBudgetTemplateSummary struct {

	// The ARN of the collaboration privacy budget template.
	//
	// This member is required.
	Arn *string

	// The ARN of the collaboration that contains this collaboration privacy budget
	// template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this collaboration
	// privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the collaboration privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the account that created this collaboration privacy
	// budget template.
	//
	// This member is required.
	CreatorAccountId *string

	// The unique identifier of the collaboration privacy budget template.
	//
	// This member is required.
	Id *string

	// The type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the collaboration privacy budget template was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The metadata of the collaboration.
type CollaborationSummary struct {

	// The ARN of the collaboration.
	//
	// This member is required.
	Arn *string

	// The time when the collaboration was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CreatorDisplayName *string

	// The identifier for the collaboration.
	//
	// This member is required.
	Id *string

	// The status of a member in a collaboration.
	//
	// This member is required.
	MemberStatus MemberStatus

	// A human-readable identifier provided by the collaboration owner. Display names
	// are not unique.
	//
	// This member is required.
	Name *string

	// The time the collaboration metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	//  The analytics engine.
	//
	// After July 16, 2025, the CLEAN_ROOMS_SQL parameter will no longer be available.
	AnalyticsEngine AnalyticsEngine

	// The ARN of a member in a collaboration.
	MembershipArn *string

	// The identifier of a member in a collaboration.
	MembershipId *string

	noSmithyDocumentSerde
}

// A column within a schema relation, derived from the underlying table.
type Column struct {

	// The name of the column.
	//
	// This member is required.
	Name *string

	// The type of the column.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// Contains classification information for data columns, including mappings that
// specify how columns should be handled during synthetic data generation and
// privacy analysis.
type ColumnClassificationDetails struct {

	// A mapping that defines the classification of data columns for synthetic data
	// generation and specifies how each column should be handled during the
	// privacy-preserving data synthesis process.
	//
	// This member is required.
	ColumnMapping []SyntheticDataColumnProperties

	noSmithyDocumentSerde
}

//	The configuration of the compute resources for an analysis with the Spark
//
// analytics engine.
//
// The following types satisfy this interface:
//
//	ComputeConfigurationMemberWorker
type ComputeConfiguration interface {
	isComputeConfiguration()
}

// The worker configuration for the compute environment.
type ComputeConfigurationMemberWorker struct {
	Value WorkerComputeConfiguration

	noSmithyDocumentSerde
}

func (*ComputeConfigurationMemberWorker) isComputeConfiguration() {}

//	The configuration details.
//
// The following types satisfy this interface:
//
//	ConfigurationDetailsMemberDirectAnalysisConfigurationDetails
type ConfigurationDetails interface {
	isConfigurationDetails()
}

// The direct analysis configuration details.
type ConfigurationDetailsMemberDirectAnalysisConfigurationDetails struct {
	Value DirectAnalysisConfigurationDetails

	noSmithyDocumentSerde
}

func (*ConfigurationDetailsMemberDirectAnalysisConfigurationDetails) isConfigurationDetails() {}

// Details about the configured audience model association.
type ConfiguredAudienceModelAssociation struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this
	// configured audience model association.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier of the collaboration that contains this configured audience
	// model association.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configured audience model that was used
	// for this configured audience model association.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// A unique identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// When TRUE , indicates that the resource policy for the configured audience model
	// resource being associated is configured for Clean Rooms to manage permissions
	// related to the given collaboration. When FALSE , indicates that the configured
	// audience model resource owner will manage permissions related to the given
	// collaboration.
	//
	// This member is required.
	ManageResourcePolicies *bool

	// The Amazon Resource Name (ARN) of the membership that contains this configured
	// audience model association.
	//
	// This member is required.
	MembershipArn *string

	// A unique identifier for the membership that contains this configured audience
	// model association.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A summary of the configured audience model association.
type ConfiguredAudienceModelAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the configured audience model association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains the
	// configured audience model association.
	//
	// This member is required.
	CollaborationArn *string

	// A unique identifier of the collaboration that configured audience model is
	// associated with.
	//
	// This member is required.
	CollaborationId *string

	// The Amazon Resource Name (ARN) of the configured audience model that was used
	// for this configured audience model association.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the configured audience model association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// A unique identifier of the configured audience model association.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the membership that contains the configured
	// audience model association.
	//
	// This member is required.
	MembershipArn *string

	// A unique identifier of the membership that contains the configured audience
	// model association.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured audience model association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the configured audience model association was
	// updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the configured audience model association.
	Description *string

	noSmithyDocumentSerde
}

// A table that has been configured for use in a collaboration.
type ConfiguredTable struct {

	// The columns within the underlying Glue table that can be used within
	// collaborations.
	//
	// This member is required.
	AllowedColumns []string

	// The analysis method for the configured table.
	//
	// DIRECT_QUERY allows SQL queries to be run directly on this table.
	//
	// DIRECT_JOB allows PySpark jobs to be run directly on this table.
	//
	// MULTIPLE allows both SQL queries and PySpark jobs to be run directly on this
	// table.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table. Currently,
	// only one analysis rule may be associated with a configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN for the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table.
	//
	// This member is required.
	Id *string

	// A name for the configured table.
	//
	// This member is required.
	Name *string

	// The table that this configured table represents.
	//
	// This member is required.
	TableReference TableReference

	// The time the configured table was last updated
	//
	// This member is required.
	UpdateTime *time.Time

	// A description for the configured table.
	Description *string

	//  The selected analysis methods for the configured table.
	SelectedAnalysisMethods []SelectedAnalysisMethod

	noSmithyDocumentSerde
}

// A configured table analysis rule, which limits how data for this table can be
// used.
type ConfiguredTableAnalysisRule struct {

	// The unique ARN for the configured table.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table analysis rule was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The policy that controls SQL query rules.
	//
	// This member is required.
	Policy ConfiguredTableAnalysisRulePolicy

	// The type of configured table analysis rule.
	//
	// This member is required.
	Type ConfiguredTableAnalysisRuleType

	// The time the configured table analysis rule was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyMemberV1
type ConfiguredTableAnalysisRulePolicy interface {
	isConfiguredTableAnalysisRulePolicy()
}

// Controls on the query specifications that can be run on a configured table.
type ConfiguredTableAnalysisRulePolicyMemberV1 struct {
	Value ConfiguredTableAnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyMemberV1) isConfiguredTableAnalysisRulePolicy() {}

// Controls on the query specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAnalysisRulePolicyV1MemberAggregation
//	ConfiguredTableAnalysisRulePolicyV1MemberCustom
//	ConfiguredTableAnalysisRulePolicyV1MemberList
type ConfiguredTableAnalysisRulePolicyV1 interface {
	isConfiguredTableAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberAggregation struct {
	Value AnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberAggregation) isConfiguredTableAnalysisRulePolicyV1() {
}

// A type of analysis rule that enables the table owner to approve custom SQL
// queries on their configured tables. It supports differential privacy.
type ConfiguredTableAnalysisRulePolicyV1MemberCustom struct {
	Value AnalysisRuleCustom

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberCustom) isConfiguredTableAnalysisRulePolicyV1() {}

// Analysis rule type that enables only list queries on a configured table.
type ConfiguredTableAnalysisRulePolicyV1MemberList struct {
	Value AnalysisRuleList

	noSmithyDocumentSerde
}

func (*ConfiguredTableAnalysisRulePolicyV1MemberList) isConfiguredTableAnalysisRulePolicyV1() {}

// A configured table association links a configured table to a collaboration.
type ConfiguredTableAssociation struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableArn *string

	// The unique ID for the configured table that the association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership this configured table association belongs to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association, in lowercase. The table is
	// identified by this name when running protected queries against the underlying
	// data.
	//
	// This member is required.
	Name *string

	// The service will assume this role to access catalog metadata and query the
	// table.
	//
	// This member is required.
	RoleArn *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	//  The analysis rule types for the configured table association.
	AnalysisRuleTypes []ConfiguredTableAssociationAnalysisRuleType

	// A description of the configured table association.
	Description *string

	noSmithyDocumentSerde
}

// An analysis rule for a configured table association. This analysis rule
// specifies how data from the table can be used within its associated
// collaboration. In the console, the ConfiguredTableAssociationAnalysisRule is
// referred to as the collaboration analysis rule.
type ConfiguredTableAssociationAnalysisRule struct {

	//  The Amazon Resource Name (ARN) of the configured table association.
	//
	// This member is required.
	ConfiguredTableAssociationArn *string

	//  The unique identifier for the configured table association.
	//
	// This member is required.
	ConfiguredTableAssociationId *string

	//  The creation time of the configured table association analysis rule.
	//
	// This member is required.
	CreateTime *time.Time

	//  The membership identifier for the configured table association analysis rule.
	//
	// This member is required.
	MembershipIdentifier *string

	//  The policy of the configured table association analysis rule.
	//
	// This member is required.
	Policy ConfiguredTableAssociationAnalysisRulePolicy

	//  The type of the configured table association analysis rule.
	//
	// This member is required.
	Type ConfiguredTableAssociationAnalysisRuleType

	//  The update time of the configured table association analysis rule.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

//	The configured table association analysis rule applied to a configured table
//
// with the aggregation analysis rule.
type ConfiguredTableAssociationAnalysisRuleAggregation struct {

	//  The list of resources or wildcards (ARNs) that are allowed to perform
	// additional analysis on query output.
	//
	// The allowedAdditionalAnalyses parameter is currently supported for the list
	// analysis rule ( AnalysisRuleList ) and the custom analysis rule (
	// AnalysisRuleCustom ).
	AllowedAdditionalAnalyses []string

	//  The list of collaboration members who are allowed to receive results of
	// queries run with this configured table.
	AllowedResultReceivers []string

	noSmithyDocumentSerde
}

//	The configured table association analysis rule applied to a configured table
//
// with the custom analysis rule.
type ConfiguredTableAssociationAnalysisRuleCustom struct {

	//  The list of resources or wildcards (ARNs) that are allowed to perform
	// additional analysis on query output.
	AllowedAdditionalAnalyses []string

	//  The list of collaboration members who are allowed to receive results of
	// queries run with this configured table.
	AllowedResultReceivers []string

	noSmithyDocumentSerde
}

//	The configured table association analysis rule applied to a configured table
//
// with the list analysis rule.
type ConfiguredTableAssociationAnalysisRuleList struct {

	//  The list of resources or wildcards (ARNs) that are allowed to perform
	// additional analysis on query output.
	AllowedAdditionalAnalyses []string

	//  The list of collaboration members who are allowed to receive results of
	// queries run with this configured table.
	AllowedResultReceivers []string

	noSmithyDocumentSerde
}

//	Controls on the query specifications that can be run on an associated
//
// configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAssociationAnalysisRulePolicyMemberV1
type ConfiguredTableAssociationAnalysisRulePolicy interface {
	isConfiguredTableAssociationAnalysisRulePolicy()
}

// The policy for the configured table association analysis rule.
type ConfiguredTableAssociationAnalysisRulePolicyMemberV1 struct {
	Value ConfiguredTableAssociationAnalysisRulePolicyV1

	noSmithyDocumentSerde
}

func (*ConfiguredTableAssociationAnalysisRulePolicyMemberV1) isConfiguredTableAssociationAnalysisRulePolicy() {
}

//	Controls on the query specifications that can be run on an associated
//
// configured table.
//
// The following types satisfy this interface:
//
//	ConfiguredTableAssociationAnalysisRulePolicyV1MemberAggregation
//	ConfiguredTableAssociationAnalysisRulePolicyV1MemberCustom
//	ConfiguredTableAssociationAnalysisRulePolicyV1MemberList
type ConfiguredTableAssociationAnalysisRulePolicyV1 interface {
	isConfiguredTableAssociationAnalysisRulePolicyV1()
}

// Analysis rule type that enables only aggregation queries on a configured table.
type ConfiguredTableAssociationAnalysisRulePolicyV1MemberAggregation struct {
	Value ConfiguredTableAssociationAnalysisRuleAggregation

	noSmithyDocumentSerde
}

func (*ConfiguredTableAssociationAnalysisRulePolicyV1MemberAggregation) isConfiguredTableAssociationAnalysisRulePolicyV1() {
}

//	Analysis rule type that enables the table owner to approve custom SQL queries
//
// on their configured tables. It supports differential privacy.
type ConfiguredTableAssociationAnalysisRulePolicyV1MemberCustom struct {
	Value ConfiguredTableAssociationAnalysisRuleCustom

	noSmithyDocumentSerde
}

func (*ConfiguredTableAssociationAnalysisRulePolicyV1MemberCustom) isConfiguredTableAssociationAnalysisRulePolicyV1() {
}

// Analysis rule type that enables only list queries on a configured table.
type ConfiguredTableAssociationAnalysisRulePolicyV1MemberList struct {
	Value ConfiguredTableAssociationAnalysisRuleList

	noSmithyDocumentSerde
}

func (*ConfiguredTableAssociationAnalysisRulePolicyV1MemberList) isConfiguredTableAssociationAnalysisRulePolicyV1() {
}

// The configured table association summary for the objects listed by the request.
type ConfiguredTableAssociationSummary struct {

	// The unique ARN for the configured table association.
	//
	// This member is required.
	Arn *string

	// The unique configured table ID that this configured table association refers to.
	//
	// This member is required.
	ConfiguredTableId *string

	// The time the configured table association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the configured table association.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that the configured table association belongs
	// to.
	//
	// This member is required.
	MembershipId *string

	// The name of the configured table association. The table is identified by this
	// name when running Protected Queries against the underlying data.
	//
	// This member is required.
	Name *string

	// The time the configured table association was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis rule types that are associated with the configured table
	// associations in this summary.
	AnalysisRuleTypes []ConfiguredTableAssociationAnalysisRuleType

	noSmithyDocumentSerde
}

// The configured table summary for the objects listed by the request.
type ConfiguredTableSummary struct {

	// The analysis method for the configured tables.
	//
	// DIRECT_QUERY allows SQL queries to be run directly on this table.
	//
	// DIRECT_JOB allows PySpark jobs to be run directly on this table.
	//
	// MULTIPLE allows both SQL queries and PySpark jobs to be run directly on this
	// table.
	//
	// This member is required.
	AnalysisMethod AnalysisMethod

	// The types of analysis rules associated with this configured table.
	//
	// This member is required.
	AnalysisRuleTypes []ConfiguredTableAnalysisRuleType

	// The unique ARN of the configured table.
	//
	// This member is required.
	Arn *string

	// The time the configured table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the configured table.
	//
	// This member is required.
	Id *string

	// The name of the configured table.
	//
	// This member is required.
	Name *string

	// The time the configured table was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	//  The selected analysis methods for the configured table summary.
	SelectedAnalysisMethods []SelectedAnalysisMethod

	noSmithyDocumentSerde
}

// Controls on the analysis specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConsolidatedPolicyMemberV1
type ConsolidatedPolicy interface {
	isConsolidatedPolicy()
}

// The consolidated policy version 1.
type ConsolidatedPolicyMemberV1 struct {
	Value ConsolidatedPolicyV1

	noSmithyDocumentSerde
}

func (*ConsolidatedPolicyMemberV1) isConsolidatedPolicy() {}

// Controls on the analysis specifications that can be run on a configured table.
type ConsolidatedPolicyAggregation struct {

	//  Aggregate columns in consolidated policy aggregation.
	//
	// This member is required.
	AggregateColumns []AggregateColumn

	//  The dimension columns of the consolidated policy aggregation.
	//
	// This member is required.
	DimensionColumns []string

	//  The columns to join on.
	//
	// This member is required.
	JoinColumns []string

	//  The output constraints of the consolidated policy aggregation.
	//
	// This member is required.
	OutputConstraints []AggregationConstraint

	//  The scalar functions.
	//
	// This member is required.
	ScalarFunctions []ScalarFunctions

	//  Additional analyses for the consolidated policy aggregation.
	AdditionalAnalyses AdditionalAnalyses

	//  The additional analyses allowed by the consolidated policy aggregation.
	AllowedAdditionalAnalyses []string

	//  The allowed join operators.
	AllowedJoinOperators []JoinOperator

	//  The allowed result receivers.
	AllowedResultReceivers []string

	//  Join required
	JoinRequired JoinRequiredOption

	noSmithyDocumentSerde
}

// Controls on the analysis specifications that can be run on a configured table.
type ConsolidatedPolicyCustom struct {

	//  The allowed analyses.
	//
	// This member is required.
	AllowedAnalyses []string

	//  Additional analyses for the consolidated policy.
	AdditionalAnalyses AdditionalAnalyses

	//  The additional analyses allowed by the consolidated policy.
	AllowedAdditionalAnalyses []string

	//  The allowed analysis providers.
	AllowedAnalysisProviders []string

	//  The allowed result receivers.
	AllowedResultReceivers []string

	// Specifies the unique identifier for your users.
	DifferentialPrivacy *DifferentialPrivacyConfiguration

	//  Disallowed output columns
	DisallowedOutputColumns []string

	noSmithyDocumentSerde
}

// Controls on the analysis specifications that can be run on a configured table.
type ConsolidatedPolicyList struct {

	//  The columns to join on.
	//
	// This member is required.
	JoinColumns []string

	//  The columns in the consolidated policy list.
	//
	// This member is required.
	ListColumns []string

	//  Additional analyses for the consolidated policy list.
	AdditionalAnalyses AdditionalAnalyses

	//  The additional analyses allowed by the consolidated policy list.
	AllowedAdditionalAnalyses []string

	//  The allowed join operators in the consolidated policy list.
	AllowedJoinOperators []JoinOperator

	//  The allowed result receivers.
	AllowedResultReceivers []string

	noSmithyDocumentSerde
}

// Controls on the analysis specifications that can be run on a configured table.
//
// The following types satisfy this interface:
//
//	ConsolidatedPolicyV1MemberAggregation
//	ConsolidatedPolicyV1MemberCustom
//	ConsolidatedPolicyV1MemberList
type ConsolidatedPolicyV1 interface {
	isConsolidatedPolicyV1()
}

// The aggregation setting for the consolidated policy.
type ConsolidatedPolicyV1MemberAggregation struct {
	Value ConsolidatedPolicyAggregation

	noSmithyDocumentSerde
}

func (*ConsolidatedPolicyV1MemberAggregation) isConsolidatedPolicyV1() {}

// Custom policy
type ConsolidatedPolicyV1MemberCustom struct {
	Value ConsolidatedPolicyCustom

	noSmithyDocumentSerde
}

func (*ConsolidatedPolicyV1MemberCustom) isConsolidatedPolicyV1() {}

// The list of consolidated policies.
type ConsolidatedPolicyV1MemberList struct {
	Value ConsolidatedPolicyList

	noSmithyDocumentSerde
}

func (*ConsolidatedPolicyV1MemberList) isConsolidatedPolicyV1() {}

// The settings for client-side encryption for cryptographic computing.
type DataEncryptionMetadata struct {

	// Indicates whether encrypted tables can contain cleartext data ( TRUE ) or are to
	// cryptographically process every column ( FALSE ).
	//
	// This member is required.
	AllowCleartext *bool

	// Indicates whether Fingerprint columns can contain duplicate entries ( TRUE ) or
	// are to contain only non-repeated values ( FALSE ).
	//
	// This member is required.
	AllowDuplicates *bool

	// Indicates whether Fingerprint columns can be joined on any other Fingerprint
	// column with a different name ( TRUE ) or can only be joined on Fingerprint
	// columns of the same name ( FALSE ).
	//
	// This member is required.
	AllowJoinsOnColumnsWithDifferentNames *bool

	// Indicates whether NULL values are to be copied as NULL to encrypted tables ( TRUE
	// ) or cryptographically processed ( FALSE ).
	//
	// This member is required.
	PreserveNulls *bool

	noSmithyDocumentSerde
}

// Specifies the name of the column that contains the unique identifier of your
// users, whose privacy you want to protect.
type DifferentialPrivacyColumn struct {

	// The name of the column, such as user_id, that contains the unique identifier of
	// your users, whose privacy you want to protect. If you want to turn on
	// differential privacy for two or more tables in a collaboration, you must
	// configure the same column as the user identifier column in both analysis rules.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Specifies the unique identifier for your users.
type DifferentialPrivacyConfiguration struct {

	// The name of the column (such as user_id) that contains the unique identifier of
	// your users whose privacy you want to protect. If you want to turn on diﬀerential
	// privacy for two or more tables in a collaboration, you must conﬁgure the same
	// column as the user identiﬁer column in both analysis rules.
	//
	// This member is required.
	Columns []DifferentialPrivacyColumn

	noSmithyDocumentSerde
}

// An array that contains the sensitivity parameters.
type DifferentialPrivacyParameters struct {

	// Provides the sensitivity parameters that you can use to better understand the
	// total amount of noise in query results.
	//
	// This member is required.
	SensitivityParameters []DifferentialPrivacySensitivityParameters

	noSmithyDocumentSerde
}

// Provides an estimate of the number of aggregation functions that the member who
// can query can run given the epsilon and noise parameters.
type DifferentialPrivacyPreviewAggregation struct {

	// The maximum number of aggregations that the member who can query can run given
	// the epsilon and noise parameters.
	//
	// This member is required.
	MaxCount *int32

	// The type of aggregation function.
	//
	// This member is required.
	Type DifferentialPrivacyAggregationType

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to preview.
type DifferentialPrivacyPreviewParametersInput struct {

	// The epsilon value that you want to preview.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// Specifies the configured epsilon value and the utility in terms of total
// aggregations, as well as the remaining aggregations available.
type DifferentialPrivacyPrivacyBudget struct {

	// This information includes the configured epsilon value and the utility in terms
	// of total aggregations, as well as the remaining aggregations.
	//
	// This member is required.
	Aggregations []DifferentialPrivacyPrivacyBudgetAggregation

	// The epsilon value that you configured.
	//
	// This member is required.
	Epsilon *int32

	noSmithyDocumentSerde
}

// Information about the total number of aggregations, as well as the remaining
// aggregations.
type DifferentialPrivacyPrivacyBudgetAggregation struct {

	// The maximum number of aggregation functions that you can perform with the given
	// privacy budget.
	//
	// This member is required.
	MaxCount *int32

	// The remaining number of aggregation functions that can be run with the
	// available privacy budget.
	//
	// This member is required.
	RemainingCount *int32

	// The different types of aggregation functions that you can perform.
	//
	// This member is required.
	Type DifferentialPrivacyAggregationType

	noSmithyDocumentSerde
}

// Information about the number of aggregation functions that the member who can
// query can run given the epsilon and noise parameters.
type DifferentialPrivacyPrivacyImpact struct {

	// The number of aggregation functions that you can perform.
	//
	// This member is required.
	Aggregations []DifferentialPrivacyPreviewAggregation

	noSmithyDocumentSerde
}

// Provides the sensitivity parameters.
type DifferentialPrivacySensitivityParameters struct {

	// The aggregation expression that was run.
	//
	// This member is required.
	AggregationExpression *string

	// The type of aggregation function that was run.
	//
	// This member is required.
	AggregationType DifferentialPrivacyAggregationType

	// The maximum number of rows contributed by a user in a SQL query.
	//
	// This member is required.
	UserContributionLimit *int32

	// The upper bound of the aggregation expression.
	MaxColumnValue *float32

	// The lower bound of the aggregation expression.
	MinColumnValue *float32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that you want to use for the
// differential privacy template.
type DifferentialPrivacyTemplateParametersInput struct {

	// The epsilon value that you want to use.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that were used for the differential
// privacy template.
type DifferentialPrivacyTemplateParametersOutput struct {

	// The epsilon value that you specified.
	//
	// This member is required.
	Epsilon *int32

	// Noise added per query is measured in terms of the number of users whose
	// contributions you want to obscure. This value governs the rate at which the
	// privacy budget is depleted.
	//
	// This member is required.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// The epsilon and noise parameter values that you want to update in the
// differential privacy template.
type DifferentialPrivacyTemplateUpdateParameters struct {

	// The updated epsilon value that you want to use.
	Epsilon *int32

	// The updated value of noise added per query. It is measured in terms of the
	// number of users whose contributions you want to obscure. This value governs the
	// rate at which the privacy budget is depleted.
	UsersNoisePerQuery *int32

	noSmithyDocumentSerde
}

// The direct analysis configuration details.
type DirectAnalysisConfigurationDetails struct {

	//  The account IDs for the member who received the results of a protected query.
	ReceiverAccountIds []string

	noSmithyDocumentSerde
}

// A structure that defines the level of detail included in error messages
// returned by PySpark jobs. This configuration allows you to control the verbosity
// of error messages to help with troubleshooting PySpark jobs while maintaining
// appropriate security controls.
type ErrorMessageConfiguration struct {

	// The level of detail for error messages returned by the PySpark job. When set to
	// DETAILED, error messages include more information to help troubleshoot issues
	// with your PySpark job.
	//
	// Because this setting may expose sensitive data, it is recommended for
	// development and testing environments.
	//
	// This member is required.
	Type ErrorMessageType

	noSmithyDocumentSerde
}

// A reference to a table within an Glue data catalog.
type GlueTableReference struct {

	// The name of the database the Glue table belongs to.
	//
	// This member is required.
	DatabaseName *string

	// The name of the Glue table.
	//
	// This member is required.
	TableName *string

	// The Amazon Web Services Region where the Glue table is located. This parameter
	// is required to uniquely identify and access tables across different Regions.
	Region CommercialRegion

	noSmithyDocumentSerde
}

// Hash
type Hash struct {

	//  The SHA-256 hash value.
	Sha256 *string

	noSmithyDocumentSerde
}

// The configuration settings for the ID mapping table.
type IdMappingConfig struct {

	// An indicator as to whether you can use your column as a dimension column in the
	// ID mapping table ( TRUE ) or not ( FALSE ).
	//
	// Default is FALSE .
	//
	// This member is required.
	AllowUseAsDimensionColumn bool

	noSmithyDocumentSerde
}

// Describes information about the ID mapping table.
type IdMappingTable struct {

	// The Amazon Resource Name (ARN) of the ID mapping table.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// mapping table.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this ID mapping table.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the ID mapping table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the ID mapping table.
	//
	// This member is required.
	Id *string

	// The input reference configuration for the ID mapping table.
	//
	// This member is required.
	InputReferenceConfig *IdMappingTableInputReferenceConfig

	// The input reference properties for the ID mapping table.
	//
	// This member is required.
	InputReferenceProperties *IdMappingTableInputReferenceProperties

	// The Amazon Resource Name (ARN) of the membership resource for the ID mapping
	// table.
	//
	// This member is required.
	MembershipArn *string

	// The unique identifier of the membership resource for the ID mapping table.
	//
	// This member is required.
	MembershipId *string

	// The name of the ID mapping table.
	//
	// This member is required.
	Name *string

	// The most recent time at which the ID mapping table was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the ID mapping table.
	Description *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services KMS key.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Provides the input reference configuration for the ID mapping table.
type IdMappingTableInputReferenceConfig struct {

	// The Amazon Resource Name (ARN) of the referenced resource in Entity Resolution.
	// Valid values are ID mapping workflow ARNs.
	//
	// This member is required.
	InputReferenceArn *string

	// When TRUE , Clean Rooms manages permissions for the ID mapping table resource.
	//
	// When FALSE , the resource owner manages permissions for the ID mapping table
	// resource.
	//
	// This member is required.
	ManageResourcePolicies *bool

	noSmithyDocumentSerde
}

// The input reference properties for the ID mapping table.
type IdMappingTableInputReferenceProperties struct {

	// The input source of the ID mapping table.
	//
	// This member is required.
	IdMappingTableInputSource []IdMappingTableInputSource

	noSmithyDocumentSerde
}

// The input source of the ID mapping table.
type IdMappingTableInputSource struct {

	// The unique identifier of the ID namespace association.
	//
	// This member is required.
	IdNamespaceAssociationId *string

	// The type of the input source of the ID mapping table.
	//
	// This member is required.
	Type IdNamespaceType

	noSmithyDocumentSerde
}

// Additional properties that are specific to the type of the associated schema.
type IdMappingTableSchemaTypeProperties struct {

	// Defines which ID namespace associations are used to create the ID mapping table.
	//
	// This member is required.
	IdMappingTableInputSource []IdMappingTableInputSource

	noSmithyDocumentSerde
}

// Detailed information about the ID mapping table.
type IdMappingTableSummary struct {

	// The Amazon Resource Name (ARN) of this ID mapping table.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// mapping table.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this ID mapping table.
	//
	// This member is required.
	CollaborationId *string

	// The time at which this ID mapping table was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of this ID mapping table.
	//
	// This member is required.
	Id *string

	// The input reference configuration for the ID mapping table.
	//
	// This member is required.
	InputReferenceConfig *IdMappingTableInputReferenceConfig

	// The Amazon Resource Name (ARN) of the membership resource for this ID mapping
	// table.
	//
	// This member is required.
	MembershipArn *string

	// The unique identifier of the membership resource for this ID mapping table.
	//
	// This member is required.
	MembershipId *string

	// The name of this ID mapping table.
	//
	// This member is required.
	Name *string

	// The most recent time at which this ID mapping table was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of this ID mapping table.
	Description *string

	noSmithyDocumentSerde
}

// Provides information to create the ID namespace association.
type IdNamespaceAssociation struct {

	// The Amazon Resource Name (ARN) of the ID namespace association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// namespace association.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this ID namespace
	// association.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the ID namespace association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier for this ID namespace association.
	//
	// This member is required.
	Id *string

	// The input reference configuration for the ID namespace association.
	//
	// This member is required.
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig

	// The input reference properties for the ID namespace association.
	//
	// This member is required.
	InputReferenceProperties *IdNamespaceAssociationInputReferenceProperties

	// The Amazon Resource Name (ARN) of the membership resource for this ID namespace
	// association.
	//
	// This member is required.
	MembershipArn *string

	// The unique identifier of the membership resource for this ID namespace
	// association.
	//
	// This member is required.
	MembershipId *string

	// The name of this ID namespace association.
	//
	// This member is required.
	Name *string

	// The most recent time at which the ID namespace association was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the ID namespace association.
	Description *string

	// The configuration settings for the ID mapping table.
	IdMappingConfig *IdMappingConfig

	noSmithyDocumentSerde
}

// Provides the information for the ID namespace association input reference
// configuration.
type IdNamespaceAssociationInputReferenceConfig struct {

	// The Amazon Resource Name (ARN) of the Entity Resolution resource that is being
	// associated to the collaboration. Valid resource ARNs are from the ID namespaces
	// that you own.
	//
	// This member is required.
	InputReferenceArn *string

	// When TRUE , Clean Rooms manages permissions for the ID namespace association
	// resource.
	//
	// When FALSE , the resource owner manages permissions for the ID namespace
	// association resource.
	//
	// This member is required.
	ManageResourcePolicies *bool

	noSmithyDocumentSerde
}

// Provides the information for the ID namespace association input reference
// properties.
type IdNamespaceAssociationInputReferenceProperties struct {

	// Defines how ID mapping workflows are supported for this ID namespace
	// association.
	//
	// This member is required.
	IdMappingWorkflowsSupported []document.Interface

	// The ID namespace type for this ID namespace association.
	//
	// This member is required.
	IdNamespaceType IdNamespaceType

	noSmithyDocumentSerde
}

// Detailed information about the ID namespace association input reference
// properties.
type IdNamespaceAssociationInputReferencePropertiesSummary struct {

	// The ID namespace type for this ID namespace association.
	//
	// This member is required.
	IdNamespaceType IdNamespaceType

	noSmithyDocumentSerde
}

// Detailed information about the ID namespace association.
type IdNamespaceAssociationSummary struct {

	// The Amazon Resource Name (ARN) of this ID namespace association.
	//
	// This member is required.
	Arn *string

	// The Amazon Resource Name (ARN) of the collaboration that contains this ID
	// namespace association.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this ID namespace
	// association.
	//
	// This member is required.
	CollaborationId *string

	// The time at which this ID namespace association was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of this ID namespace association.
	//
	// This member is required.
	Id *string

	// The input reference configuration details for this ID namespace association.
	//
	// This member is required.
	InputReferenceConfig *IdNamespaceAssociationInputReferenceConfig

	// The input reference properties for this ID namespace association.
	//
	// This member is required.
	InputReferenceProperties *IdNamespaceAssociationInputReferencePropertiesSummary

	// The Amazon Resource Name (ARN) of the membership resource for this ID namespace
	// association.
	//
	// This member is required.
	MembershipArn *string

	// The unique identifier of the membership resource for this ID namespace
	// association.
	//
	// This member is required.
	MembershipId *string

	// The name of the ID namespace association.
	//
	// This member is required.
	Name *string

	// The most recent time at which this ID namespace association has been updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The description of the ID namespace association.
	Description *string

	noSmithyDocumentSerde
}

// An object representing the collaboration member's payment responsibilities set
// by the collaboration creator for query and job compute costs.
type JobComputePaymentConfig struct {

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for query and job compute costs ( TRUE ) or has not configured the
	// collaboration member to pay for query and job compute costs ( FALSE ).
	//
	// Exactly one member can be configured to pay for query and job compute costs. An
	// error is returned if the collaboration creator sets a TRUE value for more than
	// one member in the collaboration.
	//
	// An error is returned if the collaboration creator sets a FALSE value for the
	// member who can run queries and jobs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// Specifies changes to collaboration membership, including adding new members
// with their abilities and display names.
type MemberChangeSpecification struct {

	// The Amazon Web Services account ID of the member to add to the collaboration.
	//
	// This member is required.
	AccountId *string

	// The abilities granted to the collaboration member. These determine what actions
	// the member can perform within the collaboration.
	//
	// The following values are currently not supported: CAN_QUERY ,
	// CAN_RECEIVE_RESULTS, and CAN_RUN_JOB .
	//
	// Set the value of memberAbilities to [] to allow a member to contribute data.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// Specifies the display name that will be shown for this member in the
	// collaboration. While this field is required when inviting new members, it
	// becomes optional when modifying abilities of existing collaboration members.
	DisplayName *string

	noSmithyDocumentSerde
}

// The membership object.
type Membership struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name of the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the membership.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The payment responsibilities accepted by the collaboration member.
	//
	// This member is required.
	PaymentConfiguration *MembershipPaymentConfiguration

	// An indicator as to whether query logging has been enabled or disabled for the
	// membership.
	//
	// When ENABLED , Clean Rooms logs details about queries run within this
	// collaboration and those logs can be viewed in Amazon CloudWatch Logs. The
	// default value is DISABLED .
	//
	// This member is required.
	QueryLogStatus MembershipQueryLogStatus

	// The status of the membership.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	//  The default job result configuration for the membership.
	DefaultJobResultConfiguration *MembershipProtectedJobResultConfiguration

	// The default protected query result configuration as specified by the member who
	// can receive results.
	DefaultResultConfiguration *MembershipProtectedQueryResultConfiguration

	// An indicator as to whether job logging has been enabled or disabled for the
	// collaboration.
	//
	// When ENABLED , Clean Rooms logs details about jobs run within this collaboration
	// and those logs can be viewed in Amazon CloudWatch Logs. The default value is
	// DISABLED .
	JobLogStatus MembershipJobLogStatus

	// Specifies the ML member abilities that are granted to a collaboration member.
	MlMemberAbilities *MLMemberAbilities

	noSmithyDocumentSerde
}

// An object representing the payment responsibilities accepted by the
// collaboration member for query and job compute costs.
type MembershipJobComputePaymentConfig struct {

	// Indicates whether the collaboration member has accepted to pay for job compute
	// costs ( TRUE ) or has not accepted to pay for query and job compute costs ( FALSE
	// ).
	//
	// There is only one member who pays for queries and jobs.
	//
	// An error message is returned for the following reasons:
	//
	//   - If you set the value to FALSE but you are responsible to pay for query and
	//   job compute costs.
	//
	//   - If you set the value to TRUE but you are not responsible to pay for query
	//   and job compute costs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// An object representing the collaboration member's machine learning payment
// responsibilities set by the collaboration creator.
type MembershipMLPaymentConfig struct {

	// The payment responsibilities accepted by the member for model inference.
	ModelInference *MembershipModelInferencePaymentConfig

	// The payment responsibilities accepted by the member for model training.
	ModelTraining *MembershipModelTrainingPaymentConfig

	// The payment configuration for synthetic data generation for this machine
	// learning membership.
	SyntheticDataGeneration *MembershipSyntheticDataGenerationPaymentConfig

	noSmithyDocumentSerde
}

// An object representing the collaboration member's model inference payment
// responsibilities set by the collaboration creator.
type MembershipModelInferencePaymentConfig struct {

	// Indicates whether the collaboration member has accepted to pay for model
	// inference costs ( TRUE ) or has not accepted to pay for model inference costs (
	// FALSE ).
	//
	// If the collaboration creator has not specified anyone to pay for model
	// inference costs, then the member who can query is the default payer.
	//
	// An error message is returned for the following reasons:
	//
	//   - If you set the value to FALSE but you are responsible to pay for model
	//   inference costs.
	//
	//   - If you set the value to TRUE but you are not responsible to pay for model
	//   inference costs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// An object representing the collaboration member's model training payment
// responsibilities set by the collaboration creator.
type MembershipModelTrainingPaymentConfig struct {

	// Indicates whether the collaboration member has accepted to pay for model
	// training costs ( TRUE ) or has not accepted to pay for model training costs (
	// FALSE ).
	//
	// If the collaboration creator has not specified anyone to pay for model training
	// costs, then the member who can query is the default payer.
	//
	// An error message is returned for the following reasons:
	//
	//   - If you set the value to FALSE but you are responsible to pay for model
	//   training costs.
	//
	//   - If you set the value to TRUE but you are not responsible to pay for model
	//   training costs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// An object representing the payment responsibilities accepted by the
// collaboration member.
type MembershipPaymentConfiguration struct {

	// The payment responsibilities accepted by the collaboration member for query
	// compute costs.
	//
	// This member is required.
	QueryCompute *MembershipQueryComputePaymentConfig

	// The payment responsibilities accepted by the collaboration member for job
	// compute costs.
	JobCompute *MembershipJobComputePaymentConfig

	// The payment responsibilities accepted by the collaboration member for machine
	// learning costs.
	MachineLearning *MembershipMLPaymentConfig

	noSmithyDocumentSerde
}

// Contains configurations for protected job results.
//
// The following types satisfy this interface:
//
//	MembershipProtectedJobOutputConfigurationMemberS3
type MembershipProtectedJobOutputConfiguration interface {
	isMembershipProtectedJobOutputConfiguration()
}

// Contains the configuration to write the job results to S3.
type MembershipProtectedJobOutputConfigurationMemberS3 struct {
	Value ProtectedJobS3OutputConfigurationInput

	noSmithyDocumentSerde
}

func (*MembershipProtectedJobOutputConfigurationMemberS3) isMembershipProtectedJobOutputConfiguration() {
}

// Contains configurations for protected job results.
type MembershipProtectedJobResultConfiguration struct {

	//  The output configuration for a protected job result.
	//
	// This member is required.
	OutputConfiguration MembershipProtectedJobOutputConfiguration

	// The unique ARN for an IAM role that is used by Clean Rooms to write protected
	// job results to the result location, given by the member who can receive results.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Contains configurations for protected query results.
//
// The following types satisfy this interface:
//
//	MembershipProtectedQueryOutputConfigurationMemberS3
type MembershipProtectedQueryOutputConfiguration interface {
	isMembershipProtectedQueryOutputConfiguration()
}

// Contains the configuration to write the query results to S3.
type MembershipProtectedQueryOutputConfigurationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*MembershipProtectedQueryOutputConfigurationMemberS3) isMembershipProtectedQueryOutputConfiguration() {
}

// Contains configurations for protected query results.
type MembershipProtectedQueryResultConfiguration struct {

	// Configuration for protected query results.
	//
	// This member is required.
	OutputConfiguration MembershipProtectedQueryOutputConfiguration

	// The unique ARN for an IAM role that is used by Clean Rooms to write protected
	// query results to the result location, given by the member who can receive
	// results.
	RoleArn *string

	noSmithyDocumentSerde
}

// An object representing the payment responsibilities accepted by the
// collaboration member for query compute costs.
type MembershipQueryComputePaymentConfig struct {

	// Indicates whether the collaboration member has accepted to pay for query
	// compute costs ( TRUE ) or has not accepted to pay for query compute costs ( FALSE
	// ).
	//
	// If the collaboration creator has not specified anyone to pay for query compute
	// costs, then the member who can query is the default payer.
	//
	// An error message is returned for the following reasons:
	//
	//   - If you set the value to FALSE but you are responsible to pay for query
	//   compute costs.
	//
	//   - If you set the value to TRUE but you are not responsible to pay for query
	//   compute costs.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// The membership object listed by the request.
type MembershipSummary struct {

	// The unique ARN for the membership.
	//
	// This member is required.
	Arn *string

	// The unique ARN for the membership's associated collaboration.
	//
	// This member is required.
	CollaborationArn *string

	// The identifier of the Amazon Web Services principal that created the
	// collaboration. Currently only supports Amazon Web Services account ID.
	//
	// This member is required.
	CollaborationCreatorAccountId *string

	// The display name of the collaboration creator.
	//
	// This member is required.
	CollaborationCreatorDisplayName *string

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	CollaborationId *string

	// The name for the membership's collaboration.
	//
	// This member is required.
	CollaborationName *string

	// The time when the membership was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID for the membership's collaboration.
	//
	// This member is required.
	Id *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The payment responsibilities accepted by the collaboration member.
	//
	// This member is required.
	PaymentConfiguration *MembershipPaymentConfiguration

	// The status of the membership.
	//
	// This member is required.
	Status MembershipStatus

	// The time the membership metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// Provides a summary of the ML abilities for the collaboration member.
	MlMemberAbilities *MLMemberAbilities

	noSmithyDocumentSerde
}

// Configuration for payment for synthetic data generation in a membership.
type MembershipSyntheticDataGenerationPaymentConfig struct {

	// Indicates if this membership is responsible for paying for synthetic data
	// generation.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// Basic metadata used to construct a new member.
type MemberSpecification struct {

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	MemberAbilities []MemberAbility

	// The ML abilities granted to the collaboration member.
	MlMemberAbilities *MLMemberAbilities

	// The collaboration member's payment responsibilities set by the collaboration
	// creator.
	//
	// If the collaboration creator hasn't speciﬁed anyone as the member paying for
	// query compute costs, then the member who can query is the default payer.
	PaymentConfiguration *PaymentConfiguration

	noSmithyDocumentSerde
}

// The member object listed by the request.
type MemberSummary struct {

	// The abilities granted to the collaboration member.
	//
	// This member is required.
	Abilities []MemberAbility

	// The identifier used to reference members of the collaboration. Currently only
	// supports Amazon Web Services account ID.
	//
	// This member is required.
	AccountId *string

	// The time when the member was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The member's display name.
	//
	// This member is required.
	DisplayName *string

	// The collaboration member's payment responsibilities set by the collaboration
	// creator.
	//
	// This member is required.
	PaymentConfiguration *PaymentConfiguration

	// The status of the member.
	//
	// This member is required.
	Status MemberStatus

	// The time the member metadata was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The unique ARN for the member's associated membership, if present.
	MembershipArn *string

	// The unique ID for the member's associated membership, if present.
	MembershipId *string

	// Provides a summary of the ML abilities for the collaboration member.
	MlAbilities *MLMemberAbilities

	noSmithyDocumentSerde
}

// The ML member abilities for a collaboration member.
type MLMemberAbilities struct {

	// The custom ML member abilities for a collaboration member.
	//
	// This member is required.
	CustomMLMemberAbilities []CustomMLMemberAbility

	noSmithyDocumentSerde
}

// An object representing the collaboration member's machine learning payment
// responsibilities set by the collaboration creator.
type MLPaymentConfig struct {

	// The payment responsibilities accepted by the member for model inference.
	ModelInference *ModelInferencePaymentConfig

	// The payment responsibilities accepted by the member for model training.
	ModelTraining *ModelTrainingPaymentConfig

	// The payment configuration for machine learning synthetic data generation.
	SyntheticDataGeneration *SyntheticDataGenerationPaymentConfig

	noSmithyDocumentSerde
}

// Parameters that control the generation of synthetic data for machine learning,
// including privacy settings and column classification details.
type MLSyntheticDataParameters struct {

	// Classification details for data columns that specify how each column should be
	// treated during synthetic data generation.
	//
	// This member is required.
	ColumnClassification *ColumnClassificationDetails

	// The epsilon value for differential privacy when generating synthetic data.
	// Lower values provide stronger privacy guarantees but may reduce data utility.
	//
	// This member is required.
	Epsilon *float64

	// The maximum acceptable score for membership inference attack vulnerability.
	// Synthetic data generation fails if the score for the resulting data exceeds this
	// threshold.
	//
	// This member is required.
	MaxMembershipInferenceAttackScore *float64

	noSmithyDocumentSerde
}

// An object representing the collaboration member's model inference payment
// responsibilities set by the collaboration creator.
type ModelInferencePaymentConfig struct {

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for model inference costs ( TRUE ) or has not configured the
	// collaboration member to pay for model inference costs ( FALSE ).
	//
	// Exactly one member can be configured to pay for model inference costs. An error
	// is returned if the collaboration creator sets a TRUE value for more than one
	// member in the collaboration.
	//
	// If the collaboration creator hasn't specified anyone as the member paying for
	// model inference costs, then the member who can query is the default payer. An
	// error is returned if the collaboration creator sets a FALSE value for the
	// member who can query.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// An object representing the collaboration member's model training payment
// responsibilities set by the collaboration creator.
type ModelTrainingPaymentConfig struct {

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for model training costs ( TRUE ) or has not configured the
	// collaboration member to pay for model training costs ( FALSE ).
	//
	// Exactly one member can be configured to pay for model training costs. An error
	// is returned if the collaboration creator sets a TRUE value for more than one
	// member in the collaboration.
	//
	// If the collaboration creator hasn't specified anyone as the member paying for
	// model training costs, then the member who can query is the default payer. An
	// error is returned if the collaboration creator sets a FALSE value for the
	// member who can query.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// An object representing the collaboration member's payment responsibilities set
// by the collaboration creator.
type PaymentConfiguration struct {

	// The collaboration member's payment responsibilities set by the collaboration
	// creator for query compute costs.
	//
	// This member is required.
	QueryCompute *QueryComputePaymentConfig

	//  The compute configuration for the job.
	JobCompute *JobComputePaymentConfig

	// An object representing the collaboration member's machine learning payment
	// responsibilities set by the collaboration creator.
	MachineLearning *MLPaymentConfig

	noSmithyDocumentSerde
}

// Specifies the updated epsilon and noise parameters to preview. The preview
// allows you to see how the maximum number of each type of aggregation function
// would change with the new parameters.
//
// The following types satisfy this interface:
//
//	PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy
type PreviewPrivacyImpactParametersInput interface {
	isPreviewPrivacyImpactParametersInput()
}

// An array that specifies the epsilon and noise parameters.
type PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPreviewParametersInput

	noSmithyDocumentSerde
}

func (*PreviewPrivacyImpactParametersInputMemberDifferentialPrivacy) isPreviewPrivacyImpactParametersInput() {
}

// The epsilon parameter value and number of each aggregation function that you
// can perform.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetMemberAccessBudget
//	PrivacyBudgetMemberDifferentialPrivacy
type PrivacyBudget interface {
	isPrivacyBudget()
}

// Access budget information associated with this privacy budget.
type PrivacyBudgetMemberAccessBudget struct {
	Value AccessBudget

	noSmithyDocumentSerde
}

func (*PrivacyBudgetMemberAccessBudget) isPrivacyBudget() {}

// An object that specifies the epsilon parameter and the utility in terms of
// total aggregations, as well as the remaining aggregations available.
type PrivacyBudgetMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPrivacyBudget

	noSmithyDocumentSerde
}

func (*PrivacyBudgetMemberDifferentialPrivacy) isPrivacyBudget() {}

// An array that summaries the specified privacy budget. This summary includes
// collaboration information, creation information, membership information, and
// privacy budget information.
type PrivacyBudgetSummary struct {

	// The provided privacy budget.
	//
	// This member is required.
	Budget PrivacyBudget

	// The ARN of the collaboration that contains this privacy budget.
	//
	// This member is required.
	CollaborationArn *string

	// The unique identifier of the collaboration that contains this privacy budget.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// summary.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The ARN of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateArn *string

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetTemplateId *string

	// Specifies the type of the privacy budget.
	//
	// This member is required.
	Type PrivacyBudgetType

	// The most recent time at which the privacy budget was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// An object that defines the privacy budget template.
type PrivacyBudgetTemplate struct {

	// The ARN of the privacy budget template.
	//
	// This member is required.
	Arn *string

	// How often the privacy budget refreshes.
	//
	// If you plan to regularly bring new data into the collaboration, use
	// CALENDAR_MONTH to automatically get a new privacy budget for the collaboration
	// every calendar month. Choosing this option allows arbitrary amounts of
	// information to be revealed about rows of the data when repeatedly queried across
	// refreshes. Avoid choosing this if the same rows will be repeatedly queried
	// between privacy budget refreshes.
	//
	// This member is required.
	AutoRefresh PrivacyBudgetTemplateAutoRefresh

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// Specifies the epsilon and noise parameters for the privacy budget template.
	//
	// This member is required.
	Parameters PrivacyBudgetTemplateParametersOutput

	// Specifies the type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the privacy budget template was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to use for the privacy budget
// template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateParametersInputMemberAccessBudget
//	PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy
type PrivacyBudgetTemplateParametersInput interface {
	isPrivacyBudgetTemplateParametersInput()
}

// Access budget configuration for the privacy budget template input, enabling
// integration with access budget functionality.
type PrivacyBudgetTemplateParametersInputMemberAccessBudget struct {
	Value AccessBudgetsPrivacyTemplateParametersInput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersInputMemberAccessBudget) isPrivacyBudgetTemplateParametersInput() {
}

// An object that specifies the epsilon and noise parameters.
type PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateParametersInput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersInputMemberDifferentialPrivacy) isPrivacyBudgetTemplateParametersInput() {
}

// The epsilon and noise parameters that were used in the privacy budget template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateParametersOutputMemberAccessBudget
//	PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy
type PrivacyBudgetTemplateParametersOutput interface {
	isPrivacyBudgetTemplateParametersOutput()
}

// Access budget configuration returned from the privacy budget template,
// containing the configured access budget settings.
type PrivacyBudgetTemplateParametersOutputMemberAccessBudget struct {
	Value AccessBudgetsPrivacyTemplateParametersOutput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersOutputMemberAccessBudget) isPrivacyBudgetTemplateParametersOutput() {
}

// The epsilon and noise parameters.
type PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateParametersOutput

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateParametersOutputMemberDifferentialPrivacy) isPrivacyBudgetTemplateParametersOutput() {
}

// A summary of the privacy budget template. The summary includes membership
// information, collaboration information, and creation information.
type PrivacyBudgetTemplateSummary struct {

	// The ARN of the privacy budget template.
	//
	// This member is required.
	Arn *string

	// The ARN of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID of the collaboration that contains this privacy budget template.
	//
	// This member is required.
	CollaborationId *string

	// The time at which the privacy budget template was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique identifier of the privacy budget template.
	//
	// This member is required.
	Id *string

	// The Amazon Resource Name (ARN) of the member who created the privacy budget
	// template.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for a membership resource.
	//
	// This member is required.
	MembershipId *string

	// The type of the privacy budget template.
	//
	// This member is required.
	PrivacyBudgetType PrivacyBudgetType

	// The most recent time at which the privacy budget template was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	noSmithyDocumentSerde
}

// The epsilon and noise parameters that you want to update in the privacy budget
// template.
//
// The following types satisfy this interface:
//
//	PrivacyBudgetTemplateUpdateParametersMemberAccessBudget
//	PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy
type PrivacyBudgetTemplateUpdateParameters interface {
	isPrivacyBudgetTemplateUpdateParameters()
}

//	The new access budget configuration that completely replaces the existing
//
// access budget settings in the privacy budget template.
type PrivacyBudgetTemplateUpdateParametersMemberAccessBudget struct {
	Value AccessBudgetsPrivacyTemplateUpdateParameters

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateUpdateParametersMemberAccessBudget) isPrivacyBudgetTemplateUpdateParameters() {
}

// An object that specifies the new values for the epsilon and noise parameters.
type PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyTemplateUpdateParameters

	noSmithyDocumentSerde
}

func (*PrivacyBudgetTemplateUpdateParametersMemberDifferentialPrivacy) isPrivacyBudgetTemplateUpdateParameters() {
}

// Provides an estimate of the number of aggregation functions that the member who
// can query can run given the epsilon and noise parameters.
//
// The following types satisfy this interface:
//
//	PrivacyImpactMemberDifferentialPrivacy
type PrivacyImpact interface {
	isPrivacyImpact()
}

// An object that lists the number and type of aggregation functions you can
// perform.
type PrivacyImpactMemberDifferentialPrivacy struct {
	Value DifferentialPrivacyPrivacyImpact

	noSmithyDocumentSerde
}

func (*PrivacyImpactMemberDifferentialPrivacy) isPrivacyImpact() {}

// The parameters for an Clean Rooms protected job.
type ProtectedJob struct {

	//  The creation time of the protected job.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier for a protected job instance.
	//
	// This member is required.
	Id *string

	// The ARN of the membership.
	//
	// This member is required.
	MembershipArn *string

	// he identifier for the membership.
	//
	// This member is required.
	MembershipId *string

	//  The status of the protected job.
	//
	// This member is required.
	Status ProtectedJobStatus

	// The compute configuration for the protected job.
	ComputeConfiguration ProtectedJobComputeConfiguration

	//  The error from the protected job.
	Error *ProtectedJobError

	//  The job parameters for the protected job.
	JobParameters *ProtectedJobParameters

	//  The result of the protected job.
	Result *ProtectedJobResult

	// Contains any details needed to write the job results.
	ResultConfiguration *ProtectedJobResultConfigurationOutput

	//  The statistics of the protected job.
	Statistics *ProtectedJobStatistics

	noSmithyDocumentSerde
}

// The configuration of the compute resources for a PySpark job.
//
// The following types satisfy this interface:
//
//	ProtectedJobComputeConfigurationMemberWorker
type ProtectedJobComputeConfiguration interface {
	isProtectedJobComputeConfiguration()
}

// The worker configuration for the compute environment.
type ProtectedJobComputeConfigurationMemberWorker struct {
	Value ProtectedJobWorkerComputeConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedJobComputeConfigurationMemberWorker) isProtectedJobComputeConfiguration() {}

// The protected job configuration details.
//
// The following types satisfy this interface:
//
//	ProtectedJobConfigurationDetailsMemberDirectAnalysisConfigurationDetails
type ProtectedJobConfigurationDetails interface {
	isProtectedJobConfigurationDetails()
}

// The details needed to configure the direct analysis.
type ProtectedJobConfigurationDetailsMemberDirectAnalysisConfigurationDetails struct {
	Value ProtectedJobDirectAnalysisConfigurationDetails

	noSmithyDocumentSerde
}

func (*ProtectedJobConfigurationDetailsMemberDirectAnalysisConfigurationDetails) isProtectedJobConfigurationDetails() {
}

// The protected job direct analysis configuration details.
type ProtectedJobDirectAnalysisConfigurationDetails struct {

	//  The receiver account IDs.
	ReceiverAccountIds []string

	noSmithyDocumentSerde
}

// The protected job error.
type ProtectedJobError struct {

	//  The error code for the protected job.
	//
	// This member is required.
	Code *string

	//  The message for the protected job error.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The protected job member output configuration input.
type ProtectedJobMemberOutputConfigurationInput struct {

	//  The account ID.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// The protected job member output configuration output.
type ProtectedJobMemberOutputConfigurationOutput struct {

	//  The account ID.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// Contains details about the protected job output.
//
// The following types satisfy this interface:
//
//	ProtectedJobOutputMemberMemberList
//	ProtectedJobOutputMemberS3
type ProtectedJobOutput interface {
	isProtectedJobOutput()
}

// The list of member Amazon Web Services account(s) that received the results of
// the job.
type ProtectedJobOutputMemberMemberList struct {
	Value []ProtectedJobSingleMemberOutput

	noSmithyDocumentSerde
}

func (*ProtectedJobOutputMemberMemberList) isProtectedJobOutput() {}

// If present, the output for a protected job with an `S3` output type.
type ProtectedJobOutputMemberS3 struct {
	Value ProtectedJobS3Output

	noSmithyDocumentSerde
}

func (*ProtectedJobOutputMemberS3) isProtectedJobOutput() {}

//	The protected job output configuration input.
//
// The following types satisfy this interface:
//
//	ProtectedJobOutputConfigurationInputMemberMember
type ProtectedJobOutputConfigurationInput interface {
	isProtectedJobOutputConfigurationInput()
}

// The member of the protected job output configuration input.
type ProtectedJobOutputConfigurationInputMemberMember struct {
	Value ProtectedJobMemberOutputConfigurationInput

	noSmithyDocumentSerde
}

func (*ProtectedJobOutputConfigurationInputMemberMember) isProtectedJobOutputConfigurationInput() {}

//	The protected job output configuration output.
//
// The following types satisfy this interface:
//
//	ProtectedJobOutputConfigurationOutputMemberMember
//	ProtectedJobOutputConfigurationOutputMemberS3
type ProtectedJobOutputConfigurationOutput interface {
	isProtectedJobOutputConfigurationOutput()
}

// The member output configuration for a protected job.
type ProtectedJobOutputConfigurationOutputMemberMember struct {
	Value ProtectedJobMemberOutputConfigurationOutput

	noSmithyDocumentSerde
}

func (*ProtectedJobOutputConfigurationOutputMemberMember) isProtectedJobOutputConfigurationOutput() {}

// If present, the output for a protected job with an `S3` output type.
type ProtectedJobOutputConfigurationOutputMemberS3 struct {
	Value ProtectedJobS3OutputConfigurationOutput

	noSmithyDocumentSerde
}

func (*ProtectedJobOutputConfigurationOutputMemberS3) isProtectedJobOutputConfigurationOutput() {}

// The parameters for the protected job.
type ProtectedJobParameters struct {

	//  The ARN of the analysis template.
	//
	// This member is required.
	AnalysisTemplateArn *string

	noSmithyDocumentSerde
}

// The protected job receiver configuration.
type ProtectedJobReceiverConfiguration struct {

	//  The analysis type for the protected job receiver configuration.
	//
	// This member is required.
	AnalysisType ProtectedJobAnalysisType

	//  The configuration details for the protected job receiver.
	ConfigurationDetails ProtectedJobConfigurationDetails

	noSmithyDocumentSerde
}

// Details about the job results.
type ProtectedJobResult struct {

	//  The output of the protected job.
	//
	// This member is required.
	Output ProtectedJobOutput

	noSmithyDocumentSerde
}

// The protected job result configuration input.
type ProtectedJobResultConfigurationInput struct {

	//  The output configuration for a protected job result.
	//
	// This member is required.
	OutputConfiguration ProtectedJobOutputConfigurationInput

	noSmithyDocumentSerde
}

// The output configuration for a protected job result.
type ProtectedJobResultConfigurationOutput struct {

	// The output configuration.
	//
	// This member is required.
	OutputConfiguration ProtectedJobOutputConfigurationOutput

	noSmithyDocumentSerde
}

// Contains output information for protected jobs with an S3 output type.
type ProtectedJobS3Output struct {

	//  The S3 location for the protected job output.
	//
	// This member is required.
	Location *string

	noSmithyDocumentSerde
}

// Contains input information for protected jobs with an S3 output type.
type ProtectedJobS3OutputConfigurationInput struct {

	//  The S3 bucket for job output.
	//
	// This member is required.
	Bucket *string

	// The S3 prefix to unload the protected job results.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// The output configuration for a protected job's S3 output.
type ProtectedJobS3OutputConfigurationOutput struct {

	//  The S3 bucket for job output.
	//
	// This member is required.
	Bucket *string

	// The S3 prefix to unload the protected job results.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// Details about the member who received the job result.
type ProtectedJobSingleMemberOutput struct {

	// The Amazon Web Services account ID of the member in the collaboration who can
	// receive results from analyses.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// Contains statistics about the execution of the protected job.
type ProtectedJobStatistics struct {

	//  The billed resource utilization for the protected job.
	BilledResourceUtilization *BilledJobResourceUtilization

	// The duration of the protected job, from creation until job completion, in
	// milliseconds.
	TotalDurationInMillis *int64

	noSmithyDocumentSerde
}

// The protected job summary for the objects listed by the request.
type ProtectedJobSummary struct {

	// The time the protected job was created.
	//
	// This member is required.
	CreateTime *time.Time

	//  The ID of the protected job.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that initiated the protected job.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that initiated the protected job.
	//
	// This member is required.
	MembershipId *string

	//  The receiver configurations for the protected job.
	//
	// This member is required.
	ReceiverConfigurations []ProtectedJobReceiverConfiguration

	// The status of the protected job.
	//
	// This member is required.
	Status ProtectedJobStatus

	noSmithyDocumentSerde
}

// The configuration of the compute resources for a PySpark job.
type ProtectedJobWorkerComputeConfiguration struct {

	// The number of workers for a PySpark job.
	//
	// This member is required.
	Number *int32

	// The worker compute configuration type.
	//
	// This member is required.
	Type ProtectedJobWorkerComputeType

	noSmithyDocumentSerde
}

// The parameters for an Clean Rooms protected query.
type ProtectedQuery struct {

	// The time at which the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The identifier for a protected query instance.
	//
	// This member is required.
	Id *string

	// The ARN of the membership.
	//
	// This member is required.
	MembershipArn *string

	// The identifier for the membership.
	//
	// This member is required.
	MembershipId *string

	// The status of the query.
	//
	// This member is required.
	Status ProtectedQueryStatus

	//  The compute configuration for the protected query.
	ComputeConfiguration ComputeConfiguration

	// The sensitivity parameters of the differential privacy results of the protected
	// query.
	DifferentialPrivacy *DifferentialPrivacyParameters

	// An error thrown by the protected query.
	Error *ProtectedQueryError

	// The result of the protected query.
	Result *ProtectedQueryResult

	// Contains any details needed to write the query results.
	ResultConfiguration *ProtectedQueryResultConfiguration

	// The protected query SQL parameters.
	SqlParameters *ProtectedQuerySQLParameters

	// Statistics about protected query execution.
	Statistics *ProtectedQueryStatistics

	noSmithyDocumentSerde
}

//	Contains the output information for a protected query with a distribute output
//
// configuration.
//
// This output type allows query results to be distributed to multiple receivers,
// including S3 and collaboration members. It is only available for queries using
// the Spark analytics engine.
type ProtectedQueryDistributeOutput struct {

	//  Contains the output results for each member location specified in the
	// distribute output configuration. Each entry provides details about the result
	// distribution to a specific collaboration member.
	MemberList []ProtectedQuerySingleMemberOutput

	// Contains output information for protected queries with an S3 output type.
	S3 *ProtectedQueryS3Output

	noSmithyDocumentSerde
}

//	Specifies the configuration for distributing protected query results to
//
// multiple receivers, including S3 and collaboration members.
type ProtectedQueryDistributeOutputConfiguration struct {

	//  A list of locations where you want to distribute the protected query results.
	// Each location must specify either an S3 destination or a collaboration member
	// destination.
	//
	// You can't specify more than one S3 location.
	//
	// You can't specify the query runner's account as a member location.
	//
	// You must include either an S3 or member output configuration for each location,
	// but not both.
	//
	// This member is required.
	Locations []ProtectedQueryDistributeOutputConfigurationLocation

	noSmithyDocumentSerde
}

//	Specifies where you'll distribute the results of your protected query. You
//
// must configure either an S3 destination or a collaboration member destination.
//
// The following types satisfy this interface:
//
//	ProtectedQueryDistributeOutputConfigurationLocationMemberMember
//	ProtectedQueryDistributeOutputConfigurationLocationMemberS3
type ProtectedQueryDistributeOutputConfigurationLocation interface {
	isProtectedQueryDistributeOutputConfigurationLocation()
}

// Contains configuration details for the protected query member output.
type ProtectedQueryDistributeOutputConfigurationLocationMemberMember struct {
	Value ProtectedQueryMemberOutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryDistributeOutputConfigurationLocationMemberMember) isProtectedQueryDistributeOutputConfigurationLocation() {
}

// Contains the configuration to write the query results to S3.
type ProtectedQueryDistributeOutputConfigurationLocationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryDistributeOutputConfigurationLocationMemberS3) isProtectedQueryDistributeOutputConfigurationLocation() {
}

// Details of errors thrown by the protected query.
type ProtectedQueryError struct {

	// An error code for the error.
	//
	// This member is required.
	Code *string

	// A description of why the query failed.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// Contains configuration details for the protected query member output.
type ProtectedQueryMemberOutputConfiguration struct {

	// The unique identifier for the account.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// Contains details about the protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputMemberDistribute
//	ProtectedQueryOutputMemberMemberList
//	ProtectedQueryOutputMemberS3
type ProtectedQueryOutput interface {
	isProtectedQueryOutput()
}

// Contains output information for protected queries that use a distribute output
// type. This output type lets you send query results to multiple locations -
// either to S3 or to collaboration members.
//
// You can only use the distribute output type with the Spark analytics engine.
type ProtectedQueryOutputMemberDistribute struct {
	Value ProtectedQueryDistributeOutput

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberDistribute) isProtectedQueryOutput() {}

// The list of member Amazon Web Services account(s) that received the results of
// the query.
type ProtectedQueryOutputMemberMemberList struct {
	Value []ProtectedQuerySingleMemberOutput

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberMemberList) isProtectedQueryOutput() {}

// If present, the output for a protected query with an S3 output type.
type ProtectedQueryOutputMemberS3 struct {
	Value ProtectedQueryS3Output

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputMemberS3) isProtectedQueryOutput() {}

// Contains configuration details for protected query output.
//
// The following types satisfy this interface:
//
//	ProtectedQueryOutputConfigurationMemberDistribute
//	ProtectedQueryOutputConfigurationMemberMember
//	ProtectedQueryOutputConfigurationMemberS3
type ProtectedQueryOutputConfiguration interface {
	isProtectedQueryOutputConfiguration()
}

// Required configuration for a protected query with a distribute output type.
type ProtectedQueryOutputConfigurationMemberDistribute struct {
	Value ProtectedQueryDistributeOutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputConfigurationMemberDistribute) isProtectedQueryOutputConfiguration() {}

// Required configuration for a protected query with a member output type.
type ProtectedQueryOutputConfigurationMemberMember struct {
	Value ProtectedQueryMemberOutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputConfigurationMemberMember) isProtectedQueryOutputConfiguration() {}

// Required configuration for a protected query with an s3 output type.
type ProtectedQueryOutputConfigurationMemberS3 struct {
	Value ProtectedQueryS3OutputConfiguration

	noSmithyDocumentSerde
}

func (*ProtectedQueryOutputConfigurationMemberS3) isProtectedQueryOutputConfiguration() {}

// Details about the query results.
type ProtectedQueryResult struct {

	// The output of the protected query.
	//
	// This member is required.
	Output ProtectedQueryOutput

	noSmithyDocumentSerde
}

// Contains configurations for protected query results.
type ProtectedQueryResultConfiguration struct {

	// Configuration for protected query results.
	//
	// This member is required.
	OutputConfiguration ProtectedQueryOutputConfiguration

	noSmithyDocumentSerde
}

// Contains output information for protected queries with an S3 output type.
type ProtectedQueryS3Output struct {

	// The S3 location of the result.
	//
	// This member is required.
	Location *string

	noSmithyDocumentSerde
}

// Contains the configuration to write the query results to S3.
type ProtectedQueryS3OutputConfiguration struct {

	// The S3 bucket to unload the protected query results.
	//
	// This member is required.
	Bucket *string

	// Intended file format of the result.
	//
	// This member is required.
	ResultFormat ResultFormat

	// The S3 prefix to unload the protected query results.
	KeyPrefix *string

	// Indicates whether files should be output as a single file ( TRUE ) or output as
	// multiple files ( FALSE ). This parameter is only supported for analyses with the
	// Spark analytics engine.
	SingleFileOutput *bool

	noSmithyDocumentSerde
}

// Details about the member who received the query result.
type ProtectedQuerySingleMemberOutput struct {

	// The Amazon Web Services account ID of the member in the collaboration who can
	// receive results for the query.
	//
	// This member is required.
	AccountId *string

	noSmithyDocumentSerde
}

// The parameters for the SQL type Protected Query.
type ProtectedQuerySQLParameters struct {

	// The Amazon Resource Name (ARN) associated with the analysis template within a
	// collaboration.
	AnalysisTemplateArn *string

	// The protected query SQL parameters.
	Parameters map[string]string

	// The query string to be submitted.
	QueryString *string

	noSmithyDocumentSerde
}

// Contains statistics about the execution of the protected query.
type ProtectedQueryStatistics struct {

	//  The billed resource utilization.
	BilledResourceUtilization *BilledResourceUtilization

	// The duration of the protected query, from creation until query completion, in
	// milliseconds.
	TotalDurationInMillis *int64

	noSmithyDocumentSerde
}

// The protected query summary for the objects listed by the request.
type ProtectedQuerySummary struct {

	// The time the protected query was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique ID of the protected query.
	//
	// This member is required.
	Id *string

	// The unique ARN for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipArn *string

	// The unique ID for the membership that initiated the protected query.
	//
	// This member is required.
	MembershipId *string

	//  The receiver configuration.
	//
	// This member is required.
	ReceiverConfigurations []ReceiverConfiguration

	// The status of the protected query.
	//
	// This member is required.
	Status ProtectedQueryStatus

	noSmithyDocumentSerde
}

// An object representing the collaboration member's payment responsibilities set
// by the collaboration creator for query compute costs.
type QueryComputePaymentConfig struct {

	// Indicates whether the collaboration creator has configured the collaboration
	// member to pay for query compute costs ( TRUE ) or has not configured the
	// collaboration member to pay for query compute costs ( FALSE ).
	//
	// Exactly one member can be configured to pay for query compute costs. An error
	// is returned if the collaboration creator sets a TRUE value for more than one
	// member in the collaboration.
	//
	// If the collaboration creator hasn't specified anyone as the member paying for
	// query compute costs, then the member who can query is the default payer. An
	// error is returned if the collaboration creator sets a FALSE value for the
	// member who can query.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// Provides any necessary query constraint information.
//
// The following types satisfy this interface:
//
//	QueryConstraintMemberRequireOverlap
type QueryConstraint interface {
	isQueryConstraint()
}

// An array of column names that specifies which columns are required in the JOIN
// statement.
type QueryConstraintMemberRequireOverlap struct {
	Value QueryConstraintRequireOverlap

	noSmithyDocumentSerde
}

func (*QueryConstraintMemberRequireOverlap) isQueryConstraint() {}

// Provides the name of the columns that are required to overlap.
type QueryConstraintRequireOverlap struct {

	// The columns that are required to overlap.
	Columns []string

	noSmithyDocumentSerde
}

// The receiver configuration for a protected query.
type ReceiverConfiguration struct {

	//  The type of analysis for the protected query. The results of the query can be
	// analyzed directly ( DIRECT_ANALYSIS ) or used as input into additional analyses (
	// ADDITIONAL_ANALYSIS ), such as a query that is a seed for a lookalike ML model.
	//
	// This member is required.
	AnalysisType AnalysisType

	//  The configuration details of the receiver configuration.
	ConfigurationDetails ConfigurationDetails

	noSmithyDocumentSerde
}

// The S3 location.
type S3Location struct {

	//  The bucket name.
	//
	// This member is required.
	Bucket *string

	//  The object key.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// A schema is a relation within a collaboration.
type Schema struct {

	// The analysis rule types that are associated with the schema. Currently, only
	// one entry is present.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique Amazon Resource Name (ARN) for the collaboration that the schema
	// belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The columns for the relation that this schema represents.
	//
	// This member is required.
	Columns []Column

	// The time at which the schema was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// A description for the schema.
	//
	// This member is required.
	Description *string

	// A name for the schema. The schema relation is referred to by this name when
	// queried by a protected query.
	//
	// This member is required.
	Name *string

	// The partition keys for the dataset underlying this schema.
	//
	// This member is required.
	PartitionKeys []Column

	// Details about the status of the schema. Currently, only one entry is present.
	//
	// This member is required.
	SchemaStatusDetails []SchemaStatusDetail

	// The type of schema.
	//
	// This member is required.
	Type SchemaType

	// The most recent time at which the schema was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the schema.
	//
	// DIRECT_QUERY allows SQL queries to be run directly on this table.
	//
	// DIRECT_JOB allows PySpark jobs to be run directly on this table.
	//
	// MULTIPLE allows both SQL queries and PySpark jobs to be run directly on this
	// table.
	AnalysisMethod AnalysisMethod

	// The Amazon Resource Name (ARN) of the schema resource.
	ResourceArn *string

	// The schema type properties.
	SchemaTypeProperties SchemaTypeProperties

	//  The selected analysis methods for the schema.
	SelectedAnalysisMethods []SelectedAnalysisMethod

	noSmithyDocumentSerde
}

// Defines the information that's necessary to retrieve an analysis rule schema.
// Schema analysis rules are uniquely identiﬁed by a combination of the schema name
// and the analysis rule type for a given collaboration.
type SchemaAnalysisRuleRequest struct {

	// The name of the analysis rule schema that you are requesting.
	//
	// This member is required.
	Name *string

	// The type of analysis rule schema that you are requesting.
	//
	// This member is required.
	Type AnalysisRuleType

	noSmithyDocumentSerde
}

// Information about the schema status.
//
// A status of READY means that based on the schema analysis rule, queries of the
// given analysis rule type are properly configured to run queries on this schema.
type SchemaStatusDetail struct {

	// The type of analysis that can be performed on the schema.
	//
	// A schema can have an analysisType of DIRECT_ANALYSIS ,
	// ADDITIONAL_ANALYSIS_FOR_AUDIENCE_GENERATION , or both.
	//
	// This member is required.
	AnalysisType AnalysisType

	// The status of the schema, indicating if it is ready to query.
	//
	// This member is required.
	Status SchemaStatus

	// The analysis rule type for which the schema status has been evaluated.
	AnalysisRuleType AnalysisRuleType

	// The configuration details of the schema analysis rule for the given type.
	Configurations []SchemaConfiguration

	// The reasons why the schema status is set to its current state.
	Reasons []SchemaStatusReason

	noSmithyDocumentSerde
}

// A reason why the schema status is set to its current value.
type SchemaStatusReason struct {

	// The schema status reason code.
	//
	// This member is required.
	Code SchemaStatusReasonCode

	// An explanation of the schema status reason code.
	//
	// This member is required.
	Message *string

	noSmithyDocumentSerde
}

// The schema summary for the objects listed by the request.
type SchemaSummary struct {

	// The types of analysis rules that are associated with this schema object.
	//
	// This member is required.
	AnalysisRuleTypes []AnalysisRuleType

	// The unique ARN for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationArn *string

	// The unique ID for the collaboration that the schema belongs to.
	//
	// This member is required.
	CollaborationId *string

	// The time the schema object was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The unique account ID for the Amazon Web Services account that owns the schema.
	//
	// This member is required.
	CreatorAccountId *string

	// The name for the schema object.
	//
	// This member is required.
	Name *string

	// The type of schema object.
	//
	// This member is required.
	Type SchemaType

	// The time the schema object was last updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The analysis method for the associated schema.
	//
	// DIRECT_QUERY allows SQL queries to be run directly on this table.
	//
	// DIRECT_JOB allows PySpark jobs to be run directly on this table.
	//
	// MULTIPLE allows both SQL queries and PySpark jobs to be run directly on this
	// table.
	AnalysisMethod AnalysisMethod

	// The Amazon Resource Name (ARN) of the schema summary resource.
	ResourceArn *string

	//  The selected analysis methods for the schema.
	SelectedAnalysisMethods []SelectedAnalysisMethod

	noSmithyDocumentSerde
}

// Information about the schema type properties.
//
// The following types satisfy this interface:
//
//	SchemaTypePropertiesMemberIdMappingTable
type SchemaTypeProperties interface {
	isSchemaTypeProperties()
}

// The ID mapping table for the schema type properties.
type SchemaTypePropertiesMemberIdMappingTable struct {
	Value IdMappingTableSchemaTypeProperties

	noSmithyDocumentSerde
}

func (*SchemaTypePropertiesMemberIdMappingTable) isSchemaTypeProperties() {}

// A reference to a table within Snowflake.
type SnowflakeTableReference struct {

	//  The account identifier for the Snowflake table reference.
	//
	// This member is required.
	AccountIdentifier *string

	//  The name of the database the Snowflake table belongs to.
	//
	// This member is required.
	DatabaseName *string

	//  The schema name of the Snowflake table reference.
	//
	// This member is required.
	SchemaName *string

	//  The secret ARN of the Snowflake table reference.
	//
	// This member is required.
	SecretArn *string

	//  The name of the Snowflake table.
	//
	// This member is required.
	TableName *string

	//  The schema of the Snowflake table.
	//
	// This member is required.
	TableSchema SnowflakeTableSchema

	noSmithyDocumentSerde
}

//	The schema of a Snowflake table.
//
// The following types satisfy this interface:
//
//	SnowflakeTableSchemaMemberV1
type SnowflakeTableSchema interface {
	isSnowflakeTableSchema()
}

// The schema of a Snowflake table.
type SnowflakeTableSchemaMemberV1 struct {
	Value []SnowflakeTableSchemaV1

	noSmithyDocumentSerde
}

func (*SnowflakeTableSchemaMemberV1) isSnowflakeTableSchema() {}

// The Snowflake table schema.
type SnowflakeTableSchemaV1 struct {

	//  The column name.
	//
	// This member is required.
	ColumnName *string

	//  The column's data type. Supported data types: ARRAY , BIGINT , BOOLEAN , CHAR ,
	// DATE , DECIMAL , DOUBLE , DOUBLE PRECISION , FLOAT , FLOAT4 , INT , INTEGER ,
	// MAP , NUMERIC , NUMBER , REAL , SMALLINT , STRING , TIMESTAMP , TIMESTAMP_LTZ ,
	// TIMESTAMP_NTZ , DATETIME , TINYINT , VARCHAR , TEXT , CHARACTER .
	//
	// This member is required.
	ColumnType *string

	noSmithyDocumentSerde
}

// Properties that define how a specific data column should be handled during
// synthetic data generation, including its name, type, and role in predictive
// modeling.
type SyntheticDataColumnProperties struct {

	// The name of the data column as it appears in the dataset.
	//
	// This member is required.
	ColumnName *string

	// The data type of the column, which determines how the synthetic data generation
	// algorithm processes and synthesizes values for this column.
	//
	// This member is required.
	ColumnType SyntheticDataColumnType

	// Indicates if this column contains predictive values that should be treated as
	// target variables in machine learning models. This affects how the synthetic data
	// generation preserves statistical relationships.
	//
	// This member is required.
	IsPredictiveValue *bool

	noSmithyDocumentSerde
}

// Payment configuration for synthetic data generation.
type SyntheticDataGenerationPaymentConfig struct {

	// Indicates who is responsible for paying for synthetic data generation.
	//
	// This member is required.
	IsResponsible *bool

	noSmithyDocumentSerde
}

// The parameters that control how synthetic data is generated, including privacy
// settings, column classifications, and other configuration options that affect
// the data synthesis process.
//
// The following types satisfy this interface:
//
//	SyntheticDataParametersMemberMlSyntheticDataParameters
type SyntheticDataParameters interface {
	isSyntheticDataParameters()
}

// The machine learning-specific parameters for synthetic data generation.
type SyntheticDataParametersMemberMlSyntheticDataParameters struct {
	Value MLSyntheticDataParameters

	noSmithyDocumentSerde
}

func (*SyntheticDataParametersMemberMlSyntheticDataParameters) isSyntheticDataParameters() {}

// A pointer to the dataset that underlies this table.
//
// The following types satisfy this interface:
//
//	TableReferenceMemberAthena
//	TableReferenceMemberGlue
//	TableReferenceMemberSnowflake
type TableReference interface {
	isTableReference()
}

//	If present, a reference to the Athena table referred to by this table
//
// reference.
type TableReferenceMemberAthena struct {
	Value AthenaTableReference

	noSmithyDocumentSerde
}

func (*TableReferenceMemberAthena) isTableReference() {}

// If present, a reference to the Glue table referred to by this table reference.
type TableReferenceMemberGlue struct {
	Value GlueTableReference

	noSmithyDocumentSerde
}

func (*TableReferenceMemberGlue) isTableReference() {}

//	If present, a reference to the Snowflake table referred to by this table
//
// reference.
type TableReferenceMemberSnowflake struct {
	Value SnowflakeTableReference

	noSmithyDocumentSerde
}

func (*TableReferenceMemberSnowflake) isTableReference() {}

// Describes validation errors for specific input parameters.
type ValidationExceptionField struct {

	// A message for the input validation error.
	//
	// This member is required.
	Message *string

	// The name of the input parameter.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

//	The configuration of the compute resources for workers running an analysis
//
// with the Clean Rooms SQL analytics engine.
type WorkerComputeConfiguration struct {

	//  The number of workers.
	//
	// SQL queries support a minimum value of 2 and a maximum value of 400.
	//
	// PySpark jobs support a minimum value of 4 and a maximum value of 128.
	Number *int32

	// The configuration properties for the worker compute environment. These
	// properties allow you to customize the compute settings for your Clean Rooms
	// workloads.
	Properties WorkerComputeConfigurationProperties

	//  The worker compute configuration type.
	Type WorkerComputeType

	noSmithyDocumentSerde
}

// The configuration properties that define the compute environment settings for
// workers in Clean Rooms. These properties enable customization of the underlying
// compute environment to optimize performance for your specific workloads.
//
// The following types satisfy this interface:
//
//	WorkerComputeConfigurationPropertiesMemberSpark
type WorkerComputeConfigurationProperties interface {
	isWorkerComputeConfigurationProperties()
}

// The Spark configuration properties for SQL workloads. This map contains
// key-value pairs that configure Apache Spark settings to optimize performance for
// your data processing jobs. You can specify up to 50 Spark properties, with each
// key being 1-200 characters and each value being 0-500 characters. These
// properties allow you to adjust compute capacity for large datasets and complex
// workloads.
type WorkerComputeConfigurationPropertiesMemberSpark struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*WorkerComputeConfigurationPropertiesMemberSpark) isWorkerComputeConfigurationProperties() {}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAnalysisRulePolicy()                                  {}
func (*UnknownUnionMember) isAnalysisRulePolicyV1()                                {}
func (*UnknownUnionMember) isAnalysisSource()                                      {}
func (*UnknownUnionMember) isAnalysisSourceMetadata()                              {}
func (*UnknownUnionMember) isChangeSpecification()                                 {}
func (*UnknownUnionMember) isComputeConfiguration()                                {}
func (*UnknownUnionMember) isConfigurationDetails()                                {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicy()                   {}
func (*UnknownUnionMember) isConfiguredTableAnalysisRulePolicyV1()                 {}
func (*UnknownUnionMember) isConfiguredTableAssociationAnalysisRulePolicy()        {}
func (*UnknownUnionMember) isConfiguredTableAssociationAnalysisRulePolicyV1()      {}
func (*UnknownUnionMember) isConsolidatedPolicy()                                  {}
func (*UnknownUnionMember) isConsolidatedPolicyV1()                                {}
func (*UnknownUnionMember) isMembershipProtectedJobOutputConfiguration()           {}
func (*UnknownUnionMember) isMembershipProtectedQueryOutputConfiguration()         {}
func (*UnknownUnionMember) isPreviewPrivacyImpactParametersInput()                 {}
func (*UnknownUnionMember) isPrivacyBudget()                                       {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateParametersInput()                {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateParametersOutput()               {}
func (*UnknownUnionMember) isPrivacyBudgetTemplateUpdateParameters()               {}
func (*UnknownUnionMember) isPrivacyImpact()                                       {}
func (*UnknownUnionMember) isProtectedJobComputeConfiguration()                    {}
func (*UnknownUnionMember) isProtectedJobConfigurationDetails()                    {}
func (*UnknownUnionMember) isProtectedJobOutput()                                  {}
func (*UnknownUnionMember) isProtectedJobOutputConfigurationInput()                {}
func (*UnknownUnionMember) isProtectedJobOutputConfigurationOutput()               {}
func (*UnknownUnionMember) isProtectedQueryDistributeOutputConfigurationLocation() {}
func (*UnknownUnionMember) isProtectedQueryOutput()                                {}
func (*UnknownUnionMember) isProtectedQueryOutputConfiguration()                   {}
func (*UnknownUnionMember) isQueryConstraint()                                     {}
func (*UnknownUnionMember) isSchemaTypeProperties()                                {}
func (*UnknownUnionMember) isSnowflakeTableSchema()                                {}
func (*UnknownUnionMember) isSyntheticDataParameters()                             {}
func (*UnknownUnionMember) isTableReference()                                      {}
func (*UnknownUnionMember) isWorkerComputeConfigurationProperties()                {}
