// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A time range with a start and end time.
type ActiveTimeRange struct {

	// The inclusive time range start date.
	//
	// This member is required.
	ActiveAfterInclusive *time.Time

	//  The inclusive time range end date.
	//
	// This member is required.
	ActiveBeforeInclusive *time.Time

	noSmithyDocumentSerde
}

// The metadata associated to the billing view.
type BillingViewElement struct {

	//  The Amazon Resource Name (ARN) that can be used to uniquely identify the
	// billing view.
	Arn *string

	// The type of billing group.
	BillingViewType BillingViewType

	// The time when the billing view was created.
	CreatedAt *time.Time

	//  See [Expression]. Billing view only supports LINKED_ACCOUNT and Tags .
	//
	// [Expression]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html
	DataFilterExpression *Expression

	//  The number of billing views that use this billing view as a source.
	DerivedViewCount *int32

	//  The description of the billing view.
	Description *string

	//  The current health status of the billing view.
	HealthStatus *BillingViewHealthStatus

	//  The account name of the billing view.
	Name *string

	// The account owner of the billing view.
	OwnerAccountId *string

	//  The Amazon Web Services account ID that owns the source billing view, if this
	// is a derived billing view.
	SourceAccountId *string

	//  The number of source views associated with this billing view.
	SourceViewCount *int32

	// The time when the billing view was last updated.
	UpdatedAt *time.Time

	//  The timestamp of when the billing view definition was last updated.
	ViewDefinitionLastUpdatedAt *time.Time

	noSmithyDocumentSerde
}

//	Represents the health status of a billing view, including a status code and
//
// optional reasons for the status.
type BillingViewHealthStatus struct {

	// The current health status code of the billing view.
	StatusCode BillingViewStatus

	// A list of reasons explaining the current health status, if applicable.
	StatusReasons []BillingViewStatusReason

	noSmithyDocumentSerde
}

// A representation of a billing view.
type BillingViewListElement struct {

	// The Amazon Resource Name (ARN) that can be used to uniquely identify the
	// billing view.
	Arn *string

	// The type of billing view.
	BillingViewType BillingViewType

	//  The description of the billing view.
	Description *string

	//  The current health status of the billing view.
	HealthStatus *BillingViewHealthStatus

	//  A list of names of the Billing view.
	Name *string

	//  The list of owners of the Billing view.
	OwnerAccountId *string

	//  The Amazon Web Services account ID that owns the source billing view, if this
	// is a derived billing view.
	SourceAccountId *string

	noSmithyDocumentSerde
}

// The metadata that you can use to filter and group your results.
type DimensionValues struct {

	//  The names of the metadata types that you can use to filter and group your
	// results.
	//
	// This member is required.
	Key Dimension

	//  The metadata values that you can use to filter and group your results.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

//	See [Expression]. Billing view only supports LINKED_ACCOUNT and Tags .
//
// [Expression]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_billing_Expression.html
type Expression struct {

	//  The specific Dimension to use for Expression .
	Dimensions *DimensionValues

	//  The specific Tag to use for Expression .
	Tags *TagValues

	//  Specifies a time range filter for the billing view data.
	TimeRange *TimeRange

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type ResourceTag struct {

	//  The key that's associated with the tag.
	//
	// This member is required.
	Key *string

	//  The value that's associated with the tag.
	Value *string

	noSmithyDocumentSerde
}

//	A structure that defines how to search for string values. You can specify a
//
// search option and the value to search for.
type StringSearch struct {

	//  The type of search operation to perform on the string value. Determines how
	// the search value is matched against the target field.
	//
	// This member is required.
	SearchOption SearchOption

	//  The string value to use in the search operation. This value is compared
	// against the target field using the specified search option.
	//
	// This member is required.
	SearchValue *string

	noSmithyDocumentSerde
}

// The values that are available for a tag.
type TagValues struct {

	//  The key for the tag.
	//
	// This member is required.
	Key *string

	//  The specific value of the tag.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Specifies a time range with inclusive begin and end dates.
type TimeRange struct {

	//  The inclusive start date of the time range.
	BeginDateInclusive *time.Time

	//  The inclusive end date of the time range.
	EndDateInclusive *time.Time

	noSmithyDocumentSerde
}

// The field's information of a request that resulted in an exception.
type ValidationExceptionField struct {

	// The message describing why the field failed validation.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
