// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockdataautomationruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockdataautomationruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Sync API: Invoke data automation.
func (c *Client) InvokeDataAutomation(ctx context.Context, params *InvokeDataAutomationInput, optFns ...func(*Options)) (*InvokeDataAutomationOutput, error) {
	if params == nil {
		params = &InvokeDataAutomationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeDataAutomation", params, optFns, c.addOperationInvokeDataAutomationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeDataAutomationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Invoke Data Automation Request
type InvokeDataAutomationInput struct {

	// Data automation profile ARN
	//
	// This member is required.
	DataAutomationProfileArn *string

	// Input configuration.
	//
	// This member is required.
	InputConfiguration *types.SyncInputConfiguration

	// Blueprint list.
	Blueprints []types.Blueprint

	// Data automation configuration.
	DataAutomationConfiguration *types.DataAutomationConfiguration

	// Encryption configuration.
	EncryptionConfiguration *types.EncryptionConfiguration

	noSmithyDocumentSerde
}

// Invoke Data Automation Response
type InvokeDataAutomationOutput struct {

	// List of outputs for each logical sub-doc
	//
	// This member is required.
	OutputSegments []types.OutputSegment

	// Detected semantic modality
	//
	// This member is required.
	SemanticModality types.SemanticModality

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationInvokeDataAutomationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpInvokeDataAutomation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpInvokeDataAutomation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeDataAutomation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpInvokeDataAutomationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeDataAutomation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opInvokeDataAutomation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeDataAutomation",
	}
}
