// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an execution of an Amazon Bedrock flow. Unlike flows that run until
// completion or time out after five minutes, flow executions let you run flows
// asynchronously for longer durations. Flow executions also yield control so that
// your application can perform other tasks.
//
// This operation returns an Amazon Resource Name (ARN) that you can use to track
// and manage your flow execution.
//
// Flow executions is in preview release for Amazon Bedrock and is subject to
// change.
func (c *Client) StartFlowExecution(ctx context.Context, params *StartFlowExecutionInput, optFns ...func(*Options)) (*StartFlowExecutionOutput, error) {
	if params == nil {
		params = &StartFlowExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartFlowExecution", params, optFns, c.addOperationStartFlowExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartFlowExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartFlowExecutionInput struct {

	// The unique identifier of the flow alias to use for the flow execution.
	//
	// This member is required.
	FlowAliasIdentifier *string

	// The unique identifier of the flow to execute.
	//
	// This member is required.
	FlowIdentifier *string

	// The input data required for the flow execution. This must match the input
	// schema defined in the flow.
	//
	// This member is required.
	Inputs []types.FlowInput

	// The unique name for the flow execution. If you don't provide one, a
	// system-generated name is used.
	FlowExecutionName *string

	// The performance settings for the foundation model used in the flow execution.
	ModelPerformanceConfiguration *types.ModelPerformanceConfiguration

	noSmithyDocumentSerde
}

type StartFlowExecutionOutput struct {

	// The Amazon Resource Name (ARN) that uniquely identifies the flow execution.
	ExecutionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartFlowExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartFlowExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartFlowExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartFlowExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartFlowExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartFlowExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartFlowExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartFlowExecution",
	}
}
