// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing gateway.
func (c *Client) UpdateGateway(ctx context.Context, params *UpdateGatewayInput, optFns ...func(*Options)) (*UpdateGatewayOutput, error) {
	if params == nil {
		params = &UpdateGatewayInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateGateway", params, optFns, c.addOperationUpdateGatewayMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateGatewayOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateGatewayInput struct {

	// The updated authorizer type for the gateway.
	//
	// This member is required.
	AuthorizerType types.AuthorizerType

	// The identifier of the gateway to update.
	//
	// This member is required.
	GatewayIdentifier *string

	// The name of the gateway. This name must be the same as the one when the gateway
	// was created.
	//
	// This member is required.
	Name *string

	// The updated protocol type for the gateway.
	//
	// This member is required.
	ProtocolType types.GatewayProtocolType

	// The updated IAM role ARN that provides permissions for the gateway.
	//
	// This member is required.
	RoleArn *string

	// The updated authorizer configuration for the gateway.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// The updated description for the gateway.
	Description *string

	// The level of detail in error messages returned when invoking the gateway.
	//
	//   - If the value is DEBUG , granular exception messages are returned to help a
	//   user debug the gateway.
	//
	//   - If the value is omitted, a generic error message is returned to the end
	//   user.
	ExceptionLevel types.ExceptionLevel

	// The updated interceptor configurations for the gateway.
	InterceptorConfigurations []types.GatewayInterceptorConfiguration

	// The updated ARN of the KMS key used to encrypt the gateway.
	KmsKeyArn *string

	// The updated policy engine configuration for the gateway. A policy engine is a
	// collection of policies that evaluates and authorizes agent tool calls. When
	// associated with a gateway, the policy engine intercepts all agent requests and
	// determines whether to allow or deny each action based on the defined policies.
	PolicyEngineConfiguration *types.GatewayPolicyEngineConfiguration

	// The configuration for a gateway protocol. This structure defines how the
	// gateway communicates with external services.
	ProtocolConfiguration types.GatewayProtocolConfiguration

	noSmithyDocumentSerde
}

type UpdateGatewayOutput struct {

	// The updated authorizer type for the gateway.
	//
	// This member is required.
	AuthorizerType types.AuthorizerType

	// The timestamp when the gateway was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the updated gateway.
	//
	// This member is required.
	GatewayArn *string

	// The unique identifier of the updated gateway.
	//
	// This member is required.
	GatewayId *string

	// The name of the gateway.
	//
	// This member is required.
	Name *string

	// The updated protocol type for the gateway.
	//
	// This member is required.
	ProtocolType types.GatewayProtocolType

	// The current status of the updated gateway.
	//
	// This member is required.
	Status types.GatewayStatus

	// The timestamp when the gateway was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The updated authorizer configuration for the gateway.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// The updated description of the gateway.
	Description *string

	// The level of detail in error messages returned when invoking the gateway.
	//
	//   - If the value is DEBUG , granular exception messages are returned to help a
	//   user debug the gateway.
	//
	//   - If the value is omitted, a generic error message is returned to the end
	//   user.
	ExceptionLevel types.ExceptionLevel

	// An endpoint for invoking the updated gateway.
	GatewayUrl *string

	// The updated interceptor configurations for the gateway.
	InterceptorConfigurations []types.GatewayInterceptorConfiguration

	// The updated ARN of the KMS key used to encrypt the gateway.
	KmsKeyArn *string

	// The updated policy engine configuration for the gateway.
	PolicyEngineConfiguration *types.GatewayPolicyEngineConfiguration

	// The configuration for a gateway protocol. This structure defines how the
	// gateway communicates with external services.
	ProtocolConfiguration types.GatewayProtocolConfiguration

	// The updated IAM role ARN that provides permissions for the gateway.
	RoleArn *string

	// The reasons for the current status of the updated gateway.
	StatusReasons []string

	// The workload identity details for the updated gateway.
	WorkloadIdentityDetails *types.WorkloadIdentityDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateGatewayMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateGateway{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateGateway{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateGateway"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateGatewayValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateGateway(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateGateway(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateGateway",
	}
}
