// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing Amazon Secure Agent.
func (c *Client) UpdateAgentRuntime(ctx context.Context, params *UpdateAgentRuntimeInput, optFns ...func(*Options)) (*UpdateAgentRuntimeOutput, error) {
	if params == nil {
		params = &UpdateAgentRuntimeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAgentRuntime", params, optFns, c.addOperationUpdateAgentRuntimeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAgentRuntimeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAgentRuntimeInput struct {

	// The updated artifact of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeArtifact types.AgentRuntimeArtifact

	// The unique identifier of the AgentCore Runtime to update.
	//
	// This member is required.
	AgentRuntimeId *string

	// The updated network configuration for the AgentCore Runtime.
	//
	// This member is required.
	NetworkConfiguration *types.NetworkConfiguration

	// The updated IAM role ARN that provides permissions for the AgentCore Runtime.
	//
	// This member is required.
	RoleArn *string

	// The updated authorizer configuration for the AgentCore Runtime.
	AuthorizerConfiguration types.AuthorizerConfiguration

	// A unique, case-sensitive identifier to ensure idempotency of the request.
	ClientToken *string

	// The updated description of the AgentCore Runtime.
	Description *string

	// Updated environment variables to set in the AgentCore Runtime environment.
	EnvironmentVariables map[string]string

	// The updated life cycle configuration for the AgentCore Runtime.
	LifecycleConfiguration *types.LifecycleConfiguration

	// The protocol configuration for an agent runtime. This structure defines how the
	// agent runtime communicates with clients.
	ProtocolConfiguration *types.ProtocolConfiguration

	// The updated configuration for HTTP request headers that will be passed through
	// to the runtime.
	RequestHeaderConfiguration types.RequestHeaderConfiguration

	noSmithyDocumentSerde
}

type UpdateAgentRuntimeOutput struct {

	// The Amazon Resource Name (ARN) of the updated AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The unique identifier of the updated AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeId *string

	// The version of the updated AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeVersion *string

	// The timestamp when the AgentCore Runtime was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The timestamp when the AgentCore Runtime was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The current status of the updated AgentCore Runtime.
	//
	// This member is required.
	Status types.AgentRuntimeStatus

	// The workload identity details for the updated AgentCore Runtime.
	WorkloadIdentityDetails *types.WorkloadIdentityDetails

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAgentRuntimeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAgentRuntime"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateAgentRuntimeMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAgentRuntimeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAgentRuntime(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateAgentRuntime struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateAgentRuntime) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateAgentRuntime) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateAgentRuntimeInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateAgentRuntimeInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateAgentRuntimeMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateAgentRuntime{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateAgentRuntime(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAgentRuntime",
	}
}
