// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of generated policy assets from a policy generation request
// within the AgentCore Policy system. This operation returns the actual Cedar
// policies and related artifacts produced by the AI-powered policy generation
// process, allowing users to review and select from multiple generated policy
// options.
func (c *Client) ListPolicyGenerationAssets(ctx context.Context, params *ListPolicyGenerationAssetsInput, optFns ...func(*Options)) (*ListPolicyGenerationAssetsOutput, error) {
	if params == nil {
		params = &ListPolicyGenerationAssetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPolicyGenerationAssets", params, optFns, c.addOperationListPolicyGenerationAssetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPolicyGenerationAssetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPolicyGenerationAssetsInput struct {

	// The unique identifier of the policy engine associated with the policy
	// generation request. This provides the context for the generation operation and
	// ensures assets are retrieved from the correct policy engine.
	//
	// This member is required.
	PolicyEngineId *string

	// The unique identifier of the policy generation request whose assets are to be
	// retrieved. This must be a valid generation ID from a previous [StartPolicyGeneration]call that has
	// completed processing.
	//
	// [StartPolicyGeneration]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_StartPolicyGeneration.html
	//
	// This member is required.
	PolicyGenerationId *string

	// The maximum number of policy generation assets to return in a single response.
	// If not specified, the default is 10 assets per page, with a maximum of 100 per
	// page. This helps control response size when dealing with policy generations that
	// produce many alternative policy options.
	MaxResults *int32

	// A pagination token returned from a previous [ListPolicyGenerationAssets] call. Use this token to retrieve
	// the next page of assets when the response is paginated due to large numbers of
	// generated policy options.
	//
	// [ListPolicyGenerationAssets]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_ListPolicyGenerationAssets.html
	NextToken *string

	noSmithyDocumentSerde
}

type ListPolicyGenerationAssetsOutput struct {

	// A pagination token that can be used in subsequent [ListPolicyGenerationAssets] calls to retrieve additional
	// assets. This token is only present when there are more generated policy assets
	// available beyond the current response.
	//
	// [ListPolicyGenerationAssets]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/API_ListPolicyGenerationAssets.html
	NextToken *string

	// An array of generated policy assets including Cedar policies and related
	// artifacts from the AI-powered policy generation process. Each asset represents a
	// different policy option or variation generated from the original natural
	// language input.
	PolicyGenerationAssets []types.PolicyGenerationAsset

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPolicyGenerationAssetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPolicyGenerationAssets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPolicyGenerationAssets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPolicyGenerationAssets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPolicyGenerationAssetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPolicyGenerationAssets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPolicyGenerationAssetsPaginatorOptions is the paginator options for
// ListPolicyGenerationAssets
type ListPolicyGenerationAssetsPaginatorOptions struct {
	// The maximum number of policy generation assets to return in a single response.
	// If not specified, the default is 10 assets per page, with a maximum of 100 per
	// page. This helps control response size when dealing with policy generations that
	// produce many alternative policy options.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPolicyGenerationAssetsPaginator is a paginator for
// ListPolicyGenerationAssets
type ListPolicyGenerationAssetsPaginator struct {
	options   ListPolicyGenerationAssetsPaginatorOptions
	client    ListPolicyGenerationAssetsAPIClient
	params    *ListPolicyGenerationAssetsInput
	nextToken *string
	firstPage bool
}

// NewListPolicyGenerationAssetsPaginator returns a new
// ListPolicyGenerationAssetsPaginator
func NewListPolicyGenerationAssetsPaginator(client ListPolicyGenerationAssetsAPIClient, params *ListPolicyGenerationAssetsInput, optFns ...func(*ListPolicyGenerationAssetsPaginatorOptions)) *ListPolicyGenerationAssetsPaginator {
	if params == nil {
		params = &ListPolicyGenerationAssetsInput{}
	}

	options := ListPolicyGenerationAssetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPolicyGenerationAssetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPolicyGenerationAssetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPolicyGenerationAssets page.
func (p *ListPolicyGenerationAssetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPolicyGenerationAssetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPolicyGenerationAssets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPolicyGenerationAssetsAPIClient is a client that implements the
// ListPolicyGenerationAssets operation.
type ListPolicyGenerationAssetsAPIClient interface {
	ListPolicyGenerationAssets(context.Context, *ListPolicyGenerationAssetsInput, ...func(*Options)) (*ListPolicyGenerationAssetsOutput, error)
}

var _ ListPolicyGenerationAssetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPolicyGenerationAssets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPolicyGenerationAssets",
	}
}
