// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Amazon Secure Agents in your account.
func (c *Client) ListAgentRuntimes(ctx context.Context, params *ListAgentRuntimesInput, optFns ...func(*Options)) (*ListAgentRuntimesOutput, error) {
	if params == nil {
		params = &ListAgentRuntimesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAgentRuntimes", params, optFns, c.addOperationListAgentRuntimesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAgentRuntimesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAgentRuntimesInput struct {

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAgentRuntimesOutput struct {

	// The list of AgentCore Runtime resources.
	//
	// This member is required.
	AgentRuntimes []types.AgentRuntime

	// A token to retrieve the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAgentRuntimesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAgentRuntimes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAgentRuntimes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAgentRuntimes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAgentRuntimes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAgentRuntimesPaginatorOptions is the paginator options for ListAgentRuntimes
type ListAgentRuntimesPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAgentRuntimesPaginator is a paginator for ListAgentRuntimes
type ListAgentRuntimesPaginator struct {
	options   ListAgentRuntimesPaginatorOptions
	client    ListAgentRuntimesAPIClient
	params    *ListAgentRuntimesInput
	nextToken *string
	firstPage bool
}

// NewListAgentRuntimesPaginator returns a new ListAgentRuntimesPaginator
func NewListAgentRuntimesPaginator(client ListAgentRuntimesAPIClient, params *ListAgentRuntimesInput, optFns ...func(*ListAgentRuntimesPaginatorOptions)) *ListAgentRuntimesPaginator {
	if params == nil {
		params = &ListAgentRuntimesInput{}
	}

	options := ListAgentRuntimesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAgentRuntimesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAgentRuntimesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAgentRuntimes page.
func (p *ListAgentRuntimesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAgentRuntimesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAgentRuntimes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAgentRuntimesAPIClient is a client that implements the ListAgentRuntimes
// operation.
type ListAgentRuntimesAPIClient interface {
	ListAgentRuntimes(context.Context, *ListAgentRuntimesInput, ...func(*Options)) (*ListAgentRuntimesOutput, error)
}

var _ ListAgentRuntimesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAgentRuntimes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAgentRuntimes",
	}
}
