// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about an Amazon Secure AgentEndpoint.
func (c *Client) GetAgentRuntimeEndpoint(ctx context.Context, params *GetAgentRuntimeEndpointInput, optFns ...func(*Options)) (*GetAgentRuntimeEndpointOutput, error) {
	if params == nil {
		params = &GetAgentRuntimeEndpointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAgentRuntimeEndpoint", params, optFns, c.addOperationGetAgentRuntimeEndpointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAgentRuntimeEndpointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAgentRuntimeEndpointInput struct {

	// The unique identifier of the AgentCore Runtime associated with the endpoint.
	//
	// This member is required.
	AgentRuntimeId *string

	// The name of the AgentCore Runtime endpoint to retrieve.
	//
	// This member is required.
	EndpointName *string

	noSmithyDocumentSerde
}

type GetAgentRuntimeEndpointOutput struct {

	// The Amazon Resource Name (ARN) of the AgentCore Runtime.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The Amazon Resource Name (ARN) of the AgentCore Runtime endpoint.
	//
	// This member is required.
	AgentRuntimeEndpointArn *string

	// The timestamp when the AgentCore Runtime endpoint was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the AgentCore Runtime endpoint.
	//
	// This member is required.
	Id *string

	// The timestamp when the AgentCore Runtime endpoint was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The name of the AgentCore Runtime endpoint.
	//
	// This member is required.
	Name *string

	// The current status of the AgentCore Runtime endpoint.
	//
	// This member is required.
	Status types.AgentRuntimeEndpointStatus

	// The description of the AgentCore Runtime endpoint.
	Description *string

	// The reason for failure if the AgentCore Runtime endpoint is in a failed state.
	FailureReason *string

	// The currently deployed version of the AgentCore Runtime on the endpoint.
	LiveVersion *string

	// The target version of the AgentCore Runtime for the endpoint.
	TargetVersion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAgentRuntimeEndpointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAgentRuntimeEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAgentRuntimeEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAgentRuntimeEndpoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetAgentRuntimeEndpointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAgentRuntimeEndpoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAgentRuntimeEndpoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAgentRuntimeEndpoint",
	}
}
