// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcorecontrol

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentcorecontrol/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a target for a gateway. A target defines an endpoint that the gateway
// can connect to.
func (c *Client) CreateGatewayTarget(ctx context.Context, params *CreateGatewayTargetInput, optFns ...func(*Options)) (*CreateGatewayTargetOutput, error) {
	if params == nil {
		params = &CreateGatewayTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGatewayTarget", params, optFns, c.addOperationCreateGatewayTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGatewayTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGatewayTargetInput struct {

	// The identifier of the gateway to create a target for.
	//
	// This member is required.
	GatewayIdentifier *string

	// The name of the gateway target. The name must be unique within the gateway.
	//
	// This member is required.
	Name *string

	// The configuration settings for the target, including endpoint information and
	// schema definitions.
	//
	// This member is required.
	TargetConfiguration types.TargetConfiguration

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If you don't specify this field, a value is randomly
	// generated for you. If this token matches a previous request, the service ignores
	// the request, but doesn't return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// The credential provider configurations for the target. These configurations
	// specify how the gateway authenticates with the target endpoint.
	CredentialProviderConfigurations []types.CredentialProviderConfiguration

	// The description of the gateway target.
	Description *string

	noSmithyDocumentSerde
}

type CreateGatewayTargetOutput struct {

	// The timestamp when the target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The credential provider configurations for the target.
	//
	// This member is required.
	CredentialProviderConfigurations []types.CredentialProviderConfiguration

	// The Amazon Resource Name (ARN) of the gateway.
	//
	// This member is required.
	GatewayArn *string

	// The name of the target.
	//
	// This member is required.
	Name *string

	// The current status of the target.
	//
	// This member is required.
	Status types.TargetStatus

	// The configuration settings for the target.
	//
	// This member is required.
	TargetConfiguration types.TargetConfiguration

	// The unique identifier of the created target.
	//
	// This member is required.
	TargetId *string

	// The timestamp when the target was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the target.
	Description *string

	// The last synchronization of the target.
	LastSynchronizedAt *time.Time

	// The reasons for the current status of the target.
	StatusReasons []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGatewayTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGatewayTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGatewayTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGatewayTarget"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateGatewayTargetMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGatewayTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGatewayTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateGatewayTarget struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateGatewayTarget) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateGatewayTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateGatewayTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateGatewayTargetInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateGatewayTargetMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateGatewayTarget{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateGatewayTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGatewayTarget",
	}
}
