// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentcore

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
)

// Sends a request to an agent or tool hosted in an Amazon Bedrock AgentCore
// Runtime and receives responses in real-time.
//
// To invoke an agent you must specify the AgentCore Runtime ARN and provide a
// payload containing your request. You can optionally specify a qualifier to
// target a specific version or endpoint of the agent.
//
// This operation supports streaming responses, allowing you to receive partial
// responses as they become available. We recommend using pagination to ensure that
// the operation returns quickly and successfully when processing large responses.
//
// For example code, see [Invoke an AgentCore Runtime agent].
//
// If you're integrating your agent with OAuth, you can't use the Amazon Web
// Services SDK to call InvokeAgentRuntime . Instead, make a HTTPS request to
// InvokeAgentRuntime . For an example, see [Authenticate and authorize with Inbound Auth and Outbound Auth].
//
// To use this operation, you must have the bedrock-agentcore:InvokeAgentRuntime
// permission. If you are making a call to InvokeAgentRuntime on behalf of a user
// ID with the X-Amzn-Bedrock-AgentCore-Runtime-User-Id header, You require
// permissions to both actions ( bedrock-agentcore:InvokeAgentRuntime and
// bedrock-agentcore:InvokeAgentRuntimeForUser ).
//
// [Invoke an AgentCore Runtime agent]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-invoke-agent.html
// [Authenticate and authorize with Inbound Auth and Outbound Auth]: https://docs.aws.amazon.com/bedrock-agentcore/latest/devguide/runtime-oauth.html
func (c *Client) InvokeAgentRuntime(ctx context.Context, params *InvokeAgentRuntimeInput, optFns ...func(*Options)) (*InvokeAgentRuntimeOutput, error) {
	if params == nil {
		params = &InvokeAgentRuntimeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "InvokeAgentRuntime", params, optFns, c.addOperationInvokeAgentRuntimeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*InvokeAgentRuntimeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type InvokeAgentRuntimeInput struct {

	// The Amazon Web Services Resource Name (ARN) of the agent runtime to invoke. The
	// ARN uniquely identifies the agent runtime resource in Amazon Bedrock.
	//
	// This member is required.
	AgentRuntimeArn *string

	// The input data to send to the agent runtime. The format of this data depends on
	// the specific agent configuration and must match the specified content type. For
	// most agents, this is a JSON object containing the user's request.
	//
	// This member is required.
	Payload []byte

	// The desired MIME type for the response from the agent runtime. This tells the
	// agent runtime what format to use for the response data. Common values include
	// application/json for JSON data.
	Accept *string

	// The identifier of the Amazon Web Services account for the agent runtime
	// resource.
	AccountId *string

	// Additional context information for distributed tracing.
	Baggage *string

	// The MIME type of the input data in the payload. This tells the agent runtime
	// how to interpret the payload data. Common values include application/json for
	// JSON data.
	ContentType *string

	// The version of the MCP protocol being used.
	McpProtocolVersion *string

	// The identifier of the MCP session.
	McpSessionId *string

	// The qualifier to use for the agent runtime. This can be a version number or an
	// endpoint name that points to a specific version. If not specified, Amazon
	// Bedrock uses the default version of the agent runtime.
	Qualifier *string

	// The identifier of the runtime session.
	RuntimeSessionId *string

	// The identifier of the runtime user.
	RuntimeUserId *string

	// The trace identifier for request tracking.
	TraceId *string

	// The parent trace information for distributed tracing.
	TraceParent *string

	// The trace state information for distributed tracing.
	TraceState *string

	noSmithyDocumentSerde
}

type InvokeAgentRuntimeOutput struct {

	// The MIME type of the response data. This indicates how to interpret the
	// response data. Common values include application/json for JSON data.
	//
	// This member is required.
	ContentType *string

	// Additional context information for distributed tracing.
	Baggage *string

	// The version of the MCP protocol being used.
	McpProtocolVersion *string

	// The identifier of the MCP session.
	McpSessionId *string

	// The response data from the agent runtime. The format of this data depends on
	// the specific agent configuration and the requested accept type. For most agents,
	// this is a JSON object containing the agent's response to the user's request.
	Response io.ReadCloser

	// The identifier of the runtime session.
	RuntimeSessionId *string

	// The HTTP status code of the response. A status code of 200 indicates a
	// successful operation. Other status codes indicate various error conditions.
	StatusCode *int32

	// The trace identifier for request tracking.
	TraceId *string

	// The parent trace information for distributed tracing.
	TraceParent *string

	// The trace state information for distributed tracing.
	TraceState *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationInvokeAgentRuntimeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpInvokeAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpInvokeAgentRuntime{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "InvokeAgentRuntime"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opInvokeAgentRuntimeMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpInvokeAgentRuntimeValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opInvokeAgentRuntime(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpInvokeAgentRuntime struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpInvokeAgentRuntime) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpInvokeAgentRuntime) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*InvokeAgentRuntimeInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *InvokeAgentRuntimeInput ")
	}

	if input.RuntimeSessionId == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.RuntimeSessionId = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opInvokeAgentRuntimeMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpInvokeAgentRuntime{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opInvokeAgentRuntime(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "InvokeAgentRuntime",
	}
}
