// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrock/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Account-level enforced guardrail input configuration.
type AccountEnforcedGuardrailInferenceInputConfiguration struct {

	// Identifier for the guardrail, could be the ID or the ARN.
	//
	// This member is required.
	GuardrailIdentifier *string

	// Numerical guardrail version.
	//
	// This member is required.
	GuardrailVersion *string

	// Whether to honor or ignore input tags at runtime.
	//
	// This member is required.
	InputTags InputTags

	noSmithyDocumentSerde
}

// Account enforced guardrail output configuration.
type AccountEnforcedGuardrailOutputConfiguration struct {

	// Unique ID for the account enforced configuration.
	ConfigId *string

	// Timestamp.
	CreatedAt *time.Time

	// The ARN of the role used to update the configuration.
	CreatedBy *string

	// ARN representation for the guardrail.
	GuardrailArn *string

	// Unique ID for the guardrail.
	GuardrailId *string

	// Numerical guardrail version.
	GuardrailVersion *string

	// Whether to honor or ignore input tags at runtime.
	InputTags InputTags

	// Configuration owner type.
	Owner ConfigurationOwner

	// Timestamp.
	UpdatedAt *time.Time

	// The ARN of the role used to update the configuration.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// Information about the agreement availability
type AgreementAvailability struct {

	// Status of the agreement.
	//
	// This member is required.
	Status AgreementStatus

	// Error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// The configuration details of an automated evaluation job. The
// EvaluationDatasetMetricConfig object is used to specify the prompt datasets,
// task type, and metric names.
type AutomatedEvaluationConfig struct {

	// Configuration details of the prompt datasets and metrics you want to use for
	// your evaluation job.
	//
	// This member is required.
	DatasetMetricConfigs []EvaluationDatasetMetricConfig

	// Defines the configuration of custom metrics to be used in an evaluation job.
	CustomMetricConfig *AutomatedEvaluationCustomMetricConfig

	// Contains the evaluator model configuration details. EvaluatorModelConfig is
	// required for evaluation jobs that use a knowledge base or in model evaluation
	// job that use a model as judge. This model computes all evaluation related
	// metrics.
	EvaluatorModelConfig EvaluatorModelConfig

	noSmithyDocumentSerde
}

// Defines the configuration of custom metrics to be used in an evaluation job. To
// learn more about using custom metrics in Amazon Bedrock evaluation jobs, see [Create a prompt for a custom metrics (LLM-as-a-judge model evaluations)]
// and [Create a prompt for a custom metrics (RAG evaluations)].
//
// [Create a prompt for a custom metrics (RAG evaluations)]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-evaluation-custom-metrics-prompt-formats.html
// [Create a prompt for a custom metrics (LLM-as-a-judge model evaluations)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-custom-metrics-prompt-formats.html
type AutomatedEvaluationCustomMetricConfig struct {

	// Defines a list of custom metrics to be used in an Amazon Bedrock evaluation job.
	//
	// This member is required.
	CustomMetrics []AutomatedEvaluationCustomMetricSource

	// Configuration of the evaluator model you want to use to evaluate custom metrics
	// in an Amazon Bedrock evaluation job.
	//
	// This member is required.
	EvaluatorModelConfig *CustomMetricEvaluatorModelConfig

	noSmithyDocumentSerde
}

// An array item definining a single custom metric for use in an Amazon Bedrock
// evaluation job.
//
// The following types satisfy this interface:
//
//	AutomatedEvaluationCustomMetricSourceMemberCustomMetricDefinition
type AutomatedEvaluationCustomMetricSource interface {
	isAutomatedEvaluationCustomMetricSource()
}

// The definition of a custom metric for use in an Amazon Bedrock evaluation job.
type AutomatedEvaluationCustomMetricSourceMemberCustomMetricDefinition struct {
	Value CustomMetricDefinition

	noSmithyDocumentSerde
}

func (*AutomatedEvaluationCustomMetricSourceMemberCustomMetricDefinition) isAutomatedEvaluationCustomMetricSource() {
}

// Represents the result of an Automated Reasoning validation check, indicating
// whether the content is logically valid, invalid, or falls into other categories
// based on the policy rules.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningCheckFindingMemberImpossible
//	AutomatedReasoningCheckFindingMemberInvalid
//	AutomatedReasoningCheckFindingMemberNoTranslations
//	AutomatedReasoningCheckFindingMemberSatisfiable
//	AutomatedReasoningCheckFindingMemberTooComplex
//	AutomatedReasoningCheckFindingMemberTranslationAmbiguous
//	AutomatedReasoningCheckFindingMemberValid
type AutomatedReasoningCheckFinding interface {
	isAutomatedReasoningCheckFinding()
}

// Indicates that Automated Reasoning cannot make a statement about the claims.
// This can happen if the premises are logically incorrect, or if there is a
// conflict within the Automated Reasoning policy itself.
type AutomatedReasoningCheckFindingMemberImpossible struct {
	Value AutomatedReasoningCheckImpossibleFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberImpossible) isAutomatedReasoningCheckFinding() {}

// Indicates that the claims are false. The claims are not implied by the premises
// and Automated Reasoning policy. Furthermore, there exist different claims that
// are consistent with the premises and Automated Reasoning policy.
type AutomatedReasoningCheckFindingMemberInvalid struct {
	Value AutomatedReasoningCheckInvalidFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberInvalid) isAutomatedReasoningCheckFinding() {}

// Identifies that some or all of the input prompt wasn't translated into logic.
// This can happen if the input isn't relevant to the Automated Reasoning policy,
// or if the policy doesn't have variables to model relevant input.
type AutomatedReasoningCheckFindingMemberNoTranslations struct {
	Value AutomatedReasoningCheckNoTranslationsFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberNoTranslations) isAutomatedReasoningCheckFinding() {}

// Indicates that the claims can be true or false. It depends on what assumptions
// are made for the claim to be implied from the premises and Automated Reasoning
// policy rules. In this situation, different assumptions can make input claims
// false and alternative claims true.
type AutomatedReasoningCheckFindingMemberSatisfiable struct {
	Value AutomatedReasoningCheckSatisfiableFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberSatisfiable) isAutomatedReasoningCheckFinding() {}

// Indicates that the input contains too much information for Automated Reasoning
// to process within its latency limits.
type AutomatedReasoningCheckFindingMemberTooComplex struct {
	Value AutomatedReasoningCheckTooComplexFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberTooComplex) isAutomatedReasoningCheckFinding() {}

// Indicates that an ambiguity was detected in the translation, making it unsound
// to continue with validity checking. Additional context or follow-up questions
// might be needed to get translation to succeed.
type AutomatedReasoningCheckFindingMemberTranslationAmbiguous struct {
	Value AutomatedReasoningCheckTranslationAmbiguousFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberTranslationAmbiguous) isAutomatedReasoningCheckFinding() {}

// Indicates that the claims are true. The claims are implied by the premises and
// the Automated Reasoning policy. Given the Automated Reasoning policy and
// premises, it is not possible for these claims to be false.
type AutomatedReasoningCheckFindingMemberValid struct {
	Value AutomatedReasoningCheckValidFinding

	noSmithyDocumentSerde
}

func (*AutomatedReasoningCheckFindingMemberValid) isAutomatedReasoningCheckFinding() {}

// Indicates that no valid claims can be made due to logical contradictions in the
// premises or rules.
type AutomatedReasoningCheckImpossibleFinding struct {

	// The automated reasoning policy rules that contradict the claims and/or premises
	// in the input.
	ContradictingRules []AutomatedReasoningCheckRule

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *AutomatedReasoningCheckLogicWarning

	// The logical translation of the input that this finding evaluates.
	Translation *AutomatedReasoningCheckTranslation

	noSmithyDocumentSerde
}

// References a portion of the original input text that corresponds to logical
// elements.
type AutomatedReasoningCheckInputTextReference struct {

	// The specific text from the original input that this reference points to.
	Text *string

	noSmithyDocumentSerde
}

// Indicates that the claims are logically false and contradictory to the
// established rules or premises.
type AutomatedReasoningCheckInvalidFinding struct {

	// The automated reasoning policy rules that contradict the claims in the input.
	ContradictingRules []AutomatedReasoningCheckRule

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *AutomatedReasoningCheckLogicWarning

	// The logical translation of the input that this finding invalidates.
	Translation *AutomatedReasoningCheckTranslation

	noSmithyDocumentSerde
}

// Identifies logical issues in the translated statements that exist independent
// of any policy rules, such as statements that are always true or always false.
type AutomatedReasoningCheckLogicWarning struct {

	// The logical statements that are validated while assuming the policy and
	// premises.
	Claims []AutomatedReasoningLogicStatement

	// The logical statements that serve as premises under which the claims are
	// validated.
	Premises []AutomatedReasoningLogicStatement

	// The category of the detected logical issue, such as statements that are always
	// true or always false.
	Type AutomatedReasoningCheckLogicWarningType

	noSmithyDocumentSerde
}

// Indicates that no relevant logical information could be extracted from the
// input for validation.
type AutomatedReasoningCheckNoTranslationsFinding struct {
	noSmithyDocumentSerde
}

// References a specific automated reasoning policy rule that was applied during
// evaluation.
type AutomatedReasoningCheckRule struct {

	// The unique identifier of the automated reasoning rule.
	Id *string

	// The ARN of the automated reasoning policy version that contains this rule.
	PolicyVersionArn *string

	noSmithyDocumentSerde
}

// Indicates that the claims could be either true or false depending on additional
// assumptions not provided in the input.
type AutomatedReasoningCheckSatisfiableFinding struct {

	// An example scenario demonstrating how the claims could be logically false.
	ClaimsFalseScenario *AutomatedReasoningCheckScenario

	// An example scenario demonstrating how the claims could be logically true.
	ClaimsTrueScenario *AutomatedReasoningCheckScenario

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *AutomatedReasoningCheckLogicWarning

	// The logical translation of the input that this finding evaluates.
	Translation *AutomatedReasoningCheckTranslation

	noSmithyDocumentSerde
}

// Represents a logical scenario where claims can be evaluated as true or false,
// containing specific logical assignments.
type AutomatedReasoningCheckScenario struct {

	// List of logical assignments and statements that define this scenario.
	Statements []AutomatedReasoningLogicStatement

	noSmithyDocumentSerde
}

// Indicates that the input exceeds the processing capacity due to the volume or
// complexity of the logical information.
type AutomatedReasoningCheckTooComplexFinding struct {
	noSmithyDocumentSerde
}

// Contains the logical translation of natural language input into formal logical
// statements, including premises, claims, and confidence scores.
type AutomatedReasoningCheckTranslation struct {

	// The logical statements that are being validated against the premises and policy
	// rules.
	//
	// This member is required.
	Claims []AutomatedReasoningLogicStatement

	// A confidence score between 0 and 1 indicating how certain the system is about
	// the logical translation.
	//
	// This member is required.
	Confidence *float64

	// The logical statements that serve as the foundation or assumptions for the
	// claims.
	Premises []AutomatedReasoningLogicStatement

	// References to portions of the original input text that correspond to the claims
	// but could not be fully translated.
	UntranslatedClaims []AutomatedReasoningCheckInputTextReference

	// References to portions of the original input text that correspond to the
	// premises but could not be fully translated.
	UntranslatedPremises []AutomatedReasoningCheckInputTextReference

	noSmithyDocumentSerde
}

// Indicates that the input has multiple valid logical interpretations, requiring
// additional context or clarification.
type AutomatedReasoningCheckTranslationAmbiguousFinding struct {

	// Scenarios showing how the different translation options differ in meaning.
	DifferenceScenarios []AutomatedReasoningCheckScenario

	// Different logical interpretations that were detected during translation of the
	// input.
	Options []AutomatedReasoningCheckTranslationOption

	noSmithyDocumentSerde
}

// Represents one possible logical interpretation of ambiguous input content.
type AutomatedReasoningCheckTranslationOption struct {

	// Different logical interpretations that were detected during translation of the
	// input.
	Translations []AutomatedReasoningCheckTranslation

	noSmithyDocumentSerde
}

// Indicates that the claims are definitively true and logically implied by the
// premises, with no possible alternative interpretations.
type AutomatedReasoningCheckValidFinding struct {

	// An example scenario demonstrating how the claims are logically true.
	ClaimsTrueScenario *AutomatedReasoningCheckScenario

	// Indication of a logic issue with the translation without needing to consider
	// the automated reasoning policy rules.
	LogicWarning *AutomatedReasoningCheckLogicWarning

	// The automated reasoning policy rules that support why this result is considered
	// valid.
	SupportingRules []AutomatedReasoningCheckRule

	// The logical translation of the input that this finding validates.
	Translation *AutomatedReasoningCheckTranslation

	noSmithyDocumentSerde
}

// Represents a logical statement that can be expressed both in formal logic
// notation and natural language, providing dual representations for better
// understanding and validation.
type AutomatedReasoningLogicStatement struct {

	// The formal logic representation of the statement using mathematical notation
	// and logical operators.
	//
	// This member is required.
	Logic *string

	// The natural language representation of the logical statement, providing a
	// human-readable interpretation of the formal logic.
	NaturalLanguage *string

	noSmithyDocumentSerde
}

// An annotation for adding a new rule to an Automated Reasoning policy using a
// formal logical expression.
type AutomatedReasoningPolicyAddRuleAnnotation struct {

	// The formal logical expression that defines the rule, using mathematical
	// notation and referencing policy variables and types.
	//
	// This member is required.
	Expression *string

	noSmithyDocumentSerde
}

// An annotation for adding a new rule to the policy by converting a natural
// language description into a formal logical expression.
type AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation struct {

	// The natural language description of the rule that should be converted into a
	// formal logical expression.
	//
	// This member is required.
	NaturalLanguage *string

	noSmithyDocumentSerde
}

// A mutation operation that adds a new rule to the policy definition during the
// build process.
type AutomatedReasoningPolicyAddRuleMutation struct {

	// The rule definition that specifies the formal logical expression and metadata
	// for the new rule being added to the policy.
	//
	// This member is required.
	Rule *AutomatedReasoningPolicyDefinitionRule

	noSmithyDocumentSerde
}

// An annotation for adding a new custom type to an Automated Reasoning policy,
// defining a set of possible values for variables.
type AutomatedReasoningPolicyAddTypeAnnotation struct {

	// A description of what the custom type represents and how it should be used in
	// the policy.
	//
	// This member is required.
	Description *string

	// The name of the new custom type. This name will be used to reference the type
	// in variable definitions and rules.
	//
	// This member is required.
	Name *string

	// The list of possible values that variables of this type can take, each with its
	// own description and identifier.
	//
	// This member is required.
	Values []AutomatedReasoningPolicyDefinitionTypeValue

	noSmithyDocumentSerde
}

// A mutation operation that adds a new custom type to the policy definition
// during the build process.
type AutomatedReasoningPolicyAddTypeMutation struct {

	// The type definition that specifies the name, description, and possible values
	// for the new custom type being added to the policy.
	//
	// This member is required.
	Type *AutomatedReasoningPolicyDefinitionType

	noSmithyDocumentSerde
}

// Represents a single value that can be added to an existing custom type in the
// policy.
type AutomatedReasoningPolicyAddTypeValue struct {

	// The identifier or name of the new value to add to the type.
	//
	// This member is required.
	Value *string

	// A description of what this new type value represents and when it should be used.
	Description *string

	noSmithyDocumentSerde
}

// An annotation for adding a new variable to an Automated Reasoning policy, which
// can be used in rule expressions.
type AutomatedReasoningPolicyAddVariableAnnotation struct {

	// A description of what the variable represents and how it should be used in
	// rules.
	//
	// This member is required.
	Description *string

	// The name of the new variable. This name will be used to reference the variable
	// in rule expressions.
	//
	// This member is required.
	Name *string

	// The type of the variable, which can be a built-in type (like string or number)
	// or a custom type defined in the policy.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// A mutation operation that adds a new variable to the policy definition during
// the build process.
type AutomatedReasoningPolicyAddVariableMutation struct {

	// The variable definition that specifies the name, type, and description for the
	// new variable being added to the policy.
	//
	// This member is required.
	Variable *AutomatedReasoningPolicyDefinitionVariable

	noSmithyDocumentSerde
}

// Contains the various operations that can be performed on an Automated Reasoning
// policy, including adding, updating, and deleting rules, variables, and types.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyAnnotationMemberAddRule
//	AutomatedReasoningPolicyAnnotationMemberAddRuleFromNaturalLanguage
//	AutomatedReasoningPolicyAnnotationMemberAddType
//	AutomatedReasoningPolicyAnnotationMemberAddVariable
//	AutomatedReasoningPolicyAnnotationMemberDeleteRule
//	AutomatedReasoningPolicyAnnotationMemberDeleteType
//	AutomatedReasoningPolicyAnnotationMemberDeleteVariable
//	AutomatedReasoningPolicyAnnotationMemberIngestContent
//	AutomatedReasoningPolicyAnnotationMemberUpdateFromRulesFeedback
//	AutomatedReasoningPolicyAnnotationMemberUpdateFromScenarioFeedback
//	AutomatedReasoningPolicyAnnotationMemberUpdateRule
//	AutomatedReasoningPolicyAnnotationMemberUpdateType
//	AutomatedReasoningPolicyAnnotationMemberUpdateVariable
type AutomatedReasoningPolicyAnnotation interface {
	isAutomatedReasoningPolicyAnnotation()
}

// An operation to add a new logical rule to the policy using formal mathematical
// expressions.
type AutomatedReasoningPolicyAnnotationMemberAddRule struct {
	Value AutomatedReasoningPolicyAddRuleAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberAddRule) isAutomatedReasoningPolicyAnnotation() {}

// An operation to add a new rule by converting natural language descriptions into
// formal logical expressions.
type AutomatedReasoningPolicyAnnotationMemberAddRuleFromNaturalLanguage struct {
	Value AutomatedReasoningPolicyAddRuleFromNaturalLanguageAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberAddRuleFromNaturalLanguage) isAutomatedReasoningPolicyAnnotation() {
}

// An operation to add a new custom type to the policy, defining a set of possible
// values for policy variables.
type AutomatedReasoningPolicyAnnotationMemberAddType struct {
	Value AutomatedReasoningPolicyAddTypeAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberAddType) isAutomatedReasoningPolicyAnnotation() {}

// An operation to add a new variable to the policy, which can be used in rule
// expressions to represent dynamic values.
type AutomatedReasoningPolicyAnnotationMemberAddVariable struct {
	Value AutomatedReasoningPolicyAddVariableAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberAddVariable) isAutomatedReasoningPolicyAnnotation() {}

// An operation to remove a rule from the policy.
type AutomatedReasoningPolicyAnnotationMemberDeleteRule struct {
	Value AutomatedReasoningPolicyDeleteRuleAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberDeleteRule) isAutomatedReasoningPolicyAnnotation() {}

// An operation to remove a custom type from the policy. The type must not be
// referenced by any variables or rules.
type AutomatedReasoningPolicyAnnotationMemberDeleteType struct {
	Value AutomatedReasoningPolicyDeleteTypeAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberDeleteType) isAutomatedReasoningPolicyAnnotation() {}

// An operation to remove a variable from the policy. The variable must not be
// referenced by any rules.
type AutomatedReasoningPolicyAnnotationMemberDeleteVariable struct {
	Value AutomatedReasoningPolicyDeleteVariableAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberDeleteVariable) isAutomatedReasoningPolicyAnnotation() {
}

// An operation to process and incorporate new content into the policy, extracting
// additional rules and concepts.
type AutomatedReasoningPolicyAnnotationMemberIngestContent struct {
	Value AutomatedReasoningPolicyIngestContentAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberIngestContent) isAutomatedReasoningPolicyAnnotation() {
}

// An operation to update the policy based on feedback about how specific rules
// performed during testing or validation.
type AutomatedReasoningPolicyAnnotationMemberUpdateFromRulesFeedback struct {
	Value AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberUpdateFromRulesFeedback) isAutomatedReasoningPolicyAnnotation() {
}

// An operation to update the policy based on feedback about how it performed on
// specific test scenarios.
type AutomatedReasoningPolicyAnnotationMemberUpdateFromScenarioFeedback struct {
	Value AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberUpdateFromScenarioFeedback) isAutomatedReasoningPolicyAnnotation() {
}

// An operation to modify an existing rule in the policy, such as changing its
// logical expression or conditions.
type AutomatedReasoningPolicyAnnotationMemberUpdateRule struct {
	Value AutomatedReasoningPolicyUpdateRuleAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberUpdateRule) isAutomatedReasoningPolicyAnnotation() {}

// An operation to modify an existing custom type in the policy, such as changing
// its name, description, or allowed values.
type AutomatedReasoningPolicyAnnotationMemberUpdateType struct {
	Value AutomatedReasoningPolicyUpdateTypeAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberUpdateType) isAutomatedReasoningPolicyAnnotation() {}

// An operation to modify an existing variable in the policy, such as changing its
// name, type, or description.
type AutomatedReasoningPolicyAnnotationMemberUpdateVariable struct {
	Value AutomatedReasoningPolicyUpdateVariableAnnotation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyAnnotationMemberUpdateVariable) isAutomatedReasoningPolicyAnnotation() {
}

// Contains detailed logging information about the policy build process, including
// steps taken, decisions made, and any issues encountered.
type AutomatedReasoningPolicyBuildLog struct {

	// A list of log entries documenting each step in the policy build process,
	// including timestamps, status, and detailed messages.
	//
	// This member is required.
	Entries []AutomatedReasoningPolicyBuildLogEntry

	noSmithyDocumentSerde
}

// Represents a single entry in the policy build log, containing information about
// a specific step or event in the build process.
type AutomatedReasoningPolicyBuildLogEntry struct {

	// The annotation or operation that was being processed when this log entry was
	// created.
	//
	// This member is required.
	Annotation AutomatedReasoningPolicyAnnotation

	// Detailed information about the specific build steps that were executed,
	// including any sub-operations or transformations.
	//
	// This member is required.
	BuildSteps []AutomatedReasoningPolicyBuildStep

	// The status of the build step (e.g., SUCCESS, FAILED, IN_PROGRESS).
	//
	// This member is required.
	Status AutomatedReasoningPolicyAnnotationStatus

	noSmithyDocumentSerde
}

// Contains the various assets generated during a policy build workflow, including
// logs, quality reports, test cases, and the final policy definition.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyBuildResultAssetsMemberBuildLog
//	AutomatedReasoningPolicyBuildResultAssetsMemberGeneratedTestCases
//	AutomatedReasoningPolicyBuildResultAssetsMemberPolicyDefinition
//	AutomatedReasoningPolicyBuildResultAssetsMemberQualityReport
type AutomatedReasoningPolicyBuildResultAssets interface {
	isAutomatedReasoningPolicyBuildResultAssets()
}

// The complete build log containing detailed information about each step in the
// policy generation process.
type AutomatedReasoningPolicyBuildResultAssetsMemberBuildLog struct {
	Value AutomatedReasoningPolicyBuildLog

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildResultAssetsMemberBuildLog) isAutomatedReasoningPolicyBuildResultAssets() {
}

// A comprehensive test suite generated by the build workflow, providing
// validation capabilities for automated reasoning policies.
type AutomatedReasoningPolicyBuildResultAssetsMemberGeneratedTestCases struct {
	Value AutomatedReasoningPolicyGeneratedTestCases

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildResultAssetsMemberGeneratedTestCases) isAutomatedReasoningPolicyBuildResultAssets() {
}

// The complete policy definition generated by the build workflow, containing all
// rules, variables, and custom types extracted from the source documents.
type AutomatedReasoningPolicyBuildResultAssetsMemberPolicyDefinition struct {
	Value AutomatedReasoningPolicyDefinition

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildResultAssetsMemberPolicyDefinition) isAutomatedReasoningPolicyBuildResultAssets() {
}

// A comprehensive report analyzing the quality of the generated policy, including
// metrics about rule coverage, potential conflicts, and unused elements.
type AutomatedReasoningPolicyBuildResultAssetsMemberQualityReport struct {
	Value AutomatedReasoningPolicyDefinitionQualityReport

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildResultAssetsMemberQualityReport) isAutomatedReasoningPolicyBuildResultAssets() {
}

// Represents a single step in the policy build process, containing context about
// what was being processed and any messages or results.
type AutomatedReasoningPolicyBuildStep struct {

	// Contextual information about what was being processed during this build step,
	// such as the type of operation or the source material being analyzed.
	//
	// This member is required.
	Context AutomatedReasoningPolicyBuildStepContext

	// A list of messages generated during this build step, including informational
	// messages, warnings, and error details.
	//
	// This member is required.
	Messages []AutomatedReasoningPolicyBuildStepMessage

	// Reference to the previous element or step in the build process, helping to
	// trace the sequence of operations.
	PriorElement AutomatedReasoningPolicyDefinitionElement

	noSmithyDocumentSerde
}

// Provides context about what type of operation was being performed during a
// build step.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyBuildStepContextMemberMutation
//	AutomatedReasoningPolicyBuildStepContextMemberPlanning
type AutomatedReasoningPolicyBuildStepContext interface {
	isAutomatedReasoningPolicyBuildStepContext()
}

// Indicates that this build step involved modifying the policy structure, such as
// adding or updating rules, variables, or types.
type AutomatedReasoningPolicyBuildStepContextMemberMutation struct {
	Value AutomatedReasoningPolicyMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildStepContextMemberMutation) isAutomatedReasoningPolicyBuildStepContext() {
}

// Indicates that this build step was part of the planning phase, where the system
// determines what operations to perform.
type AutomatedReasoningPolicyBuildStepContextMemberPlanning struct {
	Value AutomatedReasoningPolicyPlanning

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyBuildStepContextMemberPlanning) isAutomatedReasoningPolicyBuildStepContext() {
}

// Represents a message generated during a build step, providing information about
// what happened or any issues encountered.
type AutomatedReasoningPolicyBuildStepMessage struct {

	// The content of the message, describing what occurred during the build step.
	//
	// This member is required.
	Message *string

	// The type of message (e.g., INFO, WARNING, ERROR) indicating its severity and
	// purpose.
	//
	// This member is required.
	MessageType AutomatedReasoningPolicyBuildMessageType

	noSmithyDocumentSerde
}

// Represents a source document used in the policy build workflow, containing the
// content and metadata needed for policy generation.
type AutomatedReasoningPolicyBuildWorkflowDocument struct {

	// The actual content of the source document that will be analyzed to extract
	// policy rules and concepts.
	//
	// This member is required.
	Document []byte

	// The MIME type of the document content (e.g., text/plain, application/pdf,
	// text/markdown).
	//
	// This member is required.
	DocumentContentType AutomatedReasoningPolicyBuildDocumentContentType

	// A descriptive name for the document that helps identify its purpose and content.
	//
	// This member is required.
	DocumentName *string

	// A detailed description of the document's content and how it should be used in
	// the policy generation process.
	DocumentDescription *string

	noSmithyDocumentSerde
}

// Contains content and instructions for repairing or improving an existing
// Automated Reasoning policy.
type AutomatedReasoningPolicyBuildWorkflowRepairContent struct {

	// Specific annotations or modifications to apply during the policy repair
	// process, such as rule corrections or variable updates.
	//
	// This member is required.
	Annotations []AutomatedReasoningPolicyAnnotation

	noSmithyDocumentSerde
}

// Defines the source content for a policy build workflow, which can include
// documents, repair instructions, or other input materials.
type AutomatedReasoningPolicyBuildWorkflowSource struct {

	// An existing policy definition that serves as the starting point for the build
	// workflow, typically used in policy repair or update scenarios.
	PolicyDefinition *AutomatedReasoningPolicyDefinition

	// The actual content to be processed in the build workflow, such as documents to
	// analyze or repair instructions to apply.
	WorkflowContent AutomatedReasoningPolicyWorkflowTypeContent

	noSmithyDocumentSerde
}

// Provides a summary of a policy build workflow, including its current status,
// timing information, and key identifiers.
type AutomatedReasoningPolicyBuildWorkflowSummary struct {

	// The unique identifier of the build workflow.
	//
	// This member is required.
	BuildWorkflowId *string

	// The type of build workflow (e.g., DOCUMENT_INGESTION, POLICY_REPAIR).
	//
	// This member is required.
	BuildWorkflowType AutomatedReasoningPolicyBuildWorkflowType

	// The timestamp when the build workflow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy associated
	// with this build workflow.
	//
	// This member is required.
	PolicyArn *string

	// The current status of the build workflow (e.g., RUNNING, COMPLETED, FAILED,
	// CANCELLED).
	//
	// This member is required.
	Status AutomatedReasoningPolicyBuildWorkflowStatus

	// The timestamp when the build workflow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Contains the formal logic rules, variables, and custom variable types that
// define an Automated Reasoning policy. The policy definition specifies the
// constraints used to validate foundation model responses for accuracy and logical
// consistency.
type AutomatedReasoningPolicyDefinition struct {

	// The formal logic rules extracted from the source document. Rules define the
	// logical constraints that determine whether model responses are valid, invalid,
	// or satisfiable.
	Rules []AutomatedReasoningPolicyDefinitionRule

	// The custom user-defined vairable types used in the policy. Types are enum-based
	// variable types that provide additional context beyond the predefined variable
	// types.
	Types []AutomatedReasoningPolicyDefinitionType

	// The variables that represent concepts in the policy. Variables can have values
	// assigned when translating natural language into formal logic. Their descriptions
	// are crucial for accurate translation.
	Variables []AutomatedReasoningPolicyDefinitionVariable

	// The version of the policy definition format.
	Version *string

	noSmithyDocumentSerde
}

// Represents a single element in an Automated Reasoning policy definition, such
// as a rule, variable, or type definition.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionRule
//	AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionType
//	AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionVariable
type AutomatedReasoningPolicyDefinitionElement interface {
	isAutomatedReasoningPolicyDefinitionElement()
}

// A rule element within the policy definition that contains a formal logical
// expression used for validation.
type AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionRule struct {
	Value AutomatedReasoningPolicyDefinitionRule

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionRule) isAutomatedReasoningPolicyDefinitionElement() {
}

// A custom type element within the policy definition that defines a set of
// possible values for variables.
type AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionType struct {
	Value AutomatedReasoningPolicyDefinitionType

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionType) isAutomatedReasoningPolicyDefinitionElement() {
}

// A variable element within the policy definition that represents a concept used
// in logical expressions and rules.
type AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionVariable struct {
	Value AutomatedReasoningPolicyDefinitionVariable

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyDefinitionElementMemberPolicyDefinitionVariable) isAutomatedReasoningPolicyDefinitionElement() {
}

// Provides a comprehensive analysis of the quality and completeness of an
// Automated Reasoning policy definition, highlighting potential issues and
// optimization opportunities.
type AutomatedReasoningPolicyDefinitionQualityReport struct {

	// A list of rules that may conflict with each other, potentially leading to
	// inconsistent policy behavior.
	//
	// This member is required.
	ConflictingRules []string

	// Groups of rules that operate on completely separate sets of variables,
	// indicating the policy may be addressing multiple unrelated concerns.
	//
	// This member is required.
	DisjointRuleSets []AutomatedReasoningPolicyDisjointRuleSet

	// The total number of rules defined in the policy.
	//
	// This member is required.
	RuleCount *int32

	// The total number of custom types defined in the policy.
	//
	// This member is required.
	TypeCount *int32

	// A list of type values that are defined but never used in any rules, indicating
	// potential cleanup opportunities.
	//
	// This member is required.
	UnusedTypeValues []AutomatedReasoningPolicyDefinitionTypeValuePair

	// A list of custom types that are defined but not referenced by any variables or
	// rules, suggesting they may be unnecessary.
	//
	// This member is required.
	UnusedTypes []string

	// A list of variables that are defined but not referenced by any rules,
	// suggesting they may be unnecessary.
	//
	// This member is required.
	UnusedVariables []string

	// The total number of variables defined in the policy.
	//
	// This member is required.
	VariableCount *int32

	noSmithyDocumentSerde
}

// Represents a formal logic rule in an Automated Reasoning policy. For example,
// rules can be expressed as if-then statements that define logical constraints.
type AutomatedReasoningPolicyDefinitionRule struct {

	// The formal logic expression of the rule.
	//
	// This member is required.
	Expression *string

	// The unique identifier of the rule within the policy.
	//
	// This member is required.
	Id *string

	// The human-readable form of the rule expression, often in natural language or
	// simplified notation.
	AlternateExpression *string

	noSmithyDocumentSerde
}

// Represents a custom user-defined viarble type in an Automated Reasoning policy.
// Types are enum-based and provide additional context beyond predefined variable
// types.
type AutomatedReasoningPolicyDefinitionType struct {

	// The name of the custom type.
	//
	// This member is required.
	Name *string

	// The possible values for this enum-based type, each with its own description.
	//
	// This member is required.
	Values []AutomatedReasoningPolicyDefinitionTypeValue

	// The description of what the custom type represents.
	Description *string

	noSmithyDocumentSerde
}

// Represents a single value within a custom type definition, including its
// identifier and description.
type AutomatedReasoningPolicyDefinitionTypeValue struct {

	// The actual value or identifier for this type value.
	//
	// This member is required.
	Value *string

	// A human-readable description explaining what this type value represents and
	// when it should be used.
	Description *string

	noSmithyDocumentSerde
}

// Associates a type name with a specific value name, used for referencing type
// values in rules and other policy elements.
type AutomatedReasoningPolicyDefinitionTypeValuePair struct {

	// The name of the custom type that contains the referenced value.
	//
	// This member is required.
	TypeName *string

	// The name of the specific value within the type.
	//
	// This member is required.
	ValueName *string

	noSmithyDocumentSerde
}

// Represents a variable in an Automated Reasoning policy. Variables represent
// concepts that can have values assigned during natural language translation.
type AutomatedReasoningPolicyDefinitionVariable struct {

	// The description of the variable that explains what it represents and how users
	// might refer to it. Clear and comprehensive descriptions are essential for
	// accurate natural language translation.
	//
	// This member is required.
	Description *string

	// The name of the variable. Use descriptive names that clearly indicate the
	// concept being represented.
	//
	// This member is required.
	Name *string

	// The data type of the variable. Valid types include bool, int, real, enum, and
	// custom types that you can provide.
	//
	// This member is required.
	Type *string

	noSmithyDocumentSerde
}

// An annotation for removing a rule from an Automated Reasoning policy.
type AutomatedReasoningPolicyDeleteRuleAnnotation struct {

	// The unique identifier of the rule to delete from the policy.
	//
	// This member is required.
	RuleId *string

	noSmithyDocumentSerde
}

// A mutation operation that removes a rule from the policy definition during the
// build process.
type AutomatedReasoningPolicyDeleteRuleMutation struct {

	// The unique identifier of the rule to delete.
	//
	// This member is required.
	Id *string

	noSmithyDocumentSerde
}

// An annotation for removing a custom type from an Automated Reasoning policy.
type AutomatedReasoningPolicyDeleteTypeAnnotation struct {

	// The name of the custom type to delete from the policy. The type must not be
	// referenced by any variables or rules.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A mutation operation that removes a custom type from the policy definition
// during the build process.
type AutomatedReasoningPolicyDeleteTypeMutation struct {

	// The name of the custom type to delete.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents a value to be removed from an existing custom type in the policy.
type AutomatedReasoningPolicyDeleteTypeValue struct {

	// The identifier or name of the value to remove from the type.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// An annotation for removing a variable from an Automated Reasoning policy.
type AutomatedReasoningPolicyDeleteVariableAnnotation struct {

	// The name of the variable to delete from the policy. The variable must not be
	// referenced by any rules.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A mutation operation that removes a variable from the policy definition during
// the build process.
type AutomatedReasoningPolicyDeleteVariableMutation struct {

	// The name of the variable to delete.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Represents a set of rules that operate on completely separate variables,
// indicating they address different concerns or domains within the policy.
type AutomatedReasoningPolicyDisjointRuleSet struct {

	// The list of rules that form this disjoint set, all operating on the same set of
	// variables.
	//
	// This member is required.
	Rules []string

	// The set of variables that are used by the rules in this disjoint set.
	//
	// This member is required.
	Variables []string

	noSmithyDocumentSerde
}

// Represents a generated test case, consisting of query content, guard content,
// and expected results.
type AutomatedReasoningPolicyGeneratedTestCase struct {

	// The expected results of the generated test case. Possible values include:
	//
	//   - VALID - The claims are true. The claims are implied by the premises and the
	//   Automated Reasoning policy. Given the Automated Reasoning policy and premises,
	//   it is not possible for these claims to be false. In other words, there are no
	//   alternative answers that are true that contradict the claims.
	//
	//   - INVALID - The claims are false. The claims are not implied by the premises
	//   and Automated Reasoning policy. Furthermore, there exists different claims that
	//   are consistent with the premises and Automated Reasoning policy.
	//
	//   - SATISFIABLE - The claims can be true or false. It depends on what
	//   assumptions are made for the claim to be implied from the premises and Automated
	//   Reasoning policy rules. In this situation, different assumptions can make input
	//   claims false and alternative claims true.
	//
	//   - IMPOSSIBLE - Automated Reasoning can’t make a statement about the claims.
	//   This can happen if the premises are logically incorrect, or if there is a
	//   conflict within the Automated Reasoning policy itself.
	//
	// This member is required.
	ExpectedAggregatedFindingsResult AutomatedReasoningCheckResult

	// The output content that's validated by the Automated Reasoning policy. This
	// represents the foundation model response that will be checked for accuracy.
	//
	// This member is required.
	GuardContent *string

	// The input query or prompt that generated the content. This provides context for
	// the validation.
	//
	// This member is required.
	QueryContent *string

	noSmithyDocumentSerde
}

// Contains a comprehensive test suite generated by the build workflow, providing
// validation capabilities for automated reasoning policies.
type AutomatedReasoningPolicyGeneratedTestCases struct {

	// Represents a collection of generated test cases.
	//
	// This member is required.
	GeneratedTestCases []AutomatedReasoningPolicyGeneratedTestCase

	noSmithyDocumentSerde
}

// An annotation for processing and incorporating new content into an Automated
// Reasoning policy.
type AutomatedReasoningPolicyIngestContentAnnotation struct {

	// The new content to be analyzed and incorporated into the policy, such as
	// additional documents or rule descriptions.
	//
	// This member is required.
	Content *string

	noSmithyDocumentSerde
}

// A container for various mutation operations that can be applied to an Automated
// Reasoning policy, including adding, updating, and deleting policy elements.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyMutationMemberAddRule
//	AutomatedReasoningPolicyMutationMemberAddType
//	AutomatedReasoningPolicyMutationMemberAddVariable
//	AutomatedReasoningPolicyMutationMemberDeleteRule
//	AutomatedReasoningPolicyMutationMemberDeleteType
//	AutomatedReasoningPolicyMutationMemberDeleteVariable
//	AutomatedReasoningPolicyMutationMemberUpdateRule
//	AutomatedReasoningPolicyMutationMemberUpdateType
//	AutomatedReasoningPolicyMutationMemberUpdateVariable
type AutomatedReasoningPolicyMutation interface {
	isAutomatedReasoningPolicyMutation()
}

// A mutation to add a new rule to the policy.
type AutomatedReasoningPolicyMutationMemberAddRule struct {
	Value AutomatedReasoningPolicyAddRuleMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberAddRule) isAutomatedReasoningPolicyMutation() {}

// A mutation to add a new custom type to the policy.
type AutomatedReasoningPolicyMutationMemberAddType struct {
	Value AutomatedReasoningPolicyAddTypeMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberAddType) isAutomatedReasoningPolicyMutation() {}

// A mutation to add a new variable to the policy.
type AutomatedReasoningPolicyMutationMemberAddVariable struct {
	Value AutomatedReasoningPolicyAddVariableMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberAddVariable) isAutomatedReasoningPolicyMutation() {}

// A mutation to remove a rule from the policy.
type AutomatedReasoningPolicyMutationMemberDeleteRule struct {
	Value AutomatedReasoningPolicyDeleteRuleMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberDeleteRule) isAutomatedReasoningPolicyMutation() {}

// A mutation to remove a custom type from the policy.
type AutomatedReasoningPolicyMutationMemberDeleteType struct {
	Value AutomatedReasoningPolicyDeleteTypeMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberDeleteType) isAutomatedReasoningPolicyMutation() {}

// A mutation to remove a variable from the policy.
type AutomatedReasoningPolicyMutationMemberDeleteVariable struct {
	Value AutomatedReasoningPolicyDeleteVariableMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberDeleteVariable) isAutomatedReasoningPolicyMutation() {}

// A mutation to modify an existing rule in the policy.
type AutomatedReasoningPolicyMutationMemberUpdateRule struct {
	Value AutomatedReasoningPolicyUpdateRuleMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberUpdateRule) isAutomatedReasoningPolicyMutation() {}

// A mutation to modify an existing custom type in the policy.
type AutomatedReasoningPolicyMutationMemberUpdateType struct {
	Value AutomatedReasoningPolicyUpdateTypeMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberUpdateType) isAutomatedReasoningPolicyMutation() {}

// A mutation to modify an existing variable in the policy.
type AutomatedReasoningPolicyMutationMemberUpdateVariable struct {
	Value AutomatedReasoningPolicyUpdateVariableMutation

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyMutationMemberUpdateVariable) isAutomatedReasoningPolicyMutation() {}

// Represents the planning phase of policy build workflow, where the system
// analyzes source content and determines what operations to perform.
type AutomatedReasoningPolicyPlanning struct {
	noSmithyDocumentSerde
}

// Represents a test scenario used to validate an Automated Reasoning policy,
// including the test conditions and expected outcomes.
type AutomatedReasoningPolicyScenario struct {

	// An alternative way to express the same test scenario, used for validation and
	// comparison purposes.
	//
	// This member is required.
	AlternateExpression *string

	// The expected outcome when this scenario is evaluated against the policy (e.g.,
	// PASS, FAIL, VIOLATION).
	//
	// This member is required.
	ExpectedResult AutomatedReasoningCheckResult

	// The logical expression or condition that defines this test scenario.
	//
	// This member is required.
	Expression *string

	// The list of rule identifiers that are expected to be triggered or evaluated by
	// this test scenario.
	//
	// This member is required.
	RuleIds []string

	noSmithyDocumentSerde
}

// Contains summary information about an Automated Reasoning policy, including
// metadata and timestamps.
type AutomatedReasoningPolicySummary struct {

	// The timestamp when the policy was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the policy.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the policy.
	//
	// This member is required.
	PolicyArn *string

	// The unique identifier of the policy.
	//
	// This member is required.
	PolicyId *string

	// The timestamp when the policy was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the policy.
	//
	// This member is required.
	Version *string

	// The description of the policy.
	Description *string

	noSmithyDocumentSerde
}

// Represents a test for validating an Automated Reasoning policy. tests contain
// sample inputs and expected outcomes to verify policy behavior.
type AutomatedReasoningPolicyTestCase struct {

	// The timestamp when the test was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The output content to be validated by the policy, typically representing a
	// foundation model response.
	//
	// This member is required.
	GuardContent *string

	// The unique identifier of the test.
	//
	// This member is required.
	TestCaseId *string

	// The timestamp when the test was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The minimum confidence level for logic validation. Content meeting this
	// threshold is considered high-confidence and can be validated.
	ConfidenceThreshold *float64

	// The expected result of the Automated Reasoning check for this test.
	ExpectedAggregatedFindingsResult AutomatedReasoningCheckResult

	// The input query or prompt that generated the content. This provides context for
	// the validation.
	QueryContent *string

	noSmithyDocumentSerde
}

// Contains the results of testing an Automated Reasoning policy against various
// scenarios and validation checks.
type AutomatedReasoningPolicyTestResult struct {

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy that was
	// tested.
	//
	// This member is required.
	PolicyArn *string

	// The test case that was executed, including the input content, expected results,
	// and configuration parameters used during validation.
	//
	// This member is required.
	TestCase *AutomatedReasoningPolicyTestCase

	// The overall status of the test run (e.g., COMPLETED, FAILED, IN_PROGRESS).
	//
	// This member is required.
	TestRunStatus AutomatedReasoningPolicyTestRunStatus

	// The timestamp when the test results were last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A summary of all test findings, aggregated to provide an overall assessment of
	// policy quality and correctness.
	AggregatedTestFindingsResult AutomatedReasoningCheckResult

	// Detailed findings from the test run, including any issues, violations, or
	// unexpected behaviors discovered.
	TestFindings []AutomatedReasoningCheckFinding

	// The overall result of the test run, indicating whether the policy passed or
	// failed validation.
	TestRunResult AutomatedReasoningPolicyTestRunResult

	noSmithyDocumentSerde
}

// An annotation for managing values within custom types, including adding,
// updating, or removing specific type values.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyTypeValueAnnotationMemberAddTypeValue
//	AutomatedReasoningPolicyTypeValueAnnotationMemberDeleteTypeValue
//	AutomatedReasoningPolicyTypeValueAnnotationMemberUpdateTypeValue
type AutomatedReasoningPolicyTypeValueAnnotation interface {
	isAutomatedReasoningPolicyTypeValueAnnotation()
}

// An operation to add a new value to an existing custom type.
type AutomatedReasoningPolicyTypeValueAnnotationMemberAddTypeValue struct {
	Value AutomatedReasoningPolicyAddTypeValue

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyTypeValueAnnotationMemberAddTypeValue) isAutomatedReasoningPolicyTypeValueAnnotation() {
}

// An operation to remove a value from an existing custom type.
type AutomatedReasoningPolicyTypeValueAnnotationMemberDeleteTypeValue struct {
	Value AutomatedReasoningPolicyDeleteTypeValue

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyTypeValueAnnotationMemberDeleteTypeValue) isAutomatedReasoningPolicyTypeValueAnnotation() {
}

// An operation to modify an existing value within a custom type.
type AutomatedReasoningPolicyTypeValueAnnotationMemberUpdateTypeValue struct {
	Value AutomatedReasoningPolicyUpdateTypeValue

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyTypeValueAnnotationMemberUpdateTypeValue) isAutomatedReasoningPolicyTypeValueAnnotation() {
}

// An annotation for updating the policy based on feedback about how specific
// rules performed during testing or real-world usage.
type AutomatedReasoningPolicyUpdateFromRuleFeedbackAnnotation struct {

	// The feedback information about rule performance, including suggestions for
	// improvements or corrections.
	//
	// This member is required.
	Feedback *string

	// The list of rule identifiers that the feedback applies to.
	RuleIds []string

	noSmithyDocumentSerde
}

// An annotation for updating the policy based on feedback about how it performed
// on specific test scenarios.
type AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation struct {

	// The logical expression that defines the test scenario that generated this
	// feedback.
	//
	// This member is required.
	ScenarioExpression *string

	// The feedback information about scenario performance, including any issues or
	// improvements identified.
	Feedback *string

	// The list of rule identifiers that were involved in the scenario being evaluated.
	RuleIds []string

	noSmithyDocumentSerde
}

// An annotation for modifying an existing rule in an Automated Reasoning policy.
type AutomatedReasoningPolicyUpdateRuleAnnotation struct {

	// The new formal logical expression for the rule, replacing the previous
	// expression.
	//
	// This member is required.
	Expression *string

	// The unique identifier of the rule to update.
	//
	// This member is required.
	RuleId *string

	noSmithyDocumentSerde
}

// A mutation operation that modifies an existing rule in the policy definition
// during the build process.
type AutomatedReasoningPolicyUpdateRuleMutation struct {

	// The updated rule definition containing the modified formal logical expression
	// and any changed metadata for the existing rule.
	//
	// This member is required.
	Rule *AutomatedReasoningPolicyDefinitionRule

	noSmithyDocumentSerde
}

// An annotation for modifying an existing custom type in an Automated Reasoning
// policy.
type AutomatedReasoningPolicyUpdateTypeAnnotation struct {

	// The current name of the custom type to update.
	//
	// This member is required.
	Name *string

	// The updated list of values for the custom type, which can include additions,
	// modifications, or removals.
	//
	// This member is required.
	Values []AutomatedReasoningPolicyTypeValueAnnotation

	// The new description for the custom type, replacing the previous description.
	Description *string

	// The new name for the custom type, if you want to rename it. If not provided,
	// the name remains unchanged.
	NewName *string

	noSmithyDocumentSerde
}

// A mutation operation that modifies an existing custom type in the policy
// definition during the build process.
type AutomatedReasoningPolicyUpdateTypeMutation struct {

	// The updated type definition containing the modified name, description, or
	// values for the existing custom type.
	//
	// This member is required.
	Type *AutomatedReasoningPolicyDefinitionType

	noSmithyDocumentSerde
}

// Represents a modification to a value within an existing custom type.
type AutomatedReasoningPolicyUpdateTypeValue struct {

	// The current identifier or name of the type value to update.
	//
	// This member is required.
	Value *string

	// The new description for the type value, replacing the previous description.
	Description *string

	// The new identifier or name for the type value, if you want to rename it.
	NewValue *string

	noSmithyDocumentSerde
}

// An annotation for modifying an existing variable in an Automated Reasoning
// policy.
type AutomatedReasoningPolicyUpdateVariableAnnotation struct {

	// The current name of the variable to update.
	//
	// This member is required.
	Name *string

	// The new description for the variable, replacing the previous description.
	Description *string

	// The new name for the variable, if you want to rename it. If not provided, the
	// name remains unchanged.
	NewName *string

	noSmithyDocumentSerde
}

// A mutation operation that modifies an existing variable in the policy
// definition during the build process.
type AutomatedReasoningPolicyUpdateVariableMutation struct {

	// The updated variable definition containing the modified name, type, or
	// description for the existing variable.
	//
	// This member is required.
	Variable *AutomatedReasoningPolicyDefinitionVariable

	noSmithyDocumentSerde
}

// Defines the content and configuration for different types of policy build
// workflows.
//
// The following types satisfy this interface:
//
//	AutomatedReasoningPolicyWorkflowTypeContentMemberDocuments
//	AutomatedReasoningPolicyWorkflowTypeContentMemberPolicyRepairAssets
type AutomatedReasoningPolicyWorkflowTypeContent interface {
	isAutomatedReasoningPolicyWorkflowTypeContent()
}

// The list of documents to be processed in a document ingestion workflow.
type AutomatedReasoningPolicyWorkflowTypeContentMemberDocuments struct {
	Value []AutomatedReasoningPolicyBuildWorkflowDocument

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyWorkflowTypeContentMemberDocuments) isAutomatedReasoningPolicyWorkflowTypeContent() {
}

// The assets and instructions needed for a policy repair workflow, including
// repair annotations and guidance.
type AutomatedReasoningPolicyWorkflowTypeContentMemberPolicyRepairAssets struct {
	Value AutomatedReasoningPolicyBuildWorkflowRepairContent

	noSmithyDocumentSerde
}

func (*AutomatedReasoningPolicyWorkflowTypeContentMemberPolicyRepairAssets) isAutomatedReasoningPolicyWorkflowTypeContent() {
}

// A JSON array that provides the status of the evaluation jobs being deleted.
type BatchDeleteEvaluationJobError struct {

	// A HTTP status code of the evaluation job being deleted.
	//
	// This member is required.
	Code *string

	// The ARN of the evaluation job being deleted.
	//
	// This member is required.
	JobIdentifier *string

	// A status message about the evaluation job deletion.
	Message *string

	noSmithyDocumentSerde
}

// An evaluation job for deletion, and it’s current status.
type BatchDeleteEvaluationJobItem struct {

	// The Amazon Resource Name (ARN) of the evaluation job for deletion.
	//
	// This member is required.
	JobIdentifier *string

	// The status of the evaluation job for deletion.
	//
	// This member is required.
	JobStatus EvaluationJobStatus

	noSmithyDocumentSerde
}

// The evaluator model used in knowledge base evaluation job or in model
// evaluation job that use a model as judge. This model computes all evaluation
// related metrics.
type BedrockEvaluatorModel struct {

	// The Amazon Resource Name (ARN) of the evaluator model used used in knowledge
	// base evaluation job or in model evaluation job that use a model as judge.
	//
	// This member is required.
	ModelIdentifier *string

	noSmithyDocumentSerde
}

// Contains the document contained in the wrapper object, along with its
// attributes/fields.
type ByteContentDoc struct {

	// The MIME type of the document contained in the wrapper object.
	//
	// This member is required.
	ContentType *string

	// The byte value of the file to upload, encoded as a Base-64 string.
	//
	// This member is required.
	Data []byte

	// The file name of the document contained in the wrapper object.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// CloudWatch logging configuration.
type CloudWatchConfig struct {

	// The log group name.
	//
	// This member is required.
	LogGroupName *string

	// The role Amazon Resource Name (ARN).
	//
	// This member is required.
	RoleArn *string

	// S3 configuration for delivering a large amount of data.
	LargeDataDeliveryS3Config *S3Config

	noSmithyDocumentSerde
}

// A model customization configuration
//
// The following types satisfy this interface:
//
//	CustomizationConfigMemberDistillationConfig
type CustomizationConfig interface {
	isCustomizationConfig()
}

// The Distillation configuration for the custom model.
type CustomizationConfigMemberDistillationConfig struct {
	Value DistillationConfig

	noSmithyDocumentSerde
}

func (*CustomizationConfigMemberDistillationConfig) isCustomizationConfig() {}

// Defines the model you want to evaluate custom metrics in an Amazon Bedrock
// evaluation job.
type CustomMetricBedrockEvaluatorModel struct {

	// The Amazon Resource Name (ARN) of the evaluator model for custom metrics. For a
	// list of supported evaluator models, see [Evaluate model performance using another LLM as a judge]and [Evaluate the performance of RAG sources using Amazon Bedrock evaluations].
	//
	// [Evaluate the performance of RAG sources using Amazon Bedrock evaluations]: https://docs.aws.amazon.com/bedrock/latest/userguide/evaluation-kb.html
	// [Evaluate model performance using another LLM as a judge]: https://docs.aws.amazon.com/bedrock/latest/userguide/evaluation-judge.html
	//
	// This member is required.
	ModelIdentifier *string

	noSmithyDocumentSerde
}

// The definition of a custom metric for use in an Amazon Bedrock evaluation job.
// A custom metric definition includes a metric name, prompt (instructions) and
// optionally, a rating scale. Your prompt must include a task description and
// input variables. The required input variables are different for model-as-a-judge
// and RAG evaluations.
//
// For more information about how to define a custom metric in Amazon Bedrock, see [Create a prompt for a custom metrics (LLM-as-a-judge model evaluations)]
// and [Create a prompt for a custom metrics (RAG evaluations)].
//
// [Create a prompt for a custom metrics (RAG evaluations)]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-evaluation-custom-metrics-prompt-formats.html
// [Create a prompt for a custom metrics (LLM-as-a-judge model evaluations)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-custom-metrics-prompt-formats.html
type CustomMetricDefinition struct {

	// The prompt for a custom metric that instructs the evaluator model how to rate
	// the model or RAG source under evaluation.
	//
	// This member is required.
	Instructions *string

	// The name for a custom metric. Names must be unique in your Amazon Web Services
	// region.
	//
	// This member is required.
	Name *string

	// Defines the rating scale to be used for a custom metric. We recommend that you
	// always define a ratings scale when creating a custom metric. If you don't define
	// a scale, Amazon Bedrock won't be able to visually display the results of the
	// evaluation in the console or calculate average values of numerical scores. For
	// more information on specifying a rating scale, see [Specifying an output schema (rating scale)].
	//
	// [Specifying an output schema (rating scale)]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-custom-metrics-prompt-formats.html#model-evaluation-custom-metrics-prompt-formats-schema
	RatingScale []RatingScaleItem

	noSmithyDocumentSerde
}

// Configuration of the evaluator model you want to use to evaluate custom metrics
// in an Amazon Bedrock evaluation job.
type CustomMetricEvaluatorModelConfig struct {

	// Defines the model you want to evaluate custom metrics in an Amazon Bedrock
	// evaluation job.
	//
	// This member is required.
	BedrockEvaluatorModels []CustomMetricBedrockEvaluatorModel

	noSmithyDocumentSerde
}

// Contains summary information about a custom model deployment, including its
// ARN, name, status, and associated custom model.
type CustomModelDeploymentSummary struct {

	// The date and time when the custom model deployment was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the custom model deployment.
	//
	// This member is required.
	CustomModelDeploymentArn *string

	// The name of the custom model deployment.
	//
	// This member is required.
	CustomModelDeploymentName *string

	// The Amazon Resource Name (ARN) of the custom model associated with this
	// deployment.
	//
	// This member is required.
	ModelArn *string

	// The status of the custom model deployment. Possible values are CREATING , ACTIVE
	// , and FAILED .
	//
	// This member is required.
	Status CustomModelDeploymentStatus

	// If the deployment status is FAILED , this field contains a message describing
	// the failure reason.
	FailureMessage *string

	// The date and time when the custom model deployment was last modified.
	LastUpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary information for a custom model.
type CustomModelSummary struct {

	// The base model Amazon Resource Name (ARN).
	//
	// This member is required.
	BaseModelArn *string

	// The base model name.
	//
	// This member is required.
	BaseModelName *string

	// Creation time of the model.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the custom model.
	//
	// This member is required.
	ModelArn *string

	// The name of the custom model.
	//
	// This member is required.
	ModelName *string

	// Specifies whether to carry out continued pre-training of a model or whether to
	// fine-tune it. For more information, see [Custom models].
	//
	// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
	CustomizationType CustomizationType

	// The current status of the custom model. Possible values include:
	//
	//   - Creating - The model is being created and validated.
	//
	//   - Active - The model has been successfully created and is ready for use.
	//
	//   - Failed - The model creation process failed.
	ModelStatus ModelStatus

	// The unique identifier of the account that owns the model.
	OwnerAccountId *string

	noSmithyDocumentSerde
}

// A CustomModelUnit (CMU) is an abstract view of the hardware utilization that
// Amazon Bedrock needs to host a single copy of your custom model. A model copy
// represents a single instance of your imported model that is ready to serve
// inference requests. Amazon Bedrock determines the number of custom model units
// that a model copy needs when you import the custom model.
//
// You can use CustomModelUnits to estimate the cost of running your custom model.
// For more information, see Calculate the cost of running a custom model in the
// Amazon Bedrock user guide.
type CustomModelUnits struct {

	// The number of custom model units used to host a model copy.
	CustomModelUnitsPerModelCopy *int32

	// The version of the custom model unit. Use to determine the billing rate for the
	// custom model unit.
	CustomModelUnitsVersion *string

	noSmithyDocumentSerde
}

// For a Distillation job, the status details for the data processing sub-task of
// the job.
type DataProcessingDetails struct {

	// The start time of the data processing sub-task of the job.
	CreationTime *time.Time

	// The latest update to the data processing sub-task of the job.
	LastModifiedTime *time.Time

	// The status of the data processing sub-task of the job.
	Status JobStatusDetails

	noSmithyDocumentSerde
}

// Dimensional price rate.
type DimensionalPriceRate struct {

	// Description of the price rate.
	Description *string

	// Dimension for the price rate.
	Dimension *string

	// Single-dimensional rate information.
	Price *string

	// Unit associated with the price.
	Unit *string

	noSmithyDocumentSerde
}

// Settings for distilling a foundation model into a smaller and more efficient
// model.
type DistillationConfig struct {

	// The teacher model configuration.
	//
	// This member is required.
	TeacherModelConfig *TeacherModelConfig

	noSmithyDocumentSerde
}

// Specifies the configuration for the endpoint.
//
// The following types satisfy this interface:
//
//	EndpointConfigMemberSageMaker
type EndpointConfig interface {
	isEndpointConfig()
}

// The configuration specific to Amazon SageMaker for the endpoint.
type EndpointConfigMemberSageMaker struct {
	Value SageMakerEndpoint

	noSmithyDocumentSerde
}

func (*EndpointConfigMemberSageMaker) isEndpointConfig() {}

// Contains the ARN of the Amazon Bedrock model or [inference profile] specified in your evaluation
// job. Each Amazon Bedrock model supports different inferenceParams . To learn
// more about supported inference parameters for Amazon Bedrock models, see [Inference parameters for foundation models].
//
// The inferenceParams are specified using JSON. To successfully insert JSON as
// string make sure that all quotations are properly escaped. For example,
// "temperature":"0.25" key value pair would need to be formatted as
// \"temperature\":\"0.25\" to successfully accepted in the request.
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
type EvaluationBedrockModel struct {

	// The ARN of the Amazon Bedrock model or inference profile specified.
	//
	// This member is required.
	ModelIdentifier *string

	// Each Amazon Bedrock support different inference parameters that change how the
	// model behaves during inference.
	InferenceParams *string

	// Specifies performance settings for the model or inference profile.
	PerformanceConfig *PerformanceConfiguration

	noSmithyDocumentSerde
}

// The configuration details of either an automated or human-based evaluation job.
//
// The following types satisfy this interface:
//
//	EvaluationConfigMemberAutomated
//	EvaluationConfigMemberHuman
type EvaluationConfig interface {
	isEvaluationConfig()
}

// Contains the configuration details of an automated evaluation job that computes
// metrics.
type EvaluationConfigMemberAutomated struct {
	Value AutomatedEvaluationConfig

	noSmithyDocumentSerde
}

func (*EvaluationConfigMemberAutomated) isEvaluationConfig() {}

// Contains the configuration details of an evaluation job that uses human workers.
type EvaluationConfigMemberHuman struct {
	Value HumanEvaluationConfig

	noSmithyDocumentSerde
}

func (*EvaluationConfigMemberHuman) isEvaluationConfig() {}

// Used to specify the name of a built-in prompt dataset and optionally, the
// Amazon S3 bucket where a custom prompt dataset is saved.
type EvaluationDataset struct {

	// Used to specify supported built-in prompt datasets. Valid values are
	// Builtin.Bold , Builtin.BoolQ , Builtin.NaturalQuestions , Builtin.Gigaword ,
	// Builtin.RealToxicityPrompts , Builtin.TriviaQA , Builtin.T-Rex ,
	// Builtin.WomensEcommerceClothingReviews and Builtin.Wikitext2 .
	//
	// This member is required.
	Name *string

	// For custom prompt datasets, you must specify the location in Amazon S3 where
	// the prompt dataset is saved.
	DatasetLocation EvaluationDatasetLocation

	noSmithyDocumentSerde
}

// The location in Amazon S3 where your prompt dataset is stored.
//
// The following types satisfy this interface:
//
//	EvaluationDatasetLocationMemberS3Uri
type EvaluationDatasetLocation interface {
	isEvaluationDatasetLocation()
}

// The S3 URI of the S3 bucket specified in the job.
type EvaluationDatasetLocationMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*EvaluationDatasetLocationMemberS3Uri) isEvaluationDatasetLocation() {}

// Defines the prompt datasets, built-in metric names and custom metric names, and
// the task type.
type EvaluationDatasetMetricConfig struct {

	// Specifies the prompt dataset.
	//
	// This member is required.
	Dataset *EvaluationDataset

	// The names of the metrics you want to use for your evaluation job.
	//
	// For knowledge base evaluation jobs that evaluate retrieval only, valid values
	// are " Builtin.ContextRelevance ", " Builtin.ContextCoverage ".
	//
	// For knowledge base evaluation jobs that evaluate retrieval with response
	// generation, valid values are " Builtin.Correctness ", " Builtin.Completeness ", "
	// Builtin.Helpfulness ", " Builtin.LogicalCoherence ", " Builtin.Faithfulness ", "
	// Builtin.Harmfulness ", " Builtin.Stereotyping ", " Builtin.Refusal ".
	//
	// For automated model evaluation jobs, valid values are " Builtin.Accuracy ", "
	// Builtin.Robustness ", and " Builtin.Toxicity ". In model evaluation jobs that
	// use a LLM as judge you can specify " Builtin.Correctness ", "
	// Builtin.Completeness" , " Builtin.Faithfulness" , " Builtin.Helpfulness ", "
	// Builtin.Coherence ", " Builtin.Relevance ", " Builtin.FollowingInstructions ", "
	// Builtin.ProfessionalStyleAndTone ", You can also specify the following
	// responsible AI related metrics only for model evaluation job that use a LLM as
	// judge " Builtin.Harmfulness ", " Builtin.Stereotyping ", and " Builtin.Refusal ".
	//
	// For human-based model evaluation jobs, the list of strings must match the name
	// parameter specified in HumanEvaluationCustomMetric .
	//
	// This member is required.
	MetricNames []string

	// The the type of task you want to evaluate for your evaluation job. This applies
	// only to model evaluation jobs and is ignored for knowledge base evaluation jobs.
	//
	// This member is required.
	TaskType EvaluationTaskType

	noSmithyDocumentSerde
}

// The configuration details of the inference model for an evaluation job.
//
// For automated model evaluation jobs, only a single model is supported.
//
// For human-based model evaluation jobs, your annotator can compare the responses
// for up to two different models.
//
// The following types satisfy this interface:
//
//	EvaluationInferenceConfigMemberModels
//	EvaluationInferenceConfigMemberRagConfigs
type EvaluationInferenceConfig interface {
	isEvaluationInferenceConfig()
}

// Specifies the inference models.
type EvaluationInferenceConfigMemberModels struct {
	Value []EvaluationModelConfig

	noSmithyDocumentSerde
}

func (*EvaluationInferenceConfigMemberModels) isEvaluationInferenceConfig() {}

// Contains the configuration details of the inference for a knowledge base
// evaluation job, including either the retrieval only configuration or the
// retrieval with response generation configuration.
type EvaluationInferenceConfigMemberRagConfigs struct {
	Value []RAGConfig

	noSmithyDocumentSerde
}

func (*EvaluationInferenceConfigMemberRagConfigs) isEvaluationInferenceConfig() {}

// Identifies the models, Knowledge Bases, or other RAG sources evaluated in a
// model or Knowledge Base evaluation job.
type EvaluationInferenceConfigSummary struct {

	// A summary of the models used in an Amazon Bedrock model evaluation job. These
	// resources can be models in Amazon Bedrock or models outside of Amazon Bedrock
	// that you use to generate your own inference response data.
	ModelConfigSummary *EvaluationModelConfigSummary

	// A summary of the RAG resources used in an Amazon Bedrock Knowledge Base
	// evaluation job. These resources can be Knowledge Bases in Amazon Bedrock or RAG
	// sources outside of Amazon Bedrock that you use to generate your own inference
	// response data.
	RagConfigSummary *EvaluationRagConfigSummary

	noSmithyDocumentSerde
}

// Defines the models used in the model evaluation job.
//
// The following types satisfy this interface:
//
//	EvaluationModelConfigMemberBedrockModel
//	EvaluationModelConfigMemberPrecomputedInferenceSource
type EvaluationModelConfig interface {
	isEvaluationModelConfig()
}

// Defines the Amazon Bedrock model or inference profile and inference parameters
// you want used.
type EvaluationModelConfigMemberBedrockModel struct {
	Value EvaluationBedrockModel

	noSmithyDocumentSerde
}

func (*EvaluationModelConfigMemberBedrockModel) isEvaluationModelConfig() {}

// Defines the model used to generate inference response data for a model
// evaluation job where you provide your own inference response data.
type EvaluationModelConfigMemberPrecomputedInferenceSource struct {
	Value EvaluationPrecomputedInferenceSource

	noSmithyDocumentSerde
}

func (*EvaluationModelConfigMemberPrecomputedInferenceSource) isEvaluationModelConfig() {}

// A summary of the models used in an Amazon Bedrock model evaluation job. These
// resources can be models in Amazon Bedrock or models outside of Amazon Bedrock
// that you use to generate your own inference response data.
type EvaluationModelConfigSummary struct {

	// The Amazon Resource Names (ARNs) of the models used for the evaluation job.
	BedrockModelIdentifiers []string

	// A label that identifies the models used for a model evaluation job where you
	// provide your own inference response data.
	PrecomputedInferenceSourceIdentifiers []string

	noSmithyDocumentSerde
}

// The Amazon S3 location where the results of your evaluation job are saved.
type EvaluationOutputDataConfig struct {

	// The Amazon S3 URI where the results of the evaluation job are saved.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// A summary of a model used for a model evaluation job where you provide your own
// inference response data.
type EvaluationPrecomputedInferenceSource struct {

	// A label that identifies a model used in a model evaluation job where you
	// provide your own inference response data.
	//
	// This member is required.
	InferenceSourceIdentifier *string

	noSmithyDocumentSerde
}

// A summary of a RAG source used for a Knowledge Base evaluation job where you
// provide your own inference response data.
//
// The following types satisfy this interface:
//
//	EvaluationPrecomputedRagSourceConfigMemberRetrieveAndGenerateSourceConfig
//	EvaluationPrecomputedRagSourceConfigMemberRetrieveSourceConfig
type EvaluationPrecomputedRagSourceConfig interface {
	isEvaluationPrecomputedRagSourceConfig()
}

// A summary of a RAG source used for a retrieve-and-generate Knowledge Base
// evaluation job where you provide your own inference response data.
type EvaluationPrecomputedRagSourceConfigMemberRetrieveAndGenerateSourceConfig struct {
	Value EvaluationPrecomputedRetrieveAndGenerateSourceConfig

	noSmithyDocumentSerde
}

func (*EvaluationPrecomputedRagSourceConfigMemberRetrieveAndGenerateSourceConfig) isEvaluationPrecomputedRagSourceConfig() {
}

// A summary of a RAG source used for a retrieve-only Knowledge Base evaluation
// job where you provide your own inference response data.
type EvaluationPrecomputedRagSourceConfigMemberRetrieveSourceConfig struct {
	Value EvaluationPrecomputedRetrieveSourceConfig

	noSmithyDocumentSerde
}

func (*EvaluationPrecomputedRagSourceConfigMemberRetrieveSourceConfig) isEvaluationPrecomputedRagSourceConfig() {
}

// A summary of a RAG source used for a retrieve-and-generate Knowledge Base
// evaluation job where you provide your own inference response data.
type EvaluationPrecomputedRetrieveAndGenerateSourceConfig struct {

	// A label that identifies the RAG source used for a retrieve-and-generate
	// Knowledge Base evaluation job where you provide your own inference response
	// data.
	//
	// This member is required.
	RagSourceIdentifier *string

	noSmithyDocumentSerde
}

// A summary of a RAG source used for a retrieve-only Knowledge Base evaluation
// job where you provide your own inference response data.
type EvaluationPrecomputedRetrieveSourceConfig struct {

	// A label that identifies the RAG source used for a retrieve-only Knowledge Base
	// evaluation job where you provide your own inference response data.
	//
	// This member is required.
	RagSourceIdentifier *string

	noSmithyDocumentSerde
}

// A summary of the RAG resources used in an Amazon Bedrock Knowledge Base
// evaluation job. These resources can be Knowledge Bases in Amazon Bedrock or RAG
// sources outside of Amazon Bedrock that you use to generate your own inference
// response data.
type EvaluationRagConfigSummary struct {

	// The Amazon Resource Names (ARNs) of the Knowledge Base resources used for a
	// Knowledge Base evaluation job where Amazon Bedrock invokes the Knowledge Base
	// for you.
	BedrockKnowledgeBaseIdentifiers []string

	// A label that identifies the RAG sources used for a Knowledge Base evaluation
	// job where you provide your own inference response data.
	PrecomputedRagSourceIdentifiers []string

	noSmithyDocumentSerde
}

// Summary information of an evaluation job.
type EvaluationSummary struct {

	// The time the evaluation job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The type of task for model evaluation.
	//
	// This member is required.
	EvaluationTaskTypes []EvaluationTaskType

	// The Amazon Resource Name (ARN) of the evaluation job.
	//
	// This member is required.
	JobArn *string

	// The name for the evaluation job.
	//
	// This member is required.
	JobName *string

	// Specifies whether the evaluation job is automated or human-based.
	//
	// This member is required.
	JobType EvaluationJobType

	// The current status of the evaluation job.
	//
	// This member is required.
	Status EvaluationJobStatus

	// Specifies whether the evaluation job is for evaluating a model or evaluating a
	// knowledge base (retrieval and response generation).
	ApplicationType ApplicationType

	// The Amazon Resource Names (ARNs) of the models used to compute custom metrics
	// in an Amazon Bedrock evaluation job.
	CustomMetricsEvaluatorModelIdentifiers []string

	// The Amazon Resource Names (ARNs) of the models used to compute the metrics for
	// a knowledge base evaluation job.
	EvaluatorModelIdentifiers []string

	// Identifies the models, Knowledge Bases, or other RAG sources evaluated in a
	// model or Knowledge Base evaluation job.
	InferenceConfigSummary *EvaluationInferenceConfigSummary

	// The Amazon Resource Names (ARNs) of the model(s) used for the evaluation job.
	//
	// Deprecated: Inference identifiers should be retrieved from the
	// inferenceConfigSummary
	ModelIdentifiers []string

	// The Amazon Resource Names (ARNs) of the knowledge base resources used for a
	// knowledge base evaluation job.
	//
	// Deprecated: Inference identifiers should be retrieved from the
	// inferenceConfigSummary
	RagIdentifiers []string

	noSmithyDocumentSerde
}

// Specifies the model configuration for the evaluator model. EvaluatorModelConfig
// is required for evaluation jobs that use a knowledge base or in model evaluation
// job that use a model as judge. This model computes all evaluation related
// metrics.
//
// The following types satisfy this interface:
//
//	EvaluatorModelConfigMemberBedrockEvaluatorModels
type EvaluatorModelConfig interface {
	isEvaluatorModelConfig()
}

// The evaluator model used in knowledge base evaluation job or in model
// evaluation job that use a model as judge. This model computes all evaluation
// related metrics.
type EvaluatorModelConfigMemberBedrockEvaluatorModels struct {
	Value []BedrockEvaluatorModel

	noSmithyDocumentSerde
}

func (*EvaluatorModelConfigMemberBedrockEvaluatorModels) isEvaluatorModelConfig() {}

// The unique external source of the content contained in the wrapper object.
type ExternalSource struct {

	// The source type of the external source wrapper object.
	//
	// This member is required.
	SourceType ExternalSourceType

	// The identifier, content type, and data of the external source wrapper object.
	ByteContent *ByteContentDoc

	// The S3 location of the external source wrapper object.
	S3Location *S3ObjectDoc

	noSmithyDocumentSerde
}

// The response generation configuration of the external source wrapper object.
type ExternalSourcesGenerationConfiguration struct {

	// Additional model parameters and their corresponding values not included in the
	// text inference configuration for an external source. Takes in custom model
	// parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// Configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	// Configuration details for inference when using RetrieveAndGenerate to generate
	// responses while using an external source.
	KbInferenceConfig *KbInferenceConfig

	// Contains the template for the prompt for the external source wrapper object.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// The configuration of the external source wrapper object in the
// retrieveAndGenerate function.
type ExternalSourcesRetrieveAndGenerateConfiguration struct {

	// The Amazon Resource Name (ARN) of the foundation model or [inference profile] used to generate
	// responses.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelArn *string

	// The document for the external source wrapper object in the retrieveAndGenerate
	// function.
	//
	// This member is required.
	Sources []ExternalSource

	// Contains configurations details for response generation based on retrieved text
	// chunks.
	GenerationConfiguration *ExternalSourcesGenerationConfiguration

	noSmithyDocumentSerde
}

// Specifies a field to be used during the reranking process in a Knowledge Base
// vector search. This structure identifies metadata fields that should be
// considered when reordering search results to improve relevance.
type FieldForReranking struct {

	// The name of the metadata field to be used during the reranking process.
	//
	// This member is required.
	FieldName *string

	noSmithyDocumentSerde
}

// Specifies the name of the metadata attribute/field to apply filters. You must
// match the name of the attribute/field in your data source/document metadata.
type FilterAttribute struct {

	// The name of metadata attribute/field, which must match the name in your data
	// source/document metadata.
	//
	// This member is required.
	Key *string

	// The value of the metadata attribute/field.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Information about a foundation model.
type FoundationModelDetails struct {

	// The model Amazon Resource Name (ARN).
	//
	// This member is required.
	ModelArn *string

	// The model identifier.
	//
	// This member is required.
	ModelId *string

	// The customization that the model supports.
	CustomizationsSupported []ModelCustomization

	// The inference types that the model supports.
	InferenceTypesSupported []InferenceType

	// The input modalities that the model supports.
	InputModalities []ModelModality

	// Contains details about whether a model version is available or deprecated
	ModelLifecycle *FoundationModelLifecycle

	// The model name.
	ModelName *string

	// The output modalities that the model supports.
	OutputModalities []ModelModality

	// The model's provider name.
	ProviderName *string

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool

	noSmithyDocumentSerde
}

// Details about whether a model version is available or deprecated.
type FoundationModelLifecycle struct {

	// Specifies whether a model version is available ( ACTIVE ) or deprecated ( LEGACY
	// .
	//
	// This member is required.
	Status FoundationModelLifecycleStatus

	noSmithyDocumentSerde
}

// Summary information for a foundation model.
type FoundationModelSummary struct {

	// The Amazon Resource Name (ARN) of the foundation model.
	//
	// This member is required.
	ModelArn *string

	// The model ID of the foundation model.
	//
	// This member is required.
	ModelId *string

	// Whether the model supports fine-tuning or continual pre-training.
	CustomizationsSupported []ModelCustomization

	// The inference types that the model supports.
	InferenceTypesSupported []InferenceType

	// The input modalities that the model supports.
	InputModalities []ModelModality

	// Contains details about whether a model version is available or deprecated.
	ModelLifecycle *FoundationModelLifecycle

	// The name of the model.
	ModelName *string

	// The output modalities that the model supports.
	OutputModalities []ModelModality

	// The model's provider name.
	ProviderName *string

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool

	noSmithyDocumentSerde
}

// The configuration details for response generation based on retrieved text
// chunks.
type GenerationConfiguration struct {

	// Additional model parameters and corresponding values not included in the
	// textInferenceConfig structure for a knowledge base. This allows you to provide
	// custom model parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// Contains configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	// Contains configuration details for inference for knowledge base retrieval and
	// response generation.
	KbInferenceConfig *KbInferenceConfig

	// Contains the template for the prompt that's sent to the model for response
	// generation.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// Represents the configuration of Automated Reasoning policies within a Amazon
// Bedrock Guardrail, including the policies to apply and confidence thresholds.
type GuardrailAutomatedReasoningPolicy struct {

	// The list of Automated Reasoning policy ARNs that should be applied as part of
	// this guardrail configuration.
	//
	// This member is required.
	Policies []string

	// The minimum confidence level required for Automated Reasoning policy violations
	// to trigger guardrail actions. Values range from 0.0 to 1.0.
	ConfidenceThreshold *float64

	noSmithyDocumentSerde
}

// Configuration settings for integrating Automated Reasoning policies with Amazon
// Bedrock Guardrails.
type GuardrailAutomatedReasoningPolicyConfig struct {

	// The list of Automated Reasoning policy ARNs to include in the guardrail
	// configuration.
	//
	// This member is required.
	Policies []string

	// The confidence threshold for triggering guardrail actions based on Automated
	// Reasoning policy violations.
	ConfidenceThreshold *float64

	noSmithyDocumentSerde
}

// The configuration details for the guardrail.
type GuardrailConfiguration struct {

	// The unique identifier for the guardrail.
	//
	// This member is required.
	GuardrailId *string

	// The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an identity
//     (such as race, ethnicity, gender, religion, sexual orientation, ability, and
//     national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of language
//     is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts, physical
//     traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification of
//     or threats to inflict physical pain, hurt, or injury toward a person, group or
//     thing.
//
// Content filtering depends on the confidence classification of user inputs and
// FM responses across each of the four harmful categories. All input and output
// statements are classified into one of four confidence levels (NONE, LOW, MEDIUM,
// HIGH) for each harmful category. For example, if a statement is classified as
// Hate with HIGH confidence, the likelihood of the statement representing hateful
// content is high. A single statement can be classified across multiple categories
// with varying confidence levels. For example, a single statement can be
// classified as Hate with HIGH confidence, Insults with LOW confidence, Sexual
// with NONE confidence, and Violence with MEDIUM confidence.
//
// For more information, see [Guardrails content filters].
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
// [Guardrails content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html
type GuardrailContentFilter struct {

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and the
	// probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	InputStrength GuardrailFilterStrength

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	OutputStrength GuardrailFilterStrength

	// The harmful category that the content filter is applied to.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailContentFilterAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The input modalities selected for the guardrail content filter.
	InputModalities []GuardrailModality

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailContentFilterAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	// The output modalities selected for the guardrail content filter.
	OutputModalities []GuardrailModality

	noSmithyDocumentSerde
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an identity
//     (such as race, ethnicity, gender, religion, sexual orientation, ability, and
//     national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of language
//     is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts, physical
//     traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification of
//     or threats to inflict physical pain, hurt, or injury toward a person, group or
//     thing.
//
// Content filtering depends on the confidence classification of user inputs and
// FM responses across each of the four harmful categories. All input and output
// statements are classified into one of four confidence levels (NONE, LOW, MEDIUM,
// HIGH) for each harmful category. For example, if a statement is classified as
// Hate with HIGH confidence, the likelihood of the statement representing hateful
// content is high. A single statement can be classified across multiple categories
// with varying confidence levels. For example, a single statement can be
// classified as Hate with HIGH confidence, Insults with LOW confidence, Sexual
// with NONE confidence, and Violence with MEDIUM confidence.
//
// For more information, see [Guardrails content filters].
//
// [Guardrails content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html
type GuardrailContentFilterConfig struct {

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and the
	// probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	InputStrength GuardrailFilterStrength

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	OutputStrength GuardrailFilterStrength

	// The harmful category that the content filter is applied to.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// Specifies the action to take when harmful content is detected. Supported values
	// include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailContentFilterAction

	// Specifies whether to enable guardrail evaluation on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The input modalities selected for the guardrail content filter configuration.
	InputModalities []GuardrailModality

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailContentFilterAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	// The output modalities selected for the guardrail content filter configuration.
	OutputModalities []GuardrailModality

	noSmithyDocumentSerde
}

// The tier that your guardrail uses for content filters.
type GuardrailContentFiltersTier struct {

	// The tier that your guardrail uses for content filters. Valid values include:
	//
	//   - CLASSIC tier – Provides established guardrails functionality supporting
	//   English, French, and Spanish languages.
	//
	//   - STANDARD tier – Provides a more robust solution than the CLASSIC tier and
	//   has more comprehensive language support. This tier requires that your guardrail
	//   use [cross-Region inference].
	//
	// [cross-Region inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
	//
	// This member is required.
	TierName GuardrailContentFiltersTierName

	noSmithyDocumentSerde
}

// The tier that your guardrail uses for content filters. Consider using a tier
// that balances performance, accuracy, and compatibility with your existing
// generative AI workflows.
type GuardrailContentFiltersTierConfig struct {

	// The tier that your guardrail uses for content filters. Valid values include:
	//
	//   - CLASSIC tier – Provides established guardrails functionality supporting
	//   English, French, and Spanish languages.
	//
	//   - STANDARD tier – Provides a more robust solution than the CLASSIC tier and
	//   has more comprehensive language support. This tier requires that your guardrail
	//   use [cross-Region inference].
	//
	// [cross-Region inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
	//
	// This member is required.
	TierName GuardrailContentFiltersTierName

	noSmithyDocumentSerde
}

// Contains details about how to handle harmful content.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailContentPolicy struct {

	// Contains the type of the content filter and how strongly it should apply to
	// prompts and model responses.
	Filters []GuardrailContentFilter

	// The tier that your guardrail uses for content filters.
	Tier *GuardrailContentFiltersTier

	noSmithyDocumentSerde
}

// Contains details about how to handle harmful content.
type GuardrailContentPolicyConfig struct {

	// Contains the type of the content filter and how strongly it should apply to
	// prompts and model responses.
	//
	// This member is required.
	FiltersConfig []GuardrailContentFilterConfig

	// The tier that your guardrail uses for content filters.
	TierConfig *GuardrailContentFiltersTierConfig

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilter struct {

	// The threshold details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Threshold *float64

	// The filter type details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	// The action to take when content fails the contextual grounding evaluation.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	Action GuardrailContextualGroundingAction

	// Indicates whether contextual grounding is enabled for evaluation. When
	// disabled, you aren't charged for the evaluation. The evaluation doesn't appear
	// in the response.
	Enabled *bool

	noSmithyDocumentSerde
}

// The filter configuration details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilterConfig struct {

	// The threshold details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Threshold *float64

	// The filter details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	// Specifies the action to take when content fails the contextual grounding
	// evaluation. Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	Action GuardrailContextualGroundingAction

	// Specifies whether to enable contextual grounding evaluation. When disabled, you
	// aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	Enabled *bool

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding policy.
type GuardrailContextualGroundingPolicy struct {

	// The filter details for the guardrails contextual grounding policy.
	//
	// This member is required.
	Filters []GuardrailContextualGroundingFilter

	noSmithyDocumentSerde
}

// The policy configuration details for the guardrails contextual grounding policy.
type GuardrailContextualGroundingPolicyConfig struct {

	// The filter configuration details for the guardrails contextual grounding policy.
	//
	// This member is required.
	FiltersConfig []GuardrailContextualGroundingFilterConfig

	noSmithyDocumentSerde
}

// The system-defined guardrail profile that you're using with your guardrail.
// Guardrail profiles define the destination Amazon Web Services Regions where
// guardrail inference requests can be automatically routed. Using guardrail
// profiles helps maintain guardrail performance and reliability when demand
// increases.
//
// For more information, see the [Amazon Bedrock User Guide].
//
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
type GuardrailCrossRegionConfig struct {

	// The ID or Amazon Resource Name (ARN) of the guardrail profile that your
	// guardrail is using. Guardrail profile availability depends on your current
	// Amazon Web Services Region. For more information, see the [Amazon Bedrock User Guide].
	//
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html
	//
	// This member is required.
	GuardrailProfileIdentifier *string

	noSmithyDocumentSerde
}

// Contains details about the system-defined guardrail profile that you're using
// with your guardrail for cross-Region inference.
//
// For more information, see the [Amazon Bedrock User Guide].
//
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
type GuardrailCrossRegionDetails struct {

	// The Amazon Resource Name (ARN) of the guardrail profile that you're using with
	// your guardrail.
	GuardrailProfileArn *string

	// The ID of the guardrail profile that your guardrail is using. Profile
	// availability depends on your current Amazon Web Services Region. For more
	// information, see the [Amazon Bedrock User Guide].
	//
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html
	GuardrailProfileId *string

	noSmithyDocumentSerde
}

// The managed word list that was configured for the guardrail. (This is a list of
// words that are pre-defined and managed by guardrails only.)
type GuardrailManagedWords struct {

	// ManagedWords$type The managed word type that was configured for the guardrail.
	// (For now, we only offer profanity word list)
	//
	// This member is required.
	Type GuardrailManagedWordsType

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailWordAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailWordAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// The managed word list to configure for the guardrail.
type GuardrailManagedWordsConfig struct {

	// The managed word type to configure for the guardrail.
	//
	// This member is required.
	Type GuardrailManagedWordsType

	// Specifies the action to take when harmful content is detected in the input.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailWordAction

	// Specifies whether to enable guardrail evaluation on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailWordAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// The PII entity configured for the guardrail.
type GuardrailPiiEntity struct {

	// The configured guardrail action when PII entity is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The type of PII entity. For example, Social Security Number.
	//
	// This member is required.
	Type GuardrailPiiEntityType

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - ANONYMIZE – Mask the content and replace it with identifier tags.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailSensitiveInformationAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - ANONYMIZE – Mask the content and replace it with identifier tags.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailSensitiveInformationAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// The PII entity to configure for the guardrail.
type GuardrailPiiEntityConfig struct {

	// Configure guardrail action when the PII entity is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// Configure guardrail type when the PII entity is detected.
	//
	// The following PIIs are used to block or mask sensitive information:
	//
	//   - General
	//
	//   - ADDRESS
	//
	// A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12,
	//   Building 123". An address can include information such as the street, building,
	//   location, city, state, country, county, zip code, precinct, and neighborhood.
	//
	//   - AGE
	//
	// An individual's age, including the quantity and unit of time. For example, in
	//   the phrase "I am 40 years old," Guardrails recognizes "40 years" as an age.
	//
	//   - NAME
	//
	// An individual's name. This entity type does not include titles, such as Dr.,
	//   Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are
	//   part of organizations or addresses. For example, guardrails recognizes the "John
	//   Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an
	//   address.
	//
	//   - EMAIL
	//
	// An email address, such as marymajor@email.com.
	//
	//   - PHONE
	//
	// A phone number. This entity type also includes fax and pager numbers.
	//
	//   - USERNAME
	//
	// A user name that identifies an account, such as a login name, screen name, nick
	//   name, or handle.
	//
	//   - PASSWORD
	//
	// An alphanumeric string that is used as a password, such as
	//   "*very20special#pass*".
	//
	//   - DRIVER_ID
	//
	// The number assigned to a driver's license, which is an official document
	//   permitting an individual to operate one or more motorized vehicles on a public
	//   road. A driver's license number consists of alphanumeric characters.
	//
	//   - LICENSE_PLATE
	//
	// A license plate for a vehicle is issued by the state or country where the
	//   vehicle is registered. The format for passenger vehicles is typically five to
	//   eight digits, consisting of upper-case letters and numbers. The format varies
	//   depending on the location of the issuing state or country.
	//
	//   - VEHICLE_IDENTIFICATION_NUMBER
	//
	// A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN
	//   content and format are defined in the ISO 3779 specification. Each country has
	//   specific codes and formats for VINs.
	//
	//   - Finance
	//
	//   - CREDIT_DEBIT_CARD_CVV
	//
	// A three-digit card verification code (CVV) that is present on VISA, MasterCard,
	//   and Discover credit and debit cards. For American Express credit or debit cards,
	//   the CVV is a four-digit numeric code.
	//
	//   - CREDIT_DEBIT_CARD_EXPIRY
	//
	// The expiration date for a credit or debit card. This number is usually four
	//   digits long and is often formatted as month/year or MM/YY. Guardrails recognizes
	//   expiration dates such as 01/21, 01/2021, and Jan 2021.
	//
	//   - CREDIT_DEBIT_CARD_NUMBER
	//
	// The number for a credit or debit card. These numbers can vary from 13 to 16
	//   digits in length. However, Amazon Comprehend also recognizes credit or debit
	//   card numbers when only the last four digits are present.
	//
	//   - PIN
	//
	// A four-digit personal identification number (PIN) with which you can access
	//   your bank account.
	//
	//   - INTERNATIONAL_BANK_ACCOUNT_NUMBER
	//
	// An International Bank Account Number has specific formats in each country. For
	//   more information, see [www.iban.com/structure].
	//
	//   - SWIFT_CODE
	//
	// A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify
	//   a particular bank or branch. Banks use these codes for money transfers such as
	//   international wire transfers.
	//
	// SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to
	//   specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX')
	//   refer to the head or primary office.
	//
	//   - IT
	//
	//   - IP_ADDRESS
	//
	// An IPv4 address, such as 198.51.100.0.
	//
	//   - MAC_ADDRESS
	//
	// A media access control (MAC) address is a unique identifier assigned to a
	//   network interface controller (NIC).
	//
	//   - URL
	//
	// A web address, such as www.example.com.
	//
	//   - AWS_ACCESS_KEY
	//
	// A unique identifier that's associated with a secret access key; you use the
	//   access key ID and secret access key to sign programmatic Amazon Web Services
	//   requests cryptographically.
	//
	//   - AWS_SECRET_KEY
	//
	// A unique identifier that's associated with an access key. You use the access
	//   key ID and secret access key to sign programmatic Amazon Web Services requests
	//   cryptographically.
	//
	//   - USA specific
	//
	//   - US_BANK_ACCOUNT_NUMBER
	//
	// A US bank account number, which is typically 10 to 12 digits long.
	//
	//   - US_BANK_ROUTING_NUMBER
	//
	// A US bank account routing number. These are typically nine digits long,
	//
	//   - US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
	//
	// A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number
	//   that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can
	//   be formatted with a space or a dash after the third and forth digits.
	//
	//   - US_PASSPORT_NUMBER
	//
	// A US passport number. Passport numbers range from six to nine alphanumeric
	//   characters.
	//
	//   - US_SOCIAL_SECURITY_NUMBER
	//
	// A US Social Security Number (SSN) is a nine-digit number that is issued to US
	//   citizens, permanent residents, and temporary working residents.
	//
	//   - Canada specific
	//
	//   - CA_HEALTH_NUMBER
	//
	// A Canadian Health Service Number is a 10-digit unique identifier, required for
	//   individuals to access healthcare benefits.
	//
	//   - CA_SOCIAL_INSURANCE_NUMBER
	//
	// A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier,
	//   required for individuals to access government programs and benefits.
	//
	// The SIN is formatted as three groups of three digits, such as 123-456-789. A
	//   SIN can be validated through a simple check-digit process called the [Luhn algorithm].
	//
	//   - UK Specific
	//
	//   - UK_NATIONAL_HEALTH_SERVICE_NUMBER
	//
	// A UK National Health Service Number is a 10-17 digit number, such as 485 777
	//   3456. The current system formats the 10-digit number with spaces after the third
	//   and sixth digits. The final digit is an error-detecting checksum.
	//
	//   - UK_NATIONAL_INSURANCE_NUMBER
	//
	// A UK National Insurance Number (NINO) provides individuals with access to
	//   National Insurance (social security) benefits. It is also used for some purposes
	//   in the UK tax system.
	//
	// The number is nine digits long and starts with two letters, followed by six
	//   numbers and one letter. A NINO can be formatted with a space or a dash after the
	//   two letters and after the second, forth, and sixth digits.
	//
	//   - UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
	//
	// A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a
	//   taxpayer or a business.
	//
	//   - Custom
	//
	//   - Regex filter - You can use a regular expressions to define patterns for a
	//   guardrail to recognize and act upon such as serial number, booking ID etc..
	//
	// [Luhn algorithm]: https://www.wikipedia.org/wiki/Luhn_algorithm
	// [www.iban.com/structure]: https://www.iban.com/structure
	//
	// This member is required.
	Type GuardrailPiiEntityType

	// Specifies the action to take when harmful content is detected in the input.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - ANONYMIZE – Mask the content and replace it with identifier tags.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailSensitiveInformationAction

	// Specifies whether to enable guardrail evaluation on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - ANONYMIZE – Mask the content and replace it with identifier tags.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailSensitiveInformationAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// The regular expression configured for the guardrail.
type GuardrailRegex struct {

	// The action taken when a match to the regular expression is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The name of the regular expression for the guardrail.
	//
	// This member is required.
	Name *string

	// The pattern of the regular expression configured for the guardrail.
	//
	// This member is required.
	Pattern *string

	// The description of the regular expression for the guardrail.
	Description *string

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailSensitiveInformationAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailSensitiveInformationAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// The regular expression to configure for the guardrail.
type GuardrailRegexConfig struct {

	// The guardrail action to configure when matching regular expression is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The name of the regular expression to configure for the guardrail.
	//
	// This member is required.
	Name *string

	// The regular expression pattern to configure for the guardrail.
	//
	// This member is required.
	Pattern *string

	// The description of the regular expression to configure for the guardrail.
	Description *string

	// Specifies the action to take when harmful content is detected in the input.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailSensitiveInformationAction

	// Specifies whether to enable guardrail evaluation on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailSensitiveInformationAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// Contains details about PII entities and regular expressions configured for the
// guardrail.
type GuardrailSensitiveInformationPolicy struct {

	// The list of PII entities configured for the guardrail.
	PiiEntities []GuardrailPiiEntity

	// The list of regular expressions configured for the guardrail.
	Regexes []GuardrailRegex

	noSmithyDocumentSerde
}

// Contains details about PII entities and regular expressions to configure for
// the guardrail.
type GuardrailSensitiveInformationPolicyConfig struct {

	// A list of PII entities to configure to the guardrail.
	PiiEntitiesConfig []GuardrailPiiEntityConfig

	// A list of regular expressions to configure to the guardrail.
	RegexesConfig []GuardrailRegexConfig

	noSmithyDocumentSerde
}

// Contains details about a guardrail.
//
// This data type is used in the following API operations:
//
// [ListGuardrails response body]
//
// [ListGuardrails response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax
type GuardrailSummary struct {

	// The ARN of the guardrail.
	//
	// This member is required.
	Arn *string

	// The date and time at which the guardrail was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the guardrail.
	//
	// This member is required.
	Id *string

	// The name of the guardrail.
	//
	// This member is required.
	Name *string

	// The status of the guardrail.
	//
	// This member is required.
	Status GuardrailStatus

	// The date and time at which the guardrail was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the guardrail.
	//
	// This member is required.
	Version *string

	// Details about the system-defined guardrail profile that you're using with your
	// guardrail, including the guardrail profile ID and Amazon Resource Name (ARN).
	CrossRegionDetails *GuardrailCrossRegionDetails

	// A description of the guardrail.
	Description *string

	noSmithyDocumentSerde
}

// Details about topics for the guardrail to identify and deny.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailTopic struct {

	// A definition of the topic to deny.
	//
	// This member is required.
	Definition *string

	// The name of the topic to deny.
	//
	// This member is required.
	Name *string

	// A list of prompts, each of which is an example of a prompt that can be
	// categorized as belonging to the topic.
	Examples []string

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailTopicAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailTopicAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	// Specifies to deny the topic.
	Type GuardrailTopicType

	noSmithyDocumentSerde
}

// Details about topics for the guardrail to identify and deny.
type GuardrailTopicConfig struct {

	// A definition of the topic to deny.
	//
	// This member is required.
	Definition *string

	// The name of the topic to deny.
	//
	// This member is required.
	Name *string

	// Specifies to deny the topic.
	//
	// This member is required.
	Type GuardrailTopicType

	// A list of prompts, each of which is an example of a prompt that can be
	// categorized as belonging to the topic.
	Examples []string

	// Specifies the action to take when harmful content is detected in the input.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailTopicAction

	// Specifies whether to enable guardrail evaluation on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailTopicAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// Contains details about topics that the guardrail should identify and deny.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailTopicPolicy struct {

	// A list of policies related to topics that the guardrail should deny.
	//
	// This member is required.
	Topics []GuardrailTopic

	// The tier that your guardrail uses for denied topic filters.
	Tier *GuardrailTopicsTier

	noSmithyDocumentSerde
}

// Contains details about topics that the guardrail should identify and deny.
type GuardrailTopicPolicyConfig struct {

	// A list of policies related to topics that the guardrail should deny.
	//
	// This member is required.
	TopicsConfig []GuardrailTopicConfig

	// The tier that your guardrail uses for denied topic filters.
	TierConfig *GuardrailTopicsTierConfig

	noSmithyDocumentSerde
}

// The tier that your guardrail uses for denied topic filters.
type GuardrailTopicsTier struct {

	// The tier that your guardrail uses for denied topic filters. Valid values
	// include:
	//
	//   - CLASSIC tier – Provides established guardrails functionality supporting
	//   English, French, and Spanish languages.
	//
	//   - STANDARD tier – Provides a more robust solution than the CLASSIC tier and
	//   has more comprehensive language support. This tier requires that your guardrail
	//   use [cross-Region inference].
	//
	// [cross-Region inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
	//
	// This member is required.
	TierName GuardrailTopicsTierName

	noSmithyDocumentSerde
}

// The tier that your guardrail uses for denied topic filters. Consider using a
// tier that balances performance, accuracy, and compatibility with your existing
// generative AI workflows.
type GuardrailTopicsTierConfig struct {

	// The tier that your guardrail uses for denied topic filters. Valid values
	// include:
	//
	//   - CLASSIC tier – Provides established guardrails functionality supporting
	//   English, French, and Spanish languages.
	//
	//   - STANDARD tier – Provides a more robust solution than the CLASSIC tier and
	//   has more comprehensive language support. This tier requires that your guardrail
	//   use [cross-Region inference].
	//
	// [cross-Region inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html
	//
	// This member is required.
	TierName GuardrailTopicsTierName

	noSmithyDocumentSerde
}

// A word configured for the guardrail.
type GuardrailWord struct {

	// Text of the word configured for the guardrail to block.
	//
	// This member is required.
	Text *string

	// The action to take when harmful content is detected in the input. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailWordAction

	// Indicates whether guardrail evaluation is enabled on the input. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// The action to take when harmful content is detected in the output. Supported
	// values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailWordAction

	// Indicates whether guardrail evaluation is enabled on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// A word to configure for the guardrail.
type GuardrailWordConfig struct {

	// Text of the word configured for the guardrail to block.
	//
	// This member is required.
	Text *string

	// Specifies the action to take when harmful content is detected in the input.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	InputAction GuardrailWordAction

	// Specifies whether to enable guardrail evaluation on the intput. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	InputEnabled *bool

	// Specifies the action to take when harmful content is detected in the output.
	// Supported values include:
	//
	//   - BLOCK – Block the content and replace it with blocked messaging.
	//
	//   - NONE – Take no action but return detection information in the trace response.
	OutputAction GuardrailWordAction

	// Specifies whether to enable guardrail evaluation on the output. When disabled,
	// you aren't charged for the evaluation. The evaluation doesn't appear in the
	// response.
	OutputEnabled *bool

	noSmithyDocumentSerde
}

// Contains details about the word policy configured for the guardrail.
type GuardrailWordPolicy struct {

	// A list of managed words configured for the guardrail.
	ManagedWordLists []GuardrailManagedWords

	// A list of words configured for the guardrail.
	Words []GuardrailWord

	noSmithyDocumentSerde
}

// Contains details about the word policy to configured for the guardrail.
type GuardrailWordPolicyConfig struct {

	// A list of managed words to configure for the guardrail.
	ManagedWordListsConfig []GuardrailManagedWordsConfig

	// A list of words to configure for the guardrail.
	WordsConfig []GuardrailWordConfig

	noSmithyDocumentSerde
}

// Specifies the custom metrics, how tasks will be rated, the flow definition ARN,
// and your custom prompt datasets. Model evaluation jobs use human workers only
// support the use of custom prompt datasets. To learn more about custom prompt
// datasets and the required format, see [Custom prompt datasets].
//
// When you create custom metrics in HumanEvaluationCustomMetric you must specify
// the metric's name . The list of names specified in the
// HumanEvaluationCustomMetric array, must match the metricNames array of strings
// specified in EvaluationDatasetMetricConfig . For example, if in the
// HumanEvaluationCustomMetric array your specified the names "accuracy",
// "toxicity", "readability" as custom metrics then the metricNames array would
// need to look like the following ["accuracy", "toxicity", "readability"] in
// EvaluationDatasetMetricConfig .
//
// [Custom prompt datasets]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html
type HumanEvaluationConfig struct {

	// Use to specify the metrics, task, and prompt dataset to be used in your model
	// evaluation job.
	//
	// This member is required.
	DatasetMetricConfigs []EvaluationDatasetMetricConfig

	// A HumanEvaluationCustomMetric object. It contains the names the metrics, how
	// the metrics are to be evaluated, an optional description.
	CustomMetrics []HumanEvaluationCustomMetric

	// The parameters of the human workflow.
	HumanWorkflowConfig *HumanWorkflowConfig

	noSmithyDocumentSerde
}

// In a model evaluation job that uses human workers you must define the name of
// the metric, and how you want that metric rated ratingMethod , and an optional
// description of the metric.
type HumanEvaluationCustomMetric struct {

	// The name of the metric. Your human evaluators will see this name in the
	// evaluation UI.
	//
	// This member is required.
	Name *string

	// Choose how you want your human workers to evaluation your model. Valid values
	// for rating methods are ThumbsUpDown , IndividualLikertScale ,
	// ComparisonLikertScale , ComparisonChoice , and ComparisonRank
	//
	// This member is required.
	RatingMethod *string

	// An optional description of the metric. Use this parameter to provide more
	// details about the metric.
	Description *string

	noSmithyDocumentSerde
}

// Contains SageMakerFlowDefinition object. The object is used to specify the
// prompt dataset, task type, rating method and metric names.
type HumanWorkflowConfig struct {

	// The Amazon Resource Number (ARN) for the flow definition
	//
	// This member is required.
	FlowDefinitionArn *string

	// Instructions for the flow definition
	Instructions *string

	noSmithyDocumentSerde
}

// Configuration for implicit filtering in Knowledge Base vector searches.
// Implicit filtering allows you to automatically filter search results based on
// metadata attributes without requiring explicit filter expressions in each query.
type ImplicitFilterConfiguration struct {

	// A list of metadata attribute schemas that define the structure and properties
	// of metadata fields used for implicit filtering. Each attribute defines a key,
	// type, and optional description.
	//
	// This member is required.
	MetadataAttributes []MetadataAttributeSchema

	// The Amazon Resource Name (ARN) of the foundation model used for implicit
	// filtering. This model processes the query to extract relevant filtering
	// criteria.
	//
	// This member is required.
	ModelArn *string

	noSmithyDocumentSerde
}

// Information about the imported model.
type ImportedModelSummary struct {

	// Creation time of the imported model.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the imported model.
	//
	// This member is required.
	ModelArn *string

	// Name of the imported model.
	//
	// This member is required.
	ModelName *string

	// Specifies if the imported model supports converse.
	InstructSupported *bool

	// The architecture of the imported model.
	ModelArchitecture *string

	noSmithyDocumentSerde
}

// Contains information about a model.
type InferenceProfileModel struct {

	// The Amazon Resource Name (ARN) of the model.
	ModelArn *string

	noSmithyDocumentSerde
}

// Contains information about the model or system-defined inference profile that
// is the source for an inference profile..
//
// The following types satisfy this interface:
//
//	InferenceProfileModelSourceMemberCopyFrom
type InferenceProfileModelSource interface {
	isInferenceProfileModelSource()
}

// The ARN of the model or system-defined inference profile that is the source for
// the inference profile.
type InferenceProfileModelSourceMemberCopyFrom struct {
	Value string

	noSmithyDocumentSerde
}

func (*InferenceProfileModelSourceMemberCopyFrom) isInferenceProfileModelSource() {}

// Contains information about an inference profile.
type InferenceProfileSummary struct {

	// The Amazon Resource Name (ARN) of the inference profile.
	//
	// This member is required.
	InferenceProfileArn *string

	// The unique identifier of the inference profile.
	//
	// This member is required.
	InferenceProfileId *string

	// The name of the inference profile.
	//
	// This member is required.
	InferenceProfileName *string

	// A list of information about each model in the inference profile.
	//
	// This member is required.
	Models []InferenceProfileModel

	// The status of the inference profile. ACTIVE means that the inference profile is
	// ready to be used.
	//
	// This member is required.
	Status InferenceProfileStatus

	// The type of the inference profile. The following types are possible:
	//
	//   - SYSTEM_DEFINED – The inference profile is defined by Amazon Bedrock. You can
	//   route inference requests across regions with these inference profiles.
	//
	//   - APPLICATION – The inference profile was created by a user. This type of
	//   inference profile can track metrics and costs when invoking the model in it. The
	//   inference profile may route requests to one or multiple regions.
	//
	// This member is required.
	Type InferenceProfileType

	// The time at which the inference profile was created.
	CreatedAt *time.Time

	// The description of the inference profile.
	Description *string

	// The time at which the inference profile was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Settings for using invocation logs to customize a model.
type InvocationLogsConfig struct {

	// The source of the invocation logs.
	//
	// This member is required.
	InvocationLogSource InvocationLogSource

	// Rules for filtering invocation logs based on request metadata.
	RequestMetadataFilters RequestMetadataFilters

	// Whether to use the model's response for training, or just the prompt. The
	// default value is False .
	UsePromptResponse bool

	noSmithyDocumentSerde
}

// A storage location for invocation logs.
//
// The following types satisfy this interface:
//
//	InvocationLogSourceMemberS3Uri
type InvocationLogSource interface {
	isInvocationLogSource()
}

// The URI of an invocation log in a bucket.
type InvocationLogSourceMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*InvocationLogSourceMemberS3Uri) isInvocationLogSource() {}

// Contains configuration details of the inference for knowledge base retrieval
// and response generation.
type KbInferenceConfig struct {

	// Contains configuration details for text generation using a language model via
	// the RetrieveAndGenerate function.
	TextInferenceConfig *TextInferenceConfig

	noSmithyDocumentSerde
}

// The configuration details for retrieving information from a knowledge base and
// generating responses.
//
// The following types satisfy this interface:
//
//	KnowledgeBaseConfigMemberRetrieveAndGenerateConfig
//	KnowledgeBaseConfigMemberRetrieveConfig
type KnowledgeBaseConfig interface {
	isKnowledgeBaseConfig()
}

// Contains configuration details for retrieving information from a knowledge base
// and generating responses.
type KnowledgeBaseConfigMemberRetrieveAndGenerateConfig struct {
	Value RetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

func (*KnowledgeBaseConfigMemberRetrieveAndGenerateConfig) isKnowledgeBaseConfig() {}

// Contains configuration details for retrieving information from a knowledge base.
type KnowledgeBaseConfigMemberRetrieveConfig struct {
	Value RetrieveConfig

	noSmithyDocumentSerde
}

func (*KnowledgeBaseConfigMemberRetrieveConfig) isKnowledgeBaseConfig() {}

// Contains configuration details for retrieving information from a knowledge base.
type KnowledgeBaseRetrievalConfiguration struct {

	// Contains configuration details for returning the results from the vector search.
	//
	// This member is required.
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration

	noSmithyDocumentSerde
}

// Contains configuration details for retrieving information from a knowledge base
// and generating responses.
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The Amazon Resource Name (ARN) of the foundation model or [inference profile] used to generate
	// responses.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelArn *string

	// Contains configurations details for response generation based on retrieved text
	// chunks.
	GenerationConfiguration *GenerationConfiguration

	// Contains configuration details for the model to process the prompt prior to
	// retrieval and response generation.
	OrchestrationConfiguration *OrchestrationConfiguration

	// Contains configuration details for retrieving text chunks.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// The configuration details for returning the results from the knowledge base
// vector search.
type KnowledgeBaseVectorSearchConfiguration struct {

	// Specifies the filters to use on the metadata fields in the knowledge base data
	// sources before returning results.
	Filter RetrievalFilter

	// Configuration for implicit filtering in Knowledge Base vector searches. This
	// allows the system to automatically apply filters based on the query context
	// without requiring explicit filter expressions.
	ImplicitFilterConfiguration *ImplicitFilterConfiguration

	// The number of text chunks to retrieve; the number of results to return.
	NumberOfResults *int32

	// By default, Amazon Bedrock decides a search strategy for you. If you're using
	// an Amazon OpenSearch Serverless vector store that contains a filterable text
	// field, you can specify whether to query the knowledge base with a HYBRID search
	// using both vector embeddings and raw text, or SEMANTIC search using only vector
	// embeddings. For other vector store configurations, only SEMANTIC search is
	// available.
	OverrideSearchType SearchType

	// Configuration for reranking search results in Knowledge Base vector searches.
	// Reranking improves search relevance by reordering initial vector search results
	// using more sophisticated relevance models.
	RerankingConfiguration *VectorSearchRerankingConfiguration

	noSmithyDocumentSerde
}

// The legal term of the agreement.
type LegalTerm struct {

	// URL to the legal term document.
	Url *string

	noSmithyDocumentSerde
}

// Configuration fields for invocation logging.
type LoggingConfig struct {

	// Set to include audio data in the log delivery.
	AudioDataDeliveryEnabled *bool

	// CloudWatch logging configuration.
	CloudWatchConfig *CloudWatchConfig

	// Set to include embeddings data in the log delivery.
	EmbeddingDataDeliveryEnabled *bool

	// Set to include image data in the log delivery.
	ImageDataDeliveryEnabled *bool

	// S3 configuration for storing log data.
	S3Config *S3Config

	// Set to include text data in the log delivery.
	TextDataDeliveryEnabled *bool

	// Set to include video data in the log delivery.
	VideoDataDeliveryEnabled *bool

	noSmithyDocumentSerde
}

// Contains details about an endpoint for a model from Amazon Bedrock Marketplace.
type MarketplaceModelEndpoint struct {

	// The timestamp when the endpoint was registered.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The configuration of the endpoint, including the number and type of instances
	// used.
	//
	// This member is required.
	EndpointConfig EndpointConfig

	// The current status of the endpoint (e.g., Creating, InService, Updating,
	// Failed).
	//
	// This member is required.
	EndpointStatus *string

	// The ARN of the model from Amazon Bedrock Marketplace that is deployed on this
	// endpoint.
	//
	// This member is required.
	ModelSourceIdentifier *string

	// The timestamp when the endpoint was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Additional information about the endpoint status, if available.
	EndpointStatusMessage *string

	// The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE,
	// INACTIVE).
	Status Status

	// Additional information about the overall status, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Provides a summary of an endpoint for a model from Amazon Bedrock Marketplace.
type MarketplaceModelEndpointSummary struct {

	// The timestamp when the endpoint was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The ARN of the model from Amazon Bedrock Marketplace that is deployed on this
	// endpoint.
	//
	// This member is required.
	ModelSourceIdentifier *string

	// The timestamp when the endpoint was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The overall status of the endpoint in Amazon Bedrock Marketplace.
	Status Status

	// Additional information about the overall status, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Defines the schema for a metadata attribute used in Knowledge Base vector
// searches. Metadata attributes provide additional context for documents and can
// be used for filtering and reranking search results.
type MetadataAttributeSchema struct {

	// An optional description of the metadata attribute that provides additional
	// context about its purpose and usage.
	//
	// This member is required.
	Description *string

	// The unique identifier for the metadata attribute. This key is used to reference
	// the attribute in filter expressions and reranking configurations.
	//
	// This member is required.
	Key *string

	// The data type of the metadata attribute. The type determines how the attribute
	// can be used in filter expressions and reranking.
	//
	// This member is required.
	Type AttributeType

	noSmithyDocumentSerde
}

// Configuration for how metadata should be used during the reranking process in
// Knowledge Base vector searches. This determines which metadata fields are
// included or excluded when reordering search results.
type MetadataConfigurationForReranking struct {

	// The mode for selecting which metadata fields to include in the reranking
	// process. Valid values are ALL (use all available metadata fields) or SELECTIVE
	// (use only specified fields).
	//
	// This member is required.
	SelectionMode RerankingMetadataSelectionMode

	// Configuration for selective mode, which allows you to explicitly include or
	// exclude specific metadata fields during reranking. This is only used when
	// selectionMode is set to SELECTIVE.
	SelectiveModeConfiguration RerankingMetadataSelectiveModeConfiguration

	noSmithyDocumentSerde
}

// Contains details about each model copy job.
//
// This data type is used in the following API operations:
//
// [ListModelCopyJobs response]
//
// [ListModelCopyJobs response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCopyJobs.html#API_ListModelCopyJobs_ResponseSyntax
type ModelCopyJobSummary struct {

	// The time that the model copy job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resoource Name (ARN) of the model copy job.
	//
	// This member is required.
	JobArn *string

	// The unique identifier of the account that the model being copied originated
	// from.
	//
	// This member is required.
	SourceAccountId *string

	// The Amazon Resource Name (ARN) of the original model being copied.
	//
	// This member is required.
	SourceModelArn *string

	// The status of the model copy job.
	//
	// This member is required.
	Status ModelCopyJobStatus

	// The Amazon Resource Name (ARN) of the copied model.
	//
	// This member is required.
	TargetModelArn *string

	// If a model fails to be copied, a message describing why the job failed is
	// included here.
	FailureMessage *string

	// The name of the original model being copied.
	SourceModelName *string

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the copied model.
	TargetModelKmsKeyArn *string

	// The name of the copied model.
	TargetModelName *string

	// Tags associated with the copied model.
	TargetModelTags []Tag

	noSmithyDocumentSerde
}

// Information about one customization job
type ModelCustomizationJobSummary struct {

	// Amazon Resource Name (ARN) of the base model.
	//
	// This member is required.
	BaseModelArn *string

	// Creation time of the custom model.
	//
	// This member is required.
	CreationTime *time.Time

	// Amazon Resource Name (ARN) of the customization job.
	//
	// This member is required.
	JobArn *string

	// Name of the customization job.
	//
	// This member is required.
	JobName *string

	// Status of the customization job.
	//
	// This member is required.
	Status ModelCustomizationJobStatus

	// Amazon Resource Name (ARN) of the custom model.
	CustomModelArn *string

	// Name of the custom model.
	CustomModelName *string

	// Specifies whether to carry out continued pre-training of a model or whether to
	// fine-tune it. For more information, see [Custom models].
	//
	// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
	CustomizationType CustomizationType

	// Time that the customization job ended.
	EndTime *time.Time

	// Time that the customization job was last modified.
	LastModifiedTime *time.Time

	// Details about the status of the data processing sub-task of the job.
	StatusDetails *StatusDetails

	noSmithyDocumentSerde
}

// The data source of the model to import.
//
// The following types satisfy this interface:
//
//	ModelDataSourceMemberS3DataSource
type ModelDataSource interface {
	isModelDataSource()
}

// The Amazon S3 data source of the model to import.
type ModelDataSourceMemberS3DataSource struct {
	Value S3DataSource

	noSmithyDocumentSerde
}

func (*ModelDataSourceMemberS3DataSource) isModelDataSource() {}

// Information about the import job.
type ModelImportJobSummary struct {

	// The time import job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the import job.
	//
	// This member is required.
	JobArn *string

	// The name of the import job.
	//
	// This member is required.
	JobName *string

	// The status of the imported job.
	//
	// This member is required.
	Status ModelImportJobStatus

	// The time when import job ended.
	EndTime *time.Time

	// The Amazon resource Name (ARN) of the imported model.
	ImportedModelArn *string

	// The name of the imported model.
	ImportedModelName *string

	// The time when the import job was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Details about the location of the input to the batch inference job.
//
// The following types satisfy this interface:
//
//	ModelInvocationJobInputDataConfigMemberS3InputDataConfig
type ModelInvocationJobInputDataConfig interface {
	isModelInvocationJobInputDataConfig()
}

// Contains the configuration of the S3 location of the input data.
type ModelInvocationJobInputDataConfigMemberS3InputDataConfig struct {
	Value ModelInvocationJobS3InputDataConfig

	noSmithyDocumentSerde
}

func (*ModelInvocationJobInputDataConfigMemberS3InputDataConfig) isModelInvocationJobInputDataConfig() {
}

// Contains the configuration of the S3 location of the output data.
//
// The following types satisfy this interface:
//
//	ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig
type ModelInvocationJobOutputDataConfig interface {
	isModelInvocationJobOutputDataConfig()
}

// Contains the configuration of the S3 location of the output data.
type ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig struct {
	Value ModelInvocationJobS3OutputDataConfig

	noSmithyDocumentSerde
}

func (*ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig) isModelInvocationJobOutputDataConfig() {
}

// Contains the configuration of the S3 location of the input data.
type ModelInvocationJobS3InputDataConfig struct {

	// The S3 location of the input data.
	//
	// This member is required.
	S3Uri *string

	// The ID of the Amazon Web Services account that owns the S3 bucket containing
	// the input data.
	S3BucketOwner *string

	// The format of the input data.
	S3InputFormat S3InputFormat

	noSmithyDocumentSerde
}

// Contains the configuration of the S3 location of the output data.
type ModelInvocationJobS3OutputDataConfig struct {

	// The S3 location of the output data.
	//
	// This member is required.
	S3Uri *string

	// The ID of the Amazon Web Services account that owns the S3 bucket containing
	// the output data.
	S3BucketOwner *string

	// The unique identifier of the key that encrypts the S3 location of the output
	// data.
	S3EncryptionKeyId *string

	noSmithyDocumentSerde
}

// A summary of a batch inference job.
type ModelInvocationJobSummary struct {

	// Details about the location of the input to the batch inference job.
	//
	// This member is required.
	InputDataConfig ModelInvocationJobInputDataConfig

	// The Amazon Resource Name (ARN) of the batch inference job.
	//
	// This member is required.
	JobArn *string

	// The name of the batch inference job.
	//
	// This member is required.
	JobName *string

	// The unique identifier of the foundation model used for model inference.
	//
	// This member is required.
	ModelId *string

	// Details about the location of the output of the batch inference job.
	//
	// This member is required.
	OutputDataConfig ModelInvocationJobOutputDataConfig

	// The Amazon Resource Name (ARN) of the service role with permissions to carry
	// out and manage batch inference. You can use the console to create a default
	// service role or follow the steps at [Create a service role for batch inference].
	//
	// [Create a service role for batch inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html
	//
	// This member is required.
	RoleArn *string

	// The time at which the batch inference job was submitted.
	//
	// This member is required.
	SubmitTime *time.Time

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// The time at which the batch inference job ended.
	EndTime *time.Time

	// The time at which the batch inference job times or timed out.
	JobExpirationTime *time.Time

	// The time at which the batch inference job was last modified.
	LastModifiedTime *time.Time

	// If the batch inference job failed, this field contains a message describing why
	// the job failed.
	Message *string

	// The status of the batch inference job.
	//
	// The following statuses are possible:
	//
	//   - Submitted – This job has been submitted to a queue for validation.
	//
	//   - Validating – This job is being validated for the requirements described in [Format and upload your batch inference data]
	//   . The criteria include the following:
	//
	//   - Your IAM service role has access to the Amazon S3 buckets containing your
	//   files.
	//
	//   - Your files are .jsonl files and each individual record is a JSON object in
	//   the correct format. Note that validation doesn't check if the modelInput value
	//   matches the request body for the model.
	//
	//   - Your files fulfill the requirements for file size and number of records.
	//   For more information, see [Quotas for Amazon Bedrock].
	//
	//   - Scheduled – This job has been validated and is now in a queue. The job will
	//   automatically start when it reaches its turn.
	//
	//   - Expired – This job timed out because it was scheduled but didn't begin
	//   before the set timeout duration. Submit a new job request.
	//
	//   - InProgress – This job has begun. You can start viewing the results in the
	//   output S3 location.
	//
	//   - Completed – This job has successfully completed. View the output files in
	//   the output S3 location.
	//
	//   - PartiallyCompleted – This job has partially completed. Not all of your
	//   records could be processed in time. View the output files in the output S3
	//   location.
	//
	//   - Failed – This job has failed. Check the failure message for any further
	//   details. For further assistance, reach out to the [Amazon Web Services Support Center].
	//
	//   - Stopped – This job was stopped by a user.
	//
	//   - Stopping – This job is being stopped by a user.
	//
	// [Format and upload your batch inference data]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html
	// [Quotas for Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html
	// [Amazon Web Services Support Center]: https://console.aws.amazon.com/support/home/
	Status ModelInvocationJobStatus

	// The number of hours after which the batch inference job was set to time out.
	TimeoutDurationInHours *int32

	// The configuration of the Virtual Private Cloud (VPC) for the data in the batch
	// inference job. For more information, see [Protect batch inference jobs using a VPC].
	//
	// [Protect batch inference jobs using a VPC]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// An offer dictates usage terms for the model.
type Offer struct {

	// Offer token.
	//
	// This member is required.
	OfferToken *string

	// Details about the terms of the offer.
	//
	// This member is required.
	TermDetails *TermDetails

	// Offer Id for a model offer.
	OfferId *string

	noSmithyDocumentSerde
}

// The configuration details for the model to process the prompt prior to
// retrieval and response generation.
type OrchestrationConfiguration struct {

	// Contains configuration details for transforming the prompt.
	//
	// This member is required.
	QueryTransformationConfiguration *QueryTransformationConfiguration

	noSmithyDocumentSerde
}

// S3 Location of the output data.
type OutputDataConfig struct {

	// The S3 URI where the output data is stored.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Contains performance settings for a model.
type PerformanceConfiguration struct {

	// Specifies whether to use the latency-optimized or standard version of a model
	// or inference profile.
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// Describes the usage-based pricing term.
type PricingTerm struct {

	// Describes a usage price for each dimension.
	//
	// This member is required.
	RateCard []DimensionalPriceRate

	noSmithyDocumentSerde
}

// Details about a prompt router.
type PromptRouterSummary struct {

	// The router's fallback model.
	//
	// This member is required.
	FallbackModel *PromptRouterTargetModel

	// The router's models.
	//
	// This member is required.
	Models []PromptRouterTargetModel

	// The router's ARN.
	//
	// This member is required.
	PromptRouterArn *string

	// The router's name.
	//
	// This member is required.
	PromptRouterName *string

	// The router's routing criteria.
	//
	// This member is required.
	RoutingCriteria *RoutingCriteria

	// The router's status.
	//
	// This member is required.
	Status PromptRouterStatus

	// The summary's type.
	//
	// This member is required.
	Type PromptRouterType

	// When the router was created.
	CreatedAt *time.Time

	// The router's description.
	Description *string

	// When the router was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The target model for a prompt router.
type PromptRouterTargetModel struct {

	// The target model's ARN.
	//
	// This member is required.
	ModelArn *string

	noSmithyDocumentSerde
}

// The template for the prompt that's sent to the model for response generation.
type PromptTemplate struct {

	// The template for the prompt that's sent to the model for response generation.
	// You can include prompt placeholders, which become replaced before the prompt is
	// sent to the model to provide instructions and context to the model. In addition,
	// you can include XML tags to delineate meaningful sections of the prompt
	// template.
	//
	// For more information, see [Knowledge base prompt template] and [Use XML tags with Anthropic Claude models].
	//
	// [Knowledge base prompt template]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	// [Use XML tags with Anthropic Claude models]: https://docs.anthropic.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags
	TextPromptTemplate *string

	noSmithyDocumentSerde
}

// A summary of information about a Provisioned Throughput.
//
// This data type is used in the following API operations:
//
// [ListProvisionedThroughputs response]
//
// [ListProvisionedThroughputs response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html#API_ListProvisionedModelThroughputs_ResponseSyntax
type ProvisionedModelSummary struct {

	// The time that the Provisioned Throughput was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model requested to be associated to this
	// Provisioned Throughput. This value differs from the modelArn if updating hasn't
	// completed.
	//
	// This member is required.
	DesiredModelArn *string

	// The number of model units that was requested to be allocated to the Provisioned
	// Throughput.
	//
	// This member is required.
	DesiredModelUnits *int32

	// The Amazon Resource Name (ARN) of the base model for which the Provisioned
	// Throughput was created, or of the base model that the custom model for which the
	// Provisioned Throughput was created was customized.
	//
	// This member is required.
	FoundationModelArn *string

	// The time that the Provisioned Throughput was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the model associated with the Provisioned
	// Throughput.
	//
	// This member is required.
	ModelArn *string

	// The number of model units allocated to the Provisioned Throughput.
	//
	// This member is required.
	ModelUnits *int32

	// The Amazon Resource Name (ARN) of the Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelArn *string

	// The name of the Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelName *string

	// The status of the Provisioned Throughput.
	//
	// This member is required.
	Status ProvisionedModelStatus

	// The duration for which the Provisioned Throughput was committed.
	CommitmentDuration CommitmentDuration

	// The timestamp for when the commitment term of the Provisioned Throughput
	// expires.
	CommitmentExpirationTime *time.Time

	noSmithyDocumentSerde
}

// The configuration details for transforming the prompt.
type QueryTransformationConfiguration struct {

	// The type of transformation to apply to the prompt.
	//
	// This member is required.
	Type QueryTransformationType

	noSmithyDocumentSerde
}

// Contains configuration details for retrieval of information and response
// generation.
//
// The following types satisfy this interface:
//
//	RAGConfigMemberKnowledgeBaseConfig
//	RAGConfigMemberPrecomputedRagSourceConfig
type RAGConfig interface {
	isRAGConfig()
}

// Contains configuration details for knowledge base retrieval and response
// generation.
type RAGConfigMemberKnowledgeBaseConfig struct {
	Value KnowledgeBaseConfig

	noSmithyDocumentSerde
}

func (*RAGConfigMemberKnowledgeBaseConfig) isRAGConfig() {}

// Contains configuration details about the RAG source used to generate inference
// response data for a Knowledge Base evaluation job.
type RAGConfigMemberPrecomputedRagSourceConfig struct {
	Value EvaluationPrecomputedRagSourceConfig

	noSmithyDocumentSerde
}

func (*RAGConfigMemberPrecomputedRagSourceConfig) isRAGConfig() {}

// Defines the value and corresponding definition for one rating in a custom
// metric rating scale.
type RatingScaleItem struct {

	// Defines the definition for one rating in a custom metric rating scale.
	//
	// This member is required.
	Definition *string

	// Defines the value for one rating in a custom metric rating scale.
	//
	// This member is required.
	Value RatingScaleItemValue

	noSmithyDocumentSerde
}

// Defines the value for one rating in a custom metric rating scale.
//
// The following types satisfy this interface:
//
//	RatingScaleItemValueMemberFloatValue
//	RatingScaleItemValueMemberStringValue
type RatingScaleItemValue interface {
	isRatingScaleItemValue()
}

// A floating point number representing the value for a rating in a custom metric
// rating scale.
type RatingScaleItemValueMemberFloatValue struct {
	Value float32

	noSmithyDocumentSerde
}

func (*RatingScaleItemValueMemberFloatValue) isRatingScaleItemValue() {}

// A string representing the value for a rating in a custom metric rating scale.
type RatingScaleItemValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*RatingScaleItemValueMemberStringValue) isRatingScaleItemValue() {}

// A mapping of a metadata key to a value that it should or should not equal.
type RequestMetadataBaseFilters struct {

	// Include results where the key equals the value.
	Equals map[string]string

	// Include results where the key does not equal the value.
	NotEquals map[string]string

	noSmithyDocumentSerde
}

// Rules for filtering invocation logs. A filter can be a mapping of a metadata
// key to a value that it should or should not equal (a base filter), or a list of
// base filters that are all applied with AND or OR logical operators
//
// The following types satisfy this interface:
//
//	RequestMetadataFiltersMemberAndAll
//	RequestMetadataFiltersMemberEquals
//	RequestMetadataFiltersMemberNotEquals
//	RequestMetadataFiltersMemberOrAll
type RequestMetadataFilters interface {
	isRequestMetadataFilters()
}

// Include results where all of the based filters match.
type RequestMetadataFiltersMemberAndAll struct {
	Value []RequestMetadataBaseFilters

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberAndAll) isRequestMetadataFilters() {}

// Include results where the key equals the value.
type RequestMetadataFiltersMemberEquals struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberEquals) isRequestMetadataFilters() {}

// Include results where the key does not equal the value.
type RequestMetadataFiltersMemberNotEquals struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberNotEquals) isRequestMetadataFilters() {}

// Include results where any of the base filters match.
type RequestMetadataFiltersMemberOrAll struct {
	Value []RequestMetadataBaseFilters

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberOrAll) isRequestMetadataFilters() {}

// Configuration for selectively including or excluding metadata fields during the
// reranking process. This allows you to control which metadata attributes are
// considered when reordering search results.
//
// The following types satisfy this interface:
//
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude
//	RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude
type RerankingMetadataSelectiveModeConfiguration interface {
	isRerankingMetadataSelectiveModeConfiguration()
}

// A list of metadata field names to explicitly exclude from the reranking
// process. All metadata fields except these will be considered when reordering
// search results. This parameter cannot be used together with fieldsToInclude.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToExclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// A list of metadata field names to explicitly include in the reranking process.
// Only these fields will be considered when reordering search results. This
// parameter cannot be used together with fieldsToExclude.
type RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude struct {
	Value []FieldForReranking

	noSmithyDocumentSerde
}

func (*RerankingMetadataSelectiveModeConfigurationMemberFieldsToInclude) isRerankingMetadataSelectiveModeConfiguration() {
}

// Specifies the filters to use on the metadata attributes/fields in the knowledge
// base data sources before returning results.
//
// The following types satisfy this interface:
//
//	RetrievalFilterMemberAndAll
//	RetrievalFilterMemberEquals
//	RetrievalFilterMemberGreaterThan
//	RetrievalFilterMemberGreaterThanOrEquals
//	RetrievalFilterMemberIn
//	RetrievalFilterMemberLessThan
//	RetrievalFilterMemberLessThanOrEquals
//	RetrievalFilterMemberListContains
//	RetrievalFilterMemberNotEquals
//	RetrievalFilterMemberNotIn
//	RetrievalFilterMemberOrAll
//	RetrievalFilterMemberStartsWith
//	RetrievalFilterMemberStringContains
type RetrievalFilter interface {
	isRetrievalFilter()
}

// Knowledge base data sources are returned if their metadata attributes fulfill
// all the filter conditions inside this list.
type RetrievalFilterMemberAndAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberAndAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value matches the value in this object.
//
// The following example would return data sources with an animal attribute whose
// value is 'cat': "equals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is greater than '1989': "greaterThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberGreaterThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than or equal to the value
// in this object.
//
// The following example would return data sources with an year attribute whose
// value is greater than or equal to '1989': "greaterThanOrEquals": { "key":
// "year", "value": 1989 }
type RetrievalFilterMemberGreaterThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is in the list specified in the value
// in this object.
//
// The following example would return data sources with an animal attribute that
// is either 'cat' or 'dog': "in": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is less than to '1989': "lessThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberLessThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than or equal to the value in
// this object.
//
// The following example would return data sources with an year attribute whose
// value is less than or equal to '1989': "lessThanOrEquals": { "key": "year",
// "value": 1989 }
type RetrievalFilterMemberLessThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is a list that contains the value as
// one of its members.
//
// The following example would return data sources with an animals attribute that
// is a list containing a cat member (for example, ["dog", "cat"] ):
// "listContains": { "key": "animals", "value": "cat" }
type RetrievalFilterMemberListContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberListContains) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value doesn't match the value in this object are
// returned.
//
// The following example would return data sources that don't contain an animal
// attribute whose value is 'cat': "notEquals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberNotEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value isn't in the list specified in the
// value in this object.
//
// The following example would return data sources whose animal attribute is
// neither 'cat' nor 'dog': "notIn": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberNotIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if their metadata attributes fulfill
// at least one of the filter conditions inside this list.
type RetrievalFilterMemberOrAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberOrAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value starts with the value in this object.
// This filter is currently only supported for Amazon OpenSearch Serverless vector
// stores.
//
// The following example would return data sources with an animal attribute starts
// with 'ca' (for example, 'cat' or 'camel'). "startsWith": { "key": "animal",
// "value": "ca" }
type RetrievalFilterMemberStartsWith struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStartsWith) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is one of the following:
//
// A string that contains the value as a substring. The following example would
// return data sources with an animal attribute that contains the substring at (for
// example, 'cat'): "stringContains": { "key": "animal", "value": "at" }
//
// A list with a member that contains the value as a substring. The following
// example would return data sources with an animals attribute that is a list
// containing a member that contains the substring at (for example, ["dog", "cat"]
// ): "stringContains": { "key": "animals", "value": "at" }
type RetrievalFilterMemberStringContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStringContains) isRetrievalFilter() {}

// Contains configuration details for a knowledge base retrieval and response
// generation.
type RetrieveAndGenerateConfiguration struct {

	// The type of resource that contains your data for retrieving information and
	// generating responses.
	//
	// If you choose to use EXTERNAL_SOURCES , then currently only Claude 3 Sonnet
	// models for knowledge bases are supported.
	//
	// This member is required.
	Type RetrieveAndGenerateType

	// The configuration for the external source wrapper object in the
	// retrieveAndGenerate function.
	ExternalSourcesConfiguration *ExternalSourcesRetrieveAndGenerateConfiguration

	// Contains configuration details for the knowledge base retrieval and response
	// generation.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

// The configuration details for retrieving information from a knowledge base.
type RetrieveConfig struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Contains configuration details for knowledge base retrieval.
	//
	// This member is required.
	KnowledgeBaseRetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Routing criteria for a prompt router.
type RoutingCriteria struct {

	// The criteria's response quality difference.
	//
	// This member is required.
	ResponseQualityDifference *float64

	noSmithyDocumentSerde
}

// S3 configuration for storing log data.
type S3Config struct {

	// S3 bucket name.
	//
	// This member is required.
	BucketName *string

	// S3 prefix.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// The Amazon S3 data source of the model to import.
type S3DataSource struct {

	// The URI of the Amazon S3 data source.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The unique wrapper object of the document from the S3 location.
type S3ObjectDoc struct {

	// The S3 URI location for the wrapper object of the document.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Specifies the configuration for a Amazon SageMaker endpoint.
type SageMakerEndpoint struct {

	// The ARN of the IAM role that Amazon SageMaker can assume to access model
	// artifacts and docker image for deployment on Amazon EC2 compute instances or for
	// batch transform jobs.
	//
	// This member is required.
	ExecutionRole *string

	// The number of Amazon EC2 compute instances to deploy for initial endpoint
	// creation.
	//
	// This member is required.
	InitialInstanceCount *int32

	// The Amazon EC2 compute instance type to deploy for hosting the model.
	//
	// This member is required.
	InstanceType *string

	// The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on
	// the storage volume attached to the Amazon EC2 compute instance that hosts the
	// endpoint.
	KmsEncryptionKey *string

	// The VPC configuration for the endpoint.
	Vpc *VpcConfig

	noSmithyDocumentSerde
}

// For a Distillation job, the status details for sub-tasks of the job. Possible
// statuses for each sub-task include the following:
//
//   - NotStarted
//
//   - InProgress
//
//   - Completed
//
//   - Stopping
//
//   - Stopped
//
//   - Failed
type StatusDetails struct {

	// The status details for the data processing sub-task of the job.
	DataProcessingDetails *DataProcessingDetails

	// The status details for the training sub-task of the job.
	TrainingDetails *TrainingDetails

	// The status details for the validation sub-task of the job.
	ValidationDetails *ValidationDetails

	noSmithyDocumentSerde
}

// Describes a support term.
type SupportTerm struct {

	// Describes the refund policy.
	RefundPolicyDescription *string

	noSmithyDocumentSerde
}

// Definition of the key/value pair for a tag.
type Tag struct {

	// Key for the tag.
	//
	// This member is required.
	Key *string

	// Value for the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Details about a teacher model used for model customization.
type TeacherModelConfig struct {

	// The identifier of the teacher model.
	//
	// This member is required.
	TeacherModelIdentifier *string

	// The maximum number of tokens requested when the customization job invokes the
	// teacher model.
	MaxResponseLengthForInference *int32

	noSmithyDocumentSerde
}

// Describes the usage terms of an offer.
type TermDetails struct {

	// Describes the legal terms.
	//
	// This member is required.
	LegalTerm *LegalTerm

	// Describes the support terms.
	//
	// This member is required.
	SupportTerm *SupportTerm

	// Describes the usage-based pricing term.
	//
	// This member is required.
	UsageBasedPricingTerm *PricingTerm

	// Describes the validity terms.
	ValidityTerm *ValidityTerm

	noSmithyDocumentSerde
}

// The configuration details for text generation using a language model via the
// RetrieveAndGenerate function.
type TextInferenceConfig struct {

	// The maximum number of tokens to generate in the output text. Do not use the
	// minimum of 0 or the maximum of 65536. The limit values described here are
	// arbitrary values, for actual values consult the limits defined by your specific
	// model.
	MaxTokens *int32

	// A list of sequences of characters that, if generated, will cause the model to
	// stop generating further tokens. Do not use a minimum length of 1 or a maximum
	// length of 1000. The limit values described here are arbitrary values, for actual
	// values consult the limits defined by your specific model.
	StopSequences []string

	// Controls the random-ness of text generated by the language model, influencing
	// how much the model sticks to the most predictable next words versus exploring
	// more surprising options. A lower temperature value (e.g. 0.2 or 0.3) makes model
	// outputs more deterministic or predictable, while a higher temperature (e.g. 0.8
	// or 0.9) makes the outputs more creative or unpredictable.
	Temperature *float32

	// A probability distribution threshold which controls what the model considers
	// for the set of possible next tokens. The model will only consider the top p% of
	// the probability distribution when generating the next token.
	TopP *float32

	noSmithyDocumentSerde
}

// S3 Location of the training data.
type TrainingDataConfig struct {

	// Settings for using invocation logs to customize a model.
	InvocationLogsConfig *InvocationLogsConfig

	// The S3 URI where the training data is stored.
	S3Uri *string

	noSmithyDocumentSerde
}

// For a Distillation job, the status details for the training sub-task of the job.
type TrainingDetails struct {

	// The start time of the training sub-task of the job.
	CreationTime *time.Time

	// The latest update to the training sub-task of the job.
	LastModifiedTime *time.Time

	// The status of the training sub-task of the job.
	Status JobStatusDetails

	noSmithyDocumentSerde
}

// Metrics associated with the custom job.
type TrainingMetrics struct {

	// Loss metric associated with the custom job.
	TrainingLoss *float32

	noSmithyDocumentSerde
}

// Array of up to 10 validators.
type ValidationDataConfig struct {

	// Information about the validators.
	//
	// This member is required.
	Validators []Validator

	noSmithyDocumentSerde
}

// For a Distillation job, the status details for the validation sub-task of the
// job.
type ValidationDetails struct {

	// The start time of the validation sub-task of the job.
	CreationTime *time.Time

	// The latest update to the validation sub-task of the job.
	LastModifiedTime *time.Time

	// The status of the validation sub-task of the job.
	Status JobStatusDetails

	noSmithyDocumentSerde
}

// Information about a validator.
type Validator struct {

	// The S3 URI where the validation data is stored.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The metric for the validator.
type ValidatorMetric struct {

	// The validation loss associated with this validator.
	ValidationLoss *float32

	noSmithyDocumentSerde
}

// Describes the validity terms.
type ValidityTerm struct {

	// Describes the agreement duration.
	AgreementDuration *string

	noSmithyDocumentSerde
}

// Configuration for using Amazon Bedrock foundation models to rerank Knowledge
// Base vector search results. This enables more sophisticated relevance ranking
// using large language models.
type VectorSearchBedrockRerankingConfiguration struct {

	// Configuration for the Amazon Bedrock foundation model used for reranking. This
	// includes the model ARN and any additional request fields required by the model.
	//
	// This member is required.
	ModelConfiguration *VectorSearchBedrockRerankingModelConfiguration

	// Configuration for how document metadata should be used during the reranking
	// process. This determines which metadata fields are included when reordering
	// search results.
	MetadataConfiguration *MetadataConfigurationForReranking

	// The maximum number of results to rerank. This limits how many of the initial
	// vector search results will be processed by the reranking model. A smaller number
	// improves performance but may exclude potentially relevant results.
	NumberOfRerankedResults *int32

	noSmithyDocumentSerde
}

// Configuration for the Amazon Bedrock foundation model used for reranking vector
// search results. This specifies which model to use and any additional parameters
// required by the model.
type VectorSearchBedrockRerankingModelConfiguration struct {

	// The Amazon Resource Name (ARN) of the foundation model to use for reranking.
	// This model processes the query and search results to determine a more relevant
	// ordering.
	//
	// This member is required.
	ModelArn *string

	// A list of additional fields to include in the model request during reranking.
	// These fields provide extra context or configuration options specific to the
	// selected foundation model.
	AdditionalModelRequestFields map[string]document.Interface

	noSmithyDocumentSerde
}

// Configuration for reranking vector search results to improve relevance.
// Reranking applies additional relevance models to reorder the initial vector
// search results based on more sophisticated criteria.
type VectorSearchRerankingConfiguration struct {

	// The type of reranking to apply to vector search results. Currently, the only
	// supported value is BEDROCK, which uses Amazon Bedrock foundation models for
	// reranking.
	//
	// This member is required.
	Type VectorSearchRerankingConfigurationType

	// Configuration for using Amazon Bedrock foundation models to rerank search
	// results. This is required when the reranking type is set to BEDROCK.
	BedrockRerankingConfiguration *VectorSearchBedrockRerankingConfiguration

	noSmithyDocumentSerde
}

// The configuration of a virtual private cloud (VPC). For more information, see [Protect your data using Amazon Virtual Private Cloud and Amazon Web Services PrivateLink].
//
// [Protect your data using Amazon Virtual Private Cloud and Amazon Web Services PrivateLink]: https://docs.aws.amazon.com/bedrock/latest/userguide/usingVPC.html
type VpcConfig struct {

	// An array of IDs for each security group in the VPC to use.
	//
	// This member is required.
	SecurityGroupIds []string

	// An array of IDs for each subnet in the VPC to use.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAutomatedEvaluationCustomMetricSource()       {}
func (*UnknownUnionMember) isAutomatedReasoningCheckFinding()              {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyAnnotation()          {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyBuildResultAssets()   {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyBuildStepContext()    {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyDefinitionElement()   {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyMutation()            {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyTypeValueAnnotation() {}
func (*UnknownUnionMember) isAutomatedReasoningPolicyWorkflowTypeContent() {}
func (*UnknownUnionMember) isCustomizationConfig()                         {}
func (*UnknownUnionMember) isEndpointConfig()                              {}
func (*UnknownUnionMember) isEvaluationConfig()                            {}
func (*UnknownUnionMember) isEvaluationDatasetLocation()                   {}
func (*UnknownUnionMember) isEvaluationInferenceConfig()                   {}
func (*UnknownUnionMember) isEvaluationModelConfig()                       {}
func (*UnknownUnionMember) isEvaluationPrecomputedRagSourceConfig()        {}
func (*UnknownUnionMember) isEvaluatorModelConfig()                        {}
func (*UnknownUnionMember) isInferenceProfileModelSource()                 {}
func (*UnknownUnionMember) isInvocationLogSource()                         {}
func (*UnknownUnionMember) isKnowledgeBaseConfig()                         {}
func (*UnknownUnionMember) isModelDataSource()                             {}
func (*UnknownUnionMember) isModelInvocationJobInputDataConfig()           {}
func (*UnknownUnionMember) isModelInvocationJobOutputDataConfig()          {}
func (*UnknownUnionMember) isRAGConfig()                                   {}
func (*UnknownUnionMember) isRatingScaleItemValue()                        {}
func (*UnknownUnionMember) isRequestMetadataFilters()                      {}
func (*UnknownUnionMember) isRerankingMetadataSelectiveModeConfiguration() {}
func (*UnknownUnionMember) isRetrievalFilter()                             {}
