// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing Automated Reasoning policy test. You can modify the
// content, query, expected result, and confidence threshold.
func (c *Client) UpdateAutomatedReasoningPolicyTestCase(ctx context.Context, params *UpdateAutomatedReasoningPolicyTestCaseInput, optFns ...func(*Options)) (*UpdateAutomatedReasoningPolicyTestCaseOutput, error) {
	if params == nil {
		params = &UpdateAutomatedReasoningPolicyTestCaseInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAutomatedReasoningPolicyTestCase", params, optFns, c.addOperationUpdateAutomatedReasoningPolicyTestCaseMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAutomatedReasoningPolicyTestCaseOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAutomatedReasoningPolicyTestCaseInput struct {

	// The updated expected result of the Automated Reasoning check.
	//
	// This member is required.
	ExpectedAggregatedFindingsResult types.AutomatedReasoningCheckResult

	// The updated content to be validated by the Automated Reasoning policy.
	//
	// This member is required.
	GuardContent *string

	// The timestamp when the test was last updated. This is used as a concurrency
	// token to prevent conflicting modifications.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy that contains
	// the test.
	//
	// This member is required.
	PolicyArn *string

	// The unique identifier of the test to update.
	//
	// This member is required.
	TestCaseId *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error.
	ClientRequestToken *string

	// The updated minimum confidence level for logic validation. If null is provided,
	// the threshold will be removed.
	ConfidenceThreshold *float64

	// The updated input query or prompt that generated the content.
	QueryContent *string

	noSmithyDocumentSerde
}

type UpdateAutomatedReasoningPolicyTestCaseOutput struct {

	// The Amazon Resource Name (ARN) of the policy that contains the updated test.
	//
	// This member is required.
	PolicyArn *string

	// The unique identifier of the updated test.
	//
	// This member is required.
	TestCaseId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAutomatedReasoningPolicyTestCaseMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAutomatedReasoningPolicyTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAutomatedReasoningPolicyTestCase{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAutomatedReasoningPolicyTestCase"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateAutomatedReasoningPolicyTestCaseMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateAutomatedReasoningPolicyTestCaseValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicyTestCase(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateAutomatedReasoningPolicyTestCase struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateAutomatedReasoningPolicyTestCase) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateAutomatedReasoningPolicyTestCase) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateAutomatedReasoningPolicyTestCaseInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateAutomatedReasoningPolicyTestCaseInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateAutomatedReasoningPolicyTestCaseMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateAutomatedReasoningPolicyTestCase{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateAutomatedReasoningPolicyTestCase(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAutomatedReasoningPolicyTestCase",
	}
}
