// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initiates a test workflow to validate Automated Reasoning policy tests. The
// workflow executes the specified tests against the policy and generates
// validation results.
func (c *Client) StartAutomatedReasoningPolicyTestWorkflow(ctx context.Context, params *StartAutomatedReasoningPolicyTestWorkflowInput, optFns ...func(*Options)) (*StartAutomatedReasoningPolicyTestWorkflowOutput, error) {
	if params == nil {
		params = &StartAutomatedReasoningPolicyTestWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartAutomatedReasoningPolicyTestWorkflow", params, optFns, c.addOperationStartAutomatedReasoningPolicyTestWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartAutomatedReasoningPolicyTestWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartAutomatedReasoningPolicyTestWorkflowInput struct {

	// The build workflow identifier. The build workflow must show a COMPLETED status
	// before running tests.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy to test.
	//
	// This member is required.
	PolicyArn *string

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request but doesn't return an error.
	ClientRequestToken *string

	// The list of test identifiers to run. If not provided, all tests for the policy
	// are run.
	TestCaseIds []string

	noSmithyDocumentSerde
}

type StartAutomatedReasoningPolicyTestWorkflowOutput struct {

	// The Amazon Resource Name (ARN) of the policy for which the test workflow was
	// started.
	//
	// This member is required.
	PolicyArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartAutomatedReasoningPolicyTestWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartAutomatedReasoningPolicyTestWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartAutomatedReasoningPolicyTestWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartAutomatedReasoningPolicyTestWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartAutomatedReasoningPolicyTestWorkflowMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartAutomatedReasoningPolicyTestWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartAutomatedReasoningPolicyTestWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartAutomatedReasoningPolicyTestWorkflow struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartAutomatedReasoningPolicyTestWorkflow) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartAutomatedReasoningPolicyTestWorkflow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartAutomatedReasoningPolicyTestWorkflowInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartAutomatedReasoningPolicyTestWorkflowInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartAutomatedReasoningPolicyTestWorkflowMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartAutomatedReasoningPolicyTestWorkflow{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartAutomatedReasoningPolicyTestWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartAutomatedReasoningPolicyTestWorkflow",
	}
}
