// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts a new build workflow for an Automated Reasoning policy. This initiates
// the process of analyzing source documents and generating policy rules,
// variables, and types.
func (c *Client) StartAutomatedReasoningPolicyBuildWorkflow(ctx context.Context, params *StartAutomatedReasoningPolicyBuildWorkflowInput, optFns ...func(*Options)) (*StartAutomatedReasoningPolicyBuildWorkflowOutput, error) {
	if params == nil {
		params = &StartAutomatedReasoningPolicyBuildWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartAutomatedReasoningPolicyBuildWorkflow", params, optFns, c.addOperationStartAutomatedReasoningPolicyBuildWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartAutomatedReasoningPolicyBuildWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartAutomatedReasoningPolicyBuildWorkflowInput struct {

	// The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing
	// new documents, POLICY_REPAIR for fixing existing policies).
	//
	// This member is required.
	BuildWorkflowType types.AutomatedReasoningPolicyBuildWorkflowType

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to
	// start the build workflow.
	//
	// This member is required.
	PolicyArn *string

	// The source content for the build workflow, such as documents to analyze or
	// repair instructions for existing policies.
	//
	// This member is required.
	SourceContent *types.AutomatedReasoningPolicyBuildWorkflowSource

	// A unique, case-sensitive identifier to ensure that the operation completes no
	// more than once. If this token matches a previous request, Amazon Bedrock ignores
	// the request but doesn't return an error.
	ClientRequestToken *string

	noSmithyDocumentSerde
}

type StartAutomatedReasoningPolicyBuildWorkflowOutput struct {

	// The unique identifier of the newly started build workflow. Use this ID to track
	// the workflow's progress and retrieve its results.
	//
	// This member is required.
	BuildWorkflowId *string

	// The Amazon Resource Name (ARN) of the Automated Reasoning policy.
	//
	// This member is required.
	PolicyArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartAutomatedReasoningPolicyBuildWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartAutomatedReasoningPolicyBuildWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartAutomatedReasoningPolicyBuildWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartAutomatedReasoningPolicyBuildWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opStartAutomatedReasoningPolicyBuildWorkflowMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpStartAutomatedReasoningPolicyBuildWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartAutomatedReasoningPolicyBuildWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpStartAutomatedReasoningPolicyBuildWorkflow struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpStartAutomatedReasoningPolicyBuildWorkflow) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpStartAutomatedReasoningPolicyBuildWorkflow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*StartAutomatedReasoningPolicyBuildWorkflowInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *StartAutomatedReasoningPolicyBuildWorkflowInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opStartAutomatedReasoningPolicyBuildWorkflowMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpStartAutomatedReasoningPolicyBuildWorkflow{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opStartAutomatedReasoningPolicyBuildWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartAutomatedReasoningPolicyBuildWorkflow",
	}
}
