// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates an existing bill estimate.
func (c *Client) UpdateBillEstimate(ctx context.Context, params *UpdateBillEstimateInput, optFns ...func(*Options)) (*UpdateBillEstimateOutput, error) {
	if params == nil {
		params = &UpdateBillEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateBillEstimate", params, optFns, c.addOperationUpdateBillEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateBillEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateBillEstimateInput struct {

	//  The unique identifier of the bill estimate to update.
	//
	// This member is required.
	Identifier *string

	//  The new expiration date for the bill estimate.
	ExpiresAt *time.Time

	//  The new name for the bill estimate.
	Name *string

	noSmithyDocumentSerde
}

type UpdateBillEstimateOutput struct {

	//  The unique identifier of the updated bill estimate.
	//
	// This member is required.
	Id *string

	//  The time period covered by the updated bill estimate.
	BillInterval *types.BillInterval

	// The arn of the cost category used in the reserved and prioritized group sharing.
	CostCategoryGroupSharingPreferenceArn *string

	// Timestamp of the effective date of the cost category used in the group sharing
	// settings.
	CostCategoryGroupSharingPreferenceEffectiveDate *time.Time

	//  A summary of the updated estimated costs.
	CostSummary *types.BillEstimateCostSummary

	//  The timestamp when the bill estimate was originally created.
	CreatedAt *time.Time

	//  The updated expiration timestamp for the bill estimate.
	ExpiresAt *time.Time

	//  An error message if the bill estimate update failed.
	FailureMessage *string

	// The setting for the reserved instance and savings plan group sharing used in
	// this estimate.
	GroupSharingPreference types.GroupSharingPreferenceEnum

	//  The updated name of the bill estimate.
	Name *string

	//  The current status of the updated bill estimate.
	Status types.BillEstimateStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateBillEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateBillEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateBillEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateBillEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateBillEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateBillEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateBillEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateBillEstimate",
	}
}
