// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the line items associated with a bill estimate.
func (c *Client) ListBillEstimateLineItems(ctx context.Context, params *ListBillEstimateLineItemsInput, optFns ...func(*Options)) (*ListBillEstimateLineItemsOutput, error) {
	if params == nil {
		params = &ListBillEstimateLineItemsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillEstimateLineItems", params, optFns, c.addOperationListBillEstimateLineItemsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillEstimateLineItemsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillEstimateLineItemsInput struct {

	//  The unique identifier of the bill estimate to list line items for.
	//
	// This member is required.
	BillEstimateId *string

	//  Filters to apply to the list of line items.
	Filters []types.ListBillEstimateLineItemsFilter

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBillEstimateLineItemsOutput struct {

	//  The list of line items associated with the bill estimate.
	Items []types.BillEstimateLineItemSummary

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillEstimateLineItemsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillEstimateLineItems{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillEstimateLineItems{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillEstimateLineItems"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListBillEstimateLineItemsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillEstimateLineItems(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListBillEstimateLineItemsPaginatorOptions is the paginator options for
// ListBillEstimateLineItems
type ListBillEstimateLineItemsPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillEstimateLineItemsPaginator is a paginator for ListBillEstimateLineItems
type ListBillEstimateLineItemsPaginator struct {
	options   ListBillEstimateLineItemsPaginatorOptions
	client    ListBillEstimateLineItemsAPIClient
	params    *ListBillEstimateLineItemsInput
	nextToken *string
	firstPage bool
}

// NewListBillEstimateLineItemsPaginator returns a new
// ListBillEstimateLineItemsPaginator
func NewListBillEstimateLineItemsPaginator(client ListBillEstimateLineItemsAPIClient, params *ListBillEstimateLineItemsInput, optFns ...func(*ListBillEstimateLineItemsPaginatorOptions)) *ListBillEstimateLineItemsPaginator {
	if params == nil {
		params = &ListBillEstimateLineItemsInput{}
	}

	options := ListBillEstimateLineItemsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillEstimateLineItemsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillEstimateLineItemsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillEstimateLineItems page.
func (p *ListBillEstimateLineItemsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillEstimateLineItemsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillEstimateLineItems(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillEstimateLineItemsAPIClient is a client that implements the
// ListBillEstimateLineItems operation.
type ListBillEstimateLineItemsAPIClient interface {
	ListBillEstimateLineItems(context.Context, *ListBillEstimateLineItemsInput, ...func(*Options)) (*ListBillEstimateLineItemsOutput, error)
}

var _ ListBillEstimateLineItemsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillEstimateLineItems(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillEstimateLineItems",
	}
}
