// Code generated by smithy-go-codegen DO NOT EDIT.

package batch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/batch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes one or more of your service environments.
func (c *Client) DescribeServiceEnvironments(ctx context.Context, params *DescribeServiceEnvironmentsInput, optFns ...func(*Options)) (*DescribeServiceEnvironmentsOutput, error) {
	if params == nil {
		params = &DescribeServiceEnvironmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeServiceEnvironments", params, optFns, c.addOperationDescribeServiceEnvironmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeServiceEnvironmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeServiceEnvironmentsInput struct {

	// The maximum number of results returned by DescribeServiceEnvironments in
	// paginated output. When this parameter is used, DescribeServiceEnvironments only
	// returns maxResults results in a single page and a nextToken response element.
	// The remaining results of the initial request can be seen by sending another
	// DescribeServiceEnvironments request with the returned nextToken value. This
	// value can be between 1 and 100. If this parameter isn't used, then
	// DescribeServiceEnvironments returns up to 100 results and a nextToken value if
	// applicable.
	MaxResults *int32

	// The nextToken value returned from a previous paginated
	// DescribeServiceEnvironments request where maxResults was used and the results
	// exceeded the value of that parameter. Pagination continues from the end of the
	// previous results that returned the nextToken value. This value is null when
	// there are no more results to return.
	//
	// Treat this token as an opaque identifier that's only used to retrieve the next
	// items in a list and not for other programmatic purposes.
	NextToken *string

	// An array of service environment names or ARN entries.
	ServiceEnvironments []string

	noSmithyDocumentSerde
}

type DescribeServiceEnvironmentsOutput struct {

	// The nextToken value to include in a future DescribeServiceEnvironments request.
	// When the results of a DescribeServiceEnvironments request exceed maxResults ,
	// this value can be used to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string

	// The list of service environments that match the request.
	ServiceEnvironments []types.ServiceEnvironmentDetail

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeServiceEnvironmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeServiceEnvironments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeServiceEnvironments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeServiceEnvironments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeServiceEnvironments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeServiceEnvironmentsPaginatorOptions is the paginator options for
// DescribeServiceEnvironments
type DescribeServiceEnvironmentsPaginatorOptions struct {
	// The maximum number of results returned by DescribeServiceEnvironments in
	// paginated output. When this parameter is used, DescribeServiceEnvironments only
	// returns maxResults results in a single page and a nextToken response element.
	// The remaining results of the initial request can be seen by sending another
	// DescribeServiceEnvironments request with the returned nextToken value. This
	// value can be between 1 and 100. If this parameter isn't used, then
	// DescribeServiceEnvironments returns up to 100 results and a nextToken value if
	// applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeServiceEnvironmentsPaginator is a paginator for
// DescribeServiceEnvironments
type DescribeServiceEnvironmentsPaginator struct {
	options   DescribeServiceEnvironmentsPaginatorOptions
	client    DescribeServiceEnvironmentsAPIClient
	params    *DescribeServiceEnvironmentsInput
	nextToken *string
	firstPage bool
}

// NewDescribeServiceEnvironmentsPaginator returns a new
// DescribeServiceEnvironmentsPaginator
func NewDescribeServiceEnvironmentsPaginator(client DescribeServiceEnvironmentsAPIClient, params *DescribeServiceEnvironmentsInput, optFns ...func(*DescribeServiceEnvironmentsPaginatorOptions)) *DescribeServiceEnvironmentsPaginator {
	if params == nil {
		params = &DescribeServiceEnvironmentsInput{}
	}

	options := DescribeServiceEnvironmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeServiceEnvironmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeServiceEnvironmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeServiceEnvironments page.
func (p *DescribeServiceEnvironmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeServiceEnvironmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeServiceEnvironments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeServiceEnvironmentsAPIClient is a client that implements the
// DescribeServiceEnvironments operation.
type DescribeServiceEnvironmentsAPIClient interface {
	DescribeServiceEnvironments(context.Context, *DescribeServiceEnvironmentsInput, ...func(*Options)) (*DescribeServiceEnvironmentsOutput, error)
}

var _ DescribeServiceEnvironmentsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeServiceEnvironments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeServiceEnvironments",
	}
}
