// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// This is a request for a summary of scan jobs created or running within the most
// recent 30 days.
func (c *Client) ListScanJobSummaries(ctx context.Context, params *ListScanJobSummariesInput, optFns ...func(*Options)) (*ListScanJobSummariesOutput, error) {
	if params == nil {
		params = &ListScanJobSummariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListScanJobSummaries", params, optFns, c.addOperationListScanJobSummariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListScanJobSummariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListScanJobSummariesInput struct {

	// Returns the job count for the specified account.
	//
	// If the request is sent from a member account or an account not part of Amazon
	// Web Services Organizations, jobs within requestor's account will be returned.
	//
	// Root, admin, and delegated administrator accounts can use the value ANY to
	// return job counts from every account in the organization.
	//
	// AGGREGATE_ALL aggregates job counts from all accounts within the authenticated
	// organization, then returns the sum.
	AccountId *string

	// The period for the returned results.
	//
	//   - ONE_DAY The daily job count for the prior 1 day.
	//
	//   - SEVEN_DAYS The daily job count for the prior 7 days.
	//
	//   - FOURTEEN_DAYS The daily job count for the prior 14 days.
	AggregationPeriod types.AggregationPeriod

	// Returns only the scan jobs for the specified malware scanner. Currently the
	// only MalwareScanner is GUARDDUTY . But the field also supports ANY , and
	// AGGREGATE_ALL .
	MalwareScanner types.MalwareScanner

	// The maximum number of items to be returned.
	//
	// The value is an integer. Range of accepted values is from 1 to 500.
	MaxResults *int32

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	// Returns the job count for the specified resource type. Use request
	// GetSupportedResourceTypes to obtain strings for supported resource types.
	//
	// The the value ANY returns count of all resource types.
	//
	// AGGREGATE_ALL aggregates job counts for all resource types and returns the sum.
	ResourceType *string

	// Returns only the scan jobs for the specified scan results.
	ScanResultStatus types.ScanResultStatus

	// Returns only the scan jobs for the specified scanning job state.
	State types.ScanJobStatus

	noSmithyDocumentSerde
}

type ListScanJobSummariesOutput struct {

	// The period for the returned results.
	//
	//   - ONE_DAY The daily job count for the prior 1 day.
	//
	//   - SEVEN_DAYS The daily job count for the prior 7 days.
	//
	//   - FOURTEEN_DAYS The daily job count for the prior 14 days.
	//
	// Valid Values: 'ONE_DAY' | 'SEVEN_DAYS' | 'FOURTEEN_DAYS'
	AggregationPeriod *string

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the next
	// token.
	NextToken *string

	// The summary information.
	ScanJobSummaries []types.ScanJobSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListScanJobSummariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListScanJobSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListScanJobSummaries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListScanJobSummaries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListScanJobSummaries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListScanJobSummariesPaginatorOptions is the paginator options for
// ListScanJobSummaries
type ListScanJobSummariesPaginatorOptions struct {
	// The maximum number of items to be returned.
	//
	// The value is an integer. Range of accepted values is from 1 to 500.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListScanJobSummariesPaginator is a paginator for ListScanJobSummaries
type ListScanJobSummariesPaginator struct {
	options   ListScanJobSummariesPaginatorOptions
	client    ListScanJobSummariesAPIClient
	params    *ListScanJobSummariesInput
	nextToken *string
	firstPage bool
}

// NewListScanJobSummariesPaginator returns a new ListScanJobSummariesPaginator
func NewListScanJobSummariesPaginator(client ListScanJobSummariesAPIClient, params *ListScanJobSummariesInput, optFns ...func(*ListScanJobSummariesPaginatorOptions)) *ListScanJobSummariesPaginator {
	if params == nil {
		params = &ListScanJobSummariesInput{}
	}

	options := ListScanJobSummariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListScanJobSummariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListScanJobSummariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListScanJobSummaries page.
func (p *ListScanJobSummariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListScanJobSummariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListScanJobSummaries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListScanJobSummariesAPIClient is a client that implements the
// ListScanJobSummaries operation.
type ListScanJobSummariesAPIClient interface {
	ListScanJobSummaries(context.Context, *ListScanJobSummariesInput, ...func(*Options)) (*ListScanJobSummariesOutput, error)
}

var _ ListScanJobSummariesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListScanJobSummaries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListScanJobSummaries",
	}
}
