// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns scan job details for the specified ScanJobID.
func (c *Client) DescribeScanJob(ctx context.Context, params *DescribeScanJobInput, optFns ...func(*Options)) (*DescribeScanJobOutput, error) {
	if params == nil {
		params = &DescribeScanJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeScanJob", params, optFns, c.addOperationDescribeScanJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeScanJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeScanJobInput struct {

	// Uniquely identifies a request to Backup to scan a resource.
	//
	// This member is required.
	ScanJobId *string

	noSmithyDocumentSerde
}

type DescribeScanJobOutput struct {

	// Returns the account ID that owns the scan job.
	//
	// Pattern: ^[0-9]{12}$
	//
	// This member is required.
	AccountId *string

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault
	//
	// This member is required.
	BackupVaultArn *string

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and the
	// Amazon Web Services Region where they are created.
	//
	// Pattern: ^[a-zA-Z0-9\-\_\.]{2,50}$
	//
	// This member is required.
	BackupVaultName *string

	// Contains identifying information about the creation of a scan job, including
	// the backup plan and rule that initiated the scan.
	//
	// This member is required.
	CreatedBy *types.ScanJobCreator

	// The date and time that a backup index finished creation, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	//
	// This member is required.
	CreationDate *time.Time

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:iam::123456789012:role/S3Access .
	//
	// This member is required.
	IamRoleArn *string

	// The scanning engine used for the corresponding scan job. Currently only GUARDUTY
	// is supported.
	//
	// This member is required.
	MalwareScanner types.MalwareScanner

	// An ARN that uniquely identifies the target recovery point for scanning.; for
	// example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45
	// .
	//
	// This member is required.
	RecoveryPointArn *string

	// An ARN that uniquely identifies the source resource of the corresponding
	// recovery point ARN.
	//
	// This member is required.
	ResourceArn *string

	// The non-unique name of the resource that belongs to the specified backup.
	//
	// This member is required.
	ResourceName *string

	// The type of Amazon Web Services Resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume.
	//
	// Pattern: ^[a-zA-Z0-9\-\_\.]{1,50}$
	//
	// This member is required.
	ResourceType types.ScanResourceType

	// The scan job ID that uniquely identified the request to Backup.
	//
	// This member is required.
	ScanJobId *string

	// Specifies the scan type used for the scan job.
	//
	// This member is required.
	ScanMode types.ScanMode

	// Specifies the scanner IAM role ARN used to for the scan job.
	//
	// This member is required.
	ScannerRoleArn *string

	// The current state of a scan job.
	//
	// This member is required.
	State types.ScanState

	// The date and time that a backup index finished creation, in Unix format and
	// Coordinated Universal Time (UTC). The value of CompletionDate is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time

	// An ARN that uniquely identifies the base recovery point for scanning. This
	// field will only be populated when an incremental scan job has taken place.
	ScanBaseRecoveryPointArn *string

	// The scan ID generated by Amazon GuardDuty for the corresponding Scan Job ID
	// request from Backup.
	ScanId *string

	//  Contains the ScanResultsStatus for the scanning job and returns THREATS_FOUND
	// or NO_THREATS_FOUND for completed jobs.
	ScanResult *types.ScanResultInfo

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeScanJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeScanJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeScanJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeScanJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeScanJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeScanJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeScanJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeScanJob",
	}
}
