// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// A practice run configuration for zonal autoshift is required when you enable
// zonal autoshift. A practice run configuration includes specifications for
// blocked dates and blocked time windows, and for Amazon CloudWatch alarms that
// you create to use with practice runs. The alarms that you specify are an outcome
// alarm, to monitor application health during practice runs and, optionally, a
// blocking alarm, to block practice runs from starting.
//
// When a resource has a practice run configuration, ARC starts zonal shifts for
// the resource weekly, to shift traffic for practice runs. Practice runs help you
// to ensure that shifting away traffic from an Availability Zone during an
// autoshift is safe for your application.
//
// For more information, see [Considerations when you configure zonal autoshift] in the Amazon Application Recovery Controller
// Developer Guide.
//
// [Considerations when you configure zonal autoshift]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html
func (c *Client) CreatePracticeRunConfiguration(ctx context.Context, params *CreatePracticeRunConfigurationInput, optFns ...func(*Options)) (*CreatePracticeRunConfigurationOutput, error) {
	if params == nil {
		params = &CreatePracticeRunConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePracticeRunConfiguration", params, optFns, c.addOperationCreatePracticeRunConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePracticeRunConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePracticeRunConfigurationInput struct {

	//  Outcome alarms for practice runs are alarms that you specify that end a
	// practice run when one or more of the alarms is in an ALARM state.
	//
	// Configure one or more of these alarms to monitor the health of your application
	// when traffic is shifted away from an Availability Zone during each practice run.
	// You should configure these alarms to go into an ALARM state if you want to stop
	// a zonal shift, to let traffic for the resource return to the original
	// Availability Zone.
	//
	// This member is required.
	OutcomeAlarms []types.ControlCondition

	// The identifier of the resource that Amazon Web Services shifts traffic for with
	// a practice run zonal shift. The identifier is the Amazon Resource Name (ARN) for
	// the resource.
	//
	// Amazon Application Recovery Controller currently supports enabling the
	// following resources for zonal shift and zonal autoshift:
	//
	// [Amazon EC2 Auto Scaling groups]
	//
	// [Amazon Elastic Kubernetes Service]
	//
	// [Application Load Balancer]
	//
	// [Network Load Balancer]
	//
	// [Amazon EC2 Auto Scaling groups]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html
	// [Amazon Elastic Kubernetes Service]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html
	// [Application Load Balancer]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html
	// [Network Load Balancer]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html
	//
	// This member is required.
	ResourceIdentifier *string

	// Optionally, you can allow ARC to start practice runs for specific windows of
	// days and times.
	//
	// The format for allowed windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you
	// specify dates, that dates and times for practice runs are in UTC. Also, be aware
	// of potential time adjustments that might be required for daylight saving time
	// differences. Separate multiple allowed windows with spaces.
	//
	// For example, say you want to allow practice runs only on Wednesdays and Fridays
	// from noon to 5 p.m. For this scenario, you could set the following recurring
	// days and times as allowed windows, for example: Wed-12:00-Wed:17:00
	// Fri-12:00-Fri:17:00 .
	//
	// The allowedWindows have to start and end on the same day. Windows that span
	// multiple days aren't supported.
	AllowedWindows []string

	// Optionally, you can block ARC from starting practice runs for a resource on
	// specific calendar dates.
	//
	// The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify
	// dates, that dates and times for practice runs are in UTC. Separate multiple
	// blocked dates with spaces.
	//
	// For example, if you have an application update scheduled to launch on May 1,
	// 2024, and you don't want practice runs to shift traffic away at that time, you
	// could set a blocked date for 2024-05-01 .
	BlockedDates []string

	// Optionally, you can block ARC from starting practice runs for specific windows
	// of days and times.
	//
	// The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind, when you
	// specify dates, that dates and times for practice runs are in UTC. Also, be aware
	// of potential time adjustments that might be required for daylight saving time
	// differences. Separate multiple blocked windows with spaces.
	//
	// For example, say you run business report summaries three days a week. For this
	// scenario, you could set the following recurring days and times as blocked
	// windows, for example: Mon:00:00-Mon:10:00 Wed-20:30-Wed:21:30
	// Fri-20:30-Fri:21:30 .
	//
	// The blockedWindows have to start and end on the same day. Windows that span
	// multiple days aren't supported.
	BlockedWindows []string

	//  Blocking alarms for practice runs are optional alarms that you can specify
	// that block practice runs when one or more of the alarms is in an ALARM state.
	BlockingAlarms []types.ControlCondition

	noSmithyDocumentSerde
}

type CreatePracticeRunConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the resource that you configured the practice
	// run for.
	//
	// This member is required.
	Arn *string

	// The name of the resource that you configured the practice run for.
	//
	// This member is required.
	Name *string

	// A practice run configuration for a resource. Configurations include the outcome
	// alarm that you specify for practice runs, and, optionally, a blocking alarm and
	// blocking dates and windows.
	//
	// This member is required.
	PracticeRunConfiguration *types.PracticeRunConfiguration

	// The status for zonal autoshift for a resource. When you specify ENABLED for the
	// autoshift status, Amazon Web Services shifts traffic away from shifts away
	// application resource traffic from an Availability Zone, on your behalf, when
	// internal telemetry indicates that there is an Availability Zone impairment that
	// could potentially impact customers.
	//
	// When you enable zonal autoshift, you must also configure practice runs for the
	// resource.
	//
	// This member is required.
	ZonalAutoshiftStatus types.ZonalAutoshiftStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePracticeRunConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreatePracticeRunConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreatePracticeRunConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePracticeRunConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePracticeRunConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePracticeRunConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreatePracticeRunConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePracticeRunConfiguration",
	}
}
