// Code generated by smithy-go-codegen DO NOT EDIT.

package arcregionswitch

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arcregionswitch/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts the execution of a Region switch plan. You can execute a plan in either
// PRACTICE or RECOVERY mode.
//
// In PRACTICE mode, the execution simulates the steps without making actual
// changes to your application's traffic routing. In RECOVERY mode, the execution
// performs actual changes to shift traffic between Regions.
func (c *Client) StartPlanExecution(ctx context.Context, params *StartPlanExecutionInput, optFns ...func(*Options)) (*StartPlanExecutionOutput, error) {
	if params == nil {
		params = &StartPlanExecutionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartPlanExecution", params, optFns, c.addOperationStartPlanExecutionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartPlanExecutionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartPlanExecutionInput struct {

	// The action to perform. Valid values are ACTIVATE (to shift traffic to the
	// target Region) or DEACTIVATE (to shift traffic away from the target Region).
	//
	// This member is required.
	Action types.ExecutionAction

	// The Amazon Resource Name (ARN) of the plan to execute.
	//
	// This member is required.
	PlanArn *string

	// The Amazon Web Services Region to target with this execution. This is the
	// Region that traffic will be shifted to or from, depending on the action.
	//
	// This member is required.
	TargetRegion *string

	// An optional comment explaining why the plan execution is being started.
	Comment *string

	// A boolean value indicating whether to use the latest version of the plan. If
	// set to false, you must specify a specific version.
	LatestVersion *string

	// The plan execution mode. Valid values are Practice , for testing without making
	// actual changes, or Recovery , for actual traffic shifting and application
	// recovery.
	Mode types.ExecutionMode

	noSmithyDocumentSerde
}

type StartPlanExecutionOutput struct {

	// The Amazon Web Services Region to activate.
	ActivateRegion *string

	// The Amazon Web Services Region to deactivate.
	DeactivateRegion *string

	// The execution identifier of a plan execution.
	ExecutionId *string

	// The details of the Region switch plan.
	Plan *string

	// The version of the plan, a unique number generated by Region switch.
	PlanVersion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartPlanExecutionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&smithyRpcv2cbor_serializeOpStartPlanExecution{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&smithyRpcv2cbor_deserializeOpStartPlanExecution{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartPlanExecution"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addUserAgentFeatureProtocolRPCV2CBOR(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartPlanExecutionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartPlanExecution(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartPlanExecution(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartPlanExecution",
	}
}
