// Code generated by smithy-go-codegen DO NOT EDIT.

package appmesh

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/appmesh/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of existing virtual services in a service mesh.
func (c *Client) ListVirtualServices(ctx context.Context, params *ListVirtualServicesInput, optFns ...func(*Options)) (*ListVirtualServicesOutput, error) {
	if params == nil {
		params = &ListVirtualServicesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVirtualServices", params, optFns, c.addOperationListVirtualServicesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVirtualServicesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVirtualServicesInput struct {

	// The name of the service mesh to list virtual services in.
	//
	// This member is required.
	MeshName *string

	// The maximum number of results returned by ListVirtualServices in paginated
	// output. When you use this parameter, ListVirtualServices returns only limit
	// results in a single page along with a nextToken response element. You can see
	// the remaining results of the initial request by sending another
	// ListVirtualServices request with the returned nextToken value. This value can
	// be between 1 and 100. If you don't use this parameter, ListVirtualServices
	// returns up to 100 results and a nextToken value if applicable.
	Limit *int32

	// The Amazon Web Services IAM account ID of the service mesh owner. If the
	// account ID is not your own, then it's the ID of the account that shared the mesh
	// with your account. For more information about mesh sharing, see [Working with shared meshes].
	//
	// [Working with shared meshes]: https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html
	MeshOwner *string

	// The nextToken value returned from a previous paginated ListVirtualServices
	// request where limit was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVirtualServicesOutput struct {

	// The list of existing virtual services for the specified service mesh.
	//
	// This member is required.
	VirtualServices []types.VirtualServiceRef

	// The nextToken value to include in a future ListVirtualServices request. When
	// the results of a ListVirtualServices request exceed limit , you can use this
	// value to retrieve the next page of results. This value is null when there are
	// no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVirtualServicesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListVirtualServices{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListVirtualServices{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListVirtualServices"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListVirtualServicesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVirtualServices(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVirtualServicesPaginatorOptions is the paginator options for
// ListVirtualServices
type ListVirtualServicesPaginatorOptions struct {
	// The maximum number of results returned by ListVirtualServices in paginated
	// output. When you use this parameter, ListVirtualServices returns only limit
	// results in a single page along with a nextToken response element. You can see
	// the remaining results of the initial request by sending another
	// ListVirtualServices request with the returned nextToken value. This value can
	// be between 1 and 100. If you don't use this parameter, ListVirtualServices
	// returns up to 100 results and a nextToken value if applicable.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVirtualServicesPaginator is a paginator for ListVirtualServices
type ListVirtualServicesPaginator struct {
	options   ListVirtualServicesPaginatorOptions
	client    ListVirtualServicesAPIClient
	params    *ListVirtualServicesInput
	nextToken *string
	firstPage bool
}

// NewListVirtualServicesPaginator returns a new ListVirtualServicesPaginator
func NewListVirtualServicesPaginator(client ListVirtualServicesAPIClient, params *ListVirtualServicesInput, optFns ...func(*ListVirtualServicesPaginatorOptions)) *ListVirtualServicesPaginator {
	if params == nil {
		params = &ListVirtualServicesInput{}
	}

	options := ListVirtualServicesPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVirtualServicesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVirtualServicesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVirtualServices page.
func (p *ListVirtualServicesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVirtualServicesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListVirtualServices(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListVirtualServicesAPIClient is a client that implements the
// ListVirtualServices operation.
type ListVirtualServicesAPIClient interface {
	ListVirtualServices(context.Context, *ListVirtualServicesInput, ...func(*Options)) (*ListVirtualServicesOutput, error)
}

var _ ListVirtualServicesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListVirtualServices(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListVirtualServices",
	}
}
