// Code generated by smithy-go-codegen DO NOT EDIT.

package apigatewayv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apigatewayv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a product REST endpoint page for a portal product.
func (c *Client) CreateProductRestEndpointPage(ctx context.Context, params *CreateProductRestEndpointPageInput, optFns ...func(*Options)) (*CreateProductRestEndpointPageOutput, error) {
	if params == nil {
		params = &CreateProductRestEndpointPageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProductRestEndpointPage", params, optFns, c.addOperationCreateProductRestEndpointPageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProductRestEndpointPageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request body for the post operation.
type CreateProductRestEndpointPageInput struct {

	// The portal product identifier.
	//
	// This member is required.
	PortalProductId *string

	// The REST endpoint identifier.
	//
	// This member is required.
	RestEndpointIdentifier *types.RestEndpointIdentifier

	// The content of the product REST endpoint page.
	DisplayContent *types.EndpointDisplayContent

	// The try it state of the product REST endpoint page.
	TryItState types.TryItState

	noSmithyDocumentSerde
}

type CreateProductRestEndpointPageOutput struct {

	// The display content.
	DisplayContent *types.EndpointDisplayContentResponse

	// The timestamp when the product REST endpoint page was last modified.
	LastModified *time.Time

	// The ARN of the product REST endpoint page.
	ProductRestEndpointPageArn *string

	// The product REST endpoint page identifier.
	ProductRestEndpointPageId *string

	// The REST endpoint identifier.
	RestEndpointIdentifier *types.RestEndpointIdentifier

	// The status.
	Status types.Status

	// The status exception information.
	StatusException *types.StatusException

	// The try it state.
	TryItState types.TryItState

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProductRestEndpointPageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateProductRestEndpointPage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateProductRestEndpointPage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProductRestEndpointPage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProductRestEndpointPageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProductRestEndpointPage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProductRestEndpointPage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProductRestEndpointPage",
	}
}
