// Code generated by smithy-go-codegen DO NOT EDIT.

package aiops

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/aiops/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the configuration information for the specified investigation group.
func (c *Client) GetInvestigationGroup(ctx context.Context, params *GetInvestigationGroupInput, optFns ...func(*Options)) (*GetInvestigationGroupOutput, error) {
	if params == nil {
		params = &GetInvestigationGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetInvestigationGroup", params, optFns, c.addOperationGetInvestigationGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetInvestigationGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetInvestigationGroupInput struct {

	// Specify either the name or the ARN of the investigation group that you want to
	// view. This is used to set the name of the investigation group.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

type GetInvestigationGroupOutput struct {

	// The Amazon Resource Name (ARN) of the investigation group.
	Arn *string

	// This structure is a string array. The first string is the ARN of a Amazon SNS
	// topic. The array of strings display the ARNs of chat applications configurations
	// that are associated with that topic. For more information about these
	// configuration ARNs, see [Getting started with Amazon Q in chat applications]and [Resource type defined by Amazon Web Services Chatbot].
	//
	// [Resource type defined by Amazon Web Services Chatbot]: https://docs.aws.amazon.com/service-authorization/latest/reference/list_awschatbot.html#awschatbot-resources-for-iam-policies
	// [Getting started with Amazon Q in chat applications]: https://docs.aws.amazon.com/chatbot/latest/adminguide/getting-started.html
	ChatbotNotificationChannel map[string][]string

	// The date and time that the investigation group was created.
	CreatedAt *int64

	// The name of the user who created the investigation group.
	CreatedBy *string

	// Lists the AWSAccountId of the accounts configured for cross-account access and
	// the results of the last scan performed on each account.
	CrossAccountConfigurations []types.CrossAccountConfiguration

	// Specifies the customer managed KMS key that the investigation group uses to
	// encrypt data, if there is one. If not, the investigation group uses an Amazon
	// Web Services key to encrypt the data.
	EncryptionConfiguration *types.EncryptionConfiguration

	// Specifies whether CloudWatch investigationshas access to change events that are
	// recorded by CloudTrail.
	IsCloudTrailEventHistoryEnabled *bool

	// The date and time that the investigation group was most recently modified.
	LastModifiedAt *int64

	// The name of the user who created the investigation group.
	LastModifiedBy *string

	// The name of the investigation group.
	Name *string

	// Specifies how long that investigation data is kept.
	RetentionInDays *int64

	// The ARN of the IAM role that the investigation group uses for permissions to
	// gather data.
	RoleArn *string

	// Displays the custom tag keys for custom applications in your system that you
	// have specified in the investigation group. Resource tags help CloudWatch
	// investigations narrow the search space when it is unable to discover definite
	// relationships between resources.
	TagKeyBoundaries []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetInvestigationGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetInvestigationGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetInvestigationGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetInvestigationGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetInvestigationGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetInvestigationGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetInvestigationGroup",
	}
}
