// Code generated by smithy-go-codegen DO NOT EDIT.

package storagegateway

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/storagegateway/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets a list of the file shares for a specific S3 File Gateway, or the list of
// file shares that belong to the calling Amazon Web Services account. This
// operation is only supported for S3 File Gateways.
func (c *Client) ListFileShares(ctx context.Context, params *ListFileSharesInput, optFns ...func(*Options)) (*ListFileSharesOutput, error) {
	if params == nil {
		params = &ListFileSharesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFileShares", params, optFns, c.addOperationListFileSharesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFileSharesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// ListFileShareInput
type ListFileSharesInput struct {

	// The Amazon Resource Name (ARN) of the gateway whose file shares you want to
	// list. If this field is not present, all file shares under your account are
	// listed.
	GatewayARN *string

	// The maximum number of file shares to return in the response. The value must be
	// an integer with a value greater than zero. Optional.
	Limit *int32

	// Opaque pagination token returned from a previous ListFileShares operation. If
	// present, Marker specifies where to continue the list from after a previous call
	// to ListFileShares. Optional.
	Marker *string

	noSmithyDocumentSerde
}

// ListFileShareOutput
type ListFileSharesOutput struct {

	// An array of information about the S3 File Gateway's file shares.
	FileShareInfoList []types.FileShareInfo

	// If the request includes Marker , the response returns that value in this field.
	Marker *string

	// If a value is present, there are more file shares to return. In a subsequent
	// request, use NextMarker as the value for Marker to retrieve the next set of
	// file shares.
	NextMarker *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFileSharesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListFileShares{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListFileShares{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFileShares"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFileShares(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFileSharesPaginatorOptions is the paginator options for ListFileShares
type ListFileSharesPaginatorOptions struct {
	// The maximum number of file shares to return in the response. The value must be
	// an integer with a value greater than zero. Optional.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFileSharesPaginator is a paginator for ListFileShares
type ListFileSharesPaginator struct {
	options   ListFileSharesPaginatorOptions
	client    ListFileSharesAPIClient
	params    *ListFileSharesInput
	nextToken *string
	firstPage bool
}

// NewListFileSharesPaginator returns a new ListFileSharesPaginator
func NewListFileSharesPaginator(client ListFileSharesAPIClient, params *ListFileSharesInput, optFns ...func(*ListFileSharesPaginatorOptions)) *ListFileSharesPaginator {
	if params == nil {
		params = &ListFileSharesInput{}
	}

	options := ListFileSharesPaginatorOptions{}
	if params.Limit != nil {
		options.Limit = *params.Limit
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFileSharesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFileSharesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFileShares page.
func (p *ListFileSharesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFileSharesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.Limit = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFileShares(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFileSharesAPIClient is a client that implements the ListFileShares
// operation.
type ListFileSharesAPIClient interface {
	ListFileShares(context.Context, *ListFileSharesInput, ...func(*Options)) (*ListFileSharesOutput, error)
}

var _ ListFileSharesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFileShares(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFileShares",
	}
}
