// Code generated by smithy-go-codegen DO NOT EDIT.

package pcs

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pcs/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates a compute node group. You can update many of the fields related to your
// compute node group including the configurations for networking, compute nodes,
// and settings specific to your scheduler (such as Slurm).
func (c *Client) UpdateComputeNodeGroup(ctx context.Context, params *UpdateComputeNodeGroupInput, optFns ...func(*Options)) (*UpdateComputeNodeGroupOutput, error) {
	if params == nil {
		params = &UpdateComputeNodeGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateComputeNodeGroup", params, optFns, c.addOperationUpdateComputeNodeGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateComputeNodeGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateComputeNodeGroupInput struct {

	// The name or ID of the cluster of the compute node group.
	//
	// This member is required.
	ClusterIdentifier *string

	// The name or ID of the compute node group.
	//
	// This member is required.
	ComputeNodeGroupIdentifier *string

	// The ID of the Amazon Machine Image (AMI) that Amazon Web Services PCS uses to
	// launch instances. If not provided, Amazon Web Services PCS uses the AMI ID
	// specified in the custom launch template.
	AmiId *string

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. Idempotency ensures that an API request completes only once.
	// With an idempotent request, if the original request completes successfully, the
	// subsequent retries with the same client token return the result from the
	// original successful request and they have no additional effect. If you don't
	// specify a client token, the CLI and SDK automatically generate 1 for you.
	ClientToken *string

	// An Amazon EC2 launch template Amazon Web Services PCS uses to launch compute
	// nodes.
	CustomLaunchTemplate *types.CustomLaunchTemplate

	// The Amazon Resource Name (ARN) of the IAM instance profile used to pass an IAM
	// role when launching EC2 instances. The role contained in your instance profile
	// must have the pcs:RegisterComputeNodeGroupInstance permission and the role name
	// must start with AWSPCS or must have the path /aws-pcs/ . For more information,
	// see [IAM instance profiles for PCS]in the PCS User Guide.
	//
	// [IAM instance profiles for PCS]: https://docs.aws.amazon.com/pcs/latest/userguide/security-instance-profiles.html
	IamInstanceProfileArn *string

	// Specifies how EC2 instances are purchased on your behalf. Amazon Web Services
	// PCS supports On-Demand and Spot instances. For more information, see [Instance purchasing options]in the
	// Amazon Elastic Compute Cloud User Guide. If you don't provide this option, it
	// defaults to On-Demand.
	//
	// [Instance purchasing options]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-purchasing-options.html
	PurchaseOption types.PurchaseOption

	// Specifies the boundaries of the compute node group auto scaling.
	ScalingConfiguration *types.ScalingConfigurationRequest

	// Additional options related to the Slurm scheduler.
	SlurmConfiguration *types.UpdateComputeNodeGroupSlurmConfigurationRequest

	// Additional configuration when you specify SPOT as the purchaseOption for the
	// CreateComputeNodeGroup API action.
	SpotOptions *types.SpotOptions

	// The list of subnet IDs where the compute node group provisions instances. The
	// subnets must be in the same VPC as the cluster.
	SubnetIds []string

	noSmithyDocumentSerde
}

type UpdateComputeNodeGroupOutput struct {

	// A compute node group associated with a cluster.
	ComputeNodeGroup *types.ComputeNodeGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateComputeNodeGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateComputeNodeGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateComputeNodeGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateComputeNodeGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opUpdateComputeNodeGroupMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateComputeNodeGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateComputeNodeGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpUpdateComputeNodeGroup struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpUpdateComputeNodeGroup) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpUpdateComputeNodeGroup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*UpdateComputeNodeGroupInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *UpdateComputeNodeGroupInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opUpdateComputeNodeGroupMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpUpdateComputeNodeGroup{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opUpdateComputeNodeGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateComputeNodeGroup",
	}
}
