// Code generated by smithy-go-codegen DO NOT EDIT.

package mediapackagev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Resetting the origin endpoint can help to resolve unexpected behavior and other
// content packaging issues. It also helps to preserve special events when you
// don't want the previous content to be available for viewing. A reset clears out
// all previous content from the origin endpoint.
//
// MediaPackage might return old content from this endpoint in the first 30
// seconds after the endpoint reset. For best results, when possible, wait 30
// seconds from endpoint reset to send playback requests to this endpoint.
func (c *Client) ResetOriginEndpointState(ctx context.Context, params *ResetOriginEndpointStateInput, optFns ...func(*Options)) (*ResetOriginEndpointStateOutput, error) {
	if params == nil {
		params = &ResetOriginEndpointStateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ResetOriginEndpointState", params, optFns, c.addOperationResetOriginEndpointStateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ResetOriginEndpointStateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ResetOriginEndpointStateInput struct {

	// The name of the channel group that contains the channel with the origin
	// endpoint that you are resetting.
	//
	// This member is required.
	ChannelGroupName *string

	// The name of the channel with the origin endpoint that you are resetting.
	//
	// This member is required.
	ChannelName *string

	// The name of the origin endpoint that you are resetting.
	//
	// This member is required.
	OriginEndpointName *string

	noSmithyDocumentSerde
}

type ResetOriginEndpointStateOutput struct {

	// The Amazon Resource Name (ARN) associated with the endpoint that you just reset.
	//
	// This member is required.
	Arn *string

	// The name of the channel group that contains the channel with the origin
	// endpoint that you just reset.
	//
	// This member is required.
	ChannelGroupName *string

	// The name of the channel with the origin endpoint that you just reset.
	//
	// This member is required.
	ChannelName *string

	// The name of the origin endpoint that you just reset.
	//
	// This member is required.
	OriginEndpointName *string

	// The time that the origin endpoint was last reset.
	//
	// This member is required.
	ResetAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationResetOriginEndpointStateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpResetOriginEndpointState{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpResetOriginEndpointState{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ResetOriginEndpointState"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpResetOriginEndpointStateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opResetOriginEndpointState(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opResetOriginEndpointState(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ResetOriginEndpointState",
	}
}
