// Code generated by smithy-go-codegen DO NOT EDIT.

package marketplacecatalog

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/marketplacecatalog/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/marketplacecatalog/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/marketplacecatalog/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchDescribeEntities struct {
}

func (*awsRestjson1_serializeOpBatchDescribeEntities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDescribeEntities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDescribeEntitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BatchDescribeEntities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDescribeEntitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDescribeEntitiesInput(v *BatchDescribeEntitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDescribeEntitiesInput(v *BatchDescribeEntitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityRequestList != nil {
		ok := object.Key("EntityRequestList")
		if err := awsRestjson1_serializeDocumentEntityRequestList(v.EntityRequestList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCancelChangeSet struct {
}

func (*awsRestjson1_serializeOpCancelChangeSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCancelChangeSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelChangeSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/CancelChangeSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCancelChangeSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCancelChangeSetInput(v *CancelChangeSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Catalog != nil {
		encoder.SetQuery("catalog").String(*v.Catalog)
	}

	if v.ChangeSetId != nil {
		encoder.SetQuery("changeSetId").String(*v.ChangeSetId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteResourcePolicy struct {
}

func (*awsRestjson1_serializeOpDeleteResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DeleteResourcePolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyInput(v *DeleteResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeChangeSet struct {
}

func (*awsRestjson1_serializeOpDescribeChangeSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeChangeSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeChangeSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeChangeSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeChangeSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeChangeSetInput(v *DescribeChangeSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Catalog != nil {
		encoder.SetQuery("catalog").String(*v.Catalog)
	}

	if v.ChangeSetId != nil {
		encoder.SetQuery("changeSetId").String(*v.ChangeSetId)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeEntity struct {
}

func (*awsRestjson1_serializeOpDescribeEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DescribeEntity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeEntityInput(v *DescribeEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Catalog != nil {
		encoder.SetQuery("catalog").String(*v.Catalog)
	}

	if v.EntityId != nil {
		encoder.SetQuery("entityId").String(*v.EntityId)
	}

	return nil
}

type awsRestjson1_serializeOpGetResourcePolicy struct {
}

func (*awsRestjson1_serializeOpGetResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GetResourcePolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetResourcePolicyInput(v *GetResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn != nil {
		encoder.SetQuery("resourceArn").String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpListChangeSets struct {
}

func (*awsRestjson1_serializeOpListChangeSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListChangeSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListChangeSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListChangeSets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListChangeSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListChangeSetsInput(v *ListChangeSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListChangeSetsInput(v *ListChangeSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.FilterList != nil {
		ok := object.Key("FilterList")
		if err := awsRestjson1_serializeDocumentFilterList(v.FilterList, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.Sort != nil {
		ok := object.Key("Sort")
		if err := awsRestjson1_serializeDocumentSort(v.Sort, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListEntities struct {
}

func (*awsRestjson1_serializeOpListEntities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEntities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEntitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListEntities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListEntitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEntitiesInput(v *ListEntitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListEntitiesInput(v *ListEntitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.EntityType != nil {
		ok := object.Key("EntityType")
		ok.String(*v.EntityType)
	}

	if v.EntityTypeFilters != nil {
		ok := object.Key("EntityTypeFilters")
		if err := awsRestjson1_serializeDocumentEntityTypeFilters(v.EntityTypeFilters, ok); err != nil {
			return err
		}
	}

	if v.EntityTypeSort != nil {
		ok := object.Key("EntityTypeSort")
		if err := awsRestjson1_serializeDocumentEntityTypeSort(v.EntityTypeSort, ok); err != nil {
			return err
		}
	}

	if v.FilterList != nil {
		ok := object.Key("FilterList")
		if err := awsRestjson1_serializeDocumentFilterList(v.FilterList, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.OwnershipType) > 0 {
		ok := object.Key("OwnershipType")
		ok.String(string(v.OwnershipType))
	}

	if v.Sort != nil {
		ok := object.Key("Sort")
		if err := awsRestjson1_serializeDocumentSort(v.Sort, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ListTagsForResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpPutResourcePolicy struct {
}

func (*awsRestjson1_serializeOpPutResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/PutResourcePolicy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutResourcePolicyInput(v *PutResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutResourcePolicyInput(v *PutResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

type awsRestjson1_serializeOpStartChangeSet struct {
}

func (*awsRestjson1_serializeOpStartChangeSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartChangeSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartChangeSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/StartChangeSet")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartChangeSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartChangeSetInput(v *StartChangeSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartChangeSetInput(v *StartChangeSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.ChangeSet != nil {
		ok := object.Key("ChangeSet")
		if err := awsRestjson1_serializeDocumentRequestedChangeList(v.ChangeSet, ok); err != nil {
			return err
		}
	}

	if v.ChangeSetName != nil {
		ok := object.Key("ChangeSetName")
		ok.String(*v.ChangeSetName)
	}

	if v.ChangeSetTags != nil {
		ok := object.Key("ChangeSetTags")
		if err := awsRestjson1_serializeDocumentTagList(v.ChangeSetTags, ok); err != nil {
			return err
		}
	}

	if v.ClientRequestToken != nil {
		ok := object.Key("ClientRequestToken")
		ok.String(*v.ClientRequestToken)
	}

	if len(v.Intent) > 0 {
		ok := object.Key("Intent")
		ok.String(string(v.Intent))
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/TagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/UntagResource")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsRestjson1_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductEntityIdFilter(v *types.AmiProductEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentAmiProductEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAmiProductFilters(v *types.AmiProductFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentAmiProductEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentAmiProductLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ProductTitle != nil {
		ok := object.Key("ProductTitle")
		if err := awsRestjson1_serializeDocumentAmiProductTitleFilter(v.ProductTitle, ok); err != nil {
			return err
		}
	}

	if v.Visibility != nil {
		ok := object.Key("Visibility")
		if err := awsRestjson1_serializeDocumentAmiProductVisibilityFilter(v.Visibility, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductLastModifiedDateFilter(v *types.AmiProductLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentAmiProductLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductLastModifiedDateFilterDateRange(v *types.AmiProductLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductSort(v *types.AmiProductSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductTitleFilter(v *types.AmiProductTitleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentAmiProductTitleFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductTitleFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAmiProductVisibilityFilter(v *types.AmiProductVisibilityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentAmiProductVisibilityFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAmiProductVisibilityFilterValueList(v []types.AmiProductVisibilityString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentChange(v *types.Change, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ChangeName != nil {
		ok := object.Key("ChangeName")
		ok.String(*v.ChangeName)
	}

	if v.ChangeType != nil {
		ok := object.Key("ChangeType")
		ok.String(*v.ChangeType)
	}

	if v.Details != nil {
		ok := object.Key("Details")
		ok.String(*v.Details)
	}

	if v.DetailsDocument != nil {
		ok := object.Key("DetailsDocument")
		if err := awsRestjson1_serializeDocumentJsonDocumentType(v.DetailsDocument, ok); err != nil {
			return err
		}
	}

	if v.Entity != nil {
		ok := object.Key("Entity")
		if err := awsRestjson1_serializeDocumentEntity(v.Entity, ok); err != nil {
			return err
		}
	}

	if v.EntityTags != nil {
		ok := object.Key("EntityTags")
		if err := awsRestjson1_serializeDocumentTagList(v.EntityTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductEntityIdFilter(v *types.ContainerProductEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentContainerProductEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentContainerProductFilters(v *types.ContainerProductFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentContainerProductEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentContainerProductLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ProductTitle != nil {
		ok := object.Key("ProductTitle")
		if err := awsRestjson1_serializeDocumentContainerProductTitleFilter(v.ProductTitle, ok); err != nil {
			return err
		}
	}

	if v.Visibility != nil {
		ok := object.Key("Visibility")
		if err := awsRestjson1_serializeDocumentContainerProductVisibilityFilter(v.Visibility, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductLastModifiedDateFilter(v *types.ContainerProductLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentContainerProductLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductLastModifiedDateFilterDateRange(v *types.ContainerProductLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductSort(v *types.ContainerProductSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductTitleFilter(v *types.ContainerProductTitleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentContainerProductTitleFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductTitleFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentContainerProductVisibilityFilter(v *types.ContainerProductVisibilityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentContainerProductVisibilityFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentContainerProductVisibilityFilterValueList(v []types.ContainerProductVisibilityString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentDataProductEntityIdFilter(v *types.DataProductEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentDataProductEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataProductFilters(v *types.DataProductFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentDataProductEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentDataProductLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ProductTitle != nil {
		ok := object.Key("ProductTitle")
		if err := awsRestjson1_serializeDocumentDataProductTitleFilter(v.ProductTitle, ok); err != nil {
			return err
		}
	}

	if v.Visibility != nil {
		ok := object.Key("Visibility")
		if err := awsRestjson1_serializeDocumentDataProductVisibilityFilter(v.Visibility, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductLastModifiedDateFilter(v *types.DataProductLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentDataProductLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductLastModifiedDateFilterDateRange(v *types.DataProductLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductSort(v *types.DataProductSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductTitleFilter(v *types.DataProductTitleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentDataProductTitleFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductTitleFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataProductVisibilityFilter(v *types.DataProductVisibilityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentDataProductVisibilityFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataProductVisibilityFilterValueList(v []types.DataProductVisibilityString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentEntity(v *types.Entity, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifier != nil {
		ok := object.Key("Identifier")
		ok.String(*v.Identifier)
	}

	if v.Type != nil {
		ok := object.Key("Type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentEntityRequest(v *types.EntityRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Catalog != nil {
		ok := object.Key("Catalog")
		ok.String(*v.Catalog)
	}

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		ok.String(*v.EntityId)
	}

	return nil
}

func awsRestjson1_serializeDocumentEntityRequestList(v []types.EntityRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEntityRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEntityTypeFilters(v types.EntityTypeFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EntityTypeFiltersMemberAmiProductFilters:
		av := object.Key("AmiProductFilters")
		if err := awsRestjson1_serializeDocumentAmiProductFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberContainerProductFilters:
		av := object.Key("ContainerProductFilters")
		if err := awsRestjson1_serializeDocumentContainerProductFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberDataProductFilters:
		av := object.Key("DataProductFilters")
		if err := awsRestjson1_serializeDocumentDataProductFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberMachineLearningProductFilters:
		av := object.Key("MachineLearningProductFilters")
		if err := awsRestjson1_serializeDocumentMachineLearningProductFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberOfferFilters:
		av := object.Key("OfferFilters")
		if err := awsRestjson1_serializeDocumentOfferFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberResaleAuthorizationFilters:
		av := object.Key("ResaleAuthorizationFilters")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationFilters(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeFiltersMemberSaaSProductFilters:
		av := object.Key("SaaSProductFilters")
		if err := awsRestjson1_serializeDocumentSaaSProductFilters(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentEntityTypeSort(v types.EntityTypeSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.EntityTypeSortMemberAmiProductSort:
		av := object.Key("AmiProductSort")
		if err := awsRestjson1_serializeDocumentAmiProductSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberContainerProductSort:
		av := object.Key("ContainerProductSort")
		if err := awsRestjson1_serializeDocumentContainerProductSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberDataProductSort:
		av := object.Key("DataProductSort")
		if err := awsRestjson1_serializeDocumentDataProductSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberMachineLearningProductSort:
		av := object.Key("MachineLearningProductSort")
		if err := awsRestjson1_serializeDocumentMachineLearningProductSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberOfferSort:
		av := object.Key("OfferSort")
		if err := awsRestjson1_serializeDocumentOfferSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberResaleAuthorizationSort:
		av := object.Key("ResaleAuthorizationSort")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationSort(&uv.Value, av); err != nil {
			return err
		}

	case *types.EntityTypeSortMemberSaaSProductSort:
		av := object.Key("SaaSProductSort")
		if err := awsRestjson1_serializeDocumentSaaSProductSort(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentFilter(v *types.Filter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterList(v []types.Filter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentJsonDocumentType(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductEntityIdFilter(v *types.MachineLearningProductEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentMachineLearningProductEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductFilters(v *types.MachineLearningProductFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentMachineLearningProductEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentMachineLearningProductLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ProductTitle != nil {
		ok := object.Key("ProductTitle")
		if err := awsRestjson1_serializeDocumentMachineLearningProductTitleFilter(v.ProductTitle, ok); err != nil {
			return err
		}
	}

	if v.Visibility != nil {
		ok := object.Key("Visibility")
		if err := awsRestjson1_serializeDocumentMachineLearningProductVisibilityFilter(v.Visibility, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductLastModifiedDateFilter(v *types.MachineLearningProductLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentMachineLearningProductLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductLastModifiedDateFilterDateRange(v *types.MachineLearningProductLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductSort(v *types.MachineLearningProductSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductTitleFilter(v *types.MachineLearningProductTitleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentMachineLearningProductTitleFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductTitleFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductVisibilityFilter(v *types.MachineLearningProductVisibilityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentMachineLearningProductVisibilityFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMachineLearningProductVisibilityFilterValueList(v []types.MachineLearningProductVisibilityString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferAvailabilityEndDateFilter(v *types.OfferAvailabilityEndDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentOfferAvailabilityEndDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferAvailabilityEndDateFilterDateRange(v *types.OfferAvailabilityEndDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferBuyerAccountsFilter(v *types.OfferBuyerAccountsFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferEntityIdFilter(v *types.OfferEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferFilters(v *types.OfferFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityEndDate != nil {
		ok := object.Key("AvailabilityEndDate")
		if err := awsRestjson1_serializeDocumentOfferAvailabilityEndDateFilter(v.AvailabilityEndDate, ok); err != nil {
			return err
		}
	}

	if v.BuyerAccounts != nil {
		ok := object.Key("BuyerAccounts")
		if err := awsRestjson1_serializeDocumentOfferBuyerAccountsFilter(v.BuyerAccounts, ok); err != nil {
			return err
		}
	}

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentOfferEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentOfferLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		if err := awsRestjson1_serializeDocumentOfferNameFilter(v.Name, ok); err != nil {
			return err
		}
	}

	if v.ProductId != nil {
		ok := object.Key("ProductId")
		if err := awsRestjson1_serializeDocumentOfferProductIdFilter(v.ProductId, ok); err != nil {
			return err
		}
	}

	if v.ReleaseDate != nil {
		ok := object.Key("ReleaseDate")
		if err := awsRestjson1_serializeDocumentOfferReleaseDateFilter(v.ReleaseDate, ok); err != nil {
			return err
		}
	}

	if v.ResaleAuthorizationId != nil {
		ok := object.Key("ResaleAuthorizationId")
		if err := awsRestjson1_serializeDocumentOfferResaleAuthorizationIdFilter(v.ResaleAuthorizationId, ok); err != nil {
			return err
		}
	}

	if v.State != nil {
		ok := object.Key("State")
		if err := awsRestjson1_serializeDocumentOfferStateFilter(v.State, ok); err != nil {
			return err
		}
	}

	if v.Targeting != nil {
		ok := object.Key("Targeting")
		if err := awsRestjson1_serializeDocumentOfferTargetingFilter(v.Targeting, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferLastModifiedDateFilter(v *types.OfferLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentOfferLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferLastModifiedDateFilterDateRange(v *types.OfferLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferNameFilter(v *types.OfferNameFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferNameFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferNameFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferProductIdFilter(v *types.OfferProductIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferProductIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferProductIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferReleaseDateFilter(v *types.OfferReleaseDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentOfferReleaseDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferReleaseDateFilterDateRange(v *types.OfferReleaseDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferResaleAuthorizationIdFilter(v *types.OfferResaleAuthorizationIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferResaleAuthorizationIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferResaleAuthorizationIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferSort(v *types.OfferSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferStateFilter(v *types.OfferStateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferStateFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferStateFilterValueList(v []types.OfferStateString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentOfferTargetingFilter(v *types.OfferTargetingFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentOfferTargetingFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentOfferTargetingFilterValueList(v []types.OfferTargetingString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentRequestedChangeList(v []types.Change, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentChange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilter(v *types.ResaleAuthorizationAvailabilityEndDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilterDateRange(v *types.ResaleAuthorizationAvailabilityEndDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilter(v *types.ResaleAuthorizationCreatedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilterDateRange(v *types.ResaleAuthorizationCreatedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationEntityIdFilter(v *types.ResaleAuthorizationEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationFilters(v *types.ResaleAuthorizationFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityEndDate != nil {
		ok := object.Key("AvailabilityEndDate")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationAvailabilityEndDateFilter(v.AvailabilityEndDate, ok); err != nil {
			return err
		}
	}

	if v.CreatedDate != nil {
		ok := object.Key("CreatedDate")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationCreatedDateFilter(v.CreatedDate, ok); err != nil {
			return err
		}
	}

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ManufacturerAccountId != nil {
		ok := object.Key("ManufacturerAccountId")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationManufacturerAccountIdFilter(v.ManufacturerAccountId, ok); err != nil {
			return err
		}
	}

	if v.ManufacturerLegalName != nil {
		ok := object.Key("ManufacturerLegalName")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationManufacturerLegalNameFilter(v.ManufacturerLegalName, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("Name")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationNameFilter(v.Name, ok); err != nil {
			return err
		}
	}

	if v.OfferExtendedStatus != nil {
		ok := object.Key("OfferExtendedStatus")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationOfferExtendedStatusFilter(v.OfferExtendedStatus, ok); err != nil {
			return err
		}
	}

	if v.ProductId != nil {
		ok := object.Key("ProductId")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationProductIdFilter(v.ProductId, ok); err != nil {
			return err
		}
	}

	if v.ProductName != nil {
		ok := object.Key("ProductName")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationProductNameFilter(v.ProductName, ok); err != nil {
			return err
		}
	}

	if v.ResellerAccountID != nil {
		ok := object.Key("ResellerAccountID")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationResellerAccountIDFilter(v.ResellerAccountID, ok); err != nil {
			return err
		}
	}

	if v.ResellerLegalName != nil {
		ok := object.Key("ResellerLegalName")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationResellerLegalNameFilter(v.ResellerLegalName, ok); err != nil {
			return err
		}
	}

	if v.Status != nil {
		ok := object.Key("Status")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationStatusFilter(v.Status, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationLastModifiedDateFilter(v *types.ResaleAuthorizationLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationLastModifiedDateFilterDateRange(v *types.ResaleAuthorizationLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationManufacturerAccountIdFilter(v *types.ResaleAuthorizationManufacturerAccountIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationManufacturerAccountIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationManufacturerAccountIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationManufacturerLegalNameFilter(v *types.ResaleAuthorizationManufacturerLegalNameFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationManufacturerLegalNameFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationManufacturerLegalNameFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationNameFilter(v *types.ResaleAuthorizationNameFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationNameFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationNameFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationOfferExtendedStatusFilter(v *types.ResaleAuthorizationOfferExtendedStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationOfferExtendedStatusFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationOfferExtendedStatusFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationProductIdFilter(v *types.ResaleAuthorizationProductIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationProductIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationProductIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationProductNameFilter(v *types.ResaleAuthorizationProductNameFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationProductNameFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationProductNameFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationResellerAccountIDFilter(v *types.ResaleAuthorizationResellerAccountIDFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationResellerAccountIDFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationResellerAccountIDFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationResellerLegalNameFilter(v *types.ResaleAuthorizationResellerLegalNameFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationResellerLegalNameFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationResellerLegalNameFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationSort(v *types.ResaleAuthorizationSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationStatusFilter(v *types.ResaleAuthorizationStatusFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentResaleAuthorizationStatusFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentResaleAuthorizationStatusFilterValueList(v []types.ResaleAuthorizationStatusString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSaaSProductEntityIdFilter(v *types.SaaSProductEntityIdFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentSaaSProductEntityIdFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductEntityIdFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSaaSProductFilters(v *types.SaaSProductFilters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityId != nil {
		ok := object.Key("EntityId")
		if err := awsRestjson1_serializeDocumentSaaSProductEntityIdFilter(v.EntityId, ok); err != nil {
			return err
		}
	}

	if v.LastModifiedDate != nil {
		ok := object.Key("LastModifiedDate")
		if err := awsRestjson1_serializeDocumentSaaSProductLastModifiedDateFilter(v.LastModifiedDate, ok); err != nil {
			return err
		}
	}

	if v.ProductTitle != nil {
		ok := object.Key("ProductTitle")
		if err := awsRestjson1_serializeDocumentSaaSProductTitleFilter(v.ProductTitle, ok); err != nil {
			return err
		}
	}

	if v.Visibility != nil {
		ok := object.Key("Visibility")
		if err := awsRestjson1_serializeDocumentSaaSProductVisibilityFilter(v.Visibility, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductLastModifiedDateFilter(v *types.SaaSProductLastModifiedDateFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRange != nil {
		ok := object.Key("DateRange")
		if err := awsRestjson1_serializeDocumentSaaSProductLastModifiedDateFilterDateRange(v.DateRange, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductLastModifiedDateFilterDateRange(v *types.SaaSProductLastModifiedDateFilterDateRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AfterValue != nil {
		ok := object.Key("AfterValue")
		ok.String(*v.AfterValue)
	}

	if v.BeforeValue != nil {
		ok := object.Key("BeforeValue")
		ok.String(*v.BeforeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductSort(v *types.SaaSProductSort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SortBy) > 0 {
		ok := object.Key("SortBy")
		ok.String(string(v.SortBy))
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductTitleFilter(v *types.SaaSProductTitleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentSaaSProductTitleFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	if v.WildCardValue != nil {
		ok := object.Key("WildCardValue")
		ok.String(*v.WildCardValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductTitleFilterValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSaaSProductVisibilityFilter(v *types.SaaSProductVisibilityFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ValueList != nil {
		ok := object.Key("ValueList")
		if err := awsRestjson1_serializeDocumentSaaSProductVisibilityFilterValueList(v.ValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSaaSProductVisibilityFilterValueList(v []types.SaaSProductVisibilityString, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentSort(v *types.Sort, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SortBy != nil {
		ok := object.Key("SortBy")
		ok.String(*v.SortBy)
	}

	if len(v.SortOrder) > 0 {
		ok := object.Key("SortOrder")
		ok.String(string(v.SortOrder))
	}

	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}
